/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class CroppedImageServer
extends TransformingImageServer<BufferedImage> {
    private ImageServerMetadata metadata;
    private ImageRegion region;

    public CroppedImageServer(ImageServer<BufferedImage> server, ImageRegion region) {
        super(server);
        this.region = region;
        ImageServerMetadata.ImageResolutionLevel.Builder levelBuilder = new ImageServerMetadata.ImageResolutionLevel.Builder(region.getWidth(), region.getHeight());
        boolean fullServer = server.getWidth() == region.getWidth() && server.getHeight() == region.getHeight();
        int i = 0;
        do {
            ImageServerMetadata.ImageResolutionLevel originalLevel = server.getMetadata().getLevel(i);
            if (fullServer) {
                levelBuilder.addLevel(originalLevel);
                continue;
            }
            levelBuilder.addLevelByDownsample(originalLevel.getDownsample());
        } while (++i < server.nResolutions() && region.getWidth() >= server.getMetadata().getPreferredTileWidth() && region.getHeight() >= server.getMetadata().getPreferredTileHeight());
        this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).width(region.getWidth()).height(region.getHeight()).name(String.format("%s (%d, %d, %d, %d)", server.getMetadata().getName(), region.getX(), region.getY(), region.getWidth(), region.getHeight())).levels(levelBuilder.build()).build();
    }

    @Override
    protected String createID() {
        return this.getClass().getName() + ": + " + this.getWrappedServer().getPath() + " " + GsonTools.getInstance().toJson((Object)this.region);
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        RegionRequest request2 = RegionRequest.createInstance(request.getPath(), request.getDownsample(), request.getX() + this.region.getX(), request.getY() + this.region.getY(), request.getWidth(), request.getHeight(), request.getZ(), request.getT());
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request2);
        return img;
    }

    public ImageRegion getCropRegion() {
        return this.region;
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public String getServerType() {
        return "Cropped image server";
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.CroppedImageServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.region);
    }
}

