/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images.servers;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferFloat;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.color.ColorTransformer;
import qupath.lib.color.StainVector;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ImageServers;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TransformingImageServer;
import qupath.lib.regions.RegionRequest;

class ColorDeconvolutionImageServer
extends TransformingImageServer<BufferedImage> {
    private static final Logger logger = LoggerFactory.getLogger(ColorDeconvolutionImageServer.class);
    private ColorDeconvolutionStains stains;
    private List<ColorTransformer.ColorTransformMethod> methods;
    private int[] stainNumbers;
    private ImageServerMetadata metadata;
    private transient List<StainVector> stainVectors;
    private transient ColorModel colorModel;

    public ColorDeconvolutionImageServer(ImageServer<BufferedImage> server, ColorDeconvolutionStains stains, int ... stainNumbers) {
        super(server);
        this.stains = stains;
        this.methods = new ArrayList<ColorTransformer.ColorTransformMethod>();
        if (stainNumbers.length == 0) {
            stainNumbers = new int[]{1, 2, 3};
        }
        this.stainNumbers = stainNumbers;
        ArrayList<ImageChannel> channels = new ArrayList<ImageChannel>();
        StringBuilder sb = new StringBuilder();
        this.stainVectors = new ArrayList<StainVector>();
        block5: for (int s : stainNumbers) {
            if (s < 1 || s > 3) {
                logger.warn("Invalid stain number {}, must be >= 1 and <= 3 (i.e. 'one-based')", (Object)s);
                continue;
            }
            if (sb.length() == 1) {
                sb.append(s);
            } else {
                sb.append(",").append(s);
            }
            StainVector stain = stains.getStain(s);
            this.stainVectors.add(stain);
            channels.add(ImageChannel.getInstance(stain.getName(), stain.getColor()));
            switch (s) {
                case 1: {
                    this.methods.add(ColorTransformer.ColorTransformMethod.Stain_1);
                    continue block5;
                }
                case 2: {
                    this.methods.add(ColorTransformer.ColorTransformMethod.Stain_2);
                    continue block5;
                }
                case 3: {
                    this.methods.add(ColorTransformer.ColorTransformMethod.Stain_3);
                }
            }
        }
        this.stainVectors = Collections.unmodifiableList(this.stainVectors);
        this.metadata = new ImageServerMetadata.Builder(server.getMetadata()).pixelType(PixelType.FLOAT32).rgb(false).channels(channels).name(String.format("%s (%s)", server.getMetadata().getName(), stains.toString())).build();
    }

    private ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = ColorModelFactory.getProbabilityColorModel32Bit(this.getMetadata().getChannels());
        }
        return this.colorModel;
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return new ImageServers.ColorDeconvolutionServerBuilder(this.getMetadata(), this.getWrappedServer().getBuilder(), this.stains, this.stainNumbers);
    }

    @Override
    protected String createID() {
        return UUID.randomUUID().toString();
    }

    public ColorDeconvolutionStains getStains() {
        return this.stains;
    }

    public List<StainVector> getStainVectors() {
        if (this.stainVectors == null) {
            ArrayList<StainVector> list = new ArrayList<StainVector>();
            for (int s : this.stainNumbers) {
                list.add(this.stains.getStain(s));
            }
            this.stainVectors = Collections.unmodifiableList(list);
        }
        return this.stainVectors;
    }

    @Override
    public BufferedImage readRegion(RegionRequest request) throws IOException {
        BufferedImage img = (BufferedImage)this.getWrappedServer().readRegion(request);
        if (img == null) {
            return null;
        }
        int w = img.getWidth();
        int h = img.getHeight();
        int nChannels = this.methods.size();
        BandedSampleModel model = new BandedSampleModel(4, w, h, nChannels);
        float[][] bytes = new float[nChannels][w * h];
        DataBufferFloat buffer = new DataBufferFloat(bytes, w * h);
        WritableRaster raster = Raster.createWritableRaster(model, buffer, null);
        if (BufferedImageTools.is8bitColorType(img.getType())) {
            int[] rgb = img.getRGB(0, 0, w, h, null, 0, img.getWidth());
            float[] pixels = new float[w * h];
            for (int b = 0; b < this.methods.size(); ++b) {
                ColorTransformer.getTransformedPixels(rgb, this.methods.get(b), pixels, this.stains);
                raster.setSamples(0, 0, img.getWidth(), img.getHeight(), b, pixels);
            }
        } else {
            float[] pixels = new float[w * h];
            for (int b = 0; b < this.methods.size(); ++b) {
                ColorDeconvolutionHelper.colorDeconvolve(img, this.stains, this.stainNumbers[b] - 1, pixels);
                raster.setSamples(0, 0, img.getWidth(), img.getHeight(), b, pixels);
            }
        }
        return new BufferedImage(this.getColorModel(), Raster.createWritableRaster(model, buffer, null), false, null);
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.metadata;
    }

    @Override
    public String getServerType() {
        return "Color deconvolution server";
    }
}

