/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.images;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.Workflow;
import qupath.lib.plugins.workflow.WorkflowListener;
import qupath.lib.plugins.workflow.WorkflowStep;

public class ImageData<T>
implements WorkflowListener,
PathObjectHierarchyListener,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ImageData.class);
    private transient PropertyChangeSupport pcs;
    private transient ImageServerBuilder.ServerBuilder<T> serverBuilder;
    private transient ImageServerMetadata lazyMetadata;
    private transient ImageServer<T> server;
    private String lastSavedPath = null;
    private PathObjectHierarchy hierarchy;
    private ImageType type = ImageType.UNSET;
    private Workflow workflow = new Workflow();
    private Map<ImageType, ColorDeconvolutionStains> stainMap = new HashMap<ImageType, ColorDeconvolutionStains>();
    private Map<String, Object> propertiesMap = new HashMap<String, Object>();
    private boolean changes = false;

    private ImageData(ImageServerBuilder.ServerBuilder<T> serverBuilder, ImageServer<T> server, PathObjectHierarchy hierarchy, ImageType type) throws IllegalArgumentException {
        if (server == null && serverBuilder == null) {
            throw new IllegalArgumentException("Cannot create ImageData without a server or server builder");
        }
        this.pcs = new PropertyChangeSupport(this);
        this.serverBuilder = serverBuilder;
        this.server = server;
        this.hierarchy = hierarchy == null ? new PathObjectHierarchy() : hierarchy;
        this.initializeStainMap();
        if (type == null) {
            type = ImageType.UNSET;
        }
        this.setImageType(type);
        this.hierarchy.addListener(this);
        this.workflow.addWorkflowListener(this);
        this.changes = false;
    }

    public ImageData(ImageServerBuilder.ServerBuilder<T> serverBuilder, PathObjectHierarchy hierarchy, ImageType type) {
        this(serverBuilder, null, hierarchy, type);
    }

    public ImageData(ImageServer<T> server, PathObjectHierarchy hierarchy, ImageType type) {
        this(null, server, hierarchy, type);
    }

    public ImageData(ImageServer<T> server, ImageType type) {
        this(server, new PathObjectHierarchy(), type);
    }

    public Workflow getHistoryWorkflow() {
        return this.workflow;
    }

    public ImageData(ImageServer<T> server, PathObjectHierarchy hierarchy) {
        this(server, hierarchy, null);
    }

    public ImageData(ImageServer<T> server) {
        this(server, new PathObjectHierarchy());
    }

    private void initializeStainMap() {
        this.stainMap.put(ImageType.BRIGHTFIELD_H_DAB, ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_DAB));
        this.stainMap.put(ImageType.BRIGHTFIELD_H_E, ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_E));
        this.stainMap.put(ImageType.BRIGHTFIELD_OTHER, ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_DAB));
    }

    public void setColorDeconvolutionStains(ColorDeconvolutionStains stains) {
        if (!this.isBrightfield()) {
            throw new IllegalArgumentException("Cannot set color deconvolution stains for image type " + String.valueOf((Object)this.type));
        }
        logger.trace("Setting stains to {}", (Object)stains);
        ColorDeconvolutionStains stainsOld = this.stainMap.put(this.type, stains);
        this.pcs.firePropertyChange("stains", stainsOld, stains);
        ImageData.addColorDeconvolutionStainsToWorkflow(this);
        this.changes = true;
    }

    public void updateServerMetadata(ImageServerMetadata newMetadata) {
        Objects.requireNonNull(newMetadata);
        ImageServerMetadata currentMetadata = this.getServerMetadata();
        if (Objects.equals(currentMetadata, newMetadata)) {
            logger.trace("Call to updateServerMetadata ignored - metadata is unchanged");
            return;
        }
        logger.trace("Updating server metadata");
        ImageServer<T> server = this.getServer();
        ImageServerMetadata oldMetadata = server.getMetadata();
        server.setMetadata(newMetadata);
        this.pcs.firePropertyChange("serverMetadata", oldMetadata, newMetadata);
        this.changes = this.changes || !oldMetadata.equals(newMetadata);
    }

    public ImageServerMetadata getServerMetadata() {
        if (this.server == null) {
            ImageServerMetadata metadata;
            if (this.lazyMetadata != null) {
                logger.trace("Returning lazy metadata");
                return this.lazyMetadata;
            }
            if (this.serverBuilder != null && (metadata = (ImageServerMetadata)this.serverBuilder.getMetadata().orElse(null)) != null) {
                return metadata;
            }
        }
        return this.getServer().getMetadata();
    }

    public boolean isBrightfield() {
        return ImageData.isBrightfield(this.getImageType());
    }

    private static boolean isBrightfield(ImageType type) {
        return type.toString().toLowerCase().startsWith("brightfield");
    }

    public boolean isFluorescence() {
        return this.getImageType() == ImageType.FLUORESCENCE;
    }

    public void setImageType(ImageType type) throws IllegalArgumentException {
        if (this.type == type) {
            return;
        }
        if (ImageData.isBrightfield(type) && !this.getServerMetadata().isRGB() && this.getServerMetadata().getChannels().size() != 3) {
            throw new IllegalArgumentException("Type for non-RGB image cannot be set to " + String.valueOf((Object)type));
        }
        logger.trace("Setting image type to {}", (Object)type);
        ImageType oldType = this.type;
        this.type = type;
        this.getHistoryWorkflow().addStep(new DefaultScriptableWorkflowStep("Set image type", Collections.singletonMap("Image type", type), "setImageType('" + type.name() + "')"));
        if (this.isBrightfield()) {
            ImageData.addColorDeconvolutionStainsToWorkflow(this);
        }
        this.pcs.firePropertyChange("imageType", (Object)oldType, (Object)type);
        this.changes = true;
    }

    private static void addColorDeconvolutionStainsToWorkflow(ImageData<?> imageData) {
        WorkflowStep lastStep;
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        if (stains == null) {
            logger.debug("{} has no color deconvolution stain. Cannot add workflow step", imageData);
            return;
        }
        String arg = ColorDeconvolutionStains.getColorDeconvolutionStainsAsString(imageData.getColorDeconvolutionStains(), 32);
        DefaultScriptableWorkflowStep newStep = new DefaultScriptableWorkflowStep("Set color deconvolution stains", GeneralTools.parseArgStringValues(arg), "setColorDeconvolutionStains('" + arg + "');");
        if (!Objects.equals(newStep, lastStep = imageData.getHistoryWorkflow().getLastStep())) {
            imageData.getHistoryWorkflow().addStep(newStep);
        }
    }

    public boolean isLoaded() {
        return this.server != null;
    }

    public ImageServerBuilder.ServerBuilder<T> getServerBuilder() {
        return this.isLoaded() ? this.getServer().getBuilder() : this.serverBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageServer<T> getServer() {
        if (this.server == null && this.serverBuilder != null) {
            ImageData imageData = this;
            synchronized (imageData) {
                if (this.server == null) {
                    try {
                        logger.debug("Lazily requesting image server: {}", this.serverBuilder);
                        this.server = this.serverBuilder.build();
                        if (this.lazyMetadata != null && !this.lazyMetadata.equals(this.server.getMetadata())) {
                            this.updateServerMetadata(this.lazyMetadata);
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to load ImageServer", e);
                    }
                }
            }
        }
        return this.server;
    }

    public String getServerPath() {
        return this.getServer().getPath();
    }

    public PathObjectHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public ImageType getImageType() {
        return this.type;
    }

    public ColorDeconvolutionStains getColorDeconvolutionStains() {
        return this.stainMap.get((Object)this.getImageType());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public Object getProperty(String key) {
        return this.propertiesMap.get(key);
    }

    public Object setProperty(String key, Object value) {
        Object oldValue = this.propertiesMap.put(key, value);
        if (oldValue == value) {
            return oldValue;
        }
        this.changes = oldValue == null ? value != null : this.changes || !oldValue.equals(value);
        logger.trace("Setting property: {}: {}", (Object)key, value);
        if (oldValue != value) {
            this.pcs.firePropertyChange(key, oldValue, value);
        }
        return oldValue;
    }

    public Object removeProperty(String key) {
        if (this.propertiesMap.containsKey(key)) {
            Object oldValue = this.propertiesMap.remove(key);
            this.changes = true;
            logger.trace("Removing property: {}: {}", (Object)key, oldValue);
            this.pcs.firePropertyChange(key, oldValue, null);
            return oldValue;
        }
        return null;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.propertiesMap);
    }

    public String getLastSavedPath() {
        return this.lastSavedPath;
    }

    public boolean isChanged() {
        return this.changes;
    }

    public void setChanged(boolean isChanged) {
        this.changes = isChanged;
    }

    public void setLastSavedPath(String path, boolean resetChanged) {
        this.lastSavedPath = path;
        if (resetChanged) {
            this.changes = false;
        }
    }

    @Override
    public void hierarchyChanged(PathObjectHierarchyEvent event) {
        this.changes = true;
    }

    @Override
    public void workflowUpdated(Workflow workflow) {
        this.changes = true;
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            this.server.close();
        }
    }

    public String toString() {
        Object serverName = this.server == null ? (this.serverBuilder == null ? "no server" : (this.lazyMetadata != null ? this.lazyMetadata.getName() + " (not yet loaded)" : "lazy-loaded server")) : ServerTools.getDisplayableImageName(this.server);
        return "ImageData: " + String.valueOf((Object)this.getImageType()) + ", " + (String)serverName;
    }

    public static enum ImageType {
        BRIGHTFIELD_H_DAB("Brightfield (H-DAB)"),
        BRIGHTFIELD_H_E("Brightfield (H&E)"),
        BRIGHTFIELD_OTHER("Brightfield (other)"),
        FLUORESCENCE("Fluorescence"),
        OTHER("Other"),
        UNSET("Not set");

        private final String text;

        private ImageType(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }
    }
}

