/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.geom;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.geom.AbstractPoint;

public class Point2
extends AbstractPoint
implements Externalizable,
Comparable<Point2> {
    private static final Logger logger = LoggerFactory.getLogger(Point2.class);
    private double x;
    private double y;
    private transient int hashCode = 0;

    public Point2() {
        this(0.0, 0.0);
    }

    public Point2(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double distanceSq(double x, double y) {
        double dx = this.x - x;
        double dy = this.y - y;
        return dx * dx + dy * dy;
    }

    public double distance(double x, double y) {
        return Math.sqrt(this.distanceSq(x, y));
    }

    public double distance(Point2 p) {
        return this.distance(p.getX(), p.getY());
    }

    @Override
    public double get(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        throw new IllegalArgumentException("Requested dimension " + dim + " for Point2 - allowable values are 0 and 1");
    }

    @Override
    public int dim() {
        return 2;
    }

    public String toString() {
        return "Point: " + this.x + ", " + this.y;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.computeHashCode();
        }
        return this.hashCode;
    }

    private int computeHashCode() {
        int prime = 31;
        int result = Double.hashCode(this.x);
        result = 31 * result + Double.hashCode(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Point2) {
            Point2 p = (Point2)obj;
            return this.x == p.x && this.y == p.y;
        }
        return false;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(1);
        out.writeDouble(this.x);
        out.writeDouble(this.y);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        in.skipBytes(4);
        this.x = in.readDouble();
        this.y = in.readDouble();
    }

    @Override
    public int compareTo(Point2 other) {
        if (this.y < other.y) {
            return -1;
        }
        if (this.y > other.y) {
            return 1;
        }
        if (this.x < other.x) {
            return -1;
        }
        if (this.x > other.x) {
            return 1;
        }
        return 0;
    }
}

