/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.common;

import java.util.Comparator;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import qupath.lib.common.GeneralTools;

public class Version
implements Comparable<Version> {
    private static Pattern PATTERN = Pattern.compile("(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-([\\w.]+))?");
    public static final Comparator<Version> COMPARATOR_MAJOR = Comparator.comparingInt(Version::getMajor);
    public static final Comparator<Version> COMPARATOR_MAJOR_MINOR = COMPARATOR_MAJOR.thenComparing(Version::getMinor);
    public static final Comparator<Version> COMPARATOR_MAJOR_MINOR_PATCH = COMPARATOR_MAJOR_MINOR.thenComparing(Version::getPatch);
    public static final Comparator<Version> COMPARATOR_FULL = COMPARATOR_MAJOR_MINOR_PATCH.thenComparing(Version::getSuffix, (s1, s2) -> Version.compareSuffixes(s1, s2));
    private static final Comparator<String> COMPARATOR_SUFFIX = GeneralTools.smartStringComparator();
    private int major;
    private int minor;
    private int patch;
    private String suffix;
    public static final Version UNKNOWN = new Version(-1, -1, -1, "UNKNOWN.VERSION");

    private Version(int major, int minor, int patch, String suffix) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.suffix = suffix == null ? "" : suffix;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean hasSuffix() {
        return this.suffix != null && !this.suffix.isBlank();
    }

    public String toString() {
        String v = this.major + "." + this.minor + "." + this.patch;
        if (this.suffix != null && !this.suffix.isEmpty()) {
            v = v + "-" + this.suffix;
        }
        return v;
    }

    private static int compareSuffixes(String s1, String s2) {
        if (Objects.equals(s1 = s1 == null ? "" : s1.trim(), s2 = s2 == null ? "" : s2.trim())) {
            return 0;
        }
        if (s1.isEmpty()) {
            return 1;
        }
        if (s2.isEmpty()) {
            return -1;
        }
        if (s1.length() > s2.length() && s1.startsWith(s2) && s1.charAt(s2.length()) == '.') {
            return -1;
        }
        if (s2.length() > s1.length() && s2.startsWith(s1) && s2.charAt(s1.length()) == '.') {
            return 1;
        }
        return COMPARATOR_SUFFIX.compare(s1, s2);
    }

    public static Version parse(String versionString) throws IllegalArgumentException {
        Matcher matcher;
        int ind;
        if (versionString == null || ((String)versionString).isBlank()) {
            return UNKNOWN;
        }
        if (((String)versionString).toLowerCase().startsWith("v")) {
            versionString = ((String)versionString).substring(1);
        }
        if ((ind = ((String)versionString).indexOf("-")) >= 0 && ind < ((String)versionString).length() - 1) {
            versionString = ((String)versionString).substring(0, ind + 1) + ((String)versionString).substring(ind + 1).replaceAll("-", ".");
        }
        if ((matcher = PATTERN.matcher(((String)versionString).strip())).matches()) {
            int major = Integer.parseInt(matcher.group(1));
            int minor = Integer.parseInt(matcher.group(2));
            int patch = Integer.parseInt(matcher.group(3));
            String suffix = null;
            if (matcher.groupCount() > 3) {
                suffix = matcher.group(4);
            }
            return new Version(major, minor, patch, suffix);
        }
        throw new IllegalArgumentException("No version could be parsed from " + (String)versionString);
    }

    @Override
    public int compareTo(Version o) {
        return COMPARATOR_FULL.compare(this, o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (this.suffix == null ? 0 : this.suffix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.patch != other.patch) {
            return false;
        }
        return !(this.suffix == null ? other.suffix != null : !this.suffix.equals(other.suffix));
    }
}

