/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.common;

import com.google.common.io.CharStreams;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Scanner;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.apache.commons.math3.util.Precision;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.LogTools;
import qupath.lib.common.Version;

public final class GeneralTools {
    private static final Logger logger = LoggerFactory.getLogger(GeneralTools.class);
    private static final String CURRENT_VERSION_STRING = GeneralTools.findCurrentVersionString();
    private static List<String> DEFAULT_EXTENSIONS = Arrays.asList(".ome.tif", ".ome.tiff", ".tar.gz", ".ome.zarr");
    private static final Map<Locale, NumberFormat> formatters = new HashMap<Locale, NumberFormat>();
    public static final char SYMBOL_MU = '\u00b5';
    public static final char SYMBOL_SIGMA = '\u03c3';
    public static final String SYMBOL_MICROMETER = "\u00b5m";

    public static String getVersion() {
        return CURRENT_VERSION_STRING;
    }

    public static Version getSemanticVersion() {
        if (CURRENT_VERSION_STRING == null) {
            return null;
        }
        try {
            return Version.parse(CURRENT_VERSION_STRING);
        }
        catch (Exception e) {
            logger.warn("Unable to parse version from " + CURRENT_VERSION_STRING, (Throwable)e);
            return null;
        }
    }

    private static String findCurrentVersionString() {
        String version = GeneralTools.getPackageVersion(GeneralTools.class, true);
        if (version == null) {
            Path path = Paths.get("VERSION", new String[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                path = Paths.get("app/VERSION", new String[0]);
            }
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    version = Files.readString(path);
                }
                catch (IOException e) {
                    logger.error("Unable to read version from {}", (Object)path);
                }
            }
        }
        if (version == null) {
            logger.warn("QuPath version is unknown! Proceed with caution: this may cause problems with reading/writing projects.");
            return null;
        }
        return version.strip();
    }

    public static String getPackageVersion(Class<?> cls) {
        return GeneralTools.getPackageVersion(cls, false);
    }

    private static String getPackageVersion(Class<?> cls, boolean isCoreClass) {
        String version = cls.getPackage().getImplementationVersion();
        if (version == null && isCoreClass) {
            try {
                InputStream stream = cls.getResourceAsStream("/VERSION");
                if (stream != null) {
                    version = GeneralTools.readInputStreamAsString(stream);
                }
            }
            catch (Exception e) {
                logger.error("Error reading version: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        if (version == null || version.isBlank()) {
            return null;
        }
        return version.strip();
    }

    private GeneralTools() {
        throw new AssertionError();
    }

    public static Optional<String> getExtension(File file) {
        Objects.requireNonNull(file);
        return GeneralTools.getExtension(file.getName());
    }

    public static Optional<String> getExtension(String name) {
        int ind;
        Objects.requireNonNull(name);
        String lower = name.toLowerCase();
        String ext = null;
        if (lower.endsWith(".gz")) {
            String previousExt = GeneralTools.getExtension(lower.substring(0, lower.length() - 3)).orElse(null);
            if (previousExt == null) {
                return Optional.of(".gz");
            }
            return Optional.of(previousExt + ".gz");
        }
        for (String temp : DEFAULT_EXTENSIONS) {
            if (!lower.endsWith(temp)) continue;
            ext = temp;
            break;
        }
        if (ext == null && (ind = name.lastIndexOf(".")) >= 0 && !(ext = name.substring(ind)).matches(".\\w*")) {
            ext = null;
        }
        return ext == null || ext.equals(".") ? Optional.empty() : Optional.of(lower.substring(lower.length() - ext.length()));
    }

    public static String stripInvalidFilenameChars(String name) {
        return name.replaceAll("[\\\\/:\"*?<>|\\n\\r]+", "");
    }

    public static boolean isValidFilename(String name) {
        return name != null && !name.isBlank() && name.equals(GeneralTools.stripInvalidFilenameChars(name));
    }

    public static String getNameWithoutExtension(File file) {
        String ext = GeneralTools.getExtension(file).orElse(null);
        String name = file.getName();
        return ext == null ? name : name.substring(0, name.length() - ext.length());
    }

    @Deprecated
    public static String getNameWithoutExtension(String name) {
        LogTools.warnOnce(logger, "getNameWithoutExtension(String) has been deprecated - use stripExtension(name) instead.");
        return GeneralTools.stripExtension(name);
    }

    public static String stripExtension(String path) {
        String ext = GeneralTools.getExtension(path).orElse(null);
        return ext == null ? path : path.substring(0, path.length() - ext.length());
    }

    public static boolean isMultipartExtension(String ext) {
        if (ext.length() <= 1) {
            return false;
        }
        if (ext.startsWith(".")) {
            return GeneralTools.isMultipartExtension(ext.substring(1));
        }
        return ext.length() - ext.replace(".", "").length() > 0;
    }

    public static boolean blankString(String s, boolean trim) {
        return s == null || (trim ? s.trim().length() == 0 : s.length() == 0);
    }

    public static String escapeFilePath(String path) {
        return path.replace("\\", "\\\\");
    }

    public static int clipValue(int value, int min, int max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double clipValue(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static boolean almostTheSame(double n1, double n2, double tolerance) {
        return Precision.equalsWithRelativeTolerance((double)n1, (double)n2, (double)tolerance);
    }

    public static URI toURI(String path) throws URISyntaxException {
        if (path == null || path.isEmpty()) {
            return new URI("");
        }
        if (path.startsWith("http:") || path.startsWith("https:") || path.startsWith("file:")) {
            return new URI(path);
        }
        return new File(path).toURI();
    }

    public static URI toEncodedURI(String path) throws URISyntaxException, UnsupportedEncodingException, MalformedURLException {
        if (path == null || path.isEmpty()) {
            return new URI("");
        }
        if (path.startsWith("http:") || path.startsWith("https:")) {
            String urlQuery = new URL(path).getQuery();
            if (urlQuery != null && !urlQuery.isEmpty()) {
                String encodedQueryString = URLEncoder.encode(urlQuery, StandardCharsets.UTF_8);
                String encodedURL = path.substring(0, path.lastIndexOf(urlQuery)) + urlQuery.replace(urlQuery, encodedQueryString);
                return new URI(encodedURL);
            }
            return new URI(path);
        }
        return new URI(path);
    }

    public static Path toPath(URI uri) {
        String scheme = uri.getScheme();
        if (scheme != null && !"file".equals(scheme)) {
            return null;
        }
        try {
            if (uri.getFragment() != null || uri.getQuery() != null) {
                uri = new URI(uri.getScheme(), uri.getHost(), uri.getPath(), null);
            }
            return Paths.get(uri);
        }
        catch (IllegalArgumentException | URISyntaxException | FileSystemNotFoundException e) {
            logger.warn("Problem parsing file from URI " + String.valueOf(uri) + " (" + e.getLocalizedMessage() + ")", (Throwable)e);
            return null;
        }
    }

    public static String arrayToString(Locale locale, double[] array, String delimiter, int nDecimalPlaces) {
        StringBuilder sb = new StringBuilder();
        if (array.length == 0) {
            return "";
        }
        for (int i = 0; i < array.length; ++i) {
            sb.append(GeneralTools.formatNumber(locale, array[i], nDecimalPlaces));
            if (i >= array.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String arrayToString(Locale locale, double[] array, int nDecimalPlaces) {
        return GeneralTools.arrayToString(locale, array, " ", nDecimalPlaces);
    }

    public static String arrayToString(Object[] array, String delimiter) {
        StringBuilder sb = new StringBuilder();
        if (array.length == 0) {
            return "";
        }
        for (int i = 0; i < array.length; ++i) {
            sb.append(array[i]);
            if (i >= array.length - 1) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String[] splitLines(String s) {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(s);){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        return lines.toArray(new String[lines.size()]);
    }

    public static NumberFormat createFormatter(int nDecimalPlaces) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(nDecimalPlaces);
        return nf;
    }

    public static synchronized String formatNumber(double value, int maxDecimalPlaces) {
        return GeneralTools.formatNumber(Locale.getDefault(Locale.Category.FORMAT), value, maxDecimalPlaces);
    }

    public static synchronized String formatNumber(Locale locale, double value, int maxDecimalPlaces) {
        NumberFormat nf;
        if (locale == null) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        if ((nf = formatters.get(locale)) == null) {
            nf = NumberFormat.getInstance(locale);
            nf.setGroupingUsed(false);
            formatters.put(locale, nf);
        }
        nf.setMaximumFractionDigits(maxDecimalPlaces);
        return nf.format(value);
    }

    public static Map<String, String> parseArgStringValues(String s) {
        if (s == null) {
            return Collections.emptyMap();
        }
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return (Map)new Gson().fromJson(s, type);
    }

    public static final String micrometerSymbol() {
        return SYMBOL_MICROMETER;
    }

    public static String readFileAsString(String path) throws IOException {
        return Files.readString(Paths.get(path, new String[0]), StandardCharsets.UTF_8);
    }

    public static String readFileAsString(File file) throws IOException {
        return Files.readString(file.toPath(), StandardCharsets.UTF_8);
    }

    public static String readInputStreamAsString(InputStream stream) throws IOException {
        return CharStreams.toString((Readable)new InputStreamReader(stream, StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    public static boolean checkExtensions(String path, String ... extensions) {
        String pathLower = path.toLowerCase();
        for (String string : extensions) {
            void var6_6;
            if (!string.startsWith(".")) {
                String string2 = "." + string;
            }
            if (!pathLower.endsWith(var6_6.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac") || os.contains("darwin");
    }

    public static boolean isAppleSilicon() {
        return GeneralTools.isMac() && "aarch64".equals(System.getProperty("os.arch"));
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("nux") >= 0;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean deleteFile(File fileToDelete, boolean preferTrash) {
        Desktop desktop;
        if (preferTrash && Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MOVE_TO_TRASH) && GeneralTools.moveToTrash(desktop, fileToDelete)) {
            return true;
        }
        return fileToDelete.delete();
    }

    private static boolean moveToTrash(Desktop desktop, File fileToDelete) {
        if (SwingUtilities.isEventDispatchThread() || !GeneralTools.isWindows()) {
            return desktop.moveToTrash(fileToDelete);
        }
        try {
            SwingUtilities.invokeAndWait(() -> GeneralTools.moveToTrash(desktop, fileToDelete));
        }
        catch (Exception e) {
            logger.error("Exception moving file to trash: {}", (Object)e.getMessage(), (Object)e);
            return false;
        }
        return !fileToDelete.exists();
    }

    public static String readURLAsString(URL url, int timeoutMillis) throws IOException {
        StringBuilder response = new StringBuilder();
        String line = null;
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(timeoutMillis);
        String contentType = connection.getContentType();
        if (contentType.startsWith("text/plain")) {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                while ((line = in.readLine()) != null) {
                    response.append(line + "\n");
                }
            }
            return response.toString();
        }
        throw new IOException("Expected content type text/plain, but got " + contentType);
    }

    public static int numNaNs(double[] vals) {
        int count = 0;
        for (double v : vals) {
            if (!Double.isNaN(v)) continue;
            ++count;
        }
        return count;
    }

    public static long sum(long[] values) {
        long total = 0L;
        for (long v : values) {
            total += v;
        }
        return total;
    }

    public static String generateDistinctName(String base, Collection<String> existingNames) {
        if (!existingNames.contains(base)) {
            return base;
        }
        if (Pattern.matches(".* (\\([\\d]+\\))$", (CharSequence)base)) {
            base = ((String)base).substring(0, ((String)base).lastIndexOf(" ("));
        }
        int lastInd = 0;
        Pattern pattern = ((String)base).isEmpty() ? Pattern.compile("\\(([\\d]+)\\)") : Pattern.compile(Pattern.quote((String)base) + " \\(([\\d]+)\\)");
        for (String existing : existingNames) {
            Matcher matcher = pattern.matcher(existing);
            if (((String)base).isEmpty()) {
                if (existing.stripLeading().length() != 3 || !matcher.find()) continue;
                lastInd = Math.max(lastInd, Integer.parseInt(matcher.group(1)));
                continue;
            }
            if (!matcher.find()) continue;
            lastInd = Math.max(lastInd, Integer.parseInt(matcher.group(1)));
        }
        if (!((String)base).isEmpty()) {
            base = (String)base + " ";
        }
        return (String)base + "(" + (lastInd + 1) + ")";
    }

    public static long estimateAvailableMemory() {
        System.gc();
        return Runtime.getRuntime().maxMemory() - GeneralTools.estimateUsedMemory();
    }

    public static long estimateUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return runtime.totalMemory() - runtime.freeMemory();
    }

    public static <T> void smartStringSort(Collection<T> collection) {
        GeneralTools.smartStringSort(collection, Object::toString);
    }

    public static <T> void smartStringSort(Collection<T> collection, Function<T, String> extractor) {
        List<Object> list = collection.stream().map(c -> new StringPartsSorter<Object>(c, (String)extractor.apply(c))).sorted().map(s -> s.obj).toList();
        collection.clear();
        collection.addAll(list);
    }

    public static Comparator<String> smartStringComparator() {
        return (s1, s2) -> new StringPartsSorter<String>((String)s1, (String)s1).compareTo(new StringPartsSorter<String>((String)s2, (String)s2));
    }

    public static String zapGremlins(String text) {
        return GeneralTools.replaceGremlins(text, null);
    }

    public static String replaceGremlins(String text, CharSequence replacement) {
        StringBuilder sb = new StringBuilder();
        int skipCount = 0;
        for (char c : text.toCharArray()) {
            if (c != '\n' && c != '\t' && (c < ' ' || c > '\u007f')) {
                ++skipCount;
                if (replacement == null) continue;
                sb.append(replacement);
                continue;
            }
            sb.append(c);
        }
        if (skipCount == 1) {
            logger.info("Zapped 1 gremlin");
        } else {
            logger.info("Zapped {} gremlins", (Object)skipCount);
        }
        if (skipCount > 0) {
            return sb.toString();
        }
        return text;
    }

    public static String replaceCurlyQuotes(String text) {
        StringBuilder sb = new StringBuilder();
        int replacedCount = 0;
        for (char c : text.toCharArray()) {
            if (c == '\u2018' || c == '\u2019' || c == '\u201b' || c == '\u275b' || c == '\u275c') {
                sb.append("'");
                ++replacedCount;
                continue;
            }
            if (c == '\u201c' || c == '\u201d' || c == '\u201f' || c == '\u275d' || c == '\u275e' || c == '\u301d' || c == '\u301e') {
                sb.append("\"");
                ++replacedCount;
                continue;
            }
            sb.append(c);
        }
        if (replacedCount == 1) {
            logger.warn("Replaced 1 quotes");
        } else {
            logger.info("Replaced {} quotes", (Object)replacedCount);
        }
        if (replacedCount > 0) {
            return sb.toString();
        }
        return text;
    }

    private static class StringPartsSorter<T>
    implements Comparable<StringPartsSorter<T>> {
        private static final Pattern PATTERN = Pattern.compile("(\\d+)");
        private T obj;
        private List<Object> parts;

        StringPartsSorter(T obj, String s) {
            this.obj = obj;
            if (s == null) {
                s = Objects.toString(obj);
            }
            Matcher matcher = PATTERN.matcher(s);
            this.parts = new ArrayList<Object>();
            int next = 0;
            while (matcher.find()) {
                int s1 = matcher.start();
                if (s1 > next) {
                    this.parts.add(s.substring(next, s1));
                }
                this.parts.add(new BigDecimal(matcher.group()));
                next = matcher.end();
            }
            if (next < s.length()) {
                this.parts.add(s.substring(next));
            }
        }

        @Override
        public int compareTo(StringPartsSorter<T> s2) {
            int n = Math.min(this.parts.size(), s2.parts.size());
            for (int i = 0; i < n; ++i) {
                Object p1 = this.parts.get(i);
                Object p2 = s2.parts.get(i);
                int comp = 0;
                comp = p1 instanceof BigDecimal && p2 instanceof BigDecimal ? ((BigDecimal)p1).compareTo((BigDecimal)p2) : p1.toString().compareTo(p2.toString());
                if (comp == 0) continue;
                return comp;
            }
            return Integer.compare(this.parts.size(), s2.parts.size());
        }

        public String toString() {
            return "[" + this.parts.stream().map(p -> p.toString()).collect(Collectors.joining(", ")) + "]";
        }
    }
}

