/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Locale;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;

public class StainVector
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(StainVector.class);
    static int version = 1;
    private double r;
    private double g;
    private double b;
    private String name;
    private boolean isResidual = false;
    private static final double[] STAIN_HEMATOXYLIN_DEFAULT = new double[]{0.65, 0.7, 0.29};
    private static final double[] STAIN_DAB_DEFAULT = new double[]{0.27, 0.57, 0.78};
    private static final double[] STAIN_EOSIN_DEFAULT = new double[]{0.2159, 0.8012, 0.5581};

    public static StainVector makeDefaultStainVector(DefaultStains stain) {
        switch (stain.ordinal()) {
            case 0: {
                return StainVector.createStainVector(stain.toString(), STAIN_HEMATOXYLIN_DEFAULT, false);
            }
            case 1: {
                return StainVector.createStainVector(stain.toString(), STAIN_EOSIN_DEFAULT, false);
            }
            case 2: {
                return StainVector.createStainVector(stain.toString(), STAIN_DAB_DEFAULT, false);
            }
        }
        return null;
    }

    public StainVector() {
    }

    static StainVector createStainVector(String name, double[] vector, boolean isResidual) {
        return new StainVector(name, vector[0], vector[1], vector[2], isResidual);
    }

    public static StainVector createStainVector(String name, double r, double g, double b) {
        return new StainVector(name, r, g, b, false);
    }

    StainVector(String name, double r, double g, double b, boolean isResidual) {
        this.setName(name);
        this.setStain(r, g, b);
        this.isResidual = isResidual;
    }

    public boolean isResidual() {
        return this.isResidual;
    }

    public String getName() {
        return this.name;
    }

    private static double getLength(double r, double g, double b) {
        return Math.sqrt(r * r + g * g + b * b);
    }

    public double getRed() {
        return this.r;
    }

    public double getGreen() {
        return this.g;
    }

    public double getBlue() {
        return this.b;
    }

    private void setName(String name) {
        this.name = name;
    }

    private void setStain(double r, double g, double b) {
        double length = StainVector.getLength(r, g, b);
        if (length <= 0.0) {
            throw new IllegalArgumentException("Stain vector is not valid - must have a length > 0");
        }
        this.r = r / length;
        this.g = g / length;
        this.b = b / length;
    }

    public double[] getArray() {
        return new double[]{this.r, this.g, this.b};
    }

    public int getColor() {
        int r2 = ColorTools.clip255(255.0 - this.r * 255.0);
        int g2 = ColorTools.clip255(255.0 - this.g * 255.0);
        int b2 = ColorTools.clip255(255.0 - this.b * 255.0);
        return ColorTools.packRGB(r2, g2, b2);
    }

    String arrayAsString(Locale locale, int nDecimalPlaces) {
        return GeneralTools.arrayToString(locale, new double[]{this.r, this.g, this.b}, nDecimalPlaces);
    }

    public String arrayAsString(Locale locale) {
        return this.arrayAsString(locale, 3);
    }

    public String toString() {
        return this.name + ": " + this.arrayAsString(Locale.getDefault(Locale.Category.FORMAT));
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StainVector that = (StainVector)o;
        return this.r == that.r && this.g == that.g && this.b == that.b && this.isResidual == that.isResidual && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        int result = Double.hashCode(this.r);
        result = 31 * result + Double.hashCode(this.g);
        result = 31 * result + Double.hashCode(this.b);
        result = 31 * result + Objects.hashCode(this.name);
        result = 31 * result + Boolean.hashCode(this.isResidual);
        return result;
    }

    public static double computeAngle(StainVector s1, StainVector s2) {
        double[] v1 = s1.getArray();
        double[] v2 = s2.getArray();
        if (v1 == null || v2 == null) {
            return Double.NaN;
        }
        double n1 = 0.0;
        double n2 = 0.0;
        double dot = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            n1 += v1[i] * v1[i];
            n2 += v2[i] * v2[i];
            dot += v1[i] * v2[i];
        }
        if (Math.abs(1.0 - dot) < 1.0E-5) {
            return 0.0;
        }
        if (Math.abs(1.0 - Math.sqrt(n1) * Math.sqrt(n2)) < 0.001) {
            return Math.acos(dot) / Math.PI * 180.0;
        }
        return Math.acos(dot / (Math.sqrt(n1) * Math.sqrt(n2))) / Math.PI * 180.0;
    }

    public static double[] cross3(double[] u, double[] v) {
        double[] s = new double[]{u[1] * v[2] - u[2] * v[1], u[2] * v[0] - u[0] * v[2], u[0] * v[1] - u[1] * v[0]};
        return s;
    }

    static StainVector makeResidualStainVector(StainVector s1, StainVector s2) {
        return StainVector.makeOrthogonalStainVector("Residual", s1, s2, true);
    }

    static StainVector makeOrthogonalStainVector(String name, StainVector s1, StainVector s2, boolean isResidual) {
        return StainVector.createStainVector(name, StainVector.cross3(s1.getArray(), s2.getArray()), isResidual);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(version);
        out.writeUTF(this.name);
        out.writeDouble(this.r);
        out.writeDouble(this.g);
        out.writeDouble(this.b);
        out.writeBoolean(this.isResidual);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version != 1) {
            logger.error(this.getClass().getSimpleName() + " unsupported version number " + version);
        }
        this.name = in.readUTF();
        this.r = in.readDouble();
        this.g = in.readDouble();
        this.b = in.readDouble();
        this.isResidual = in.readBoolean();
    }

    public static enum DefaultStains {
        HEMATOXYLIN("Hematoxylin"),
        EOSIN("Eosin"),
        DAB("DAB");

        private String name;

        private DefaultStains(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

