/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.awt.Color;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import qupath.lib.color.ColorDeconvolutionHelper;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.common.ColorTools;

public class ColorTransformer {
    private static final double[] od_lut = ColorDeconvolutionHelper.makeODLUT(255.0, 256);
    private static final double[][] inv_H_DAB;
    private static final double[][] inv_H_E;
    private static final IndexColorModel ICM_RED;
    private static final IndexColorModel ICM_GREEN;
    private static final IndexColorModel ICM_BLUE;
    private static final IndexColorModel ICM_HUE;
    private static final IndexColorModel ICM_HEMATOXYLIN;
    private static final IndexColorModel ICM_EOSIN;
    private static final IndexColorModel ICM_DAB;
    private static final Map<ColorTransformMethod, ColorModel> COLOR_MODEL_MAP;
    private static final double POW_10_INC = 0.0015;
    private static final double[] POW_10_TABLE;
    private static final double LOG_10;

    public static int getODNormalizedColor(int rgb, double minOD, float offset, float scale) {
        double b_od;
        double g_od;
        double r_od = od_lut[ColorTools.red(rgb)];
        double norm = Math.sqrt(r_od * r_od + (g_od = od_lut[ColorTools.green(rgb)]) * g_od + (b_od = od_lut[ColorTools.blue(rgb)]) * b_od);
        if (norm < minOD) {
            norm = minOD;
            return 0xFFFFFF | rgb & ColorTools.MASK_ALPHA;
        }
        int r = 255 - ColorTools.do8BitRangeCheck((255.0 * r_od / norm - (double)offset) * (double)scale);
        int g = 255 - ColorTools.do8BitRangeCheck((255.0 * g_od / norm - (double)offset) * (double)scale);
        int b = 255 - ColorTools.do8BitRangeCheck((255.0 * b_od / norm - (double)offset) * (double)scale);
        return (r << 16) + (g << 8) + b & ~ColorTools.MASK_ALPHA.intValue() | rgb & ColorTools.MASK_ALPHA;
    }

    public static float getDefaultTransformedMax(ColorTransformMethod method) {
        float deconvMax = 2.5f;
        float chromaticityMax = 1.0f;
        switch (method.ordinal()) {
            case 30: {
                return 1.0f;
            }
            case 3: {
                return 255.0f;
            }
            case 25: {
                return chromaticityMax;
            }
            case 28: {
                return 255.0f;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return deconvMax;
            }
            case 2: {
                return 255.0f;
            }
            case 24: {
                return chromaticityMax;
            }
            case 26: {
                return 255.0f;
            }
            case 14: {
                return deconvMax * 2.0f;
            }
            case 8: {
                return 1.0f;
            }
            case 10: {
                return 1.0f;
            }
            case 9: {
                return 1.0f;
            }
            case 0: {
                return 255.0f;
            }
            case 7: {
                return 255.0f;
            }
            case 1: {
                return 255.0f;
            }
            case 23: {
                return chromaticityMax;
            }
            case 29: {
                return 1.0f;
            }
        }
        return 255.0f;
    }

    public static float[] getSimpleTransformedPixels(int[] buf, ColorTransformMethod method, float[] pixels) {
        return ColorTransformer.getTransformedPixels(buf, method, pixels, null);
    }

    public static float[] getTransformedPixels(int[] buf, ColorTransformMethod method, float[] pixels, ColorDeconvolutionStains stains) {
        if (pixels == null || pixels.length != buf.length) {
            pixels = new float[buf.length];
        }
        switch (method.ordinal()) {
            case 1: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTools.red(buf[i]);
                }
                break;
            }
            case 2: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTools.green(buf[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTools.blue(buf[i]);
                }
                break;
            }
            case 4: {
                double[] od_lut = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = (float)od_lut[ColorTools.red(buf[i])];
                }
                break;
            }
            case 5: {
                double[] od_lut = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = (float)od_lut[ColorTools.green(buf[i])];
                }
                break;
            }
            case 6: {
                double[] od_lut = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = (float)od_lut[ColorTools.blue(buf[i])];
                }
                break;
            }
            case 7: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.rgbMean(buf[i]);
                }
                break;
            }
            case 23: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.redChromaticity(buf[i]);
                }
                break;
            }
            case 24: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.greenChromaticity(buf[i]);
                }
                break;
            }
            case 25: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.blueChromaticity(buf[i]);
                }
                break;
            }
            case 26: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.greenOverBlue(buf[i]);
                }
                break;
            }
            case 28: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.brown(buf[i]);
                }
                break;
            }
            case 15: {
                if (stains == null || !stains.isH_E()) {
                    throw new IllegalArgumentException("No valid H&E stains supplied!");
                }
            }
            case 11: {
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 1);
                }
                break;
            }
            case 16: {
                if (stains == null || !stains.isH_E()) {
                    throw new IllegalArgumentException("No valid H&E stains supplied!");
                }
            }
            case 12: {
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 2);
                }
                break;
            }
            case 13: {
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 3);
                }
                break;
            }
            case 17: {
                if (stains == null || !stains.isH_DAB()) {
                    throw new IllegalArgumentException("No valid H-DAB stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 1);
                }
                break;
            }
            case 18: {
                if (stains == null || !stains.isH_DAB()) {
                    throw new IllegalArgumentException("No valid H-DAB stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 2);
                }
                break;
            }
            case 19: {
                if (stains == null || !stains.isH_E()) {
                    throw new IllegalArgumentException("No valid H&E stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve8bit(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 1);
                }
                break;
            }
            case 20: {
                if (stains == null || !stains.isH_E()) {
                    throw new IllegalArgumentException("No valid H&E stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve8bit(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 2);
                }
                break;
            }
            case 21: {
                if (stains == null || !stains.isH_DAB()) {
                    throw new IllegalArgumentException("No valid H-DAB stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve8bit(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 1);
                }
                break;
            }
            case 22: {
                if (stains == null || !stains.isH_DAB()) {
                    throw new IllegalArgumentException("No valid H-DAB stains supplied!");
                }
                double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                double[][] inverse = stains.getMatrixInverse();
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.deconvolve8bit(buf[i], inverse, od_lut_red, od_lut_green, od_lut_blue, 2);
                }
                break;
            }
            case 8: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.hue(buf[i]);
                }
                break;
            }
            case 9: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.saturation(buf[i]);
                }
                break;
            }
            case 10: {
                for (int i = 0; i < buf.length; ++i) {
                    pixels[i] = ColorTransformer.brightness(buf[i]);
                }
                break;
            }
            case 29: {
                Arrays.fill(pixels, 255.0f);
                break;
            }
            case 30: {
                Arrays.fill(pixels, 0.0f);
                break;
            }
            case 14: {
                if (stains != null) {
                    double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                    double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                    double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                    for (int i = 0; i < buf.length; ++i) {
                        pixels[i] = ColorTransformer.opticalDensitySum(buf[i], od_lut_red, od_lut_green, od_lut_blue);
                    }
                } else {
                    double[] od_lut = ColorDeconvolutionHelper.makeODLUT(255.0);
                    for (int i = 0; i < buf.length; ++i) {
                        pixels[i] = ColorTransformer.opticalDensitySum(buf[i], od_lut);
                    }
                }
                break;
            }
            case 0: {
                return null;
            }
        }
        return pixels;
    }

    public static float getStainRejection(int rgb, double rStain, double gStain, double bStain, double[] od_lut_red, double[] od_lut_green, double[] od_lut_blue) {
        double r = od_lut_red[(rgb & 0xFF0000) >> 16];
        double g = od_lut_green[(rgb & 0xFF00) >> 8];
        double b = od_lut_blue[rgb & 0xFF];
        double projection = r * rStain + g * gStain + b * bStain;
        double rejection = Math.sqrt(r * r + g * g + b * b - projection * projection);
        return (float)rejection;
    }

    public static float getStainProjection(int rgb, double rStain, double gStain, double bStain, double[] od_lut_red, double[] od_lut_green, double[] od_lut_blue) {
        double r = od_lut_red[(rgb & 0xFF0000) >> 16];
        double g = od_lut_green[(rgb & 0xFF00) >> 8];
        double b = od_lut_blue[rgb & 0xFF];
        double projection = r * rStain + g * gStain + b * bStain;
        return (float)projection;
    }

    public static float opticalDensitySum(int rgb, double[] od_lut) {
        if (od_lut == null) {
            od_lut = ColorTransformer.od_lut;
        }
        double r = od_lut[(rgb & 0xFF0000) >> 16];
        double g = od_lut[(rgb & 0xFF00) >> 8];
        double b = od_lut[rgb & 0xFF];
        return (float)(r + g + b);
    }

    public static float opticalDensitySum(int rgb, double[] od_lut_red, double[] od_lut_green, double[] od_lut_blue) {
        double r = od_lut_red[(rgb & 0xFF0000) >> 16];
        double g = od_lut_green[(rgb & 0xFF00) >> 8];
        double b = od_lut_blue[rgb & 0xFF];
        return (float)(r + g + b);
    }

    static float deconvolve(int rgb, double[][] invMat, double[] od_lut_red, double[] od_lut_green, double[] od_lut_blue, int stain) {
        double r = od_lut_red[(rgb & 0xFF0000) >> 16];
        double g = od_lut_green[(rgb & 0xFF00) >> 8];
        double b = od_lut_blue[rgb & 0xFF];
        return (float)(r * invMat[0][stain - 1] + g * invMat[1][stain - 1] + b * invMat[2][stain - 1]);
    }

    static float deconvolve(int rgb, double[][] invMat, double[] od_lut, int stain) {
        double r = od_lut[(rgb & 0xFF0000) >> 16];
        double g = od_lut[(rgb & 0xFF00) >> 8];
        double b = od_lut[rgb & 0xFF];
        return (float)(r * invMat[0][stain - 1] + g * invMat[1][stain - 1] + b * invMat[2][stain - 1]);
    }

    private static int deconvolve8bit(int rgb, double[][] invMat, double[] od_lut_red, double[] od_lut_green, double[] od_lut_blue, int stain) {
        return ColorTools.do8BitRangeCheck(Math.exp(-ColorTransformer.deconvolve(rgb, invMat, od_lut_red, od_lut_green, od_lut_blue, stain)) * 255.0);
    }

    public static float rgbMean(int rgb) {
        int r = (rgb & ColorTools.MASK_RED) >> 16;
        int g = (rgb & ColorTools.MASK_GREEN) >> 8;
        int b = rgb & ColorTools.MASK_BLUE;
        return (float)(r + g + b) / 3.0f;
    }

    public static float redChromaticity(int rgb) {
        float r = (rgb & ColorTools.MASK_RED) >> 16;
        float g = (rgb & ColorTools.MASK_GREEN) >> 8;
        float b = rgb & ColorTools.MASK_BLUE;
        return r / Math.max(1.0f, r + g + b);
    }

    public static float greenChromaticity(int rgb) {
        float r = (rgb & ColorTools.MASK_RED) >> 16;
        float g = (rgb & ColorTools.MASK_GREEN) >> 8;
        float b = rgb & ColorTools.MASK_BLUE;
        return g / Math.max(1.0f, r + g + b);
    }

    public static float blueChromaticity(int rgb) {
        float r = (rgb & ColorTools.MASK_RED) >> 16;
        float g = (rgb & ColorTools.MASK_GREEN) >> 8;
        float b = rgb & ColorTools.MASK_BLUE;
        return b / Math.max(1.0f, r + g + b);
    }

    public static float greenOverBlue(int rgb) {
        float g = (rgb & ColorTools.MASK_GREEN) >> 8;
        float b = rgb & ColorTools.MASK_BLUE;
        return g / Math.max(b, 1.0f);
    }

    public static float brown(int rgb) {
        int r = (rgb & ColorTools.MASK_RED) >> 16;
        int g = (rgb & ColorTools.MASK_GREEN) >> 8;
        int b = rgb & ColorTools.MASK_BLUE;
        return (float)b - (float)(r + g) * 0.3f;
    }

    public static float hue(int rgb) {
        int r = (rgb & ColorTools.MASK_RED) >> 16;
        int g = (rgb & ColorTools.MASK_GREEN) >> 8;
        int b = rgb & ColorTools.MASK_BLUE;
        return Color.RGBtoHSB(r, g, b, null)[0];
    }

    public static float saturation(int rgb) {
        int r = (rgb & ColorTools.MASK_RED) >> 16;
        int g = (rgb & ColorTools.MASK_GREEN) >> 8;
        int b = rgb & ColorTools.MASK_BLUE;
        return Color.RGBtoHSB(r, g, b, null)[1];
    }

    public static float brightness(int rgb) {
        int r = (rgb & ColorTools.MASK_RED) >> 16;
        int g = (rgb & ColorTools.MASK_GREEN) >> 8;
        int b = rgb & ColorTools.MASK_BLUE;
        return Color.RGBtoHSB(r, g, b, null)[2];
    }

    public static float getPixelValue(int rgb, ColorTransformMethod method) {
        return ColorTransformer.getPixelValue(rgb, method, null);
    }

    public static float getPixelValue(int rgb, ColorTransformMethod method, ColorDeconvolutionStains stains) {
        switch (method.ordinal()) {
            case 1: {
                return ColorTools.red(rgb);
            }
            case 2: {
                return ColorTools.green(rgb);
            }
            case 3: {
                return ColorTools.blue(rgb);
            }
            case 7: {
                return ColorTransformer.rgbMean(rgb);
            }
            case 23: {
                return ColorTransformer.redChromaticity(rgb);
            }
            case 24: {
                return ColorTransformer.greenChromaticity(rgb);
            }
            case 25: {
                return ColorTransformer.blueChromaticity(rgb);
            }
            case 26: {
                return ColorTransformer.greenOverBlue(rgb);
            }
            case 28: {
                return ColorTransformer.brown(rgb);
            }
            case 15: {
                return ColorTransformer.deconvolve(rgb, inv_H_E, od_lut, 1);
            }
            case 16: {
                return ColorTransformer.deconvolve(rgb, inv_H_E, od_lut, 2);
            }
            case 17: {
                return ColorTransformer.deconvolve(rgb, inv_H_DAB, od_lut, 1);
            }
            case 18: {
                return ColorTransformer.deconvolve(rgb, inv_H_DAB, od_lut, 2);
            }
            case 29: {
                return Float.NaN;
            }
            case 30: {
                return Float.NaN;
            }
            case 14: {
                return ColorTransformer.opticalDensitySum(rgb, od_lut);
            }
            case 8: {
                return ColorTransformer.hue(rgb);
            }
            case 9: {
                return ColorTransformer.saturation(rgb);
            }
            case 0: {
                return Float.NaN;
            }
            case 11: {
                if (stains != null) {
                    double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                    double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                    double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                    double[][] inverse = stains.getMatrixInverse();
                    return ColorTransformer.deconvolve(rgb, inverse, od_lut_red, od_lut_green, od_lut_blue, 1);
                }
                return Float.NaN;
            }
            case 12: {
                if (stains != null) {
                    double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                    double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                    double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                    double[][] inverse = stains.getMatrixInverse();
                    return ColorTransformer.deconvolve(rgb, inverse, od_lut_red, od_lut_green, od_lut_blue, 2);
                }
                return Float.NaN;
            }
            case 13: {
                if (stains != null) {
                    double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stains.getMaxRed());
                    double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stains.getMaxGreen());
                    double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stains.getMaxBlue());
                    double[][] inverse = stains.getMatrixInverse();
                    return ColorTransformer.deconvolve(rgb, inverse, od_lut_red, od_lut_green, od_lut_blue, 3);
                }
                return Float.NaN;
            }
        }
        return Float.NaN;
    }

    public static int makeScaledRGBwithRangeCheck(float v, float offset, float scale, ColorModel cm) {
        return ColorTransformer.makeRGB(ColorTools.do8BitRangeCheck((v - offset) * scale), cm);
    }

    public static ColorModel getDefaultColorModel(ColorTransformMethod method) {
        return COLOR_MODEL_MAP.get((Object)method);
    }

    public static void transformRGB(int[] buf, int[] bufOutput, ColorTransformMethod method, float offset, float scale, boolean useColorLUT) {
        ColorModel cm = useColorLUT ? COLOR_MODEL_MAP.get((Object)method) : null;
        switch (method.ordinal()) {
            case 0: {
                if (offset == 0.0f && scale == 1.0f) {
                    if (buf != bufOutput) {
                        System.arraycopy(buf, 0, bufOutput, 0, buf.length);
                    }
                    return;
                }
                for (int i = 0; i < buf.length; ++i) {
                    int rgb = buf[i];
                    int r = ColorTools.do8BitRangeCheck(((float)ColorTools.red(rgb) - offset) * scale);
                    int g = ColorTools.do8BitRangeCheck(((float)ColorTools.green(rgb) - offset) * scale);
                    int b = ColorTools.do8BitRangeCheck(((float)ColorTools.blue(rgb) - offset) * scale);
                    bufOutput[i] = (r << 16) + (g << 8) + b & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                return;
            }
            case 1: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTools.red(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 2: {
                if (useColorLUT) {
                    cm = ICM_GREEN;
                }
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTools.green(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 3: {
                if (useColorLUT) {
                    cm = ICM_BLUE;
                }
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTools.blue(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 7: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.rgbMean(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 23: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.redChromaticity(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 24: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.greenChromaticity(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 25: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.blueChromaticity(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 26: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.greenOverBlue(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 28: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.brown(buf[i]), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 15: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.deconvolve(buf[i], inv_H_E, od_lut, 1), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 16: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.deconvolve(buf[i], inv_H_E, od_lut, 2), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 17: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.deconvolve(buf[i], inv_H_DAB, od_lut, 1), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 18: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.deconvolve(buf[i], inv_H_DAB, od_lut, 2), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 14: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.makeScaledRGBwithRangeCheck(ColorTransformer.opticalDensitySum(buf[i], null), offset, scale, cm) & ~ColorTools.MASK_ALPHA.intValue() | buf[i] & ColorTools.MASK_ALPHA;
                }
                break;
            }
            case 27: {
                for (int i = 0; i < buf.length; ++i) {
                    bufOutput[i] = ColorTransformer.getODNormalizedColor(buf[i], 0.1, offset, scale);
                }
                break;
            }
            case 29: {
                Arrays.fill(bufOutput, ColorTools.MASK_RED | ColorTools.MASK_GREEN | ColorTools.MASK_BLUE);
                break;
            }
            case 30: {
                Arrays.fill(bufOutput, 0);
                break;
            }
        }
    }

    private static int makeRGB(int v, ColorModel cm) {
        if (cm == null) {
            return -16777216 + (v << 16) + (v << 8) + v;
        }
        return cm.getRGB(v);
    }

    public static float colorDeconvolveRGBPixel(int rgb, ColorDeconvolutionStains stains, int channel) {
        double[][] matInv = stains.getMatrixInverse();
        double scaleRed = matInv[0][channel];
        double scaleGreen = matInv[1][channel];
        double scaleBlue = matInv[2][channel];
        double r = ColorDeconvolutionHelper.makeOD((rgb & 0xFF0000) >> 16, stains.getMaxRed());
        double g = ColorDeconvolutionHelper.makeOD((rgb & 0xFF00) >> 8, stains.getMaxGreen());
        double b = ColorDeconvolutionHelper.makeOD(rgb & 0xFF, stains.getMaxBlue());
        return (float)(r * scaleRed + g * scaleGreen + b * scaleBlue);
    }

    private static double pow10Approx(double x) {
        int ind = (int)(x / 0.0015);
        if (ind < 0 || ind >= POW_10_TABLE.length) {
            return Math.exp(-LOG_10 * x);
        }
        return POW_10_TABLE[ind];
    }

    public static int[] colorDeconvolveReconvolveRGBArray(int[] buf, ColorDeconvolutionStains stainsInput, ColorDeconvolutionStains stainsOutput, boolean discardResidual, int[] bufOutput) {
        double[] scales = null;
        if (discardResidual) {
            scales = new double[3];
            for (int i = 0; i < 3; ++i) {
                scales[i] = stainsInput.getStain(i + 1).isResidual() ? 0.0 : 1.0;
            }
        }
        return ColorTransformer.colorDeconvolveReconvolveRGBArray(buf, stainsInput, stainsOutput, bufOutput, scales);
    }

    public static int[] colorDeconvolveReconvolveRGBArray(int[] buf, ColorDeconvolutionStains stainsInput, ColorDeconvolutionStains stainsOutput, int[] bufOutput, double[] stainScales) {
        if (bufOutput == null || bufOutput.length < buf.length) {
            bufOutput = new int[buf.length];
        } else if (stainsInput == null) {
            Arrays.fill(bufOutput, 0);
        }
        double[] scales = null;
        if (stainScales != null) {
            scales = new double[3];
            Arrays.fill(scales, 1.0);
            System.arraycopy(stainScales, 0, scales, 0, Math.min(scales.length, stainScales.length));
        }
        if (stainsInput == null) {
            return bufOutput;
        }
        double[][] matInv = stainsInput.getMatrixInverse();
        double s00 = matInv[0][0];
        double s01 = matInv[0][1];
        double s02 = matInv[0][2];
        double s10 = matInv[1][0];
        double s11 = matInv[1][1];
        double s12 = matInv[1][2];
        double s20 = matInv[2][0];
        double s21 = matInv[2][1];
        double s22 = matInv[2][2];
        double d00 = stainsOutput.getStain(1).getRed();
        double d01 = stainsOutput.getStain(1).getGreen();
        double d02 = stainsOutput.getStain(1).getBlue();
        double d10 = stainsOutput.getStain(2).getRed();
        double d11 = stainsOutput.getStain(2).getGreen();
        double d12 = stainsOutput.getStain(2).getBlue();
        double d20 = stainsOutput.getStain(3).getRed();
        double d21 = stainsOutput.getStain(3).getGreen();
        double d22 = stainsOutput.getStain(3).getBlue();
        double maxRed = stainsOutput.getMaxRed();
        double maxGreen = stainsOutput.getMaxGreen();
        double maxBlue = stainsOutput.getMaxBlue();
        double[] od_lut_red = ColorDeconvolutionHelper.makeODLUT(stainsInput.getMaxRed());
        double[] od_lut_green = ColorDeconvolutionHelper.makeODLUT(stainsInput.getMaxGreen());
        double[] od_lut_blue = ColorDeconvolutionHelper.makeODLUT(stainsInput.getMaxBlue());
        for (int i = 0; i < buf.length; ++i) {
            int c = buf[i];
            int a = ColorTools.alpha(c);
            double r = od_lut_red[(c & 0xFF0000) >> 16];
            double g = od_lut_green[(c & 0xFF00) >> 8];
            double b = od_lut_blue[c & 0xFF];
            double stain1 = r * s00 + g * s10 + b * s20;
            double stain2 = r * s01 + g * s11 + b * s21;
            double stain3 = r * s02 + g * s12 + b * s22;
            if (scales != null) {
                stain1 *= scales[0];
                stain2 *= scales[1];
                stain3 *= scales[2];
            }
            r = ColorTransformer.pow10Approx(stain1 * d00 + stain2 * d10 + stain3 * d20) * maxRed;
            g = ColorTransformer.pow10Approx(stain1 * d01 + stain2 * d11 + stain3 * d21) * maxGreen;
            b = ColorTransformer.pow10Approx(stain1 * d02 + stain2 * d12 + stain3 * d22) * maxBlue;
            bufOutput[i] = ColorTools.packARGB(a, ColorTools.do8BitRangeCheck(r), ColorTools.do8BitRangeCheck(g), ColorTools.do8BitRangeCheck(b));
        }
        return bufOutput;
    }

    static {
        ColorDeconvolutionStains stains_H_DAB = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_DAB);
        inv_H_DAB = stains_H_DAB.getMatrixInverse();
        ColorDeconvolutionStains stains_H_E = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_E);
        inv_H_E = stains_H_E.getMatrixInverse();
        ICM_RED = ColorToolsAwt.createIndexColorModel(255, 0, 0);
        ICM_GREEN = ColorToolsAwt.createIndexColorModel(0, 255, 0);
        ICM_BLUE = ColorToolsAwt.createIndexColorModel(0, 0, 255);
        ICM_HUE = ColorToolsAwt.createHueColorModel();
        stains_H_DAB = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_DAB);
        ICM_HEMATOXYLIN = ColorToolsAwt.getIndexColorModel(stains_H_DAB.getStain(1));
        ICM_DAB = ColorToolsAwt.getIndexColorModel(stains_H_DAB.getStain(2));
        stains_H_E = ColorDeconvolutionStains.makeDefaultColorDeconvolutionStains(ColorDeconvolutionStains.DefaultColorDeconvolutionStains.H_E);
        ICM_EOSIN = ColorToolsAwt.getIndexColorModel(stains_H_E.getStain(2));
        COLOR_MODEL_MAP = new HashMap<ColorTransformMethod, ColorModel>();
        COLOR_MODEL_MAP.put(ColorTransformMethod.Red, ICM_RED);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Green, ICM_GREEN);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Blue, ICM_BLUE);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Red_chromaticity, ICM_RED);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Green_chromaticity, ICM_GREEN);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Blue_chromaticity, ICM_BLUE);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Hematoxylin_H_DAB, ICM_HEMATOXYLIN);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Hematoxylin_H_E, ICM_HEMATOXYLIN);
        COLOR_MODEL_MAP.put(ColorTransformMethod.DAB_H_DAB, ICM_DAB);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Eosin_H_E, ICM_EOSIN);
        COLOR_MODEL_MAP.put(ColorTransformMethod.Hue, ICM_HUE);
        POW_10_TABLE = new double[2500];
        LOG_10 = Math.log(10.0);
        for (int i = 0; i < POW_10_TABLE.length; ++i) {
            ColorTransformer.POW_10_TABLE[i] = Math.exp(-LOG_10 * (double)i * 0.0015);
        }
    }

    public static enum ColorTransformMethod {
        Original,
        Red,
        Green,
        Blue,
        Red_OD,
        Green_OD,
        Blue_OD,
        RGB_mean,
        Hue,
        Saturation,
        Brightness,
        Stain_1,
        Stain_2,
        Stain_3,
        Optical_density_sum,
        Hematoxylin_H_E,
        Eosin_H_E,
        Hematoxylin_H_DAB,
        DAB_H_DAB,
        Hematoxylin_H_E_8_bit,
        Eosin_H_E_8_bit,
        Hematoxylin_H_DAB_8_bit,
        DAB_H_DAB_8_bit,
        Red_chromaticity,
        Green_chromaticity,
        Blue_chromaticity,
        Green_divided_by_blue,
        OD_Normalized,
        Brown,
        White,
        Black;


        public String toString() {
            return super.toString().replaceAll("_", " ");
        }
    }
}

