/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.color;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorDeconvMatrix3x3;
import qupath.lib.color.StainVector;
import qupath.lib.common.GeneralTools;

public class ColorDeconvolutionStains
implements Externalizable {
    public static final String BACKGROUND_KEY = "Background";
    public static final String RESIDUAL_KEY = "Residual";
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(ColorDeconvolutionStains.class);
    private static int version = 1;
    public static final String HEMATOXYLIN = "Hematoxylin";
    public static final String EOSIN = "Eosin";
    public static final String DAB = "DAB";
    private static String[] HEMATOXYLIN_SPELLINGS = new String[]{"haematoxylin", "hematoxylin", "haem", "h"};
    private static String[] EOSIN_SPELLINGS = new String[]{"eosin", "eos", "e"};
    private static String[] DAB_SPELLINGS = new String[]{"dab", "d"};
    private String name;
    private StainVector stain1;
    private StainVector stain2;
    private StainVector stain3;
    private double maxRed;
    private double maxGreen;
    private double maxBlue;
    private transient double[][] matInverse = null;

    public static ColorDeconvolutionStains makeDefaultColorDeconvolutionStains(DefaultColorDeconvolutionStains stains) {
        switch (stains.ordinal()) {
            case 0: {
                return new ColorDeconvolutionStains("H&E default", StainVector.makeDefaultStainVector(StainVector.DefaultStains.HEMATOXYLIN), StainVector.makeDefaultStainVector(StainVector.DefaultStains.EOSIN), 255.0, 255.0, 255.0);
            }
            case 1: {
                return new ColorDeconvolutionStains("H-DAB default", StainVector.makeDefaultStainVector(StainVector.DefaultStains.HEMATOXYLIN), StainVector.makeDefaultStainVector(StainVector.DefaultStains.DAB), 255.0, 255.0, 255.0);
            }
        }
        return null;
    }

    private static ColorDeconvolutionStains makeModifiedStains(ColorDeconvolutionStains stains, StainVector stainNew, int stainNumber) {
        StainVector[] stainVectors = new StainVector[]{stains.getStain(1), stains.getStain(2), stains.getStain(3)};
        stainVectors[stainNumber - 1] = stainNew;
        if (stainVectors[2].isResidual()) {
            stainVectors[2] = null;
        }
        return new ColorDeconvolutionStains(stains.getName(), stainVectors[0], stainVectors[1], stainVectors[2], stains.getMaxRed(), stains.getMaxGreen(), stains.getMaxBlue());
    }

    public static boolean isHematoxylin(StainVector stain) {
        String name = stain.getName();
        if (name == null) {
            return false;
        }
        name = name.toLowerCase().trim();
        for (String s : HEMATOXYLIN_SPELLINGS) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEosin(StainVector stain) {
        String name = stain.getName();
        if (name == null) {
            return false;
        }
        name = name.toLowerCase().trim();
        for (String s : EOSIN_SPELLINGS) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDAB(StainVector stain) {
        String name = stain.getName();
        if (name == null) {
            return false;
        }
        name = name.toLowerCase().trim();
        for (String s : DAB_SPELLINGS) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isH_E() {
        return this.stain3.isResidual() && ColorDeconvolutionStains.isHematoxylin(this.stain1) && ColorDeconvolutionStains.isEosin(this.stain2);
    }

    public boolean isH_DAB() {
        return ColorDeconvolutionStains.isHematoxylin(this.stain1) && ColorDeconvolutionStains.isDAB(this.stain2);
    }

    public ColorDeconvolutionStains changeStain(StainVector stainNew, int stainNumber) {
        return ColorDeconvolutionStains.makeModifiedStains(this, stainNew, stainNumber);
    }

    public ColorDeconvolutionStains changeName(String name) {
        return new ColorDeconvolutionStains(name, this.getStain(1), this.getStain(2), this.getStain(3), this.getMaxRed(), this.getMaxGreen(), this.getMaxBlue());
    }

    public ColorDeconvolutionStains changeMaxValues(double maxRed, double maxGreen, double maxBlue) {
        return new ColorDeconvolutionStains(this.getName(), this.getStain(1), this.getStain(2), this.getStain(3), maxRed, maxGreen, maxBlue);
    }

    public ColorDeconvolutionStains(String name, StainVector stain1, StainVector stain2, StainVector stain3, double maxRed, double maxGreen, double maxBlue) {
        this.name = name;
        this.stain1 = stain1;
        this.stain2 = stain2;
        this.stain3 = stain3 == null && stain1 != null && stain2 != null ? StainVector.makeResidualStainVector(stain1, stain2) : stain3;
        this.maxRed = maxRed;
        this.maxGreen = maxGreen;
        this.maxBlue = maxBlue;
    }

    public ColorDeconvolutionStains(String name, StainVector stain1, StainVector stain2, double maxRed, double maxGreen, double maxBlue) {
        this(name, stain1, stain2, null, maxRed, maxGreen, maxBlue);
    }

    public ColorDeconvolutionStains() {
    }

    public StainVector getStain(int n) {
        if (n == 1) {
            return this.stain1;
        }
        if (n == 2) {
            return this.stain2;
        }
        if (n == 3) {
            return this.stain3;
        }
        if (n == 0) {
            logger.error("Stains are not zero-based! Do you mean you want stain 1?");
        }
        return null;
    }

    public List<StainVector> getStains() {
        return List.of(this.stain1, this.stain2, this.stain3);
    }

    public Collection<StainVector> getStains(boolean includeResidual) {
        ArrayList<StainVector> list = new ArrayList<StainVector>();
        for (int s = 1; s <= 3; ++s) {
            StainVector stain = this.getStain(s);
            if (!includeResidual && stain.isResidual()) continue;
            list.add(stain);
        }
        return list;
    }

    public String getName() {
        return this.name;
    }

    public int getStainNumber(StainVector stain) {
        if (this.stain1.equals(stain)) {
            return 1;
        }
        if (this.stain2.equals(stain)) {
            return 2;
        }
        if (this.stain3.equals(stain)) {
            return 3;
        }
        return -1;
    }

    public double getMaxRed() {
        return this.maxRed;
    }

    public double getMaxGreen() {
        return this.maxGreen;
    }

    public double getMaxBlue() {
        return this.maxBlue;
    }

    public double[][] getMatrixInverse() {
        if (this.matInverse == null) {
            double[][] stainMat = new double[][]{this.getStain(1).getArray(), this.getStain(2).getArray(), this.getStain(3).getArray()};
            ColorDeconvMatrix3x3 mat3x3 = new ColorDeconvMatrix3x3(stainMat);
            this.matInverse = mat3x3.inverse();
        }
        return this.matInverse;
    }

    public String toString() {
        return "Color deconvolution stains: " + String.valueOf(this.stain1) + ", " + String.valueOf(this.stain2) + ", " + String.valueOf(this.stain3);
    }

    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + (int)this.maxRed;
        hash = 31 * hash + (int)this.maxGreen;
        hash = 31 * hash + (int)this.maxBlue;
        hash = 31 * hash + (this.name == null ? 0 : this.name.hashCode());
        hash = 31 * hash + (this.stain1 == null ? 0 : this.stain1.hashCode());
        hash = 31 * hash + (this.stain2 == null ? 0 : this.stain2.hashCode());
        hash = 31 * hash + (this.stain3 == null ? 0 : this.stain3.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ColorDeconvolutionStains)) {
            return false;
        }
        ColorDeconvolutionStains colorDeconvolutionStains = (ColorDeconvolutionStains)obj;
        return this.maxRed == colorDeconvolutionStains.maxRed && this.maxGreen == colorDeconvolutionStains.maxGreen && this.maxBlue == colorDeconvolutionStains.maxBlue && Objects.equals(this.stain1, colorDeconvolutionStains.stain1) && Objects.equals(this.stain2, colorDeconvolutionStains.stain2) && Objects.equals(this.stain3, colorDeconvolutionStains.stain3) && Objects.equals(this.name, colorDeconvolutionStains.name);
    }

    public static String getColorDeconvolutionStainsAsString(ColorDeconvolutionStains stains, int nDecimalPlaces) {
        if (stains == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("\"Name").append("\" : \"").append(stains.getName()).append("\", ");
        for (int i = 1; i <= 3; ++i) {
            StainVector stain = stains.getStain(i);
            if (i == 3 && stain.isResidual()) continue;
            sb.append("\"Stain ").append(i).append("\" : \"").append(stain.getName()).append("\", ");
            sb.append("\"Values ").append(i).append("\" : \"").append(stain.arrayAsString(Locale.US, nDecimalPlaces)).append("\", ");
        }
        sb.append("\"Background\" : \"");
        sb.append(" ").append(GeneralTools.arrayToString(Locale.US, new double[]{stains.getMaxRed(), stains.getMaxGreen(), stains.getMaxBlue()}, nDecimalPlaces));
        sb.append("\"}");
        return sb.toString();
    }

    public static ColorDeconvolutionStains parseColorDeconvolutionStainsArg(String s) {
        Map<String, String> map = GeneralTools.parseArgStringValues(s);
        if (map.isEmpty()) {
            return null;
        }
        StainVector stain1 = ColorDeconvolutionStains.parseStainVector(Locale.US, map.get("Stain 1"), map.get("Values 1"));
        StainVector stain2 = ColorDeconvolutionStains.parseStainVector(Locale.US, map.get("Stain 2"), map.get("Values 2"));
        StainVector stain3 = null;
        if (map.containsKey("Stain 3")) {
            stain3 = ColorDeconvolutionStains.parseStainVector(Locale.US, map.get("Stain 3"), map.get("Values 3"));
        }
        double[] background = ColorDeconvolutionStains.parseStainValues(Locale.US, map.get(BACKGROUND_KEY));
        return new ColorDeconvolutionStains(map.get("Name"), stain1, stain2, stain3, background[0], background[1], background[2]);
    }

    private static StainVector parseStainVector(Locale locale, String name, String s) {
        double[] vector;
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).length() == 0) {
            return null;
        }
        if (s.length() == 1) {
            if ((s = s.toLowerCase()).equals("h")) {
                return StainVector.makeDefaultStainVector(StainVector.DefaultStains.HEMATOXYLIN);
            }
            if (s.equals("e")) {
                return StainVector.makeDefaultStainVector(StainVector.DefaultStains.EOSIN);
            }
            if (s.equals("d")) {
                return StainVector.makeDefaultStainVector(StainVector.DefaultStains.DAB);
            }
        }
        if ((vector = ColorDeconvolutionStains.parseStainValues(locale, s)) != null) {
            return StainVector.createStainVector(name, vector[0], vector[1], vector[2]);
        }
        return null;
    }

    public static double[] parseStainValues(Locale locale, String s) {
        double[] vector = new double[3];
        StringTokenizer tokenizer = new StringTokenizer(s, " \t\n\r\f[]");
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (token.endsWith(",")) {
                token = token.substring(0, token.length() - 1);
            }
            try {
                vector[i] = NumberFormat.getInstance(locale).parse(token).doubleValue();
            }
            catch (Exception e) {
                vector[i] = Double.parseDouble(token);
            }
            if (++i != 3) continue;
            return vector;
        }
        return null;
    }

    public static ColorDeconvolutionStains parseColorDeconvolutionStains(String name, Map<String, List<Number>> stains) {
        Objects.requireNonNull(name);
        Optional<String> backgroundStainName = stains.keySet().stream().filter(BACKGROUND_KEY::equalsIgnoreCase).findAny();
        if (backgroundStainName.isEmpty() || stains.get(backgroundStainName.get()).size() < 3 || IntStream.range(0, 3).mapToObj(i -> (Number)((List)stains.get(backgroundStainName.get())).get(i)).anyMatch(Objects::isNull)) {
            throw new IllegalArgumentException(String.format("The provided stains %s do not contain a '%s' stain with at least three values", stains, BACKGROUND_KEY));
        }
        ArrayList<StainVector> stainVectors = new ArrayList<StainVector>();
        for (Map.Entry<String, List<Number>> entry : stains.entrySet()) {
            if (backgroundStainName.get().equals(entry.getKey())) continue;
            if (entry.getValue() == null || entry.getValue().size() != 3 || IntStream.range(0, 3).mapToObj(i -> (Number)((List)entry.getValue()).get(i)).anyMatch(Objects::isNull)) {
                logger.warn("Stain {} does not contain three values (it is {}). Skipping it", (Object)entry.getKey(), entry.getValue());
                continue;
            }
            stainVectors.add(new StainVector(entry.getKey(), entry.getValue().get(0).doubleValue(), entry.getValue().get(1).doubleValue(), entry.getValue().get(2).doubleValue(), RESIDUAL_KEY.equalsIgnoreCase(entry.getKey())));
        }
        if (stainVectors.size() < 2) {
            throw new IllegalArgumentException(String.format("It was not possible to create at least two stain vectors from the provided stains %s (without considering the '%s' stain)", stains, backgroundStainName.get()));
        }
        return new ColorDeconvolutionStains(name, (StainVector)stainVectors.get(0), (StainVector)stainVectors.get(1), stainVectors.size() > 2 ? (StainVector)stainVectors.get(2) : null, stains.get(backgroundStainName.get()).get(0).doubleValue(), stains.get(backgroundStainName.get()).get(1).doubleValue(), stains.get(backgroundStainName.get()).get(2).doubleValue());
    }

    public Map<String, List<Number>> getColorDeconvolutionStainsAsMap() {
        LinkedHashMap<String, List<Number>> stainsMap = new LinkedHashMap<String, List<Number>>();
        for (StainVector stain : Arrays.asList(this.stain1, this.stain2, this.stain3)) {
            if (stain == null) continue;
            stainsMap.put(stain.getName(), List.of(Double.valueOf(stain.getRed()), Double.valueOf(stain.getGreen()), Double.valueOf(stain.getBlue())));
        }
        stainsMap.put(BACKGROUND_KEY, List.of(Double.valueOf(this.maxRed), Double.valueOf(this.maxGreen), Double.valueOf(this.maxBlue)));
        return stainsMap;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(version);
        out.writeObject(ColorDeconvolutionStains.getColorDeconvolutionStainsAsString(this, 32));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        Object o;
        int version = in.readInt();
        if (version != 1) {
            logger.error("{} unsupported version number: {}", (Object)this.getClass().getSimpleName(), (Object)version);
        }
        if ((o = in.readObject()) instanceof String) {
            ColorDeconvolutionStains stains = ColorDeconvolutionStains.parseColorDeconvolutionStainsArg((String)o);
            this.name = stains.name;
            this.stain1 = stains.stain1;
            this.stain2 = stains.stain2;
            this.stain3 = stains.stain3;
            this.maxRed = stains.maxRed;
            this.maxGreen = stains.maxGreen;
            this.maxBlue = stains.maxBlue;
        }
    }

    public static enum DefaultColorDeconvolutionStains {
        H_E("H&E"),
        H_DAB("H-DAB");

        private String name;

        private DefaultColorDeconvolutionStains(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

