/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.pixel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.classes.PathClass;

public class PixelClassifierMetadata {
    private int inputPadding = 0;
    private PixelCalibration inputResolution;
    private int inputWidth = -1;
    private int inputHeight = -1;
    private int inputNumChannels = 3;
    private ImageServerMetadata.ChannelType outputType = ImageServerMetadata.ChannelType.CLASSIFICATION;
    private PixelType outputPixelType = null;
    private List<ImageChannel> outputChannels;
    private Map<Integer, PathClass> classificationLabels;

    public PixelCalibration getInputResolution() {
        return this.inputResolution;
    }

    public int getInputPadding() {
        return this.inputPadding;
    }

    public int getInputWidth() {
        return this.inputWidth;
    }

    public int getInputHeight() {
        return this.inputHeight;
    }

    public int getInputNumChannels() {
        return this.inputNumChannels;
    }

    public ImageServerMetadata.ChannelType getOutputType() {
        return this.outputType;
    }

    public PixelType getOutputPixelType() {
        return this.outputPixelType;
    }

    public synchronized List<ImageChannel> getOutputChannels() {
        if ((this.outputChannels == null || this.outputChannels.isEmpty()) && this.classificationLabels != null) {
            this.outputChannels = ServerTools.classificationLabelsToChannels(this.classificationLabels, true);
        }
        return this.outputChannels == null ? Collections.emptyList() : Collections.unmodifiableList(this.outputChannels);
    }

    public synchronized Map<Integer, PathClass> getClassificationLabels() {
        if (this.classificationLabels == null && this.outputChannels != null) {
            this.classificationLabels = new LinkedHashMap<Integer, PathClass>();
            for (int i = 0; i < this.outputChannels.size(); ++i) {
                ImageChannel channel = this.outputChannels.get(i);
                this.classificationLabels.put(i, PathClass.fromString(channel.getName(), channel.getColor()));
            }
        }
        return this.classificationLabels == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.classificationLabels);
    }

    private PixelClassifierMetadata(Builder builder) {
        this.inputResolution = builder.inputResolution;
        this.inputPadding = builder.inputPadding;
        this.inputWidth = builder.inputWidth;
        this.inputHeight = builder.inputHeight;
        this.inputNumChannels = builder.inputNumChannels;
        this.classificationLabels = builder.classificationLabels;
        this.outputPixelType = builder.outputPixelType;
        this.outputType = builder.outputType;
        this.outputChannels = builder.outputChannels;
    }

    public static class Builder {
        private int inputPadding = 0;
        private PixelCalibration inputResolution;
        private int inputWidth = -1;
        private int inputHeight = -1;
        private int inputNumChannels = 3;
        private ImageServerMetadata.ChannelType outputType = ImageServerMetadata.ChannelType.CLASSIFICATION;
        private PixelType outputPixelType = null;
        private List<ImageChannel> outputChannels = new ArrayList<ImageChannel>();
        private Map<Integer, PathClass> classificationLabels;

        public PixelClassifierMetadata build() {
            return new PixelClassifierMetadata(this);
        }

        public Builder inputPadding(int inputPadding) {
            this.inputPadding = inputPadding;
            return this;
        }

        public Builder setChannelType(ImageServerMetadata.ChannelType type) {
            this.outputType = type;
            return this;
        }

        public Builder inputResolution(PixelCalibration inputResolution) {
            this.inputResolution = inputResolution;
            return this;
        }

        public Builder inputShape(int width, int height) {
            this.inputWidth = width;
            this.inputHeight = height;
            return this;
        }

        public Builder outputPixelType(PixelType pixelType) {
            this.outputPixelType = pixelType;
            return this;
        }

        public Builder outputChannels(ImageChannel ... channels) {
            this.outputChannels.addAll(Arrays.asList(channels));
            return this;
        }

        public Builder outputChannels(Collection<ImageChannel> channels) {
            this.outputChannels.addAll(channels);
            return this;
        }

        public Builder classificationLabels(Map<Integer, PathClass> labels) {
            this.classificationLabels = new LinkedHashMap<Integer, PathClass>(labels);
            return this;
        }
    }
}

