/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.pixel;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.BufferedImageTools;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.classifiers.pixel.PixelClassifierMetadata;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerBuilder;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.PixelType;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.io.GsonTools;
import qupath.lib.regions.RegionRequest;

public class PixelClassificationImageServer
extends AbstractTileableImageServer {
    private static Logger logger = LoggerFactory.getLogger(PixelClassificationImageServer.class);
    private static int DEFAULT_TILE_SIZE = 512;
    private ImageData<BufferedImage> imageData;
    private ImageServer<BufferedImage> server;
    private String customID;
    private PixelClassifier classifier;
    private ColorModel colorModel;
    private ImageServerMetadata originalMetadata;
    private static Map<String, String> idCache = new HashMap<String, String>();
    private Map<TileRequest, BufferedImage> tileMap;

    public PixelClassificationImageServer(ImageData<BufferedImage> imageData, PixelClassifier classifier) {
        this(imageData, classifier, null, null);
    }

    public PixelClassificationImageServer(ImageData<BufferedImage> imageData, PixelClassifier classifier, String customID, ColorModel colorModel) {
        this.classifier = classifier;
        this.imageData = imageData;
        this.customID = customID;
        this.server = imageData.getServer();
        this.colorModel = colorModel;
        PixelClassifierMetadata classifierMetadata = classifier.getMetadata();
        PixelType pixelType = classifierMetadata.getOutputPixelType();
        if (pixelType == null) {
            logger.debug("PixelType is unknown - will use default of UINT8");
            pixelType = PixelType.UINT8;
        }
        int tileWidth = classifierMetadata.getInputWidth();
        int tileHeight = classifierMetadata.getInputHeight();
        if (tileWidth <= 0) {
            tileWidth = DEFAULT_TILE_SIZE;
        }
        if (tileHeight <= 0) {
            tileHeight = DEFAULT_TILE_SIZE;
        }
        PixelCalibration inputResolution = classifierMetadata.getInputResolution();
        PixelCalibration cal = this.server.getPixelCalibration();
        if (inputResolution == null) {
            logger.warn("Input resolution not specified in PixelClassifier metadata - will assume full resolution");
            inputResolution = cal;
        }
        double downsample = inputResolution.getAveragedPixelSize().doubleValue() / cal.getAveragedPixelSize().doubleValue();
        if (!cal.getPixelWidthUnit().equals(inputResolution.getPixelWidthUnit()) || !cal.getPixelHeightUnit().equals(inputResolution.getPixelHeightUnit())) {
            if (inputResolution.unitsMatch2D() && "px".equals(inputResolution.getPixelWidthUnit())) {
                downsample = inputResolution.getAveragedPixelSize().doubleValue();
                logger.warn("Input resolution is requested in uncalibrated units - will use downsample of {}", (Object)downsample);
            } else {
                logger.warn("Image pixel units do not match the classifier pixel units! This may give unexpected results.");
                logger.warn("Server calibration: {}", (Object)cal);
                logger.warn("Classifier calibration: {}", (Object)inputResolution);
            }
        }
        int width = this.server.getWidth();
        int height = this.server.getHeight();
        List<ImageServerMetadata.ImageResolutionLevel> levels = new ImageServerMetadata.ImageResolutionLevel.Builder(width, height).addLevelByDownsample(downsample).build();
        int pad = classifierMetadata.getInputPadding();
        ImageServerMetadata.Builder builder = new ImageServerMetadata.Builder(this.server.getMetadata()).width(width).height(height).channelType(classifierMetadata.getOutputType()).preferredTileSize(tileWidth - pad * 2, tileHeight - pad * 2).levels(levels).pixelType(pixelType).classificationLabels(classifierMetadata.getClassificationLabels()).rgb(false);
        if (classifierMetadata.getOutputType() != ImageServerMetadata.ChannelType.CLASSIFICATION) {
            builder.channels(classifierMetadata.getOutputChannels());
        }
        this.originalMetadata = builder.build();
    }

    public synchronized void readAllTiles() {
        if (this.tileMap != null) {
            return;
        }
        Map<TileRequest, BufferedImage> tempTileMap = this.getTileRequestManager().getAllTileRequests().parallelStream().filter(t -> !this.isEmptyRegion(t.getRegionRequest())).collect(Collectors.toMap(t -> t, t -> this.tryToReadTile((TileRequest)t)));
        Iterator<Map.Entry<TileRequest, BufferedImage>> iter = tempTileMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<TileRequest, BufferedImage> next = iter.next();
            if (next.getValue() != null) continue;
            iter.remove();
        }
        this.tileMap = tempTileMap;
    }

    private BufferedImage tryToReadTile(TileRequest tile) {
        try {
            return this.readTile(tile);
        }
        catch (IOException e) {
            logger.warn("Unable to read tile: " + e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    protected ColorModel getDefaultColorModel() throws IOException {
        if (this.colorModel == null) {
            return super.getDefaultColorModel();
        }
        return this.colorModel;
    }

    @Override
    protected String createID() {
        if (this.customID != null) {
            return this.customID;
        }
        try {
            String json = GsonTools.getInstance().toJson((Object)this.classifier).intern();
            int len = json.length();
            String suffix = len < 1000000 ? json : idCache.computeIfAbsent(json, j -> json.substring(0, 1000) + "... (" + String.valueOf(UUID.randomUUID()) + ")");
            return this.getClass().getName() + ": " + this.server.getPath() + "::" + suffix;
        }
        catch (Exception e) {
            logger.debug("Unable to serialize pixel classifier to JSON: {}", (Object)e.getLocalizedMessage());
            return this.getClass().getName() + ": " + this.server.getPath() + "::" + String.valueOf(UUID.randomUUID());
        }
    }

    @Override
    public Collection<URI> getURIs() {
        return Collections.emptyList();
    }

    public ImageData<BufferedImage> getImageData() {
        return this.imageData;
    }

    public PixelClassifier getClassifier() {
        return this.classifier;
    }

    @Override
    public String getServerType() {
        return "Pixel classification server";
    }

    @Override
    public ImageServerMetadata getOriginalMetadata() {
        return this.originalMetadata;
    }

    @Override
    public void setMetadata(ImageServerMetadata metadata) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Setting metadata is not allowed!");
    }

    @Override
    public BufferedImage getCachedTile(TileRequest tile) {
        if (this.tileMap != null && this.tileMap.containsKey(tile)) {
            return this.tileMap.get(tile);
        }
        return (BufferedImage)super.getCachedTile(tile);
    }

    @Override
    protected BufferedImage readTile(TileRequest tileRequest) throws IOException {
        try {
            BufferedImage img;
            double fullResDownsample = this.getDownsampleForResolution(0);
            if (tileRequest.getDownsample() != fullResDownsample && Math.abs(tileRequest.getDownsample() - fullResDownsample) > 1.0E-6) {
                RegionRequest request2 = RegionRequest.createInstance(this.getPath(), fullResDownsample, tileRequest.getRegionRequest());
                img = this.readRegion(request2);
                img = BufferedImageTools.resize(img, tileRequest.getTileWidth(), tileRequest.getTileHeight(), this.allowSmoothInterpolation());
            } else {
                img = this.classifier.applyClassification(this.imageData, tileRequest.getRegionRequest());
                img = BufferedImageTools.resize(img, tileRequest.getTileWidth(), tileRequest.getTileHeight(), this.allowSmoothInterpolation());
            }
            if (this.colorModel != null && this.colorModel != img.getColorModel() && this.colorModel.isCompatibleRaster(img.getRaster())) {
                img = new BufferedImage(this.colorModel, img.getRaster(), img.isAlphaPremultiplied(), null);
            }
            return img;
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        catch (Error e) {
            throw new IOException(e);
        }
    }

    @Override
    protected ImageServerBuilder.ServerBuilder<BufferedImage> createServerBuilder() {
        return null;
    }
}

