/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.object;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import qupath.lib.classifiers.object.CompositeClassifier;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.SimpleClassifier;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.classes.PathClass;

public class ObjectClassifiers {
    private static final TypeAdapterFactory factory = new ObjectClassifierTypeAdapterFactory();

    public static TypeAdapterFactory getTypeAdapterFactory() {
        return factory;
    }

    public static <T> ObjectClassifier<T> createCompositeClassifier(ObjectClassifier<T> ... classifiers) {
        return new CompositeClassifier<T>(Arrays.asList(classifiers));
    }

    public static <T> ObjectClassifier<T> createCompositeClassifier(Collection<ObjectClassifier<T>> classifiers) {
        return new CompositeClassifier<T>(classifiers);
    }

    public static <T> ObjectClassifier<T> createChannelClassifier(PathObjectFilter filter, ImageChannel channel, String measurement, double threshold) {
        PathClass pathClass = PathClass.fromString(channel.getName(), channel.getColor());
        return new ClassifyByMeasurementBuilder(measurement).threshold(threshold).filter(filter).aboveEquals(pathClass).build();
    }

    public static <T> ObjectClassifier<T> readClassifier(Path path) throws IOException {
        try (BufferedReader reader = Files.newBufferedReader(path, StandardCharsets.UTF_8);){
            ObjectClassifier objectClassifier = (ObjectClassifier)GsonTools.getInstance().fromJson((Reader)reader, ObjectClassifier.class);
            return objectClassifier;
        }
    }

    public static <T> void writeClassifier(ObjectClassifier<T> classifier, Path path) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
            GsonTools.getInstance(true).toJson(classifier, ObjectClassifier.class, (Appendable)writer);
        }
    }

    public static class ClassifyByMeasurementBuilder<T> {
        private PathObjectFilter filter = PathObjectFilter.DETECTIONS_ALL;
        private String measurementName;
        private Double threshold;
        private PathClass pathClassBelow;
        private PathClass pathClassEquals;
        private PathClass pathClassAbove;

        public ClassifyByMeasurementBuilder(String measurementName) {
            this.measurementName = measurementName;
        }

        public ClassifyByMeasurementBuilder<T> filter(PathObjectFilter filter) {
            this.filter = filter;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> cells() {
            return this.filter(PathObjectFilter.CELLS);
        }

        public ClassifyByMeasurementBuilder<T> tiles() {
            return this.filter(PathObjectFilter.TILES);
        }

        public ClassifyByMeasurementBuilder<T> detections() {
            return this.filter(PathObjectFilter.DETECTIONS_ALL);
        }

        public ClassifyByMeasurementBuilder<T> threshold(double threshold) {
            this.threshold = threshold;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> above(String pathClassName) {
            PathClass pathClass;
            this.pathClassAbove = pathClass = PathClass.fromString(pathClassName);
            return this;
        }

        public ClassifyByMeasurementBuilder<T> aboveEquals(String pathClassName) {
            PathClass pathClass;
            this.pathClassAbove = pathClass = PathClass.fromString(pathClassName);
            this.pathClassEquals = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> belowEquals(String pathClassName) {
            PathClass pathClass;
            this.pathClassBelow = pathClass = PathClass.fromString(pathClassName);
            this.pathClassEquals = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> below(String pathClassName) {
            PathClass pathClass;
            this.pathClassBelow = pathClass = PathClass.fromString(pathClassName);
            return this;
        }

        public ClassifyByMeasurementBuilder<T> equalTo(String pathClassName) {
            PathClass pathClass;
            this.pathClassEquals = pathClass = PathClass.fromString(pathClassName);
            return this;
        }

        public ClassifyByMeasurementBuilder<T> above(PathClass pathClass) {
            this.pathClassAbove = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> aboveEquals(PathClass pathClass) {
            this.pathClassAbove = pathClass;
            this.pathClassEquals = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> belowEquals(PathClass pathClass) {
            this.pathClassBelow = pathClass;
            this.pathClassEquals = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> below(PathClass pathClass) {
            this.pathClassBelow = pathClass;
            return this;
        }

        public ClassifyByMeasurementBuilder<T> equalTo(PathClass pathClass) {
            this.pathClassEquals = pathClass;
            return this;
        }

        public ObjectClassifier<T> build() {
            if (this.threshold == null) {
                throw new IllegalArgumentException("No threshold is specified!");
            }
            ClassifyByMeasurementFunction fun = new ClassifyByMeasurementFunction(this.measurementName, this.threshold, this.pathClassBelow, this.pathClassEquals, this.pathClassAbove);
            return new SimpleClassifier(this.filter, fun, Arrays.asList(fun.pathClassBelow, fun.pathClassEquals, fun.pathClassAbove).stream().filter((? super T p) -> p != null).distinct().toList());
        }
    }

    public static class ObjectClassifierTypeAdapterFactory
    implements TypeAdapterFactory {
        private static String typeName = "object_classifier_type";
        private static final GsonTools.SubTypeAdapterFactory<ObjectClassifier> objectClassifierTypeAdapter = GsonTools.createSubTypeAdapterFactory(ObjectClassifier.class, typeName).registerSubtype(CompositeClassifier.class).registerSubtype(SimpleClassifier.class);
        private static final GsonTools.SubTypeAdapterFactory<Function> classifierFunTypeAdapter = GsonTools.createSubTypeAdapterFactory(Function.class, "classifier_fun").registerSubtype(ClassifyByMeasurementFunction.class);

        private ObjectClassifierTypeAdapterFactory() {
        }

        public static void registerSubtype(Class<? extends ObjectClassifier> cls) {
            objectClassifierTypeAdapter.registerSubtype(cls);
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            TypeAdapter<T> adaptor = classifierFunTypeAdapter.create(gson, type);
            if (adaptor != null) {
                return adaptor;
            }
            return objectClassifierTypeAdapter.create(gson, type);
        }
    }

    static class ClassifyByMeasurementFunction
    implements Function<PathObject, PathClass> {
        private String measurement;
        private PathClass pathClassBelow;
        private PathClass pathClassEquals;
        private PathClass pathClassAbove;
        private double threshold;

        ClassifyByMeasurementFunction(String measurement, double threshold, PathClass pathClassBelow, PathClass pathClassEquals, PathClass pathClassAbove) {
            this.measurement = measurement;
            this.threshold = threshold;
            this.pathClassBelow = pathClassBelow == PathClass.NULL_CLASS ? null : pathClassBelow;
            this.pathClassEquals = pathClassEquals == PathClass.NULL_CLASS ? null : pathClassEquals;
            this.pathClassAbove = pathClassAbove == PathClass.NULL_CLASS ? null : pathClassAbove;
        }

        public String getMeasurement() {
            return this.measurement;
        }

        @Override
        public PathClass apply(PathObject pathObject) {
            double val = pathObject.getMeasurementList().get(this.measurement);
            if (Double.isNaN(val)) {
                return null;
            }
            if (val > this.threshold) {
                return this.pathClassAbove;
            }
            if (val < this.threshold) {
                return this.pathClassBelow;
            }
            if (val == this.threshold) {
                return this.pathClassEquals;
            }
            return null;
        }
    }
}

