/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.classifiers.object;

import java.util.Collection;
import java.util.List;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;

public abstract class AbstractObjectClassifier<T>
implements ObjectClassifier<T> {
    private PathObjectFilter filter;
    private long timestamp = System.currentTimeMillis();

    protected AbstractObjectClassifier(PathObjectFilter filter) {
        this.filter = filter;
    }

    @Override
    public int classifyObjects(ImageData<T> imageData, boolean resetExistingClass) {
        return this.classifyObjects(imageData, this.getCompatibleObjects(imageData), resetExistingClass);
    }

    @Override
    public Collection<PathObject> getCompatibleObjects(ImageData<T> imageData) {
        List<PathObject> pathObjects = imageData.getHierarchy().getFlattenedObjectList(null);
        if (this.filter != null) {
            pathObjects = pathObjects.stream().filter(this.filter).toList();
        }
        return pathObjects;
    }
}

