/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.awt.common;

import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Hashtable;
import java.util.List;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.color.ColorModelFactory;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.servers.AbstractTileableImageServer;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.PixelType;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public final class BufferedImageTools {
    private static final Logger logger = LoggerFactory.getLogger(AbstractTileableImageServer.class);

    private BufferedImageTools() {
        throw new AssertionError();
    }

    public static BufferedImage createROIMask(int width, int height, ROI roi, RegionRequest request) {
        return BufferedImageTools.createROIMask(width, height, roi, request.getX(), request.getY(), request.getDownsample());
    }

    public static BufferedImage createROIMask(ROI roi, double downsample) {
        int width = (int)Math.ceil(roi.getBoundsWidth() / downsample);
        int height = (int)Math.ceil(roi.getBoundsHeight() / downsample);
        return BufferedImageTools.createROIMask(width, height, roi, roi.getBoundsX(), roi.getBoundsY(), downsample);
    }

    public static BufferedImage createROIMask(int width, int height, ROI roi, double xOrigin, double yOrigin, double downsample) {
        Shape shape = RoiTools.getShape(roi);
        return BufferedImageTools.createShapeMask(width, height, shape, xOrigin, yOrigin, downsample);
    }

    public static BufferedImage createROIMask(Shape shape, double downsample) {
        Rectangle2D bounds = shape.getBounds2D();
        int width = (int)Math.ceil(bounds.getWidth() / downsample);
        int height = (int)Math.ceil(bounds.getHeight() / downsample);
        return BufferedImageTools.createShapeMask(width, height, shape, bounds.getX(), bounds.getY(), downsample);
    }

    public static BufferedImage createShapeMask(int width, int height, Shape shape, double xOrigin, double yOrigin, double downsample) {
        BufferedImage imgMask = new BufferedImage(width, height, 10);
        Graphics2D g2d = imgMask.createGraphics();
        g2d.scale(1.0 / downsample, 1.0 / downsample);
        g2d.translate(-xOrigin, -yOrigin);
        g2d.setColor(Color.WHITE);
        g2d.fill(shape);
        g2d.dispose();
        return imgMask;
    }

    public static BufferedImage ensureBufferedImageType(BufferedImage img, int requestedType) {
        if (img.getType() != requestedType) {
            BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), requestedType);
            Graphics2D g2d = img2.createGraphics();
            g2d.drawImage((Image)img, 0, 0, null);
            g2d.dispose();
            return img2;
        }
        return img;
    }

    public static BufferedImage ensureBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage imgBuf = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2d = imgBuf.createGraphics();
        g2d.drawImage(image, 0, 0, null);
        g2d.dispose();
        return imgBuf;
    }

    public static BufferedImage stripEmptyAlpha(BufferedImage img) {
        if (!BufferedImageTools.is8bitColorType(img.getType())) {
            logger.debug("stripEmptyAlpha requires an 8-bit color type - will skip type {}", (Object)img.getType());
            return img;
        }
        WritableRaster raster = img.getAlphaRaster();
        if (raster == null) {
            return img;
        }
        int[] alpha = raster.getSamples(0, 0, raster.getWidth(), raster.getHeight(), 0, (int[])null);
        if (!IntStream.of(alpha).allMatch(i -> i == 255)) {
            return img;
        }
        logger.debug("stripEmptyAlpha converting from type {} to {}", (Object)img.getType(), (Object)1);
        return BufferedImageTools.ensureBufferedImageType(img, 1);
    }

    public static BufferedImage duplicate(BufferedImage img) {
        return new BufferedImage(img.getColorModel(), img.copyData(img.getRaster().createCompatibleWritableRaster()), img.isAlphaPremultiplied(), BufferedImageTools.extractProperties(img));
    }

    public static void swapRGBOrder(BufferedImage img, String order) {
        if (img.getType() != 2 && img.getType() != 1) {
            throw new IllegalArgumentException("I can only reorder channels for INT_ARGB and INT_RGB images");
        }
        if ("RGB".equals(order)) {
            return;
        }
        int[] inds = switch (order) {
            case "RBG" -> new int[]{0, 1, 3, 2};
            case "BRG" -> new int[]{0, 3, 1, 2};
            case "BGR" -> new int[]{0, 3, 2, 1};
            case "GRB" -> new int[]{0, 2, 1, 3};
            case "GBR" -> new int[]{0, 2, 3, 1};
            default -> throw new IllegalArgumentException("Unknown RGB order '" + order + "'");
        };
        int w = img.getWidth();
        int h = img.getHeight();
        int[] rgb = img.getRGB(0, 0, w, h, null, 0, img.getWidth());
        int[] pixel = new int[4];
        int i = 0;
        for (int val : rgb) {
            pixel[0] = ColorTools.alpha(val);
            pixel[1] = ColorTools.red(val);
            pixel[2] = ColorTools.green(val);
            pixel[3] = ColorTools.blue(val);
            rgb[i++] = ColorTools.packARGB(pixel[inds[0]], pixel[inds[1]], pixel[inds[2]], pixel[inds[3]]);
        }
        img.setRGB(0, 0, w, h, rgb, 0, img.getWidth());
    }

    static Hashtable<Object, Object> extractProperties(BufferedImage img) {
        String[] names = img.getPropertyNames();
        if (names == null) {
            return null;
        }
        Hashtable<String, Object> properties = null;
        if (names != null && names.length > 0) {
            properties = new Hashtable<String, Object>();
            for (String name : names) {
                properties.put(name, img.getProperty(name));
            }
        }
        return properties;
    }

    public static void setValues(DataBuffer buffer, double val) {
        int n = buffer.getSize();
        int nBanks = buffer.getNumBanks();
        switch (buffer.getDataType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                int ival = (int)val;
                for (int b = 0; b < nBanks; ++b) {
                    for (int i = 0; i < n; ++i) {
                        buffer.setElem(b, i, ival);
                    }
                }
                break;
            }
            case 4: {
                float fval = (float)val;
                for (int b = 0; b < nBanks; ++b) {
                    for (int i = 0; i < n; ++i) {
                        buffer.setElemFloat(b, i, fval);
                    }
                }
                break;
            }
            case 5: {
                for (int b = 0; b < nBanks; ++b) {
                    for (int i = 0; i < n; ++i) {
                        buffer.setElemDouble(b, i, val);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unable to set values for unknown data buffer type " + buffer.getDataType());
            }
        }
    }

    public static boolean is8bitColorType(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public static BufferedImage crop(BufferedImage img, int x, int y, int width, int height) {
        if (x == 0 && y == 0 && img.getWidth() == width && img.getHeight() == height) {
            return BufferedImageTools.duplicate(img);
        }
        WritableRaster raster = img.getRaster();
        WritableRaster raster2 = raster.createCompatibleWritableRaster(width, height);
        raster2.setDataElements(x, y, width, height, raster);
        return new BufferedImage(img.getColorModel(), raster2, img.isAlphaPremultiplied(), null);
    }

    private static boolean isIntType(int type) {
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public static BufferedImage resize(BufferedImage img, int finalWidth, int finalHeight, boolean smoothInterpolate) {
        boolean areaAveraging;
        if (img.getWidth() == finalWidth && img.getHeight() == finalHeight) {
            return img;
        }
        logger.trace(String.format("Resizing %d x %d -> %d x %d", img.getWidth(), img.getHeight(), finalWidth, finalHeight));
        double aspectRatio = (double)img.getWidth() / (double)img.getHeight();
        double finalAspectRatio = (double)finalWidth / (double)finalHeight;
        if (!GeneralTools.almostTheSame(aspectRatio, finalAspectRatio, 0.01)) {
            if (!GeneralTools.almostTheSame(aspectRatio, finalAspectRatio, 0.05)) {
                logger.debug("Substantial difference in aspect ratio for resized image: {}x{} -> {}x{} ({}, {})", new Object[]{img.getWidth(), img.getHeight(), finalWidth, finalHeight, aspectRatio, finalAspectRatio});
            } else {
                logger.trace("Slight difference in aspect ratio for resized image: {}x{} -> {}x{} ({}, {})", new Object[]{img.getWidth(), img.getHeight(), finalWidth, finalHeight, aspectRatio, finalAspectRatio});
            }
        }
        WritableRaster raster = img.getRaster();
        WritableRaster raster2 = raster.createCompatibleWritableRaster(finalWidth, finalHeight);
        boolean isIntType = BufferedImageTools.isIntType(raster.getTransferType());
        int w = img.getWidth();
        int h = img.getHeight();
        FloatProcessor fp = new FloatProcessor(w, h);
        if (smoothInterpolate) {
            fp.setInterpolationMethod(1);
            areaAveraging = true;
        } else {
            fp.setInterpolationMethod(0);
            areaAveraging = false;
        }
        for (int b = 0; b < raster.getNumBands(); ++b) {
            float[] pixels = (float[])fp.getPixels();
            raster.getSamples(0, 0, w, h, b, pixels);
            ImageProcessor fp2 = fp.resize(finalWidth, finalHeight, areaAveraging);
            float[] pixelsOut = (float[])fp2.getPixels();
            if (isIntType) {
                for (int i = 0; i < pixelsOut.length; ++i) {
                    pixelsOut[i] = Math.round(pixelsOut[i]);
                }
            }
            raster2.setSamples(0, 0, finalWidth, finalHeight, b, pixelsOut);
        }
        return new BufferedImage(img.getColorModel(), raster2, img.isAlphaPremultiplied(), null);
    }

    public static long[] computeUnsignedIntHistogram(WritableRaster raster, long[] counts, WritableRaster rasterMask) {
        return BufferedImageTools.computeUnsignedIntHistogram(raster, counts, rasterMask, null);
    }

    public static long[] computeUnsignedIntHistogram(WritableRaster raster, long[] counts, WritableRaster rasterMask, Rectangle bounds) {
        int h;
        if (counts == null) {
            if (raster.getTransferType() == 0) {
                counts = new long[256];
            } else if (raster.getTransferType() == 1) {
                counts = new long[65536];
            } else {
                throw new IllegalArgumentException("TransferType must be DataBuffer.TYPE_BYTE or DataBuffer.TYPE_USHORT!");
            }
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int x = bounds == null ? 0 : bounds.x;
        int y = bounds == null ? 0 : bounds.y;
        int w = bounds == null ? width : bounds.width;
        int n = h = bounds == null ? height : bounds.height;
        if (w <= 0 || h <= 0) {
            return counts;
        }
        int nBands = raster.getNumBands();
        int[] maskSamples = rasterMask == null ? null : rasterMask.getSamples(x, y, w, h, 0, (int[])null);
        for (int b = 0; b < nBands; ++b) {
            for (int i = 0; i < w * h; ++i) {
                int ind;
                if (maskSamples != null && maskSamples[i] == 0) continue;
                int n2 = ind = raster.getSample(i % w + x, i / w + y, b);
                counts[n2] = counts[n2] + 1L;
            }
        }
        return counts;
    }

    public static long[] computeArgMaxHistogram(WritableRaster raster, long[] counts, WritableRaster rasterMask) {
        return BufferedImageTools.computeArgMaxHistogram(raster, counts, rasterMask, null);
    }

    public static long[] computeArgMaxHistogram(WritableRaster raster, long[] counts, WritableRaster rasterMask, Rectangle bounds) {
        int h;
        if (counts == null) {
            counts = new long[raster.getNumBands()];
        }
        int width = raster.getWidth();
        int height = raster.getHeight();
        int xOrigin = bounds == null ? 0 : bounds.x;
        int yOrigin = bounds == null ? 0 : bounds.y;
        int w = bounds == null ? width : bounds.width;
        int n = h = bounds == null ? height : bounds.height;
        if (w <= 0 || h <= 0) {
            return counts;
        }
        int nBands = raster.getNumBands();
        double[] samples = null;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (rasterMask != null && rasterMask.getSample(xOrigin + x, yOrigin + y, 0) == 0) continue;
                samples = raster.getPixel(xOrigin + x, yOrigin + y, samples);
                int ind = 0;
                double maxValue = samples[0];
                for (int i = 1; i < nBands; ++i) {
                    double val = samples[i];
                    if (!(val > maxValue)) continue;
                    maxValue = val;
                    ind = i;
                }
                int n2 = ind;
                counts[n2] = counts[n2] + 1L;
            }
        }
        return counts;
    }

    public static long computeAboveThresholdCounts(WritableRaster raster, int band, double threshold, WritableRaster rasterMask) {
        return BufferedImageTools.computeAboveThresholdCounts(raster, band, threshold, rasterMask, null);
    }

    public static long computeAboveThresholdCounts(WritableRaster raster, int band, double threshold, WritableRaster rasterMask, Rectangle bounds) {
        long count = 0L;
        int h = raster.getHeight();
        int w = raster.getWidth();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                double val;
                if (rasterMask != null && rasterMask.getSample(x, y, 0) == 0 || !((val = raster.getSampleDouble(x, y, band)) > threshold)) continue;
                ++count;
            }
        }
        return count;
    }

    public static BufferedImage convertImageType(BufferedImage img, PixelType targetPixelType, List<? extends ImageChannel> channels) {
        WritableRaster raster = img.getRaster();
        WritableRaster newRaster = BufferedImageTools.convertRasterType(raster, targetPixelType);
        if (channels == null) {
            channels = ImageChannel.getDefaultChannelList(newRaster.getNumBands());
        }
        ColorModel colorModel = ColorModelFactory.createColorModel(targetPixelType, channels);
        return new BufferedImage(colorModel, newRaster, img.isAlphaPremultiplied(), null);
    }

    public static WritableRaster convertRasterType(Raster inputRaster, PixelType targetPixelType) throws UnsupportedOperationException {
        int width = inputRaster.getWidth();
        int height = inputRaster.getHeight();
        int numBands = inputRaster.getNumBands();
        BandedSampleModel sampleModel = new BandedSampleModel(BufferedImageTools.getDataBufferType(targetPixelType), width, height, numBands);
        DataBuffer buffer = sampleModel.createDataBuffer();
        WritableRaster outputRaster = WritableRaster.createWritableRaster(sampleModel, buffer, null);
        double[] values = null;
        double minValue = targetPixelType.isFloatingPoint() ? Double.NEGATIVE_INFINITY : targetPixelType.getLowerBound().doubleValue();
        double maxValue = targetPixelType.isFloatingPoint() ? Double.POSITIVE_INFINITY : targetPixelType.getUpperBound().doubleValue();
        boolean doRounding = targetPixelType.isSignedInteger() || targetPixelType.isUnsignedInteger();
        for (int i = 0; i < numBands; ++i) {
            values = inputRaster.getSamples(0, 0, width, height, i, values);
            if (doRounding) {
                BufferedImageTools.roundAndClip(values, minValue, maxValue);
            }
            outputRaster.setSamples(0, 0, width, height, i, values);
        }
        return outputRaster;
    }

    public static int getDataBufferType(PixelType pixelType) throws UnsupportedOperationException {
        switch (pixelType) {
            case UINT8: {
                return 0;
            }
            case INT16: {
                return 2;
            }
            case UINT16: {
                return 1;
            }
            case INT32: {
                return 3;
            }
            case FLOAT32: {
                return 4;
            }
            case FLOAT64: {
                return 5;
            }
        }
        throw new IllegalArgumentException("DataBuffer does not support " + String.valueOf((Object)pixelType));
    }

    private static void roundAndClip(double[] values, double min, double max) {
        for (int i = 0; i < values.length; ++i) {
            values[i] = GeneralTools.clipValue(Math.round(values[i]), min, max);
        }
    }

    public static BufferedImage createImage(int width, int height, PixelType pixelType, int nChannels) {
        return BufferedImageTools.createImage(width, height, pixelType, ImageChannel.getDefaultChannelList(nChannels));
    }

    public static BufferedImage createImage(int width, int height, PixelType pixelType, List<? extends ImageChannel> channels) {
        BandedSampleModel sampleModel = new BandedSampleModel(BufferedImageTools.getDataBufferType(pixelType), width, height, channels.size());
        DataBuffer buffer = sampleModel.createDataBuffer();
        WritableRaster raster = WritableRaster.createWritableRaster(sampleModel, buffer, null);
        ColorModel colorModel = ColorModelFactory.createColorModel(pixelType, channels);
        return new BufferedImage(colorModel, raster, false, null);
    }
}

