/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.awt.common;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.interfaces.ROI;

public final class AwtTools {
    private AwtTools() {
        throw new AssertionError();
    }

    public static Rectangle getBounds(ImageRegion region) {
        return AwtTools.getBounds(region, new Rectangle());
    }

    public static Rectangle getBounds(ImageRegion region, Rectangle rect) {
        if (rect == null) {
            rect = new Rectangle();
        }
        rect.setFrame(region.getX(), region.getY(), region.getWidth(), region.getHeight());
        return rect;
    }

    public static Rectangle2D getBounds2D(ROI roi) {
        return AwtTools.getBounds2D(roi, new Rectangle2D.Double());
    }

    public static Rectangle2D getBounds2D(ROI roi, Rectangle2D rect) {
        if (rect == null) {
            rect = new Rectangle2D.Double();
        }
        rect.setFrame(roi.getBoundsX(), roi.getBoundsY(), roi.getBoundsWidth(), roi.getBoundsHeight());
        return rect;
    }

    public static Rectangle getBounds(ROI roi) {
        if (roi.isEmpty()) {
            return new Rectangle();
        }
        int x1 = (int)roi.getBoundsX();
        int y1 = (int)roi.getBoundsY();
        int x2 = (int)Math.ceil(roi.getBoundsX() + roi.getBoundsWidth());
        int y2 = (int)Math.ceil(roi.getBoundsY() + roi.getBoundsHeight());
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    public static ImageRegion getImageRegion(Rectangle rectangle, int z, int t) {
        return ImageRegion.createInstance(rectangle.x, rectangle.y, rectangle.width, rectangle.height, z, t);
    }

    public static ImageRegion getImageRegion(Shape shape, int z, int t) {
        if (shape instanceof Rectangle) {
            return AwtTools.getImageRegion((Rectangle)shape, z, t);
        }
        return AwtTools.getImageRegion(shape.getBounds(), z, t);
    }
}

