/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats.survival;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class KaplanMeierData {
    private List<KaplanMeierEvent> events = new ArrayList<KaplanMeierEvent>();
    private String name;
    private double[] statisticCached;
    private double[] timesAllCached;
    private double[] timesEventsCached;
    private int[] atRiskCached;

    public KaplanMeierData(String name) {
        this.name = name;
    }

    public KaplanMeierData(String name, Collection<KaplanMeierEvent> events) {
        this(name);
        this.events.addAll(events);
        Collections.sort(this.events);
    }

    public KaplanMeierData addEvents(Collection<KaplanMeierEvent> events) {
        this.events.addAll(events);
        Collections.sort(this.events);
        return this;
    }

    public KaplanMeierData addEvent(double time, boolean censored) {
        KaplanMeierEvent event = new KaplanMeierEvent(time, censored);
        int ind = Collections.binarySearch(this.events, event);
        if (ind < 0) {
            ind = -ind - 1;
        }
        this.events.add(ind, event);
        this.resetCached();
        return this;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    private void resetCached() {
        this.statisticCached = null;
        this.timesAllCached = null;
        this.atRiskCached = null;
    }

    private void compute() {
        int n0 = this.events.size();
        this.timesAllCached = new double[n0 + 1];
        this.timesEventsCached = new double[n0 + 1];
        int ind = 0;
        double lastTimeAll = 0.0;
        int indEvents = 0;
        double lastTimeEvents = 0.0;
        for (KaplanMeierEvent event : this.events) {
            double time = event.getTimeToEvent();
            if (time > lastTimeAll) {
                this.timesAllCached[++ind] = time;
                lastTimeAll = time;
            }
            if (event.isCensored() || !(time > lastTimeEvents)) continue;
            this.timesEventsCached[++indEvents] = time;
            lastTimeEvents = time;
        }
        if (ind < this.timesAllCached.length) {
            this.timesAllCached = Arrays.copyOf(this.timesAllCached, ind + 1);
        }
        if (indEvents + 1 < this.timesEventsCached.length) {
            this.timesEventsCached = Arrays.copyOf(this.timesEventsCached, indEvents + 1);
        }
        this.statisticCached = new double[this.timesAllCached.length];
        this.atRiskCached = new int[this.timesAllCached.length];
        double lastProduct = 1.0;
        for (int i = 0; i < this.timesAllCached.length; ++i) {
            int ni;
            double t = this.timesAllCached[i];
            this.atRiskCached[i] = ni = this.getAtRisk(t);
            int di = this.getEventsAtTime(t);
            this.statisticCached[i] = lastProduct *= (double)(ni - di) / (double)ni;
        }
    }

    public List<KaplanMeierEvent> getEvents() {
        return Collections.unmodifiableList(this.events);
    }

    private void ensureComputed() {
        if (this.timesAllCached == null) {
            this.compute();
        }
    }

    public double[] getAllTimes() {
        this.ensureComputed();
        return Arrays.copyOf(this.timesAllCached, this.timesAllCached.length);
    }

    public double[] getStatistic() {
        this.ensureComputed();
        return Arrays.copyOf(this.statisticCached, this.statisticCached.length);
    }

    public double getMaxTime() {
        if (this.events.isEmpty()) {
            return -1.0;
        }
        return this.events.get(this.events.size() - 1).getTimeToEvent();
    }

    public int getAtRisk(double t) {
        int n = this.events.size();
        for (KaplanMeierEvent event : this.events) {
            if (!(event.getTimeToEvent() < t)) break;
            --n;
        }
        return n;
    }

    public int getEventsAtTime(double t) {
        int n = 0;
        for (KaplanMeierEvent event : this.events) {
            if (event.getTimeToEvent() < t) continue;
            if (event.getTimeToEvent() > t) break;
            if (event.isCensored()) continue;
            ++n;
        }
        return n;
    }

    public int nEvents() {
        return this.events.size();
    }

    public int nObserved() {
        int n = 0;
        for (KaplanMeierEvent event : this.events) {
            if (event.isCensored()) continue;
            ++n;
        }
        return n;
    }

    public int nCensored() {
        int n = 0;
        for (KaplanMeierEvent event : this.events) {
            if (!event.isCensored()) continue;
            ++n;
        }
        return n;
    }

    public String toString() {
        return "Kaplan-Meier: " + this.name + ", " + this.events.size() + " events (" + this.nObserved() + " observed, " + this.nCensored() + " censored)";
    }

    public static class KaplanMeierEvent
    implements Comparable<KaplanMeierEvent> {
        private double timeToEvent;
        private boolean isCensored;

        KaplanMeierEvent(double timeToEvent, boolean isCensored) {
            this.timeToEvent = timeToEvent;
            this.isCensored = isCensored;
        }

        public double getTimeToEvent() {
            return this.timeToEvent;
        }

        public boolean isCensored() {
            return this.isCensored;
        }

        @Override
        public int compareTo(KaplanMeierEvent event) {
            int comp = Double.compare(this.timeToEvent, event.timeToEvent);
            if (comp == 0) {
                return Boolean.compare(this.isCensored, event.isCensored);
            }
            return comp;
        }

        public String toString() {
            return "KM Event: Time=" + this.timeToEvent + ", Censored=" + this.isCensored;
        }
    }
}

