/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.stats.RunningStatistics;

public class StatisticsHelper {
    public static RunningStatistics computeRunningStatistics(SimpleImage img) {
        RunningStatistics stats = new RunningStatistics();
        StatisticsHelper.updateRunningStatistics(stats, img);
        return stats;
    }

    public static void updateRunningStatistics(RunningStatistics stats, SimpleImage img) {
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                stats.addValue(img.getValue(x, y));
            }
        }
    }

    public static List<RunningStatistics> createRunningStatisticsList(int n) {
        ArrayList<RunningStatistics> stats = new ArrayList<RunningStatistics>();
        for (int i = 0; i < n; ++i) {
            stats.add(new RunningStatistics());
        }
        return stats;
    }

    public static RunningStatistics computeRunningStatistics(double[] values) {
        RunningStatistics stats = new RunningStatistics();
        for (double v : values) {
            stats.addValue(v);
        }
        return stats;
    }

    public static void computeRunningStatistics(SimpleImage img, SimpleImage imgLabels, List<RunningStatistics> statsList) {
        float lastLabel = Float.NaN;
        int nLabels = statsList.size();
        RunningStatistics stats = null;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                float label = imgLabels.getValue(x, y);
                if (label == 0.0f || label > (float)nLabels) continue;
                if (label != lastLabel) {
                    stats = statsList.get((int)label - 1);
                    lastLabel = label;
                }
                stats.addValue(img.getValue(x, y));
            }
        }
    }

    public static double[] getQuartiles(double[] scores) {
        int nScores;
        scores = Arrays.copyOf(scores, scores.length);
        Arrays.sort(scores);
        for (nScores = scores.length; nScores > 0 && Double.isNaN(scores[nScores - 1]); --nScores) {
        }
        if (nScores <= 0) {
            return new double[]{Double.NaN, Double.NaN, Double.NaN};
        }
        double v1 = StatisticsHelper.getInterpolatedSortedValue(scores, (double)(nScores - 1) / 4.0);
        double v2 = StatisticsHelper.getInterpolatedSortedValue(scores, (double)(nScores - 1) / 2.0);
        double v3 = StatisticsHelper.getInterpolatedSortedValue(scores, (double)(nScores - 1) * 3.0 / 4.0);
        return new double[]{v1, v2, v3};
    }

    private static double getInterpolatedSortedValue(double[] values, double ind) {
        if (ind > (double)(values.length - 1)) {
            return Double.NaN;
        }
        int flooredInd = (int)ind;
        double rem = ind - (double)flooredInd;
        if (rem == 0.0) {
            return values[flooredInd];
        }
        return values[flooredInd] + rem * (values[flooredInd + 1] - values[flooredInd]);
    }

    public static double[] getTertiles(double[] scores) {
        int nScores;
        scores = Arrays.copyOf(scores, scores.length);
        Arrays.sort(scores);
        for (nScores = scores.length; nScores > 0 && Double.isNaN(scores[nScores - 1]); --nScores) {
        }
        if (nScores <= 0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double v1 = StatisticsHelper.getInterpolatedSortedValue(scores, (double)(nScores - 1) / 3.0);
        double v2 = StatisticsHelper.getInterpolatedSortedValue(scores, (double)(nScores - 1) * 2.0 / 3.0);
        return new double[]{v1, v2};
    }
}

