/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningStatistics {
    private static Logger logger = LoggerFactory.getLogger(RunningStatistics.class);
    private static double LARGE_DOUBLE_THRESHOLD = Math.pow(2.0, 53.0) - 1.0;
    private int numNaNs = 0;
    protected long size = 0L;
    private double sum = 0.0;
    private double min = Double.POSITIVE_INFINITY;
    private double max = Double.NEGATIVE_INFINITY;
    private double m1 = 0.0;
    private double s1 = 0.0;

    public long size() {
        return this.size;
    }

    public void addValue(double val) {
        if (Double.isNaN(val)) {
            ++this.numNaNs;
            return;
        }
        ++this.size;
        this.sum += val;
        if (val < this.min) {
            this.min = val;
        }
        if (val > this.max) {
            this.max = val;
        }
        if (this.size == 1L) {
            this.m1 = val;
        } else {
            double mNew = this.m1 + (val - this.m1) / (double)this.size;
            this.s1 += (val - this.m1) * (val - mNew);
            this.m1 = mNew;
        }
    }

    public long getNumNaNs() {
        return this.numNaNs;
    }

    public double getSum() {
        if (Math.abs(this.sum) > LARGE_DOUBLE_THRESHOLD) {
            logger.warn("Sum in {} is particularly large ({}), beware imprecision!", (Object)this.getClass().getSimpleName(), (Object)this.sum);
        }
        return this.sum;
    }

    public double getMean() {
        return this.size == 0L ? Double.NaN : this.getSum() / (double)this.size;
    }

    public double getVariance() {
        if (Math.abs(this.s1) > LARGE_DOUBLE_THRESHOLD) {
            logger.warn("Variance parameter s1 in {} is particularly large ({}), beware imprecision!", (Object)this.getClass().getSimpleName(), (Object)this.sum);
        }
        return this.size <= 1L ? Double.NaN : this.s1 / (double)(this.size - 1L);
    }

    public double getStdDev() {
        return Math.sqrt(this.getVariance());
    }

    public double getMin() {
        return this.size == 0L ? Double.NaN : this.min;
    }

    public double getMax() {
        return this.size == 0L ? Double.NaN : this.max;
    }

    public double getRange() {
        return this.size == 0L ? Double.NaN : this.max - this.min;
    }

    public String toString() {
        return String.format("%s Mean: %.2f, Std.dev: %.2f, Min: %.2f, Max: %.2f", RunningStatistics.class.getSimpleName(), this.getMean(), this.getStdDev(), this.getMin(), this.getMax());
    }
}

