/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats;

import java.util.Collection;
import qupath.lib.analysis.stats.ArrayWrappers;
import qupath.lib.analysis.stats.RunningStatistics;
import qupath.lib.objects.PathObject;

public class Histogram {
    private double[] edges;
    private long[] counts;
    private long maxCount;
    private double edgeMin;
    private double edgeMax;
    private long countSum;
    private boolean isInteger = true;
    private RunningStatistics stats;

    public double getEdgeMin() {
        return this.edgeMin;
    }

    public double getEdgeMax() {
        return this.edgeMax;
    }

    public double getEdgeRange() {
        return this.getEdgeMax() - this.getEdgeMin();
    }

    public double getBinLeftEdge(int ind) {
        return this.edges[ind];
    }

    public double getBinRightEdge(int ind) {
        return this.edges[ind + 1];
    }

    public double getBinCenter(int ind) {
        return (this.getBinLeftEdge(ind) + this.getBinRightEdge(ind)) / 2.0;
    }

    public double getBinWidth(int ind) {
        return this.getBinRightEdge(ind) - this.getBinLeftEdge(ind);
    }

    public long getCountsForBin(int ind) {
        return this.counts[ind];
    }

    public double getNormalizedCountsForBin(int ind) {
        return (double)this.getCountsForBin(ind) / (double)this.countSum;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public double getMinValue() {
        return this.stats != null ? this.stats.getMin() : Double.NaN;
    }

    public double getMaxValue() {
        return this.stats != null ? this.stats.getMax() : Double.NaN;
    }

    public double getMeanValue() {
        return this.stats != null ? this.stats.getMean() : Double.NaN;
    }

    public double getVariance() {
        return this.stats != null ? this.stats.getVariance() : Double.NaN;
    }

    public double getStdDev() {
        return this.stats != null ? this.stats.getStdDev() : Double.NaN;
    }

    public double getSum() {
        return this.stats != null ? this.stats.getSum() : Double.NaN;
    }

    public long nValues() {
        return this.stats != null ? this.stats.size() : -1L;
    }

    public long nMissingValues() {
        return this.stats != null ? this.stats.getNumNaNs() : 0L;
    }

    int getBinIndexForValue(double value) {
        int i;
        if (value > this.edgeMax || value < this.edgeMin) {
            return -1;
        }
        for (i = this.edges.length - 2; i >= 0; --i) {
            if (!(this.edges[i] <= value)) continue;
            return i;
        }
        return i;
    }

    public int getBinIndexForValue(double value, double binWidth) {
        int bin = (int)((value - this.edgeMin) / binWidth);
        if (bin >= this.counts.length) {
            bin = this.counts.length - 1;
        }
        return bin;
    }

    public long getMaxCount() {
        return this.maxCount;
    }

    public double getMaxNormalizedCount() {
        return (double)this.getMaxCount() / (double)this.getCountSum();
    }

    public int nBins() {
        return this.counts.length;
    }

    public long getCountSum() {
        return this.countSum;
    }

    public String toString() {
        return String.format("Histogram: Min %.2f, Max %.2f, Total count: %d, N Bins %d", this.getEdgeMin(), this.getEdgeMax(), this.getCountSum(), this.nBins());
    }

    public Histogram(double[] valuesArray, int nBins, double minEdge, double maxEdge) {
        ArrayWrappers.ArrayWrapper values = ArrayWrappers.makeDoubleArrayWrapper(valuesArray);
        this.buildHistogram(values, nBins, minEdge, maxEdge);
    }

    public Histogram(float[] valuesArray, int nBins, double minEdge, double maxEdge) {
        ArrayWrappers.ArrayWrapper values = ArrayWrappers.makeFloatArrayWrapper(valuesArray);
        this.buildHistogram(values, nBins, minEdge, maxEdge);
    }

    public Histogram(int[] valuesArray, int nBins, double minEdge, double maxEdge) {
        ArrayWrappers.ArrayWrapper values = ArrayWrappers.makeIntArrayWrapper(valuesArray);
        this.buildHistogram(values, nBins, minEdge, maxEdge);
    }

    public Histogram(double[] values, int nBins) {
        this(values, nBins, Double.NaN, Double.NaN);
    }

    public Histogram(float[] values, int nBins) {
        this(values, nBins, Double.NaN, Double.NaN);
    }

    public Histogram(ArrayWrappers.ArrayWrapper values, int nBins, double minEdge, double maxEdge) {
        this.buildHistogram(values, nBins, minEdge, maxEdge);
    }

    private void buildHistogram(ArrayWrappers.ArrayWrapper values, int nBins, double minEdge, double maxEdge) {
        int i;
        this.isInteger = values.isIntegerWrapper();
        boolean maybeInteger = !this.isInteger;
        this.stats = new RunningStatistics();
        long n = values.size();
        int i2 = 0;
        while ((long)i2 < n) {
            double v = values.getDouble(i2);
            this.stats.addValue(v);
            if (maybeInteger && v != (double)((int)v)) {
                maybeInteger = false;
            }
            ++i2;
        }
        if (!this.isInteger) {
            this.isInteger = maybeInteger;
        }
        this.edgeMin = Double.isNaN(minEdge) ? this.stats.getMin() : minEdge;
        this.edgeMax = Double.isNaN(maxEdge) ? this.stats.getMax() : maxEdge;
        double binWidth = (this.edgeMax - this.edgeMin) / (double)nBins;
        if (!Double.isFinite(binWidth)) {
            nBins = 0;
        } else if (binWidth < 1.0 && this.isInteger) {
            binWidth = 1.0;
            nBins = (int)(this.edgeMax - this.edgeMin + 1.0);
        }
        this.edges = new double[nBins + 1];
        this.counts = new long[nBins];
        if (nBins == 0) {
            return;
        }
        for (i = 0; i <= nBins; ++i) {
            this.edges[i] = this.edgeMin + (double)i * binWidth;
        }
        this.maxCount = 0L;
        this.countSum = 0L;
        i = 0;
        while ((long)i < n) {
            double v = values.getDouble(i);
            if (!(Double.isNaN(v) || v < this.edgeMin || v > this.edgeMax)) {
                long count;
                int bin = this.getBinIndexForValue(v, binWidth);
                this.counts[bin] = count = this.counts[bin] + 1L;
                if (count > this.maxCount) {
                    this.maxCount = count;
                }
                ++this.countSum;
            }
            ++i;
        }
    }

    public static double[] getMeasurementValues(Collection<PathObject> pathObjects, String measurementName) {
        double[] values = new double[pathObjects.size()];
        int ind = 0;
        for (PathObject pathObject : pathObjects) {
            values[ind] = pathObject.getMeasurementList().get(measurementName);
            ++ind;
        }
        return values;
    }

    public static Histogram makeMeasurementHistogram(Collection<PathObject> pathObjects, String measurementName, int nBins) {
        if (pathObjects.isEmpty()) {
            return null;
        }
        double[] values = Histogram.getMeasurementValues(pathObjects, measurementName);
        Histogram histogram = new Histogram(values, nBins);
        if (histogram.getCountSum() > 0L) {
            return histogram;
        }
        return null;
    }
}

