/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.stats;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class ArrayWrappers {
    private static final ArrayWrapper EMPTY = new EmptyWrapper();

    public static ArrayWrapper makeDoubleArrayWrapper(double[] array) {
        return new DoubleArrayWrapper(array);
    }

    public static ArrayWrapper makeFloatArrayWrapper(float[] array) {
        return new FloatArrayWrapper(array);
    }

    public static ArrayWrapper makeIntArrayWrapper(int[] array) {
        return new IntArrayWrapper(array);
    }

    public static ArrayWrapper makeUnsignedByteArrayWrapper(byte[] array) {
        return new UnsignedByteArrayWrapper(array);
    }

    public static ArrayWrapper makeUnsignedShortArrayWrapper(short[] array) {
        return new UnsignedShortArrayWrapper(array);
    }

    public static ArrayWrapper concatenate(ArrayWrapper ... wrappers) {
        return ArrayWrappers.concatenate(Arrays.asList(wrappers));
    }

    public static ArrayWrapper concatenate(Collection<? extends ArrayWrapper> wrappers) {
        if (wrappers.isEmpty()) {
            return EMPTY;
        }
        if (wrappers.size() == 1) {
            return wrappers.iterator().next();
        }
        return new ConcatArrayWrapper(wrappers);
    }

    static class DoubleArrayWrapper
    implements ArrayWrapper {
        private final double[] array;

        public DoubleArrayWrapper(double[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return false;
        }
    }

    static class FloatArrayWrapper
    implements ArrayWrapper {
        private final float[] array;

        public FloatArrayWrapper(float[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return false;
        }
    }

    static class IntArrayWrapper
    implements ArrayWrapper {
        private final int[] array;

        public IntArrayWrapper(int[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind];
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    static class UnsignedByteArrayWrapper
    implements ArrayWrapper {
        private final byte[] array;

        public UnsignedByteArrayWrapper(byte[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind] & 0xFF;
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    static class UnsignedShortArrayWrapper
    implements ArrayWrapper {
        private final short[] array;

        public UnsignedShortArrayWrapper(short[] array) {
            this.array = array;
        }

        @Override
        public final int size() {
            return this.array.length;
        }

        @Override
        public final double getDouble(int ind) {
            return this.array[ind] & 0xFFFF;
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }

    public static interface ArrayWrapper {
        public int size();

        default public boolean isEmpty() {
            return this.size() == 0;
        }

        public double getDouble(int var1);

        public boolean isIntegerWrapper();
    }

    static class ConcatArrayWrapper
    implements ArrayWrapper {
        private final List<ArrayWrapper> wrappers;
        private final int[] offsets;
        private final int size;
        private final boolean isIntegerWrapper;

        public ConcatArrayWrapper(Collection<? extends ArrayWrapper> wrappers) {
            this.wrappers = wrappers.stream().filter(w -> !w.isEmpty()).map(w -> w).toList();
            long size = 0L;
            int[] offsets = new int[wrappers.size()];
            boolean isIntegerWrapper = true;
            int ind = 0;
            for (ArrayWrapper arrayWrapper : wrappers) {
                if ((size += (long)arrayWrapper.size()) > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Array wrapper size too large");
                }
                offsets[ind] = (int)size;
                if (!arrayWrapper.isIntegerWrapper()) {
                    isIntegerWrapper = false;
                }
                ++ind;
            }
            this.isIntegerWrapper = isIntegerWrapper;
            this.offsets = offsets;
            this.size = (int)size;
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final double getDouble(int ind) {
            if (ind < 0 || ind >= this.size()) {
                throw new ArrayIndexOutOfBoundsException(ind);
            }
            int wrapperIdx = Arrays.binarySearch(this.offsets, ind);
            if (wrapperIdx < 0) {
                if ((wrapperIdx = -wrapperIdx - 1) > 0) {
                    ind -= this.offsets[wrapperIdx - 1];
                }
                ArrayWrapper wrapper = this.wrappers.get(wrapperIdx);
                return wrapper.getDouble(ind);
            }
            ArrayWrapper wrapper = this.wrappers.get(wrapperIdx + 1);
            return wrapper.getDouble(ind -= this.offsets[wrapperIdx]);
        }

        @Override
        public boolean isIntegerWrapper() {
            return this.isIntegerWrapper;
        }
    }

    static class EmptyWrapper
    implements ArrayWrapper {
        EmptyWrapper() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public double getDouble(int ind) {
            throw new IndexOutOfBoundsException("Index: " + ind);
        }

        @Override
        public boolean isIntegerWrapper() {
            return true;
        }
    }
}

