/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.images;

import qupath.lib.analysis.images.SimpleImage;
import qupath.lib.analysis.images.SimpleModifiableImage;

public class SimpleImages {
    public static float[] getPixels(SimpleImage image, boolean direct) {
        if (image instanceof SimpleModifiableImage) {
            return ((SimpleModifiableImage)image).getArray(direct);
        }
        int n = image.getWidth() * image.getHeight();
        int w = image.getWidth();
        float[] pixels = new float[n];
        for (int i = 0; i < n; ++i) {
            pixels[i] = image.getValue(i % w, i / w);
        }
        return pixels;
    }

    public static SimpleModifiableImage createFloatImage(float[] data, int width, int height) {
        return new FloatArraySimpleImage(data, width, height);
    }

    public static SimpleModifiableImage createFloatImage(int width, int height) {
        return new FloatArraySimpleImage(new float[width * height], width, height);
    }

    static class FloatArraySimpleImage
    implements SimpleModifiableImage {
        private float[] data;
        private int width;
        private int height;

        public FloatArraySimpleImage(float[] data, int width, int height) {
            this.data = data;
            this.width = width;
            this.height = height;
        }

        public FloatArraySimpleImage(int width, int height) {
            this.data = new float[width * height];
            this.width = width;
            this.height = height;
        }

        @Override
        public float getValue(int x, int y) {
            return this.data[y * this.width + x];
        }

        @Override
        public void setValue(int x, int y, float val) {
            this.data[y * this.width + x] = val;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public float[] getArray(boolean direct) {
            if (direct) {
                return this.data;
            }
            return (float[])this.data.clone();
        }
    }
}

