/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.analysis.images;

import qupath.lib.analysis.images.IntPoint;

record CoordinatePair(IntPoint c1, IntPoint c2) implements Comparable<CoordinatePair>
{
    CoordinatePair(IntPoint c1, IntPoint c2) {
        int comp = c1.compareTo(c2);
        if (comp < 0) {
            this.c1 = c1;
            this.c2 = c2;
        } else if (comp > 0) {
            this.c1 = c2;
            this.c2 = c1;
        } else {
            throw new IllegalArgumentException("Coordinates should not be the same!");
        }
        if (!this.isHorizontal() && !this.isVertical()) {
            throw new IllegalArgumentException("Coordinate pairs should be horizontal or vertical!");
        }
    }

    boolean isHorizontal() {
        return this.c1.getY() == this.c2.getY() && this.c1.getX() != this.c2.getX();
    }

    boolean isVertical() {
        return this.c1.getX() == this.c2.getX() && this.c1.getY() != this.c2.getY();
    }

    @Override
    public int compareTo(CoordinatePair other) {
        if (this.equals(other)) {
            return 0;
        }
        int comp = this.c1.compareTo(other.c1);
        if (comp == 0) {
            return this.c2.compareTo(other.c2);
        }
        return comp;
    }
}

