/*
 * Decompiled with CFR 0.152.
 */
package org.fxmisc.richtext;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import javafx.beans.NamedArg;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.input.InputMethodEvent;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.InputMethodTextRun;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.TextFlow;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualFlowHit;
import org.fxmisc.flowless.Virtualized;
import org.fxmisc.richtext.Caret;
import org.fxmisc.richtext.CaretNode;
import org.fxmisc.richtext.CaretSelectionBind;
import org.fxmisc.richtext.CaretSelectionBindImpl;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.ClipboardActions;
import org.fxmisc.richtext.CustomCssMetaData;
import org.fxmisc.richtext.CustomStyleableProperty;
import org.fxmisc.richtext.EditActions;
import org.fxmisc.richtext.GenericStyledAreaBehavior;
import org.fxmisc.richtext.LineSelection;
import org.fxmisc.richtext.MultiChangeBuilder;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.ParagraphBox;
import org.fxmisc.richtext.Selection;
import org.fxmisc.richtext.SelectionPath;
import org.fxmisc.richtext.StyleActions;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextEditingArea;
import org.fxmisc.richtext.UndoActions;
import org.fxmisc.richtext.ViewActions;
import org.fxmisc.richtext.event.MouseOverTextEvent;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.EditableStyledDocument;
import org.fxmisc.richtext.model.GenericEditableStyledDocument;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.PlainTextChange;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.Replacement;
import org.fxmisc.richtext.model.RichTextChange;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.richtext.model.TwoDimensional;
import org.fxmisc.richtext.model.TwoLevelNavigator;
import org.fxmisc.richtext.util.SubscribeableContentsObsSet;
import org.fxmisc.richtext.util.UndoUtils;
import org.fxmisc.undo.UndoManager;
import org.reactfx.EventStream;
import org.reactfx.EventStreams;
import org.reactfx.Guard;
import org.reactfx.Subscription;
import org.reactfx.Suspendable;
import org.reactfx.SuspendableEventStream;
import org.reactfx.SuspendableNo;
import org.reactfx.collection.LiveList;
import org.reactfx.collection.SuspendableList;
import org.reactfx.util.Tuple2;
import org.reactfx.util.Tuples;
import org.reactfx.value.Val;
import org.reactfx.value.Var;

public class GenericStyledArea<PS, SEG, S>
extends Region
implements TextEditingArea<PS, SEG, S>,
EditActions<PS, SEG, S>,
ClipboardActions<PS, SEG, S>,
NavigationActions<PS, SEG, S>,
StyleActions<PS, S>,
UndoActions,
ViewActions<PS, SEG, S>,
TwoDimensional,
Virtualized {
    public static final IndexRange EMPTY_RANGE = new IndexRange(0, 0);
    private static final PseudoClass READ_ONLY = PseudoClass.getPseudoClass((String)"readonly");
    private static final PseudoClass HAS_CARET = PseudoClass.getPseudoClass((String)"has-caret");
    private static final PseudoClass FIRST_PAR = PseudoClass.getPseudoClass((String)"first-paragraph");
    private static final PseudoClass LAST_PAR = PseudoClass.getPseudoClass((String)"last-paragraph");
    private final StyleableObjectProperty<Paint> highlightTextFill = new CustomStyleableProperty<Paint>((Paint)Color.WHITE, "highlightTextFill", this, (CssMetaData<Styleable, Paint>)HIGHLIGHT_TEXT_FILL);
    private final BooleanProperty editable = new SimpleBooleanProperty(this, "editable", true){

        protected void invalidated() {
            ((Region)this.getBean()).pseudoClassStateChanged(READ_ONLY, !this.get());
        }
    };
    private final ReadOnlyBooleanProperty overwriteMode;
    private final BooleanProperty wrapText = new SimpleBooleanProperty((Object)this, "wrapText");
    private UndoManager undoManager;
    private Locale textLocale = Locale.getDefault();
    private final ObjectProperty<Duration> mouseOverTextDelay = new SimpleObjectProperty(null);
    private final ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactory = new SimpleObjectProperty(null);
    private ObjectProperty<Node> placeHolderProp = new SimpleObjectProperty((Object)this, "placeHolder", null);
    private Pos placeHolderPos = Pos.CENTER;
    private ObjectProperty<ContextMenu> contextMenu = new SimpleObjectProperty(null);
    private DoubleProperty contextMenuXOffset = new SimpleDoubleProperty(2.0);
    private DoubleProperty contextMenuYOffset = new SimpleDoubleProperty(2.0);
    private final BooleanProperty useInitialStyleForInsertion = new SimpleBooleanProperty();
    private Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> styleCodecs = Optional.empty();
    private final SubscribeableContentsObsSet<CaretNode> caretSet;
    private final SubscribeableContentsObsSet<Selection<PS, SEG, S>> selectionSet;
    private final ObjectProperty<EventHandler<MouseEvent>> onOutsideSelectionMousePressed = new SimpleObjectProperty(e -> this.moveTo(this.hit(e.getX(), e.getY()).getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR));
    private final ObjectProperty<EventHandler<MouseEvent>> onInsideSelectionMousePressReleased = new SimpleObjectProperty(e -> this.moveTo(this.hit(e.getX(), e.getY()).getInsertionIndex(), NavigationActions.SelectionPolicy.CLEAR));
    private final ObjectProperty<Consumer<Point2D>> onNewSelectionDrag = new SimpleObjectProperty(p -> {
        CharacterHit hit = this.hit(p.getX(), p.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final ObjectProperty<EventHandler<MouseEvent>> onNewSelectionDragFinished = new SimpleObjectProperty(e -> {
        CharacterHit hit = this.hit(e.getX(), e.getY());
        this.moveTo(hit.getInsertionIndex(), NavigationActions.SelectionPolicy.ADJUST);
    });
    private final ObjectProperty<Consumer<Point2D>> onSelectionDrag = new SimpleObjectProperty(p -> {
        CharacterHit hit = this.hit(p.getX(), p.getY());
        this.displaceCaret(hit.getInsertionIndex());
    });
    private final ObjectProperty<EventHandler<MouseEvent>> onSelectionDropped = new SimpleObjectProperty(e -> this.moveSelectedText(this.hit(e.getX(), e.getY()).getInsertionIndex()));
    private final BooleanProperty autoScrollOnDragDesired = new SimpleBooleanProperty(true);
    private CaretSelectionBind<PS, SEG, S> caretSelectionBind;
    private final SuspendableList<Paragraph<PS, SEG, S>> visibleParagraphs;
    private final SuspendableNo beingUpdated = new SuspendableNo();
    private final SuspendableEventStream<?> viewportDirty;
    private Subscription subscriptions = () -> {};
    private final VirtualFlow<Paragraph<PS, SEG, S>, Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>> virtualFlow;
    private final TwoLevelNavigator paragraphLineNavigator;
    private boolean paging;
    private boolean followCaretRequested = false;
    private final EditableStyledDocument<PS, SEG, S> content;
    private final S initialTextStyle;
    private final PS initialParagraphStyle;
    private final BiConsumer<TextFlow, PS> applyParagraphStyle;
    private final boolean preserveStyle;
    private final TextOps<SEG, S> segmentOps;
    private final EventStream<Boolean> autoCaretBlinksSteam;
    private int imstart;
    private int imlength;
    private Node placeholder;
    private boolean positionPlaceholder = false;
    private double caretPrevY = -1.0;
    private LineSelection<PS, SEG, S> lineHighlighter;
    private ObjectProperty<Paint> lineHighlighterFill;
    private S insertionTextStyle;
    private PS insertionParagraphStyle;
    protected boolean foldCheck = false;
    private BooleanProperty autoHeightProp = new SimpleBooleanProperty();
    private static final CssMetaData<GenericStyledArea<?, ?, ?>, Paint> HIGHLIGHT_TEXT_FILL = new CustomCssMetaData<GenericStyledArea, Color>("-fx-highlight-text-fill", StyleConverter.getPaintConverter(), Color.WHITE, s -> s.highlightTextFill);
    private static final List<CssMetaData<? extends Styleable, ?>> CSS_META_DATA_LIST;

    @Override
    public final BooleanProperty editableProperty() {
        return this.editable;
    }

    @Override
    public void setEditable(boolean value) {
        this.editable.set(value);
    }

    @Override
    public boolean isEditable() {
        return this.editable.get();
    }

    public final ReadOnlyBooleanProperty overwriteModeProperty() {
        return this.overwriteMode;
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode.get();
    }

    @Override
    public final BooleanProperty wrapTextProperty() {
        return this.wrapText;
    }

    @Override
    public void setWrapText(boolean value) {
        this.wrapText.set(value);
    }

    @Override
    public boolean isWrapText() {
        return this.wrapText.get();
    }

    @Override
    public UndoManager getUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setUndoManager(UndoManager undoManager) {
        this.undoManager.close();
        this.undoManager = undoManager != null ? undoManager : UndoUtils.noOpUndoManager();
    }

    @Override
    public Locale getLocale() {
        return this.textLocale;
    }

    public void setLocale(Locale editorLocale) {
        this.textLocale = editorLocale;
    }

    @Override
    public ObjectProperty<Duration> mouseOverTextDelayProperty() {
        return this.mouseOverTextDelay;
    }

    @Override
    public ObjectProperty<IntFunction<? extends Node>> paragraphGraphicFactoryProperty() {
        return this.paragraphGraphicFactory;
    }

    public void recreateParagraphGraphic(int parNdx) {
        ObjectProperty<IntFunction<Node>> gProp = this.getCell(parNdx).graphicFactoryProperty();
        gProp.unbind();
        gProp.bind(this.paragraphGraphicFactoryProperty());
    }

    public Node getParagraphGraphic(int parNdx) {
        return this.getCell(parNdx).getGraphic();
    }

    public final void setPlaceholder(Node value) {
        this.setPlaceholder(value, Pos.CENTER);
    }

    public void setPlaceholder(Node value, Pos where) {
        this.placeHolderProp.set((Object)value);
        this.placeHolderPos = Objects.requireNonNull(where);
    }

    public final ObjectProperty<Node> placeholderProperty() {
        return this.placeHolderProp;
    }

    public final Node getPlaceholder() {
        return (Node)this.placeHolderProp.get();
    }

    @Override
    public final ObjectProperty<ContextMenu> contextMenuObjectProperty() {
        return this.contextMenu;
    }

    @Override
    public void setContextMenu(ContextMenu menu) {
        this.contextMenu.set((Object)menu);
    }

    @Override
    public ContextMenu getContextMenu() {
        return (ContextMenu)this.contextMenu.get();
    }

    protected final boolean isContextMenuPresent() {
        return this.contextMenu.get() != null;
    }

    @Override
    public final DoubleProperty contextMenuXOffsetProperty() {
        return this.contextMenuXOffset;
    }

    @Override
    public void setContextMenuXOffset(double offset) {
        this.contextMenuXOffset.set(offset);
    }

    @Override
    public double getContextMenuXOffset() {
        return this.contextMenuXOffset.get();
    }

    @Override
    public final DoubleProperty contextMenuYOffsetProperty() {
        return this.contextMenuYOffset;
    }

    @Override
    public void setContextMenuYOffset(double offset) {
        this.contextMenuYOffset.set(offset);
    }

    @Override
    public double getContextMenuYOffset() {
        return this.contextMenuYOffset.get();
    }

    @Override
    public BooleanProperty useInitialStyleForInsertionProperty() {
        return this.useInitialStyleForInsertion;
    }

    @Override
    public void setStyleCodecs(Codec<PS> paragraphStyleCodec, Codec<StyledSegment<SEG, S>> styledSegCodec) {
        this.styleCodecs = Optional.of(Tuples.t(paragraphStyleCodec, styledSegCodec));
    }

    @Override
    public Optional<Tuple2<Codec<PS>, Codec<StyledSegment<SEG, S>>>> getStyleCodecs() {
        return this.styleCodecs;
    }

    @Override
    public Var<Double> estimatedScrollXProperty() {
        return this.virtualFlow.estimatedScrollXProperty();
    }

    @Override
    public Var<Double> estimatedScrollYProperty() {
        return this.virtualFlow.estimatedScrollYProperty();
    }

    public final boolean addCaret(CaretNode caret) {
        if (caret.getArea() != this) {
            throw new IllegalArgumentException(String.format("The caret (%s) is associated with a different area (%s), not this area (%s)", caret, caret.getArea(), this));
        }
        return this.caretSet.add(caret);
    }

    public final boolean removeCaret(CaretNode caret) {
        if (caret != this.caretSelectionBind.getUnderlyingCaret() && this.caretSet.remove(caret)) {
            this.virtualFlow.getCellIfVisible(caret.getParagraphIndex()).ifPresent(c -> ((ParagraphBox)c.getNode()).caretsProperty().remove((Object)caret));
            caret.dispose();
            return true;
        }
        return false;
    }

    public final boolean addSelection(Selection<PS, SEG, S> selection) {
        if (selection.getArea() != this) {
            throw new IllegalArgumentException(String.format("The selection (%s) is associated with a different area (%s), not this area (%s)", selection, selection.getArea(), this));
        }
        return this.selectionSet.add(selection);
    }

    public final boolean removeSelection(Selection<PS, SEG, S> selection) {
        if (selection != this.caretSelectionBind.getUnderlyingSelection() && this.selectionSet.remove(selection)) {
            for (int p = selection.getStartParagraphIndex(); p <= selection.getEndParagraphIndex(); ++p) {
                this.virtualFlow.getCellIfVisible(p).ifPresent(c -> ((ParagraphBox)c.getNode()).selectionsProperty().remove((Object)selection));
            }
            selection.dispose();
            return true;
        }
        return false;
    }

    @Override
    public final EventHandler<MouseEvent> getOnOutsideSelectionMousePressed() {
        return (EventHandler)this.onOutsideSelectionMousePressed.get();
    }

    @Override
    public final void setOnOutsideSelectionMousePressed(EventHandler<MouseEvent> handler) {
        this.onOutsideSelectionMousePressed.set(handler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onOutsideSelectionMousePressedProperty() {
        return this.onOutsideSelectionMousePressed;
    }

    @Override
    public final EventHandler<MouseEvent> getOnInsideSelectionMousePressReleased() {
        return (EventHandler)this.onInsideSelectionMousePressReleased.get();
    }

    @Override
    public final void setOnInsideSelectionMousePressReleased(EventHandler<MouseEvent> handler) {
        this.onInsideSelectionMousePressReleased.set(handler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onInsideSelectionMousePressReleasedProperty() {
        return this.onInsideSelectionMousePressReleased;
    }

    @Override
    public final ObjectProperty<Consumer<Point2D>> onNewSelectionDragProperty() {
        return this.onNewSelectionDrag;
    }

    @Override
    public final EventHandler<MouseEvent> getOnNewSelectionDragFinished() {
        return (EventHandler)this.onNewSelectionDragFinished.get();
    }

    @Override
    public final void setOnNewSelectionDragFinished(EventHandler<MouseEvent> handler) {
        this.onNewSelectionDragFinished.set(handler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onNewSelectionDragFinishedProperty() {
        return this.onNewSelectionDragFinished;
    }

    @Override
    public final ObjectProperty<Consumer<Point2D>> onSelectionDragProperty() {
        return this.onSelectionDrag;
    }

    @Override
    public final EventHandler<MouseEvent> getOnSelectionDropped() {
        return (EventHandler)this.onSelectionDropped.get();
    }

    @Override
    public final void setOnSelectionDropped(EventHandler<MouseEvent> handler) {
        this.onSelectionDropped.set(handler);
    }

    @Override
    public final ObjectProperty<EventHandler<MouseEvent>> onSelectionDroppedProperty() {
        return this.onSelectionDropped;
    }

    @Override
    public final BooleanProperty autoScrollOnDragDesiredProperty() {
        return this.autoScrollOnDragDesired;
    }

    @Override
    public void setAutoScrollOnDragDesired(boolean val) {
        this.autoScrollOnDragDesired.set(val);
    }

    @Override
    public boolean isAutoScrollOnDragDesired() {
        return this.autoScrollOnDragDesired.get();
    }

    @Override
    public final ObservableValue<String> textProperty() {
        return this.content.textProperty();
    }

    @Override
    public final StyledDocument<PS, SEG, S> getDocument() {
        return this.content;
    }

    @Override
    public final CaretSelectionBind<PS, SEG, S> getCaretSelectionBind() {
        return this.caretSelectionBind;
    }

    @Override
    public final ObservableValue<Integer> lengthProperty() {
        return this.content.lengthProperty();
    }

    @Override
    public LiveList<Paragraph<PS, SEG, S>> getParagraphs() {
        return this.content.getParagraphs();
    }

    @Override
    public final LiveList<Paragraph<PS, SEG, S>> getVisibleParagraphs() {
        return this.visibleParagraphs;
    }

    @Override
    public final SuspendableNo beingUpdatedProperty() {
        return this.beingUpdated;
    }

    @Override
    public Val<Double> totalWidthEstimateProperty() {
        return this.virtualFlow.totalWidthEstimateProperty();
    }

    @Override
    public Val<Double> totalHeightEstimateProperty() {
        return this.virtualFlow.totalHeightEstimateProperty();
    }

    @Override
    public EventStream<List<RichTextChange<PS, SEG, S>>> multiRichChanges() {
        return this.content.multiRichChanges();
    }

    @Override
    public EventStream<List<PlainTextChange>> multiPlainChanges() {
        return this.content.multiPlainChanges();
    }

    @Override
    public final EventStream<PlainTextChange> plainTextChanges() {
        return this.content.plainChanges();
    }

    @Override
    public final EventStream<RichTextChange<PS, SEG, S>> richChanges() {
        return this.content.richChanges();
    }

    @Override
    public final EventStream<?> viewportDirtyEvents() {
        return this.viewportDirty;
    }

    @Override
    public final EditableStyledDocument<PS, SEG, S> getContent() {
        return this.content;
    }

    @Override
    public final S getInitialTextStyle() {
        return this.initialTextStyle;
    }

    @Override
    public final PS getInitialParagraphStyle() {
        return this.initialParagraphStyle;
    }

    @Override
    public final BiConsumer<TextFlow, PS> getApplyParagraphStyle() {
        return this.applyParagraphStyle;
    }

    @Override
    public final boolean isPreserveStyle() {
        return this.preserveStyle;
    }

    @Override
    public final TextOps<SEG, S> getSegOps() {
        return this.segmentOps;
    }

    final EventStream<Boolean> autoCaretBlink() {
        return this.autoCaretBlinksSteam;
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, segmentOps, true, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="preserveStyle") boolean preserveStyle, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, new GenericEditableStyledDocument<PS, SEG, S>(initialParagraphStyle, initialTextStyle, segmentOps), segmentOps, preserveStyle, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> document, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this(initialParagraphStyle, applyParagraphStyle, initialTextStyle, document, segmentOps, true, nodeFactory);
    }

    public GenericStyledArea(@NamedArg(value="initialParagraphStyle") PS initialParagraphStyle, @NamedArg(value="applyParagraphStyle") BiConsumer<TextFlow, PS> applyParagraphStyle, @NamedArg(value="initialTextStyle") S initialTextStyle, @NamedArg(value="document") EditableStyledDocument<PS, SEG, S> document, @NamedArg(value="segmentOps") TextOps<SEG, S> segmentOps, @NamedArg(value="preserveStyle") boolean preserveStyle, @NamedArg(value="nodeFactory") Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        this.initialTextStyle = initialTextStyle;
        this.initialParagraphStyle = initialParagraphStyle;
        this.preserveStyle = preserveStyle;
        this.content = document;
        this.applyParagraphStyle = applyParagraphStyle;
        this.segmentOps = segmentOps;
        this.undoManager = UndoUtils.defaultUndoManager(this);
        this.setFocusTraversable(true);
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, CornerRadii.EMPTY, Insets.EMPTY)}));
        this.getStyleClass().add((Object)"styled-text-area");
        this.getStylesheets().add((Object)StyledTextArea.class.getResource("styled-text-area.css").toExternalForm());
        ObservableSet nonEmptyCells = FXCollections.observableSet((Object[])new ParagraphBox[0]);
        this.caretSet = new SubscribeableContentsObsSet();
        this.manageSubscription(() -> {
            ArrayList<CaretNode> l = new ArrayList<CaretNode>(this.caretSet);
            this.caretSet.clear();
            l.forEach(CaretNode::dispose);
        });
        this.selectionSet = new SubscribeableContentsObsSet();
        this.manageSubscription(() -> {
            ArrayList<Selection<PS, SEG, S>> l = new ArrayList<Selection<PS, SEG, S>>(this.selectionSet);
            this.selectionSet.clear();
            l.forEach(Selection::dispose);
        });
        this.virtualFlow = VirtualFlow.createVertical(this.getParagraphs(), par -> {
            Cell cell = this.createCell((Paragraph<PS, SEG, S>)par, applyParagraphStyle, nodeFactory);
            nonEmptyCells.add((Object)((ParagraphBox)cell.getNode()));
            return cell.beforeReset(() -> nonEmptyCells.remove((Object)cell.getNode())).afterUpdateItem(p -> nonEmptyCells.add((Object)((ParagraphBox)cell.getNode())));
        });
        this.getChildren().add(this.virtualFlow);
        IntSupplier cellCount = () -> this.getParagraphs().size();
        IntUnaryOperator cellLength = i -> ((ParagraphBox)this.virtualFlow.getCell(i).getNode()).getLineCount();
        this.paragraphLineNavigator = new TwoLevelNavigator(cellCount, cellLength);
        this.viewportDirty = EventStreams.merge((EventStream[])new EventStream[]{EventStreams.invalidationsOf((Observable)this.scaleXProperty()), EventStreams.invalidationsOf((Observable)this.scaleYProperty()), EventStreams.invalidationsOf(this.estimatedScrollXProperty()), EventStreams.invalidationsOf(this.estimatedScrollYProperty())}).suppressible();
        this.autoCaretBlinksSteam = EventStreams.valuesOf((ObservableValue)this.focusedProperty().and((ObservableBooleanValue)this.editableProperty()).and((ObservableBooleanValue)this.disabledProperty().not()));
        this.caretSelectionBind = new CaretSelectionBindImpl("main-caret", "main-selection", this);
        this.caretSelectionBind.paragraphIndexProperty().addListener(this::skipOverFoldedParagraphs);
        this.caretSet.add(this.caretSelectionBind.getUnderlyingCaret());
        this.selectionSet.add(this.caretSelectionBind.getUnderlyingSelection());
        this.visibleParagraphs = LiveList.map((ObservableList)this.virtualFlow.visibleCells(), c -> ((ParagraphBox)c.getNode()).getParagraph()).suspendable();
        Suspendable omniSuspendable = Suspendable.combine((Suspendable[])new Suspendable[]{this.beingUpdated, this.visibleParagraphs});
        this.manageSubscription(omniSuspendable.suspendWhen((ObservableValue)this.content.beingUpdatedProperty()));
        EventStreams.valuesOf(this.mouseOverTextDelayProperty()).flatMap(delay -> delay != null ? this.mouseOverTextEvents((ObservableSet<ParagraphBox<PS, SEG, S>>)nonEmptyCells, (Duration)delay) : EventStreams.never()).subscribe(evt -> Event.fireEvent((EventTarget)this, (Event)evt));
        this.overwriteMode = new GenericStyledAreaBehavior(this).overwriteModeProperty();
        Val showPlaceholder = Val.create(() -> this.getLength() == 0 && !this.isFocused(), (Observable[])new Observable[]{this.lengthProperty(), this.focusedProperty()});
        this.placeHolderProp.addListener((ob, ov, newNode) -> this.displayPlaceHolder((Boolean)showPlaceholder.getValue(), (Node)newNode));
        showPlaceholder.addListener((ob, ov, show) -> this.displayPlaceHolder((boolean)show, this.getPlaceholder()));
        if (Platform.isFxApplicationThread()) {
            this.initInputMethodHandling();
        } else {
            Platform.runLater(() -> this.initInputMethodHandling());
        }
    }

    private void initInputMethodHandling() {
        if (Platform.isSupported((ConditionalFeature)ConditionalFeature.INPUT_METHOD)) {
            this.setOnInputMethodTextChanged(event -> this.handleInputMethodEvent((InputMethodEvent)event));
            this.setInputMethodRequests(new InputMethodRequests(){

                public Point2D getTextLocation(int offset) {
                    return GenericStyledArea.this.getCaretBounds().or(() -> GenericStyledArea.this.getCharacterBoundsOnScreen(offset, offset)).map(cb -> new Point2D(cb.getMaxX() - 5.0, cb.getMaxY())).orElseGet(() -> new Point2D(10.0, 10.0));
                }

                public int getLocationOffset(int x, int y) {
                    return 0;
                }

                public void cancelLatestCommittedText() {
                }

                public String getSelectedText() {
                    return GenericStyledArea.this.getSelectedText();
                }
            });
        }
    }

    protected void handleInputMethodEvent(InputMethodEvent event) {
        if (this.isEditable() && !this.isDisabled()) {
            if (this.imlength != 0) {
                this.selectRange(this.imstart, this.imstart + this.imlength);
            }
            if (event.getCommitted().length() != 0) {
                this.replaceText(this.getSelection(), event.getCommitted());
            }
            this.imstart = this.getSelection().getStart();
            StringBuilder composed = new StringBuilder();
            for (Object run : event.getComposed()) {
                composed.append(run.getText());
            }
            this.replaceText(this.getSelection(), composed.toString());
            this.imlength = composed.length();
            if (this.imlength != 0) {
                int pos = this.imstart;
                for (InputMethodTextRun run : event.getComposed()) {
                    int endPos;
                    pos = endPos = pos + run.getText().length();
                }
                int caretPos = event.getCaretPosition();
                if (caretPos >= 0 && caretPos < this.imlength) {
                    this.selectRange(this.imstart + caretPos, this.imstart + caretPos);
                }
            }
        }
    }

    private void displayPlaceHolder(boolean show, Node newNode) {
        if (!(this.placeholder == null || show && newNode == this.placeholder)) {
            this.placeholder.layoutXProperty().unbind();
            this.placeholder.layoutYProperty().unbind();
            this.getChildren().remove((Object)this.placeholder);
            this.placeholder = null;
            this.setClip(null);
        }
        if (newNode != null && show && newNode != this.placeholder) {
            this.configurePlaceholder(newNode);
            this.getChildren().add((Object)newNode);
            this.placeholder = newNode;
        }
    }

    protected void configurePlaceholder(Node placeholder) {
        this.positionPlaceholder = true;
    }

    @Override
    public final double getViewportHeight() {
        return this.virtualFlow.getHeight();
    }

    @Override
    public final Optional<Integer> allParToVisibleParIndex(int allParIndex) {
        if (allParIndex < 0) {
            throw new IllegalArgumentException("The given paragraph index (allParIndex) cannot be negative but was " + allParIndex);
        }
        if (allParIndex >= this.getParagraphs().size()) {
            throw new IllegalArgumentException(String.format("Paragraphs' last index is [%s] but allParIndex was [%s]", this.getParagraphs().size() - 1, allParIndex));
        }
        ObservableList visibleList = this.virtualFlow.visibleCells();
        int firstVisibleParIndex = ((ParagraphBox)((Cell)visibleList.get(0)).getNode()).getIndex();
        int targetIndex = allParIndex - firstVisibleParIndex;
        if (allParIndex >= firstVisibleParIndex && targetIndex < visibleList.size() && ((ParagraphBox)((Cell)visibleList.get(targetIndex)).getNode()).getIndex() == allParIndex) {
            return Optional.of(targetIndex);
        }
        return Optional.empty();
    }

    @Override
    public final int visibleParToAllParIndex(int visibleParIndex) {
        if (visibleParIndex < 0) {
            throw new IllegalArgumentException("Visible paragraph index cannot be negative but was " + visibleParIndex);
        }
        if (visibleParIndex > 0 && visibleParIndex >= this.getVisibleParagraphs().size()) {
            throw new IllegalArgumentException(String.format("Visible paragraphs' last index is [%s] but visibleParIndex was [%s]", this.getVisibleParagraphs().size() - 1, visibleParIndex));
        }
        try {
            Cell visibleCell = null;
            visibleCell = visibleParIndex > 0 ? (Cell)this.virtualFlow.visibleCells().get(visibleParIndex) : this.virtualFlow.getCellIfVisible(this.virtualFlow.getFirstVisibleIndex()).orElseGet(() -> (Cell)this.virtualFlow.visibleCells().get(visibleParIndex));
            return ((ParagraphBox)visibleCell.getNode()).getIndex();
        }
        catch (IndexOutOfBoundsException | NoSuchElementException EX) {
            return -1;
        }
    }

    @Override
    public CharacterHit hit(double x, double y) {
        double adjustedY;
        double adjustedX = x - this.getInsets().getLeft();
        VirtualFlowHit hit = this.virtualFlow.hit(adjustedX, adjustedY = y - this.getInsets().getTop());
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox cell = (ParagraphBox)hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hit(cellOffset);
        return parHit.offset(parOffset);
    }

    @Override
    public final int lineIndex(int paragraphIndex, int columnPosition) {
        Cell cell = this.virtualFlow.getCell(paragraphIndex);
        return ((ParagraphBox)cell.getNode()).getCurrentLineIndex(columnPosition);
    }

    @Override
    public int getParagraphLinesCount(int paragraphIndex) {
        return ((ParagraphBox)this.virtualFlow.getCell(paragraphIndex).getNode()).getLineCount();
    }

    @Override
    public Optional<Bounds> getCharacterBoundsOnScreen(int from, int to) {
        TwoDimensional.Position endPosition;
        int endRow;
        if (from < 0) {
            throw new IllegalArgumentException("From is negative: " + from);
        }
        if (from > to) {
            throw new IllegalArgumentException(String.format("From is greater than to. from=%s to=%s", from, to));
        }
        if (to > this.getLength()) {
            throw new IllegalArgumentException(String.format("To is greater than area's length. length=%s, to=%s", this.getLength(), to));
        }
        if (from == to) {
            CaretNode cursor = new CaretNode("", this, from);
            int parIdx = this.offsetToPosition(from, TwoDimensional.Bias.Forward).getMajor();
            ParagraphBox paragrafBox = (ParagraphBox)this.virtualFlow.getCell(parIdx).getNode();
            paragrafBox.caretsProperty().add((Object)cursor);
            Bounds cursorBounds = paragrafBox.getCaretBoundsOnScreen(cursor);
            paragrafBox.caretsProperty().remove((Object)cursor);
            if (cursorBounds != null && !cursorBounds.isEmpty()) {
                BoundingBox emptyCharBounds = new BoundingBox(cursorBounds.getMinX() + 1.0, cursorBounds.getMinY() + 1.0, cursorBounds.getWidth() - 1.0, cursorBounds.getHeight() - 2.0);
                return Optional.of(emptyCharBounds);
            }
            return Optional.empty();
        }
        if (this.getText(from, to).equals("\n")) {
            return Optional.empty();
        }
        int realFrom = this.getText(from, from + 1).equals("\n") ? from + 1 : from;
        TwoDimensional.Position startPosition = this.offsetToPosition(realFrom, TwoDimensional.Bias.Forward);
        int startRow = startPosition.getMajor();
        if (startRow == (endRow = (endPosition = startPosition.offsetBy(to - realFrom, TwoDimensional.Bias.Forward)).getMajor())) {
            return this.getRangeBoundsOnScreen(startRow, startPosition.getMinor(), endPosition.getMinor());
        }
        Optional<Bounds> rangeBounds = this.getRangeBoundsOnScreen(startRow, startPosition.getMinor(), this.getParagraph(startRow).length());
        for (int i = startRow + 1; i <= endRow; ++i) {
            Optional<Bounds> nextLineBounds = this.getRangeBoundsOnScreen(i, 0, i == endRow ? endPosition.getMinor() : this.getParagraph(i).length());
            if (!nextLineBounds.isPresent()) continue;
            if (rangeBounds.isPresent()) {
                Bounds lineBounds = nextLineBounds.get();
                rangeBounds = rangeBounds.map(b -> {
                    double minX = Math.min(b.getMinX(), lineBounds.getMinX());
                    double minY = Math.min(b.getMinY(), lineBounds.getMinY());
                    double maxX = Math.max(b.getMaxX(), lineBounds.getMaxX());
                    double maxY = Math.max(b.getMaxY(), lineBounds.getMaxY());
                    return new BoundingBox(minX, minY, maxX - minX, maxY - minY);
                });
                continue;
            }
            rangeBounds = nextLineBounds;
        }
        return rangeBounds;
    }

    @Override
    public final String getText(int start, int end) {
        return this.content.getText(start, end);
    }

    @Override
    public String getText(int paragraph) {
        return this.content.getText(paragraph);
    }

    @Override
    public String getText(IndexRange range) {
        return this.content.getText(range);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int start, int end) {
        return this.content.subSequence(start, end);
    }

    @Override
    public StyledDocument<PS, SEG, S> subDocument(int paragraphIndex) {
        return this.content.subDocument(paragraphIndex);
    }

    @Override
    public IndexRange getParagraphSelection(Selection selection, int paragraph) {
        int startPar = selection.getStartParagraphIndex();
        int endPar = selection.getEndParagraphIndex();
        if (selection.getLength() == 0 || paragraph < startPar || paragraph > endPar) {
            return EMPTY_RANGE;
        }
        int start = paragraph == startPar ? selection.getStartColumnPosition() : 0;
        int end = paragraph == endPar ? selection.getEndColumnPosition() : this.getParagraphLength(paragraph) + 1;
        selection.getRange();
        return new IndexRange(start, end);
    }

    @Override
    public S getStyleOfChar(int index) {
        return this.content.getStyleOfChar(index);
    }

    @Override
    public S getStyleAtPosition(int position) {
        return this.content.getStyleAtPosition(position);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int position) {
        return this.content.getStyleRangeAtPosition(position);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int from, int to) {
        return this.content.getStyleSpans(from, to);
    }

    @Override
    public S getStyleOfChar(int paragraph, int index) {
        return this.content.getStyleOfChar(paragraph, index);
    }

    @Override
    public S getStyleAtPosition(int paragraph, int position) {
        return this.content.getStyleAtPosition(paragraph, position);
    }

    @Override
    public IndexRange getStyleRangeAtPosition(int paragraph, int position) {
        return this.content.getStyleRangeAtPosition(paragraph, position);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph) {
        return this.content.getStyleSpans(paragraph);
    }

    @Override
    public StyleSpans<S> getStyleSpans(int paragraph, int from, int to) {
        return this.content.getStyleSpans(paragraph, from, to);
    }

    @Override
    public int getAbsolutePosition(int paragraphIndex, int columnIndex) {
        return this.content.getAbsolutePosition(paragraphIndex, columnIndex);
    }

    @Override
    public TwoDimensional.Position position(int row, int col) {
        return this.content.position(row, col);
    }

    @Override
    public TwoDimensional.Position offsetToPosition(int charOffset, TwoDimensional.Bias bias) {
        return this.content.offsetToPosition(charOffset, bias);
    }

    @Override
    public Bounds getVisibleParagraphBoundsOnScreen(int visibleParagraphIndex) {
        return this.getParagraphBoundsOnScreen((Cell)this.virtualFlow.visibleCells().get(visibleParagraphIndex));
    }

    @Override
    public Optional<Bounds> getParagraphBoundsOnScreen(int paragraphIndex) {
        return this.virtualFlow.getCellIfVisible(paragraphIndex).map(this::getParagraphBoundsOnScreen);
    }

    @Override
    public final <T extends Node> Optional<Bounds> getCaretBoundsOnScreen(T caret) {
        Optional<Bounds> caretBounds;
        try {
            caretBounds = this.virtualFlow.getCellIfVisible(((Caret)caret).getParagraphIndex()).map(c -> ((ParagraphBox)c.getNode()).getCaretBoundsOnScreen(caret));
        }
        catch (IllegalArgumentException EX) {
            caretBounds = Optional.ofNullable(this.caretSelectionBind.getUnderlyingCaret().getLayoutBounds());
        }
        return caretBounds;
    }

    public void scrollXToPixel(double pixel) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollXToPixel(pixel));
    }

    public void scrollYToPixel(double pixel) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollYToPixel(pixel));
    }

    public void scrollXBy(double deltaX) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollXBy(deltaX));
    }

    public void scrollYBy(double deltaY) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollYBy(deltaY));
    }

    public void scrollBy(Point2D deltas) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollBy(deltas));
    }

    @Override
    public void showParagraphInViewport(int paragraphIndex) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.show(paragraphIndex));
    }

    @Override
    public void showParagraphAtTop(int paragraphIndex) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAsFirst(paragraphIndex));
    }

    @Override
    public void showParagraphAtBottom(int paragraphIndex) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAsLast(paragraphIndex));
    }

    @Override
    public void showParagraphRegion(int paragraphIndex, Bounds region) {
        this.suspendVisibleParsWhile(() -> this.virtualFlow.show(paragraphIndex, region));
    }

    public void showParagraphAtCenter(int paragraphIndex) {
        double offset = Math.floor(this.getHeight() / 2.0);
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAtOffset(paragraphIndex, offset));
    }

    @Override
    public void requestFollowCaret() {
        this.followCaretRequested = true;
        this.requestLayout();
    }

    @Override
    public void lineStart(NavigationActions.SelectionPolicy policy) {
        this.moveTo(this.getCurrentParagraph(), this.getCurrentLineStartInParargraph(), policy);
    }

    @Override
    public void lineEnd(NavigationActions.SelectionPolicy policy) {
        this.moveTo(this.getCurrentParagraph(), this.getCurrentLineEndInParargraph(), policy);
    }

    public int getCurrentLineStartInParargraph() {
        return ((ParagraphBox)this.virtualFlow.getCell(this.getCurrentParagraph()).getNode()).getCurrentLineStartPosition(this.caretSelectionBind.getUnderlyingCaret());
    }

    public int getCurrentLineEndInParargraph() {
        return ((ParagraphBox)this.virtualFlow.getCell(this.getCurrentParagraph()).getNode()).getCurrentLineEndPosition(this.caretSelectionBind.getUnderlyingCaret());
    }

    public void setLineHighlighterFill(Paint highlight) {
        if (this.lineHighlighterFill != null && highlight != null) {
            this.lineHighlighterFill.set((Object)highlight);
        } else {
            boolean lineHighlightOn = this.isLineHighlighterOn();
            if (lineHighlightOn) {
                this.setLineHighlighterOn(false);
            }
            this.lineHighlighterFill = highlight == null ? null : new SimpleObjectProperty((Object)highlight);
            if (lineHighlightOn) {
                this.setLineHighlighterOn(true);
            }
        }
    }

    public boolean isLineHighlighterOn() {
        return this.lineHighlighter != null && this.selectionSet.contains(this.lineHighlighter);
    }

    public void setLineHighlighterOn(boolean show) {
        if (show) {
            if (this.lineHighlighter != null) {
                return;
            }
            this.lineHighlighter = new LineSelection(this, this.lineHighlighterFill);
            Consumer<Bounds> caretListener = b -> {
                if (this.lineHighlighter != null && (b.getMinY() != this.caretPrevY || this.getCaretColumn() == 1)) {
                    if (this.getSelection().getLength() != 0) {
                        this.lineHighlighter.deselect();
                    } else {
                        this.lineHighlighter.selectCurrentLine();
                    }
                    this.caretPrevY = b.getMinY();
                }
            };
            this.caretBoundsProperty().addListener((ob, ov, nv) -> nv.ifPresent(caretListener));
            this.getCaretBounds().ifPresent(caretListener);
            this.selectionProperty().addListener((ob, ov, nv) -> {
                if (this.lineHighlighter != null) {
                    if (nv.getLength() == 0) {
                        this.lineHighlighter.selectCurrentLine();
                    } else if (ov.getLength() == 0) {
                        this.lineHighlighter.deselect();
                    }
                }
            });
            this.selectionSet.add(this.lineHighlighter);
        } else if (this.lineHighlighter != null) {
            this.selectionSet.remove(this.lineHighlighter);
            this.lineHighlighter.deselect();
            this.lineHighlighter = null;
            this.caretPrevY = -1.0;
        }
    }

    public void nextLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.scrollLine(1, selectionPolicy);
    }

    public void prevLine(NavigationActions.SelectionPolicy selectionPolicy) {
        this.scrollLine(-1, selectionPolicy);
    }

    private void scrollLine(int direction, NavigationActions.SelectionPolicy selectionPolicy) {
        this.getCaretBoundsOnScreen(this.getCaretSelectionBind().getUnderlyingCaret()).map(caretBounds -> (caretBounds.getHeight() - 2.0) * (double)direction).ifPresent(deltaY -> this.scrollText((double)deltaY, selectionPolicy));
    }

    @Override
    public void prevPage(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.firstVisibleParToAllParIndex() == 0) {
            this.caretSelectionBind.moveTo(0, selectionPolicy);
        } else {
            this.page(-1, selectionPolicy);
        }
    }

    @Override
    public void nextPage(NavigationActions.SelectionPolicy selectionPolicy) {
        if (this.lastVisibleParToAllParIndex() == this.getParagraphs().size() - 1) {
            this.caretSelectionBind.moveTo(this.getLength(), selectionPolicy);
        } else {
            this.page(1, selectionPolicy);
        }
    }

    private void page(int pgCount, NavigationActions.SelectionPolicy selectionPolicy) {
        this.scrollText((double)pgCount * this.getViewportHeight(), selectionPolicy);
    }

    private void scrollText(double deltaY, NavigationActions.SelectionPolicy selectionPolicy) {
        Optional<Bounds> cb = this.caretSelectionBind.getUnderlyingCaret().getCaretBounds();
        this.paging = true;
        this.suspendVisibleParsWhile(() -> this.virtualFlow.scrollYBy(deltaY));
        cb.map(arg_0 -> ((GenericStyledArea)this).screenToLocal(arg_0)).map(b -> this.hit(b.getMinX(), b.getMinY() + b.getHeight() / 2.0).getInsertionIndex()).ifPresent(i -> this.caretSelectionBind.moveTo((int)i, selectionPolicy));
        cb.ifPresent(prev -> this.getCaretBounds().map(newB -> newB.getMinY() - prev.getMinY()).filter(delta -> delta != 0.0).ifPresent(delta -> this.scrollYBy((double)delta)));
    }

    @Override
    public void displaceCaret(int pos) {
        this.caretSelectionBind.displaceCaret(pos);
    }

    @Override
    public void setStyle(int from, int to, S style) {
        this.content.setStyle(from, to, style);
    }

    @Override
    public void setStyle(int paragraph, S style) {
        this.content.setStyle(paragraph, style);
    }

    @Override
    public void setStyle(int paragraph, int from, int to, S style) {
        this.content.setStyle(paragraph, from, to, style);
    }

    @Override
    public void setStyleSpans(int from, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(from, styleSpans);
    }

    @Override
    public void setStyleSpans(int paragraph, int from, StyleSpans<? extends S> styleSpans) {
        this.content.setStyleSpans(paragraph, from, styleSpans);
    }

    @Override
    public void setParagraphStyle(int paragraph, PS paragraphStyle) {
        this.content.setParagraphStyle(paragraph, paragraphStyle);
    }

    public final void setTextInsertionStyle(S txtStyle) {
        this.insertionTextStyle = txtStyle;
    }

    public final S getTextInsertionStyle() {
        return this.insertionTextStyle;
    }

    @Override
    public final S getTextStyleForInsertionAt(int pos) {
        if (this.insertionTextStyle != null) {
            return this.insertionTextStyle;
        }
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialTextStyle;
        }
        return this.content.getStyleAtPosition(pos);
    }

    public final void setParagraphInsertionStyle(PS paraStyle) {
        this.insertionParagraphStyle = paraStyle;
    }

    public final PS getParagraphInsertionStyle() {
        return this.insertionParagraphStyle;
    }

    @Override
    public final PS getParagraphStyleForInsertionAt(int pos) {
        if (this.insertionParagraphStyle != null) {
            return this.insertionParagraphStyle;
        }
        if (this.useInitialStyleForInsertion.get()) {
            return this.initialParagraphStyle;
        }
        return this.content.getParagraphStyleAtPosition(pos);
    }

    @Override
    public void replaceText(int start, int end, String text) {
        ReadOnlyStyledDocument<PS, SEG, S> doc = ReadOnlyStyledDocument.fromString(text, this.getParagraphStyleForInsertionAt(start), this.getTextStyleForInsertionAt(start), this.segmentOps);
        this.replace(start, end, doc);
    }

    @Override
    public void replace(int start, int end, SEG seg, S style) {
        if (style == null) {
            style = this.getTextStyleForInsertionAt(start);
        }
        ReadOnlyStyledDocument<PS, SEG, S> doc = ReadOnlyStyledDocument.fromSegment(seg, this.getParagraphStyleForInsertionAt(start), style, this.segmentOps);
        this.replace(start, end, doc);
    }

    @Override
    public void replace(int start, int end, StyledDocument<PS, SEG, S> replacement) {
        this.content.replace(start, end, replacement);
        int newCaretPos = start + replacement.length();
        this.selectRange(newCaretPos, newCaretPos);
    }

    void replaceMulti(List<Replacement<PS, SEG, S>> replacements) {
        this.content.replaceMulti(replacements);
    }

    @Override
    public MultiChangeBuilder<PS, SEG, S> createMultiChange() {
        return new MultiChangeBuilder(this);
    }

    @Override
    public MultiChangeBuilder<PS, SEG, S> createMultiChange(int initialNumOfChanges) {
        return new MultiChangeBuilder(this, initialNumOfChanges);
    }

    protected void foldSelectedParagraphs(UnaryOperator<PS> styleMixin) {
        IndexRange range = this.getSelection();
        this.fold(range.getStart(), range.getEnd(), styleMixin);
    }

    protected void foldParagraphs(int start, int end, UnaryOperator<PS> styleMixin) {
        start = this.getAbsolutePosition(start, 0);
        end = this.getAbsolutePosition(end, this.getParagraphLength(end));
        this.fold(start, end, styleMixin);
    }

    protected void fold(int startPos, int endPos, UnaryOperator<PS> styleMixin) {
        ReadOnlyStyledDocument subDoc = (ReadOnlyStyledDocument)this.subDocument(startPos, endPos);
        UnaryOperator mapper = p -> p.setParagraphStyle(styleMixin.apply(p.getParagraphStyle()));
        for (int p2 = 1; p2 < subDoc.getParagraphCount(); ++p2) {
            subDoc = (ReadOnlyStyledDocument)subDoc.replaceParagraph(p2, mapper).get1();
        }
        this.replace(startPos, endPos, subDoc);
        this.recreateParagraphGraphic(this.offsetToPosition(startPos, TwoDimensional.Bias.Backward).getMajor());
        this.moveTo(startPos);
        this.foldCheck = true;
    }

    private void skipOverFoldedParagraphs(ObservableValue<? extends Integer> ob, Integer prevParagraph, Integer newParagraph) {
        if (this.foldCheck && this.getCell(newParagraph).isFolded()) {
            int p;
            if (newParagraph == this.getParagraphs().size() - 1) {
                return;
            }
            int skip = newParagraph - prevParagraph > 0 ? 1 : -1;
            for (p = newParagraph + skip; p > 0 && p < this.getParagraphs().size() && this.getCell(p).isFolded(); p += skip) {
            }
            if (p < 0 || p == this.getParagraphs().size()) {
                p = prevParagraph;
            }
            int col = Math.min(this.getCaretColumn(), this.getParagraphLength(p));
            if (this.getSelection().getLength() == 0) {
                this.moveTo(p, col);
            } else {
                this.moveTo(p, col, NavigationActions.SelectionPolicy.EXTEND);
            }
        }
    }

    protected void unfoldParagraphs(int startingFrom, Predicate<PS> isFolded, UnaryOperator<PS> styleMixin) {
        LiveList<Paragraph<PS, SEG, S>> pList = this.getParagraphs();
        int to = startingFrom;
        while (++to < pList.size() && isFolded.test(((Paragraph)pList.get(to)).getParagraphStyle())) {
        }
        if (--to > startingFrom) {
            int startPos = this.getAbsolutePosition(startingFrom, 0);
            int endPos = this.getAbsolutePosition(to, this.getParagraphLength(to));
            ReadOnlyStyledDocument subDoc = (ReadOnlyStyledDocument)this.subDocument(startPos, endPos);
            UnaryOperator mapper = p -> p.setParagraphStyle(styleMixin.apply(p.getParagraphStyle()));
            for (int p2 = 1; p2 < subDoc.getParagraphCount(); ++p2) {
                subDoc = (ReadOnlyStyledDocument)subDoc.replaceParagraph(p2, mapper).get1();
            }
            this.replace(startPos, endPos, subDoc);
            this.moveTo(startingFrom, this.getParagraphLength(startingFrom));
            this.recreateParagraphGraphic(startingFrom);
        }
    }

    @Override
    public void dispose() {
        if (this.undoManager != null) {
            this.undoManager.close();
        }
        this.subscriptions.unsubscribe();
        this.virtualFlow.dispose();
    }

    public BooleanProperty autoHeightProperty() {
        return this.autoHeightProp;
    }

    public void setAutoHeight(boolean value) {
        this.autoHeightProp.set(value);
    }

    public boolean isAutoHeight() {
        return this.autoHeightProp.get();
    }

    protected double computePrefHeight(double width) {
        if (this.autoHeightProp.get()) {
            double height = 0.0;
            Insets in = this.getInsets();
            double calcWidth = this.getWidth();
            if (calcWidth <= 0.0) {
                calcWidth = this.getPrefWidth();
            }
            for (int p = 0; p < this.getParagraphs().size(); ++p) {
                height += this.getCell(p).computePrefHeight(calcWidth);
            }
            if (height > 0.0) {
                return height + in.getTop() + in.getBottom();
            }
        }
        return super.computePrefHeight(width);
    }

    protected void layoutChildren() {
        Insets ins = this.getInsets();
        this.visibleParagraphs.suspendWhile(() -> {
            this.virtualFlow.resizeRelocate(ins.getLeft(), ins.getTop(), this.getWidth() - ins.getLeft() - ins.getRight(), this.getHeight() - ins.getTop() - ins.getBottom());
            if (this.followCaretRequested && !this.paging) {
                try (Guard g = this.viewportDirty.suspend();){
                    this.followCaret();
                }
            }
            this.followCaretRequested = false;
            this.paging = false;
        });
        Node holder = this.placeholder;
        if (holder != null && holder.isManaged()) {
            if (holder.isResizable()) {
                holder.autosize();
            }
            if (this.positionPlaceholder) {
                Region.positionInArea((Node)holder, (double)0.0, (double)0.0, (double)this.getWidth(), (double)this.getHeight(), (double)this.getBaselineOffset(), (Insets)ins, (HPos)this.placeHolderPos.getHpos(), (VPos)this.placeHolderPos.getVpos(), (boolean)this.isSnapToPixel());
            }
        }
    }

    TwoDimensional.Position currentLine() {
        int parIdx = this.getCurrentParagraph();
        Cell cell = this.virtualFlow.getCell(parIdx);
        int lineIdx = ((ParagraphBox)cell.getNode()).getCurrentLineIndex(this.caretSelectionBind.getUnderlyingCaret());
        return this.paragraphLineNavigator.position(parIdx, lineIdx);
    }

    void showCaretAtBottom() {
        int parIdx = this.getCurrentParagraph();
        Cell cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = ((ParagraphBox)cell.getNode()).getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        double y = caretBounds.getMaxY();
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAtOffset(parIdx, this.getViewportHeight() - y));
    }

    void showCaretAtTop() {
        int parIdx = this.getCurrentParagraph();
        Cell cell = this.virtualFlow.getCell(parIdx);
        Bounds caretBounds = ((ParagraphBox)cell.getNode()).getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        double y = caretBounds.getMinY();
        this.suspendVisibleParsWhile(() -> this.virtualFlow.showAtOffset(parIdx, -y));
    }

    final ParagraphBox.CaretOffsetX getCaretOffsetX(CaretNode caret) {
        return this.getCell(caret.getParagraphIndex()).getCaretOffsetX(caret);
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, TwoDimensional.Position targetLine) {
        int parIdx = targetLine.getMajor();
        ParagraphBox cell = (ParagraphBox)this.virtualFlow.getCell(parIdx).getNode();
        CharacterHit parHit = cell.hitTextLine(x, targetLine.getMinor());
        return parHit.offset(this.getParagraphOffset(parIdx));
    }

    CharacterHit hit(ParagraphBox.CaretOffsetX x, double y) {
        VirtualFlowHit hit = this.virtualFlow.hit(0.0, y);
        if (hit.isBeforeCells()) {
            return CharacterHit.insertionAt(0);
        }
        if (hit.isAfterCells()) {
            return CharacterHit.insertionAt(this.getLength());
        }
        int parIdx = hit.getCellIndex();
        int parOffset = this.getParagraphOffset(parIdx);
        ParagraphBox cell = (ParagraphBox)hit.getCell().getNode();
        Point2D cellOffset = hit.getCellOffset();
        CharacterHit parHit = cell.hitText(x, cellOffset.getY());
        return parHit.offset(parOffset);
    }

    final Optional<Bounds> getSelectionBoundsOnScreen(Selection<PS, SEG, S> selection) {
        if (selection.getLength() == 0) {
            return Optional.empty();
        }
        ArrayList bounds = new ArrayList(selection.getParagraphSpan());
        for (int i = selection.getStartParagraphIndex(); i <= selection.getEndParagraphIndex(); ++i) {
            this.virtualFlow.getCellIfVisible(i).ifPresent(c -> ((ParagraphBox)c.getNode()).getSelectionBoundsOnScreen(selection).ifPresent(bounds::add));
        }
        if (bounds.size() == 0) {
            return Optional.empty();
        }
        double minX = bounds.stream().mapToDouble(Bounds::getMinX).min().getAsDouble();
        double maxX = bounds.stream().mapToDouble(Bounds::getMaxX).max().getAsDouble();
        double minY = bounds.stream().mapToDouble(Bounds::getMinY).min().getAsDouble();
        double maxY = bounds.stream().mapToDouble(Bounds::getMaxY).max().getAsDouble();
        return Optional.of(new BoundingBox(minX, minY, maxX - minX, maxY - minY));
    }

    void clearTargetCaretOffset() {
        this.caretSelectionBind.clearTargetOffset();
    }

    ParagraphBox.CaretOffsetX getTargetCaretOffset() {
        return this.caretSelectionBind.getTargetOffset();
    }

    private Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> createCell(Paragraph<PS, SEG, S> paragraph, BiConsumer<TextFlow, PS> applyParagraphStyle, Function<StyledSegment<SEG, S>, Node> nodeFactory) {
        final ParagraphBox box = new ParagraphBox(paragraph, applyParagraphStyle, nodeFactory);
        box.highlightTextFillProperty().bind(this.highlightTextFill);
        box.wrapTextProperty().bind((ObservableValue)this.wrapTextProperty());
        box.graphicFactoryProperty().bind(this.paragraphGraphicFactoryProperty());
        box.graphicOffset.bind((ObservableValue)this.virtualFlow.breadthOffsetProperty());
        EventStream boxIndexValues = box.indexProperty().values().filter(i -> i != -1);
        final Subscription firstParPseudoClass = boxIndexValues.subscribe(idx -> box.pseudoClassStateChanged(FIRST_PAR, idx == 0));
        final Subscription lastParPseudoClass = EventStreams.combine((EventStream)boxIndexValues, (EventStream)this.getParagraphs().sizeProperty().values()).subscribe(in -> in.exec((i, n) -> box.pseudoClassStateChanged(LAST_PAR, i == n - 1)));
        Function<CaretNode, Subscription> subscribeToCaret = caret -> {
            EventStream caretIndexStream = EventStreams.nonNullValuesOf(caret.paragraphIndexProperty());
            EventStream freshBoxIndexValues = box.indexProperty().values().filter(i -> i != -1);
            return EventStreams.combine((EventStream)caretIndexStream, (EventStream)freshBoxIndexValues).subscribe(t -> {
                int boxIndex;
                int caretParagraphIndex = (Integer)t.get1();
                if (caretParagraphIndex == (boxIndex = ((Integer)t.get2()).intValue())) {
                    box.caretsProperty().add(caret);
                } else {
                    box.caretsProperty().remove(caret);
                }
            });
        };
        final Subscription caretSubscription = this.caretSet.addSubscriber(subscribeToCaret);
        final Subscription hasCaretPseudoClass = EventStreams.combine((EventStream)boxIndexValues, (EventStream)Val.wrap((ObservableValue)this.currentParagraphProperty()).values()).map(t -> ((Integer)t.get1()).equals(t.get2())).subscribe(value -> box.pseudoClassStateChanged(HAS_CARET, (boolean)value));
        Function<Selection, Subscription> subscribeToSelection = selection -> {
            EventStream startParagraphValues = EventStreams.nonNullValuesOf(selection.startParagraphIndexProperty());
            EventStream endParagraphValues = EventStreams.nonNullValuesOf(selection.endParagraphIndexProperty());
            EventStream freshBoxIndexValues = box.indexProperty().values().filter(i -> i != -1);
            return EventStreams.combine((EventStream)startParagraphValues, (EventStream)endParagraphValues, (EventStream)freshBoxIndexValues).subscribe(t -> {
                int startPar = (Integer)t.get1();
                int endPar = (Integer)t.get2();
                int boxIndex = (Integer)t.get3();
                if (startPar <= boxIndex && boxIndex <= endPar) {
                    SelectionPath p = (SelectionPath)((Object)((Object)((Object)box.selectionsProperty().get(selection))));
                    if (p == null) {
                        Val range = Val.create(() -> box.getIndex() != -1 ? this.getParagraphSelection((Selection)selection, box.getIndex()) : EMPTY_RANGE, (Observable[])new Observable[]{selection.rangeProperty()});
                        SelectionPath path = new SelectionPath((Val<IndexRange>)range);
                        path.getStyleClass().add((Object)selection.getSelectionName());
                        selection.configureSelectionPath(path);
                        box.selectionsProperty().put(selection, (Object)path);
                    }
                } else {
                    box.selectionsProperty().remove(selection);
                }
            });
        };
        final Subscription selectionSubscription = this.selectionSet.addSubscriber(subscribeToSelection);
        return new Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>>(){

            public ParagraphBox<PS, SEG, S> getNode() {
                return box;
            }

            public void updateIndex(int index) {
                box.setIndex(index);
            }

            public void dispose() {
                box.highlightTextFillProperty().unbind();
                box.wrapTextProperty().unbind();
                box.graphicFactoryProperty().unbind();
                box.graphicOffset.unbind();
                box.dispose();
                firstParPseudoClass.unsubscribe();
                lastParPseudoClass.unsubscribe();
                caretSubscription.unsubscribe();
                hasCaretPseudoClass.unsubscribe();
                selectionSubscription.unsubscribe();
            }
        };
    }

    private void followCaret() {
        Bounds caretBounds;
        int parIdx = this.getCurrentParagraph();
        ParagraphBox paragrafBox = (ParagraphBox)this.virtualFlow.getCell(parIdx).getNode();
        try {
            caretBounds = paragrafBox.getCaretBounds(this.caretSelectionBind.getUnderlyingCaret());
        }
        catch (IllegalArgumentException EX) {
            caretBounds = this.caretSelectionBind.getUnderlyingCaret().getLayoutBounds();
        }
        double graphicWidth = paragrafBox.getGraphicPrefWidth();
        Bounds region = GenericStyledArea.extendLeft(caretBounds, graphicWidth);
        double scrollX = this.virtualFlow.getEstimatedScrollX();
        if (!this.isWrapText() && scrollX > 0.0 && this.getParagraphSelection(parIdx).getLength() > 0) {
            CaretNode selectionStart = new CaretNode("", this, this.getSelection().getStart());
            paragrafBox.caretsProperty().add((Object)selectionStart);
            Bounds startBounds = paragrafBox.getCaretBounds(selectionStart);
            paragrafBox.caretsProperty().remove((Object)selectionStart);
            if (startBounds.getMinX() - graphicWidth < scrollX) {
                region = GenericStyledArea.extendLeft(startBounds, graphicWidth);
            }
        }
        if (parIdx == this.getParagraphs().size() - 1 && paragrafBox.getLineCount() == 1) {
            region = new BoundingBox(region.getMinX(), region.getMinY(), region.getWidth(), paragrafBox.getLayoutBounds().getHeight());
        }
        this.virtualFlow.show(parIdx, region);
    }

    private ParagraphBox<PS, SEG, S> getCell(int index) {
        return (ParagraphBox)this.virtualFlow.getCell(index).getNode();
    }

    private EventStream<MouseOverTextEvent> mouseOverTextEvents(ObservableSet<ParagraphBox<PS, SEG, S>> cells, Duration delay) {
        return EventStreams.merge(cells, c -> c.stationaryIndices(delay).map(e -> (MouseOverTextEvent)((Object)((Object)((Object)e.unify(l -> (MouseOverTextEvent)((Object)((Object)((Object)((Object)l.map((pos, charIdx) -> MouseOverTextEvent.beginAt(c.localToScreen((Point2D)pos), this.getParagraphOffset(c.getIndex()) + charIdx)))))), r -> MouseOverTextEvent.end()))))));
    }

    private int getParagraphOffset(int parIdx) {
        return this.position(parIdx, 0).toOffset();
    }

    private Bounds getParagraphBoundsOnScreen(Cell<Paragraph<PS, SEG, S>, ParagraphBox<PS, SEG, S>> cell) {
        Bounds nodeLocal = ((ParagraphBox)cell.getNode()).getBoundsInLocal();
        Bounds nodeScreen = ((ParagraphBox)cell.getNode()).localToScreen(nodeLocal);
        Bounds areaLocal = this.getBoundsInLocal();
        Bounds areaScreen = this.localToScreen(areaLocal);
        double minX = nodeScreen.getMinX() < areaScreen.getMinX() ? areaScreen.getMinX() : nodeScreen.getMinX();
        double minY = nodeScreen.getMinY() < areaScreen.getMinY() ? areaScreen.getMinY() : nodeScreen.getMinY();
        double width = areaScreen.getWidth();
        double maxY = nodeScreen.getMaxY() < areaScreen.getMaxY() ? nodeScreen.getMaxY() : areaScreen.getMaxY();
        return new BoundingBox(minX, minY, width, maxY - minY);
    }

    private Optional<Bounds> getRangeBoundsOnScreen(int paragraphIndex, int from, int to) {
        return this.virtualFlow.getCellIfVisible(paragraphIndex).map(c -> ((ParagraphBox)c.getNode()).getRangeBoundsOnScreen(from, to));
    }

    private void manageSubscription(Subscription subscription) {
        this.subscriptions = this.subscriptions.and(subscription);
    }

    private static Bounds extendLeft(Bounds b, double w) {
        if (w == 0.0) {
            return b;
        }
        return new BoundingBox(b.getMinX() - w, b.getMinY(), b.getWidth() + w, b.getHeight());
    }

    private void suspendVisibleParsWhile(Runnable runnable) {
        Suspendable.combine((Suspendable[])new Suspendable[]{this.beingUpdated, this.visibleParagraphs}).suspendWhile(runnable);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return CSS_META_DATA_LIST;
    }

    static {
        ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
        styleables.add(HIGHLIGHT_TEXT_FILL);
        CSS_META_DATA_LIST = Collections.unmodifiableList(styleables);
    }
}

