/*
 * Decompiled with CFR 0.152.
 */
package qupath.ui.logviewer.ui.richtextfx;

import java.util.Objects;
import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Region;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.StyleClassedTextArea;
import org.slf4j.event.Level;
import qupath.ui.logviewer.api.LogMessage;
import qupath.ui.logviewer.api.listener.LoggerListener;
import qupath.ui.logviewer.api.manager.LoggerManager;

public class RichTextFxLogViewer
extends BorderPane
implements LoggerListener {
    private static final StyleClassedTextArea textArea = new StyleClassedTextArea();
    private static final VirtualizedScrollPane<StyleClassedTextArea> scrollPane = new VirtualizedScrollPane((Region)textArea);
    private final LoggerManager loggerManager;

    public RichTextFxLogViewer() {
        this(null);
    }

    public RichTextFxLogViewer(LoggerManager loggerManager) {
        super(scrollPane);
        this.getStylesheets().add((Object)Objects.requireNonNull(RichTextFxLogViewer.class.getResource("css/styles.css")).toExternalForm());
        textArea.setEditable(false);
        this.loggerManager = loggerManager == null ? (LoggerManager)LoggerManager.getCurrentLoggerManager().orElse(null) : loggerManager;
        if (this.loggerManager == null) {
            textArea.append("No logging manager found", this.levelToCssClass(Level.ERROR));
        } else {
            this.startLogging();
        }
    }

    public void addLogMessage(LogMessage logMessage) {
        if (Platform.isFxApplicationThread()) {
            textArea.append(logMessage.toReadableString() + "\n", this.levelToCssClass(logMessage.level()));
            textArea.requestFollowCaret();
        } else {
            Platform.runLater(() -> this.addLogMessage(logMessage));
        }
    }

    public void startLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.addListener((LoggerListener)this);
    }

    public void stopLogging() {
        if (this.loggerManager == null) {
            throw new IllegalStateException("No logger manager found");
        }
        this.loggerManager.removeListener((LoggerListener)this);
    }

    public Optional<LoggerManager> getLoggerManager() {
        return Optional.ofNullable(this.loggerManager);
    }

    private String levelToCssClass(Level level) {
        return level.name().toLowerCase();
    }
}

