/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.extension.svg;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import org.jfree.svg.ImageElement;
import org.jfree.svg.SVGGraphics2D;
import org.jfree.svg.SVGHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.awt.common.AwtTools;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.gui.images.stores.ImageRegionStoreFactory;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.PathObjectPainter;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.overlays.GridOverlay;
import qupath.lib.gui.viewer.overlays.HierarchyOverlay;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.TMAGridOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectSelectionModel;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;

public class SvgTools {
    public static void writeViewerSnapshot(QuPathViewer viewer, File fileSVG) throws IOException {
        new SvgBuilder(viewer).writeSVG(fileSVG);
    }

    public static class SvgBuilder {
        private static final Logger logger = LoggerFactory.getLogger(SvgBuilder.class);
        private QuPathViewer viewer;
        private ImageData<BufferedImage> imageData;
        private PathObjectHierarchy hierarchy;
        private Collection<? extends PathObject> pathObjects;
        private boolean showSelection = true;
        private boolean includeOverlays = true;
        private int width = -1;
        private int height = -1;
        private ImageRegion region;
        private double downsample = -1.0;
        private ImageIncludeType imageInclude = ImageIncludeType.NONE;
        private OverlayOptions options = new OverlayOptions();

        public SvgBuilder(QuPathViewer viewer) {
            this.viewer = viewer;
            this.imageData = viewer.getImageData();
            this.hierarchy = viewer.getHierarchy();
            this.options = new OverlayOptions(viewer.getOverlayOptions());
            this.downsample = viewer.getDownsampleFactor();
            this.region = AwtTools.getImageRegion((Shape)viewer.getDisplayedRegionShape(), (int)viewer.getZPosition(), (int)viewer.getTPosition());
            this.imageInclude = ImageIncludeType.EMBED;
        }

        public SvgBuilder() {
        }

        public SvgBuilder imageData(ImageData<BufferedImage> imageData) {
            this.imageData = imageData;
            return this;
        }

        public SvgBuilder hierarchy(PathObjectHierarchy hierarchy) {
            this.hierarchy = hierarchy;
            return this;
        }

        public SvgBuilder pathObjects(Collection<? extends PathObject> pathObjects) {
            this.pathObjects = new ArrayList<PathObject>(pathObjects);
            return this;
        }

        public SvgBuilder pathObjects(PathObject ... pathObjects) {
            return this.pathObjects(Arrays.asList(pathObjects));
        }

        public SvgBuilder includeOverlays(boolean doInclude) {
            this.includeOverlays = doInclude;
            return this;
        }

        public SvgBuilder options(OverlayOptions options) {
            this.options = new OverlayOptions(options);
            return this;
        }

        public SvgBuilder fillAnnotations(boolean doFill) {
            this.options.setFillAnnotations(doFill);
            return this;
        }

        public SvgBuilder fillDetections(boolean doFill) {
            this.options.setFillDetections(doFill);
            return this;
        }

        public SvgBuilder showSelection(boolean doShow) {
            this.showSelection = doShow;
            return this;
        }

        public SvgBuilder region(ImageRegion region) {
            this.region = region;
            if (region instanceof RegionRequest && this.downsample <= 0.0) {
                this.downsample = ((RegionRequest)region).getDownsample();
            }
            return this;
        }

        public SvgBuilder downsample(double downsample) {
            this.downsample = downsample;
            return this;
        }

        public SvgBuilder width(int width) {
            this.width = width;
            return this;
        }

        public SvgBuilder height(int height) {
            this.height = height;
            return this;
        }

        public SvgBuilder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public SvgBuilder embedImages() {
            this.imageInclude = ImageIncludeType.EMBED;
            return this;
        }

        public SvgBuilder linkImages() {
            this.imageInclude = ImageIncludeType.LINK;
            return this;
        }

        public SvgBuilder images(ImageIncludeType include) {
            if (include == null) {
                include = ImageIncludeType.NONE;
            }
            this.imageInclude = include;
            return this;
        }

        public void writeSVG(File file) throws IOException {
            boolean embedImages = this.imageInclude == ImageIncludeType.EMBED;
            String ext = GeneralTools.getExtension((File)file).orElse(null);
            boolean doCompress = false;
            if (ext == null) {
                String pathBefore = file.getAbsolutePath();
                file = pathBefore.endsWith(".") ? new File(pathBefore + "svg") : new File(pathBefore + ".svg");
                logger.debug("No extension found in {}, updating to {}", (Object)pathBefore, (Object)file.getAbsolutePath());
            } else {
                doCompress = (ext = ext.toLowerCase()).endsWith("svgz");
                if (!doCompress && !ext.endsWith("svg")) {
                    logger.warn("Expected file extension '.svg' or 'svgz', but found '{}'", (Object)ext);
                }
            }
            String imageName = GeneralTools.getNameWithoutExtension((File)file) + "-image.png";
            SVGGraphics2D g2d = this.buildGraphics(imageName);
            String doc = g2d.getSVGDocument();
            if (doCompress) {
                try (OutputStreamWriter stream = new OutputStreamWriter((OutputStream)new GZIPOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0])), StandardCharsets.UTF_8);){
                    stream.write(doc);
                }
            } else {
                Files.writeString(file.toPath(), (CharSequence)doc, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            if (!embedImages) {
                for (ImageElement element : g2d.getSVGImages()) {
                    Image img = element.getImage();
                    String name = element.getHref();
                    ImageIO.write((RenderedImage)((Object)img), "PNG", new File(file.getParent(), name));
                }
            }
        }

        private SVGGraphics2D buildGraphics(String imageName) {
            PathObjectHierarchy hierarchy;
            if (this.region == null) {
                if (this.imageData != null) {
                    logger.warn("No export region defined - will try to use the entire image");
                    this.region = RegionRequest.createInstance((ImageServer)this.imageData.getServer());
                } else if (this.width > 0 && this.height > 0) {
                    logger.warn("No export region defined - will try to use everything");
                    this.region = ImageRegion.createInstance((int)0, (int)0, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)0, (int)0);
                } else {
                    throw new IllegalArgumentException("No export region nor image dimensions defined!");
                }
            }
            if ((hierarchy = this.hierarchy) == null) {
                if (this.imageData != null) {
                    hierarchy = this.imageData.getHierarchy();
                } else if (this.viewer != null) {
                    hierarchy = this.viewer.getHierarchy();
                }
            }
            double overlayOpacity = this.options.getOpacity();
            List overlayLayers = this.viewer != null && this.includeOverlays ? this.viewer.getOverlayLayers() : Collections.emptyList();
            double downsample = this.downsample;
            if (downsample <= 0.0) {
                downsample = 1.0;
            }
            int width = this.width;
            int height = this.height;
            if (width <= 0) {
                width = (int)((double)this.region.getWidth() / downsample);
            }
            if (height <= 0) {
                height = (int)((double)this.region.getHeight() / downsample);
            }
            SVGGraphics2D g2d = new SVGGraphics2D((double)width, (double)height);
            g2d.scale(1.0 / downsample, 1.0 / downsample);
            g2d.translate(-this.region.getX(), -this.region.getY());
            PathObjectSelectionModel selectionModel = null;
            if (this.showSelection && hierarchy != null) {
                selectionModel = hierarchy.getSelectionModel();
            }
            if (this.pathObjects == null) {
                this.pathObjects = hierarchy == null ? Collections.emptyList() : hierarchy.getAllObjectsForRegion(this.region, null);
            }
            Rectangle boundsDisplayed = AwtTools.getBounds((ImageRegion)this.region);
            g2d.setClip((Shape)boundsDisplayed);
            AffineTransform transform = g2d.getTransform();
            boolean includeImages = this.imageInclude == ImageIncludeType.EMBED || this.imageInclude == ImageIncludeType.LINK;
            AffineTransform transformInverse = null;
            if (includeImages) {
                try {
                    transformInverse = transform.createInverse();
                }
                catch (NoninvertibleTransformException e) {
                    logger.warn("Can't include images - unable to invert image transform: {}", (Object)e.getMessage(), (Object)e);
                }
            }
            boolean objectsDrawn = false;
            if (transformInverse != null && includeImages) {
                if (this.imageData != null) {
                    ImageDisplay display;
                    DefaultImageRegionStore store;
                    block36: {
                        store = null;
                        display = null;
                        try {
                            if (this.viewer == null) {
                                store = ImageRegionStoreFactory.createImageRegionStore((long)0x1000000L);
                                display = ImageDisplay.create(this.imageData);
                            } else {
                                store = this.viewer.getImageRegionStore();
                                display = this.viewer.getImageData() == this.imageData ? this.viewer.getImageDisplay() : ImageDisplay.create(this.imageData);
                            }
                        }
                        catch (IOException e) {
                            logger.warn("Unable to create image display, may not be able to include images", (Throwable)e);
                            if (store != null) break block36;
                            store = ImageRegionStoreFactory.createImageRegionStore((long)0x1000000L);
                        }
                    }
                    if (this.imageInclude == ImageIncludeType.LINK) {
                        g2d.setRenderingHint((RenderingHints.Key)SVGHints.KEY_IMAGE_HANDLING, SVGHints.VALUE_IMAGE_HANDLING_REFERENCE);
                        if (imageName == null) {
                            imageName = "image.png";
                        }
                        g2d.setRenderingHint((RenderingHints.Key)SVGHints.KEY_IMAGE_HREF, (Object)imageName);
                    } else {
                        g2d.setRenderingHint((RenderingHints.Key)SVGHints.KEY_IMAGE_HANDLING, SVGHints.VALUE_IMAGE_HANDLING_EMBED);
                    }
                    BufferedImage imgTemp = new BufferedImage(width, height, 2);
                    Graphics2D g = imgTemp.createGraphics();
                    g.setTransform(transform);
                    store.paintRegionCompletely(this.imageData.getServer(), (Graphics)g, (Shape)boundsDisplayed, this.region.getZ(), this.region.getT(), downsample, null, (ImageRenderer)display, 10000L);
                    g.dispose();
                    g2d.drawImage((Image)imgTemp, transformInverse, null);
                } else {
                    logger.warn("Unable to include image - I'd also need an imageData to be able to do that");
                }
                if (!overlayLayers.isEmpty() && overlayOpacity > 0.0) {
                    AlphaComposite composite = null;
                    if (overlayOpacity < 1.0) {
                        composite = AlphaComposite.getInstance(3, (float)overlayOpacity);
                    }
                    int overlayCount = 0;
                    for (PathOverlay overlay : overlayLayers) {
                        int[] rgb = null;
                        if (overlay instanceof HierarchyOverlay && !objectsDrawn) {
                            if (composite != null) {
                                g2d.setComposite((Composite)composite);
                            }
                            PathObjectPainter.paintSpecifiedObjects((Graphics2D)g2d, this.pathObjects, (OverlayOptions)this.options, (PathObjectSelectionModel)selectionModel, (double)downsample);
                            objectsDrawn = true;
                            continue;
                        }
                        if (overlay instanceof GridOverlay || overlay instanceof TMAGridOverlay) {
                            if (composite != null) {
                                g2d.setComposite((Composite)composite);
                            }
                            overlay.paintOverlay((Graphics2D)g2d, this.region, downsample, this.imageData, true);
                            continue;
                        }
                        BufferedImage imgTemp = new BufferedImage(width, height, 2);
                        Graphics2D g = imgTemp.createGraphics();
                        int transparent = ColorTools.packARGB((int)0, (int)0, (int)0, (int)0);
                        g.setBackground(new Color(transparent, true));
                        g.clearRect(0, 0, width, height);
                        g.setTransform(transform);
                        if (composite != null) {
                            g.setComposite(composite);
                        }
                        overlay.paintOverlay(g, this.region, downsample, this.imageData, true);
                        g.dispose();
                        boolean containsNonTransparent = Arrays.stream(rgb = imgTemp.getRGB(0, 0, width, height, rgb, 0, width)).anyMatch(i -> i != transparent);
                        if (!containsNonTransparent) continue;
                        String overlayImageName = GeneralTools.stripExtension((String)imageName) + "-overlay-" + ++overlayCount + ".png";
                        g2d.setRenderingHint((RenderingHints.Key)SVGHints.KEY_IMAGE_HREF, (Object)overlayImageName);
                        g2d.drawImage((Image)imgTemp, transformInverse, null);
                    }
                }
            }
            if (!objectsDrawn) {
                PathObjectPainter.paintSpecifiedObjects((Graphics2D)g2d, this.pathObjects, (OverlayOptions)this.options, (PathObjectSelectionModel)selectionModel, (double)downsample);
            }
            return g2d;
        }

        public String createDocument() {
            return this.buildGraphics(null).getSVGDocument();
        }

        public static enum ImageIncludeType {
            NONE,
            EMBED,
            LINK;


            public String toString() {
                switch (this.ordinal()) {
                    case 1: {
                        return "Embed raster";
                    }
                    case 2: {
                        return "Linked raster";
                    }
                    case 0: {
                        return "SVG vectors only";
                    }
                }
                throw new IllegalArgumentException("Unknown type " + String.valueOf((Object)this));
            }
        }
    }
}

