/*
 * Decompiled with CFR 0.152.
 */
package qupath.lib.extension.svg;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.extension.svg.SvgTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.interfaces.ROI;

class SvgExportCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SvgExportCommand.class);
    private static String title = "SVG export";
    private QuPathGUI qupath;
    private SvgExportType type;
    private DoubleProperty downsample = PathPrefs.createPersistentPreference((String)"svg.export.downsample", (double)1.0);
    private ObjectProperty<SvgTools.SvgBuilder.ImageIncludeType> imageType = PathPrefs.createPersistentPreference((String)"svg.export.imageType", (Enum)SvgTools.SvgBuilder.ImageIncludeType.EMBED, SvgTools.SvgBuilder.ImageIncludeType.class);
    private BooleanProperty highlightSelected = PathPrefs.createPersistentPreference((String)"svg.export.highlightSelected", (boolean)false);
    private BooleanProperty compress = PathPrefs.createPersistentPreference((String)"svg.export.compress", (boolean)false);

    public SvgExportCommand(QuPathGUI qupath, SvgExportType type) {
        this.qupath = qupath;
        this.type = type;
    }

    @Override
    public void run() {
        File file;
        QuPathViewer viewer = this.qupath.getViewer();
        ImageData imageData = viewer.getImageData();
        if (imageData == null) {
            GuiTools.showNoImageError((String)title);
            return;
        }
        SvgTools.SvgBuilder builder = new SvgTools.SvgBuilder(viewer);
        ImageServer server = imageData.getServer();
        String description = "SVG image";
        String ext = ".svg";
        if (this.type == SvgExportType.SELECTED_REGION) {
            PathObject selected = viewer.getSelectedObject();
            ParameterList params = new ParameterList().addDoubleParameter("downsample", "Downsample factor", this.downsample.get(), null, "Downsample factor for export resolution (default: current viewer downsample)").addChoiceParameter("includeImage", "Raster image", (Object)((SvgTools.SvgBuilder.ImageIncludeType)((Object)this.imageType.get())), Arrays.asList(SvgTools.SvgBuilder.ImageIncludeType.values()), "Export associated raster image").addBooleanParameter("highlightSelected", "Highlight selected objects", this.highlightSelected.get(), "Highlight selected objects to distinguish these from unselected objects, as they are shown in the viewer").addBooleanParameter("compress", "Compress SVGZ", this.compress.get(), "Write compressed SVGZ file, rather than standard SVG (default: no compression, for improved compatibility with other software)");
            if (!GuiTools.showParameterDialog((String)title, (ParameterList)params)) {
                return;
            }
            this.downsample.set(params.getDoubleParameterValue("downsample").doubleValue());
            this.imageType.set((Object)((SvgTools.SvgBuilder.ImageIncludeType)((Object)params.getChoiceParameterValue("includeImage"))));
            this.highlightSelected.set(params.getBooleanParameterValue("highlightSelected").booleanValue());
            this.compress.set(params.getBooleanParameterValue("compress").booleanValue());
            if (this.downsample.get() <= 0.0) {
                Dialogs.showErrorMessage((String)title, (String)"Downsample factor must be > 0!");
                return;
            }
            RegionRequest request = selected != null && selected.hasROI() ? RegionRequest.createInstance((String)server.getPath(), (double)this.downsample.get(), (ROI)selected.getROI()) : RegionRequest.createInstance((ImageServer)server, (double)this.downsample.get());
            int width = (int)((double)request.getWidth() / this.downsample.get());
            int height = (int)((double)request.getHeight() / this.downsample.get());
            if (!(width <= 8192 && height <= 8192 || Dialogs.showYesNoDialog((String)title, (String)String.format("The requested image size (approx. %d x %d pixels) is very big -\nare you sure you want to try to export at this resolution?", width, height)))) {
                return;
            }
            builder.images((SvgTools.SvgBuilder.ImageIncludeType)((Object)this.imageType.get())).region((ImageRegion)request).downsample(request.getDownsample()).showSelection(this.highlightSelected.get());
            if (this.compress.get()) {
                description = "SVGZ image";
                ext = ".svgz";
            }
        }
        if ((file = FileChoosers.promptToSaveFile((String)title, null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)description, (String[])new String[]{ext})})) == null) {
            return;
        }
        try {
            builder.writeSVG(file);
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)title, (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public static enum SvgExportType {
        VIEWER_SNAPSHOT,
        SELECTED_REGION;

    }
}

