/*
 * Decompiled with CFR 0.152.
 */
package qupathj;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import javafx.application.Platform;
import qupath.imagej.tools.IJTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.objects.PathObject;
import qupath.lib.regions.ImagePlane;

public class QuPath_Send_ROI_to_QuPath
implements PlugIn {
    public void run(String arg) {
        PathObject pathObject;
        ImageData imageData;
        ImagePlus imp = IJ.getImage();
        if (imp == null) {
            return;
        }
        Roi roi = imp.getRoi();
        if (roi == null) {
            IJ.showMessage((String)"No Roi found!");
            return;
        }
        QuPathGUI qupath = QuPathGUI.getInstance();
        QuPathViewer viewer = qupath == null ? null : qupath.getViewer();
        ImageData imageData2 = imageData = viewer == null ? null : viewer.getImageData();
        if (imageData == null) {
            IJ.showMessage((String)"No active image found in QuPath!");
            return;
        }
        ImageServer server = imageData.getServer();
        double downsample = IJTools.estimateDownsampleFactor((ImagePlus)imp, (ImageServer)server);
        Calibration cal = imp.getCalibration();
        ImagePlane plane = viewer.getImagePlane();
        if (server.nZSlices() * server.nTimepoints() > 1 && imp.getNSlices() == server.nZSlices() && imp.getNFrames() == server.nTimepoints()) {
            plane = ImagePlane.getPlane((int)(imp.getZ() - 1), (int)(imp.getT() - 1));
        }
        if ((pathObject = IJTools.convertToAnnotation((Roi)roi, (double)cal.xOrigin, (double)cal.yOrigin, (double)downsample, (ImagePlane)plane)) == null) {
            IJ.error((String)("Sorry, I couldn't convert " + String.valueOf(roi) + " to a valid QuPath object"));
            return;
        }
        Platform.runLater(() -> {
            imageData.getHierarchy().addObject(pathObject);
            imageData.getHierarchy().getSelectionModel().setSelectedObject(pathObject);
            viewer.setZPosition(pathObject.getROI().getZ());
            viewer.setTPosition(pathObject.getROI().getT());
        });
    }
}

