/*
 * Decompiled with CFR 0.152.
 */
package qupathj;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.filter.Analyzer;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import javafx.application.Platform;
import qupath.imagej.gui.scripts.ImageJScriptRunner;
import qupath.imagej.tools.IJTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.measurements.MeasurementList;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.regions.ImagePlane;
import qupath.lib.roi.interfaces.ROI;

public class QuPath_Send_Overlay_to_QuPath
implements PlugIn {
    private String typeChoice = "Annotation";
    private boolean includeMeasurements = false;
    private boolean selectObjects = true;

    public void run(String arg) {
        ImageData imageData;
        ImagePlus imp = WindowManager.getCurrentImage();
        List<Roi> rois = null;
        if ("manager".equalsIgnoreCase(arg)) {
            RoiManager rm = RoiManager.getInstance();
            if (rm == null) {
                IJ.showMessage((String)"No RoiManager found!");
                return;
            }
            rois = Arrays.asList(rm.getRoisAsArray());
            if (rois.isEmpty()) {
                IJ.showMessage((String)"No ROIs found in the RoiManager!");
                return;
            }
        } else {
            Overlay overlay;
            Overlay overlay2 = overlay = imp == null ? null : imp.getOverlay();
            if (overlay == null || overlay.size() == 0) {
                IJ.showMessage((String)"No overlay found!");
                return;
            }
            rois = Arrays.asList(overlay.toArray());
        }
        if (rois.isEmpty()) {
            return;
        }
        QuPathGUI qupath = QuPathGUI.getInstance();
        QuPathViewer viewer = qupath == null ? null : qupath.getViewer();
        ImageData imageData2 = imageData = viewer == null ? null : viewer.getImageData();
        if (imageData == null) {
            IJ.showMessage((String)"No image selected in QuPath!");
            return;
        }
        this.promptToImportRois(imageData, imp, rois, viewer.getImagePlane());
    }

    private void promptToImportRois(ImageData<?> imageData, ImagePlus imp, Collection<? extends Roi> rois, ImagePlane currentPlane) {
        GenericDialog gd = new GenericDialog("Send overlay to QuPath");
        gd.addChoice("Choose_object_type", new String[]{"Annotation", "Detection"}, this.typeChoice);
        if (imp != null) {
            gd.addCheckbox("Include_measurements", false);
        }
        gd.addCheckbox("Select_objects", this.selectObjects);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.typeChoice = gd.getNextChoice();
        boolean asDetection = "Detection".equals(this.typeChoice);
        this.includeMeasurements = imp == null ? false : gd.getNextBoolean();
        this.selectObjects = gd.getNextBoolean();
        ImageServer server = imageData.getServer();
        double downsample = imp == null ? 1.0 : IJTools.estimateDownsampleFactor((ImagePlus)imp, (ImageServer)server);
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        ImagePlane plane = currentPlane;
        if (imp == null) {
            plane = null;
        } else if (server.nZSlices() * server.nTimepoints() > 1 && imp.getNSlices() == server.nZSlices() && imp.getNFrames() == server.nTimepoints()) {
            plane = null;
        }
        List<PathObject> pathObjects = QuPath_Send_Overlay_to_QuPath.createObjectsFromROIs(imp, rois, downsample, asDetection, this.includeMeasurements, plane);
        if (!pathObjects.isEmpty()) {
            Platform.runLater(() -> {
                hierarchy.addObjects((Collection)pathObjects);
                if (this.selectObjects) {
                    hierarchy.getSelectionModel().selectObjects((Collection)pathObjects);
                }
            });
        }
    }

    public static List<PathObject> createObjectsFromROIs(ImagePlus imp, Collection<? extends Roi> rois, double downsample, boolean asDetection, boolean includeMeasurements, ImagePlane plane) {
        Function<ROI, PathObject> creator = asDetection ? ImageJScriptRunner::createDetectionOrPointAnnotation : PathObjects::createAnnotationObject;
        return QuPath_Send_Overlay_to_QuPath.createObjectsFromROIs(imp, rois, downsample, creator, includeMeasurements, plane);
    }

    public static List<PathObject> createObjectsFromROIs(ImagePlus imp, Collection<? extends Roi> rois, double downsample, Function<ROI, PathObject> creator, boolean includeMeasurements, ImagePlane plane) {
        ArrayList<PathObject> pathObjects = new ArrayList<PathObject>();
        ResultsTable rt = new ResultsTable();
        Analyzer analyzer = imp == null ? null : new Analyzer(imp, Analyzer.getMeasurements(), rt);
        String[] headings = null;
        Calibration cal = imp == null ? null : imp.getCalibration();
        double xOrigin = cal == null ? 0.0 : cal.xOrigin;
        double yOrigin = cal == null ? 0.0 : cal.yOrigin;
        for (Roi roi : rois) {
            PathObject pathObject = IJTools.convertToPathObject((Roi)roi, (double)xOrigin, (double)yOrigin, (double)downsample, creator, (ImagePlane)plane);
            if (pathObject == null) {
                IJ.log((String)("Sorry, I couldn't convert " + String.valueOf(roi) + " to a valid QuPath object"));
                continue;
            }
            if (includeMeasurements && imp != null) {
                ImageProcessor ip = imp.getProcessor();
                ip.setRoi(roi);
                ImageStatistics stats = ImageStatistics.getStatistics((ImageProcessor)ip, (int)Analyzer.getMeasurements(), (Calibration)imp.getCalibration());
                analyzer.saveResults(stats, roi);
                if (headings == null) {
                    headings = rt.getHeadings();
                }
                int row = rt.getCounter() - 1;
                MeasurementList ml = pathObject.getMeasurementList();
                for (String h : headings) {
                    if ("Label".equals(h)) continue;
                    ml.put(h, rt.getValue(h, row));
                }
                ml.close();
            }
            pathObjects.add(pathObject);
        }
        return pathObjects;
    }
}

