/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ui;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.projects.Project;
import qupath.lib.projects.ResourceManager;
import qupath.process.gui.commands.ml.ProjectClassifierBindings;

public class SaveResourcePaneBuilder<T> {
    private static final Logger logger = LoggerFactory.getLogger(SaveResourcePaneBuilder.class);
    private Class<T> cls;
    private String title = "Save resource";
    private String textFieldPrompt = "Enter name";
    private String labelText = "Classifier name";
    private ObservableValue<String> tooltipText;
    private StringProperty savedName = new SimpleStringProperty();
    private ObjectExpression<? extends T> resource;
    private ObjectExpression<Project<BufferedImage>> project = QuPathGUI.getInstance() == null ? null : QuPathGUI.getInstance().projectProperty();

    public SaveResourcePaneBuilder(Class<T> cls, ObjectExpression<? extends T> resource) {
        Objects.requireNonNull(resource);
        Objects.requireNonNull(cls);
        this.resource = resource;
        this.cls = cls;
    }

    public SaveResourcePaneBuilder<T> project(ObjectExpression<Project<BufferedImage>> project) {
        this.project = project;
        return this;
    }

    public SaveResourcePaneBuilder<T> labelText(String prompt) {
        this.labelText = prompt;
        return this;
    }

    public SaveResourcePaneBuilder<T> textFieldPrompt(String prompt) {
        this.textFieldPrompt = prompt;
        return this;
    }

    public SaveResourcePaneBuilder<T> tooltip(ObservableValue<String> tooltip) {
        this.tooltipText = tooltip;
        return this;
    }

    public SaveResourcePaneBuilder<T> title(String title) {
        this.title = title;
        return this;
    }

    public SaveResourcePaneBuilder<T> savedName(StringProperty savedName) {
        this.savedName = savedName;
        return this;
    }

    public Pane build() {
        Label label = new Label(this.labelText);
        String defaultName = (String)this.savedName.get();
        TextField tfClassifierName = new TextField(defaultName == null ? "" : defaultName);
        tfClassifierName.setPromptText(this.textFieldPrompt);
        this.resource.addListener((v, o, n) -> this.savedName.set(null));
        Button btnSave = new Button("Save");
        btnSave.setOnAction(e -> {
            String name;
            ResourceManager.Manager manager;
            Project p = (Project)this.project.get();
            ResourceManager.Manager manager2 = manager = p == null ? null : SaveResourcePaneBuilder.getResourceManager(p, this.cls);
            if (manager == null) {
                // empty if block
            }
            if ((name = SaveResourcePaneBuilder.tryToSave((Project)this.project.get(), this.title, this.cls, this.resource.get(), tfClassifierName.getText(), false)) != null) {
                Dialogs.showInfoNotification((String)this.title, (String)("Saved as \"" + name + "\""));
                this.savedName.set((Object)name);
                tfClassifierName.requestFocus();
                btnSave.requestFocus();
            }
        });
        btnSave.disableProperty().bind((ObservableValue)this.resource.isNull().or((ObservableBooleanValue)this.project.isNull()).or((ObservableBooleanValue)tfClassifierName.textProperty().isEmpty()));
        tfClassifierName.disableProperty().bind((ObservableValue)this.project.isNull());
        label.setLabelFor((Node)tfClassifierName);
        GridPane pane = new GridPane();
        if (this.tooltipText != null) {
            Tooltip tooltip = new Tooltip();
            tooltip.textProperty().bind(this.tooltipText);
            Tooltip.install((Node)pane, (Tooltip)tooltip);
        }
        GridPaneUtils.addGridRow((GridPane)pane, (int)0, (int)0, null, (Node[])new Node[]{label, tfClassifierName, btnSave});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{tfClassifierName});
        pane.setHgap(5.0);
        ProjectClassifierBindings.bindPixelClassifierNameInput(tfClassifierName, this.project);
        return pane;
    }

    private static <T> String tryToSave(Project<?> project, String title, Class<T> cls, T resource, String name, boolean overwriteQuietly) {
        if (project == null) {
            Dialogs.showWarningNotification((String)title, (String)"You need a project to be able to save the pixel classifier");
            return null;
        }
        if ((name = GeneralTools.stripInvalidFilenameChars((String)name)).isBlank()) {
            Dialogs.showErrorMessage((String)title, (String)"Please enter a valid name!");
            return null;
        }
        try {
            ResourceManager.Manager manager = SaveResourcePaneBuilder.getResourceManager(project, cls);
            if (manager == null) {
                Dialogs.showWarningNotification((String)title, (String)("Unable to save resources with type '" + String.valueOf(cls) + "'"));
                return null;
            }
            if (!overwriteQuietly && manager.contains(name) && !Dialogs.showYesNoDialog((String)title, (String)("Overwrite existing '" + name + "'?"))) {
                return null;
            }
            manager.put(name, resource);
            return name;
        }
        catch (IOException ex) {
            Dialogs.showErrorMessage((String)title, (Throwable)ex);
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    private static <T, S extends T> ResourceManager.Manager<S> getResourceManager(Project<?> project, Class<T> cls) {
        if (PixelClassifier.class.equals(cls)) {
            return project.getPixelClassifiers();
        }
        if (ObjectClassifier.class.equals(cls)) {
            return project.getObjectClassifiers();
        }
        if (DensityMaps.DensityMapBuilder.class.equals(cls)) {
            return project.getResources("classifiers/density_maps", cls, "json");
        }
        return null;
    }
}

