/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ui;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.stores.ColorModelRenderer;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.scripting.ScriptEditor;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.RegionFilter;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.io.UriResource;
import qupath.lib.io.UriUpdater;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ResourceManager;
import qupath.opencv.ml.pixel.PixelClassifierTools;
import qupath.process.gui.commands.density.DensityMapUI;
import qupath.process.gui.commands.ml.PixelClassifierUI;

public final class LoadResourceCommand<S>
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(LoadResourceCommand.class);
    private QuPathGUI qupath;
    private ResourceType<S> resourceType;
    private Map<String, S> extras = new TreeMap<String, S>();
    private int nThreads = 1;

    private LoadResourceCommand(QuPathGUI qupath, ResourceType<S> resourceType, int nThreads) {
        this.qupath = qupath;
        this.resourceType = resourceType;
        this.nThreads = nThreads;
    }

    public static LoadResourceCommand<PixelClassifier> createLoadPixelClassifierCommand(QuPathGUI qupath) {
        return new LoadResourceCommand<PixelClassifier>(qupath, new PixelClassifierType(), PathPrefs.numCommandThreadsProperty().get());
    }

    public static LoadResourceCommand<DensityMaps.DensityMapBuilder> createLoadDensityMapCommand(QuPathGUI qupath) {
        return new LoadResourceCommand<DensityMaps.DensityMapBuilder>(qupath, new DensityMapType(), 1);
    }

    @Override
    public void run() {
        String title = this.resourceType.getDialogTitle();
        WeakHashMap cachedServers = new WeakHashMap();
        PixelClassificationOverlay overlay = PixelClassificationOverlay.create((OverlayOptions)this.qupath.getOverlayOptions(), cachedServers, (ImageRenderer)new ColorModelRenderer(null));
        overlay.setMaxThreads(this.nThreads);
        ComboBox comboClassifiers = new ComboBox();
        try {
            this.updateAvailableItems((ObservableList<String>)comboClassifiers.getItems());
        }
        catch (IOException e2) {
            logger.error(e2.getLocalizedMessage(), (Throwable)e2);
        }
        ObjectBinding selectedResource = Bindings.createObjectBinding(() -> {
            String name = (String)comboClassifiers.getSelectionModel().getSelectedItem();
            cachedServers.clear();
            if (name != null) {
                try {
                    Project project = this.qupath.getProject();
                    ResourceManager.Manager<S> manager = this.resourceType.getManager(project);
                    Object resource = manager != null && manager.contains(name) ? manager.get(name) : this.extras.get(name);
                    if (resource instanceof UriResource) {
                        UriUpdater.fixUris((UriResource)((UriResource)resource), (Project)project);
                    }
                    return resource;
                }
                catch (Exception ex) {
                    Dialogs.showErrorNotification((String)this.resourceType.getDialogTitle(), (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
            return null;
        }, (Observable[])new Observable[]{comboClassifiers.getSelectionModel().selectedItemProperty()});
        Label label = new Label(this.resourceType.choosePrompt());
        label.setLabelFor((Node)comboClassifiers);
        selectedResource.addListener((v, o, n) -> {
            cachedServers.clear();
            this.updateServers(n, cachedServers);
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                if (n != null) {
                    viewer.resetCustomPixelLayerOverlay();
                    viewer.setCustomPixelLayerOverlay((PathOverlay)overlay);
                    continue;
                }
                viewer.resetCustomPixelLayerOverlay();
            }
        });
        ContextMenu menu = new ContextMenu();
        MenuItem miLoadClassifier = new MenuItem("Import from files");
        miLoadClassifier.setOnAction(e -> {
            List files = FileChoosers.promptForMultipleFiles((String)title, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)this.resourceType.filePrompt(), (String[])new String[]{".*json"})});
            if (files == null || files.isEmpty()) {
                return;
            }
            try {
                this.addExternalJson(files, this.resourceType.getManager(this.qupath.getProject()), this.extras);
                this.updateAvailableItems((ObservableList<String>)comboClassifiers.getItems());
            }
            catch (IOException ex) {
                Dialogs.showErrorMessage((String)title, (Throwable)ex);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        });
        MenuItem miOpenAsText = new MenuItem("Show as text");
        miOpenAsText.setOnAction(e -> {
            Object name = (String)comboClassifiers.getSelectionModel().getSelectedItem();
            Object resource = selectedResource.get();
            if (resource == null) {
                return;
            }
            try {
                ScriptEditor scriptEditor;
                String json = GsonTools.getInstance((boolean)true).toJson(resource, this.resourceType.getResourceClass());
                if (!((String)name).endsWith(".json")) {
                    name = (String)name + ".json";
                }
                ScriptEditor scriptEditor2 = scriptEditor = this.qupath == null ? null : this.qupath.getScriptEditor();
                if (scriptEditor != null) {
                    scriptEditor.showScript((String)name, json);
                } else {
                    Dialogs.showTextWindow((Window)this.qupath.getStage(), (String)name, (String)json, (Modality)Modality.NONE, (boolean)false);
                }
            }
            catch (Exception ex) {
                Dialogs.showErrorMessage((String)"Show model as text", (String)("Unable to create a text representation of '" + (String)name + "', sorry!"));
            }
        });
        miOpenAsText.disableProperty().bind((ObservableValue)selectedResource.isNull());
        MenuItem miThreads = new MenuItem("Set parallel threads");
        miThreads.setOnAction(e -> {
            ParameterList params = new ParameterList().addIntParameter("nThreads", "Number of parallel threads", this.nThreads, null, "Number of threads to use for live prediction");
            if (!GuiTools.showParameterDialog((String)"Set parallel threads", (ParameterList)params)) {
                return;
            }
            Integer val = params.getIntParameterValue("nThreads");
            if (val == this.nThreads) {
                return;
            }
            this.nThreads = val < 0 ? PathPrefs.numCommandThreadsProperty().get() : Math.max(1, val);
            if (overlay != null) {
                overlay.setMaxThreads(this.nThreads);
            }
        });
        menu.getItems().addAll((Object[])new MenuItem[]{miLoadClassifier, miOpenAsText, new SeparatorMenuItem(), miThreads});
        Button btnLoadExistingClassifier = GuiTools.createMoreButton((ContextMenu)menu, (Side)Side.RIGHT);
        SimpleStringProperty classifierName = new SimpleStringProperty(null);
        classifierName.bind((ObservableValue)comboClassifiers.getSelectionModel().selectedItemProperty());
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(10.0));
        pane.setHgap(5.0);
        pane.setVgap(10.0);
        pane.setPrefWidth(350.0);
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Choose model to apply to the current image", (Node[])new Node[]{label, comboClassifiers, btnLoadExistingClassifier});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{comboClassifiers});
        if (this.resourceType.getResourceClass().equals(PixelClassifier.class)) {
            Label labelRegion = new Label("Region");
            ComboBox<RegionFilter> comboRegionFilter = PixelClassifierUI.createRegionFilterCombo(this.qupath.getOverlayOptions());
            Pane tilePane = PixelClassifierUI.createPixelClassifierButtons((ObjectExpression<ImageData<BufferedImage>>)this.qupath.imageDataProperty(), (ObjectExpression<PixelClassifier>)selectedResource, (StringExpression)classifierName);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Control where the pixel classification is applied during preview", (Node[])new Node[]{labelRegion, comboRegionFilter, comboRegionFilter});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Apply pixel classification", (Node[])new Node[]{tilePane, tilePane, tilePane});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{tilePane});
        } else if (this.resourceType.getResourceClass().equals(DensityMaps.DensityMapBuilder.class)) {
            Pane buttonPane = DensityMapUI.createButtonPane(this.qupath, (ObjectExpression<ImageData<BufferedImage>>)this.qupath.imageDataProperty(), (ObjectExpression<DensityMaps.DensityMapBuilder>)selectedResource, (StringExpression)classifierName, (ObjectExpression<PixelClassificationOverlay>)Bindings.createObjectBinding(() -> overlay, (Observable[])new Observable[0]), false);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{buttonPane, buttonPane, buttonPane});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{buttonPane});
        }
        pane.setOnDragOver(e -> {
            e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            e.consume();
        });
        pane.setOnDragDropped(e -> {
            logger.trace("File(s) dragged onto pane");
            Dragboard dragboard = e.getDragboard();
            if (dragboard.hasFiles()) {
                try {
                    this.addExternalJson(dragboard.getFiles(), this.resourceType.getManager(this.qupath.getProject()), this.extras);
                    this.updateAvailableItems((ObservableList<String>)comboClassifiers.getItems());
                }
                catch (Exception ex) {
                    Dialogs.showErrorMessage((String)title, (Throwable)ex);
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        Stage stage = new Stage();
        stage.setTitle(title);
        stage.setScene(new Scene((Parent)pane));
        stage.initOwner((Window)this.qupath.getStage());
        stage.sizeToScene();
        stage.setResizable(false);
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.show();
        stage.setOnHiding(e -> {
            if (overlay != null) {
                overlay.stop();
            }
            logger.debug("Resetting overlay");
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                if (viewer.getCustomPixelLayerOverlay() != overlay) continue;
                viewer.resetCustomPixelLayerOverlay();
            }
        });
        stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue() && overlay != null) {
                for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                    viewer.setCustomPixelLayerOverlay((PathOverlay)overlay);
                }
            }
            this.updateServers(selectedResource.get(), cachedServers);
        });
        overlay.setLivePrediction(true);
    }

    private void updateServers(S resource, Map<ImageData<BufferedImage>, ImageServer<BufferedImage>> cachedServers) {
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            ImageServer<BufferedImage> server;
            ImageData imageData = viewer.getImageData();
            if (imageData == null || (server = cachedServers.get(imageData)) != null || resource == null) continue;
            server = this.resourceType.getClassifierServer(resource, (ImageData<BufferedImage>)imageData);
            cachedServers.put((ImageData<BufferedImage>)imageData, server);
        }
        this.qupath.getViewerManager().repaintAllViewers();
    }

    private void updateAvailableItems(ObservableList<String> items) throws IOException {
        ArrayList<String> tempList = new ArrayList<String>();
        ResourceManager.Manager<S> manager = this.resourceType.getManager(this.qupath.getProject());
        if (manager != null) {
            tempList.addAll(manager.getNames());
        }
        tempList.addAll(this.extras.keySet());
        if (!items.containsAll(tempList) || items.size() != tempList.size()) {
            items.setAll(tempList);
        }
    }

    private void addExternalJson(List<File> files, ResourceManager.Manager<S> manager, Map<String, S> externalResources) {
        int nSuccess;
        String plural2;
        String plural = files.size() > 1 ? "s" : "";
        HashSet<String> currentNames = new HashSet<String>();
        boolean addToManager = false;
        if (manager != null) {
            try {
                currentNames.addAll(manager.getNames());
            }
            catch (IOException e2) {
                logger.error(e2.getLocalizedMessage(), (Throwable)e2);
            }
            ButtonType response = Dialogs.showYesNoCancelDialog((String)("Copy classifier file" + plural), (String)("Copy classifier" + plural + " to the current project?"));
            if (response == ButtonType.CANCEL) {
                return;
            }
            addToManager = response == ButtonType.YES;
        }
        ArrayList<File> fails = new ArrayList<File>();
        for (File file : files) {
            try {
                if (!((String)GeneralTools.getExtension((File)file).get()).equals(".json")) {
                    throw new IOException(String.format("We need JSON files (.json), not %s", GeneralTools.getExtension((File)file).orElse("missing any file extension")));
                }
                S classifier = this.resourceType.readFromPath(file.toPath());
                String name = GeneralTools.getNameWithoutExtension((File)file);
                name = GeneralTools.generateDistinctName((String)name, currentNames);
                if (addToManager) {
                    manager.put(name, classifier);
                } else {
                    externalResources.put(name, classifier);
                }
                currentNames.add(name);
                logger.debug("Added {}", (Object)name);
            }
            catch (IOException ex) {
                Dialogs.showErrorNotification((String)String.format("Could not add %s", file.getName()), (String)ex.getLocalizedMessage());
                fails.add(file);
            }
        }
        if (!fails.isEmpty()) {
            String failedClassifiers = fails.stream().map(e -> "- " + e.getName()).collect(Collectors.joining(System.lineSeparator()));
            String pluralize = fails.size() == 1 ? "" : "s";
            Dialogs.showErrorMessage((String)("Error adding classifier" + pluralize), (String)String.format("Could not add the following:%s%s", System.lineSeparator(), failedClassifiers));
        }
        String string = plural2 = (nSuccess = files.size() - fails.size()) > 1 ? "s" : "";
        if (nSuccess > 0) {
            Dialogs.showInfoNotification((String)("Classifier" + plural2 + " added successfully"), (String)String.format("%d classifier" + plural2 + " added", nSuccess));
        }
    }

    private static interface ResourceType<T> {
        public Class<T> getResourceClass();

        public ResourceManager.Manager<T> getManager(Project<?> var1);

        default public T readFromPath(Path path) throws IOException {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                Object object = GsonTools.getInstance().fromJson((Reader)reader, this.getResourceClass());
                return (T)object;
            }
        }

        public String getDialogTitle();

        public ImageServer<BufferedImage> getClassifierServer(T var1, ImageData<BufferedImage> var2);

        public String choosePrompt();

        public String filePrompt();
    }

    private static class PixelClassifierType
    implements ResourceType<PixelClassifier> {
        private PixelClassifierType() {
        }

        @Override
        public Class<PixelClassifier> getResourceClass() {
            return PixelClassifier.class;
        }

        @Override
        public ResourceManager.Manager<PixelClassifier> getManager(Project<?> project) {
            return project == null ? null : project.getPixelClassifiers();
        }

        @Override
        public String getDialogTitle() {
            return "Load pixel classifier";
        }

        @Override
        public ImageServer<BufferedImage> getClassifierServer(PixelClassifier resource, ImageData<BufferedImage> imageData) {
            return PixelClassifierTools.createPixelClassificationServer(imageData, (PixelClassifier)resource);
        }

        @Override
        public String choosePrompt() {
            return "Choose model";
        }

        @Override
        public String filePrompt() {
            return "Pixel classifier (.json)";
        }
    }

    private static class DensityMapType
    implements ResourceType<DensityMaps.DensityMapBuilder> {
        private DensityMapType() {
        }

        @Override
        public Class<DensityMaps.DensityMapBuilder> getResourceClass() {
            return DensityMaps.DensityMapBuilder.class;
        }

        @Override
        public ResourceManager.Manager<DensityMaps.DensityMapBuilder> getManager(Project<?> project) {
            return project.getResources("classifiers/density_maps", this.getResourceClass(), "json");
        }

        @Override
        public String getDialogTitle() {
            return "Load density map";
        }

        @Override
        public ImageServer<BufferedImage> getClassifierServer(DensityMaps.DensityMapBuilder resource, ImageData<BufferedImage> imageData) {
            return resource.buildServer(imageData);
        }

        @Override
        public String choosePrompt() {
            return "Choose map";
        }

        @Override
        public String filePrompt() {
            return "Density map (.json)";
        }
    }
}

