/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.TreeSet;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.common.GeneralTools;
import qupath.lib.projects.Project;

public class ProjectClassifierBindings {
    private static final Logger logger = LoggerFactory.getLogger(ProjectClassifierBindings.class);

    public static void bindPixelClassifierNameInput(TextField textField, ObjectExpression<Project<BufferedImage>> project) {
        TreeSet<String> existingNames = new TreeSet<String>();
        ProjectClassifierBindings.updatePixelClassifierNames((Project)project.get(), existingNames);
        ProjectClassifierBindings.bindStyle(textField, existingNames);
        textField.focusedProperty().addListener((v, o, n) -> ProjectClassifierBindings.updatePixelClassifierNames((Project)project.get(), existingNames));
    }

    private static void updatePixelClassifierNames(Project<?> project, Collection<String> names) {
        if (project == null) {
            names.clear();
            return;
        }
        try {
            Collection currentNames = project.getPixelClassifiers().getNames();
            names.clear();
            names.addAll(currentNames.stream().map(n -> n.toLowerCase()).toList());
        }
        catch (Exception e) {
            logger.debug("Error updating pixel classifier names: {}", (Object)e.getLocalizedMessage());
            names.clear();
        }
    }

    private static void bindStyle(TextField tf, Collection<String> existingNames) {
        tf.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> ProjectClassifierBindings.getStyle(tf.getText(), existingNames), (Observable[])new Observable[]{tf.textProperty(), tf.focusedProperty()}));
    }

    private static String getStyle(String name, Collection<String> existingNames) {
        if (name == null) {
            return null;
        }
        if (existingNames.contains((name = GeneralTools.stripInvalidFilenameChars((String)name)).toLowerCase())) {
            return "-fx-font-style: italic;";
        }
        return null;
    }

    public static void bindObjectClassifierNameInput(TextField textField, ObjectExpression<Project<BufferedImage>> project) {
        TreeSet<String> existingNames = new TreeSet<String>();
        ProjectClassifierBindings.updateObjectClassifierNames((Project)project.get(), existingNames);
        ProjectClassifierBindings.bindStyle(textField, existingNames);
        textField.focusedProperty().addListener((v, o, n) -> ProjectClassifierBindings.updateObjectClassifierNames((Project)project.get(), existingNames));
    }

    private static void updateObjectClassifierNames(Project<?> project, Collection<String> names) {
        if (project == null) {
            names.clear();
            return;
        }
        try {
            Collection currentNames = project.getObjectClassifiers().getNames();
            names.clear();
            names.addAll(currentNames.stream().map(n -> n.toLowerCase()).toList());
        }
        catch (Exception e) {
            logger.debug("Error updating object classifier names: {}", (Object)e.getLocalizedMessage());
            names.clear();
        }
    }
}

