/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.gui.commands.Commands;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.RegionFilter;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.writers.ImageWriter;
import qupath.lib.images.writers.ImageWriterTools;
import qupath.lib.objects.PathAnnotationObject;
import qupath.lib.objects.PathCellObject;
import qupath.lib.objects.PathDetectionObject;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathTileObject;
import qupath.lib.objects.TMACoreObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.BooleanParameter;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.opencv.ml.pixel.PixelClassifierTools;
import qupath.process.gui.commands.ui.SaveResourcePaneBuilder;

public class PixelClassifierUI {
    private static final Logger logger = LoggerFactory.getLogger(PixelClassifierUI.class);
    private static final String title = "Pixel classifier";
    private static ParameterList lastCreateObjectParams;

    public static ComboBox<RegionFilter> createRegionFilterCombo(OverlayOptions options) {
        ComboBox comboRegion = new ComboBox();
        comboRegion.getItems().addAll((Object[])RegionFilter.StandardRegionFilters.values());
        RegionFilter selected = options.getPixelClassificationRegionFilter();
        if (!comboRegion.getItems().contains((Object)selected)) {
            comboRegion.getItems().add((Object)selected);
        }
        comboRegion.getSelectionModel().select((Object)selected);
        comboRegion.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> options.setPixelClassificationRegionFilter(n));
        comboRegion.focusedProperty().addListener((v, o, n) -> comboRegion.getSelectionModel().select((Object)options.getPixelClassificationRegionFilter()));
        comboRegion.setMaxWidth(Double.MAX_VALUE);
        comboRegion.setTooltip(new Tooltip("Control where the pixel classification is applied during preview.\nWarning! Classifying the entire image at high resolution can be very slow and require a lot of memory."));
        return comboRegion;
    }

    public static Pane createPixelClassifierButtons(ObjectExpression<ImageData<BufferedImage>> imageData, ObjectExpression<PixelClassifier> classifier, StringExpression classifierName) {
        BooleanBinding disableButtons = imageData.isNull().or((ObservableBooleanValue)classifier.isNull());
        Button btnCreateObjects = new Button("Create objects");
        btnCreateObjects.disableProperty().bind((ObservableValue)disableButtons);
        btnCreateObjects.setTooltip(new Tooltip("Create annotation or detection objects from the classification output"));
        Button btnAddMeasurements = new Button("Add measurements");
        btnAddMeasurements.disableProperty().bind((ObservableValue)disableButtons);
        btnAddMeasurements.setTooltip(new Tooltip("Add measurements to existing objects based upon the classifier output"));
        Button btnClassifyObjects = new Button("Classify detections");
        btnClassifyObjects.disableProperty().bind((ObservableValue)disableButtons);
        btnClassifyObjects.setTooltip(new Tooltip("Classify detections based upon the prediction at the ROI centroid"));
        Button btnSavePrediction = new Button("Save prediction");
        btnSavePrediction.disableProperty().bind((ObservableValue)disableButtons);
        btnSavePrediction.setTooltip(new Tooltip("Save an image of the classifier predictions"));
        btnAddMeasurements.setOnAction(e -> {
            if (classifierName.getValueSafe().isEmpty() && !PixelClassifierUI.promptForUnnamedClassifier(btnAddMeasurements.getText())) {
                return;
            }
            PixelClassifierUI.promptToAddMeasurements((ImageData<BufferedImage>)((ImageData)imageData.get()), (PixelClassifier)classifier.get(), (String)classifierName.get());
        });
        btnCreateObjects.setOnAction(e -> {
            if (classifierName.getValueSafe().isEmpty() && !PixelClassifierUI.promptForUnnamedClassifier(btnCreateObjects.getText())) {
                return;
            }
            PixelClassifierUI.promptToCreateObjects((ImageData<BufferedImage>)((ImageData)imageData.get()), (PixelClassifier)classifier.get(), (String)classifierName.get());
        });
        btnClassifyObjects.setOnAction(e -> {
            if (classifierName.getValueSafe().isEmpty() && !PixelClassifierUI.promptForUnnamedClassifier(btnClassifyObjects.getText())) {
                return;
            }
            PixelClassifierUI.promptToClassifyDetectionsByCentroid((ImageData<BufferedImage>)((ImageData)imageData.get()), (PixelClassifier)classifier.get(), (String)classifierName.get());
        });
        btnSavePrediction.setOnAction(e -> {
            if (classifierName.getValueSafe().isEmpty() && !PixelClassifierUI.promptForUnnamedClassifier(btnSavePrediction.getText())) {
                return;
            }
            PixelClassifierUI.promptToSavePredictionImage((ImageData<BufferedImage>)((ImageData)imageData.get()), (PixelClassifier)classifier.get(), (String)classifierName.get());
        });
        btnSavePrediction.disableProperty().bind((ObservableValue)disableButtons);
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{btnAddMeasurements, btnCreateObjects, btnClassifyObjects, btnSavePrediction});
        GridPane pane = new GridPane();
        pane.addRow(0, new Node[]{btnCreateObjects, btnSavePrediction});
        pane.addRow(1, new Node[]{btnAddMeasurements, btnClassifyObjects});
        ColumnConstraints c1 = new ColumnConstraints();
        c1.setPercentWidth(50.0);
        ColumnConstraints c2 = new ColumnConstraints();
        c2.setPercentWidth(50.0);
        pane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{c1, c2});
        return pane;
    }

    private static boolean promptForUnnamedClassifier(String title) {
        return Dialogs.builder().title(title).warning().contentText("Are you sure?\n\nThe classifier has not been saved - this step won't be logged in the workflow.").buttons(new ButtonType[]{ButtonType.OK, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL).equals(ButtonType.OK);
    }

    public static Pane createSavePixelClassifierPane(ObjectExpression<Project<BufferedImage>> project, ObjectExpression<PixelClassifier> classifier, StringProperty savedName) {
        String tooltipTextYes = "Save classifier in the current project - this is required to use the classifier later (e.g. to create objects, measurements)";
        String tooltipTextNo = "Cannot save a classifier outside a project. Please create a project to save the classifier.";
        StringBinding tooltipText = Bindings.when((ObservableBooleanValue)project.isNull()).then((ObservableStringValue)Bindings.createStringBinding(() -> tooltipTextNo, (Observable[])new Observable[]{project})).otherwise((ObservableStringValue)Bindings.createStringBinding(() -> tooltipTextYes, (Observable[])new Observable[]{project}));
        return new SaveResourcePaneBuilder<PixelClassifier>(PixelClassifier.class, classifier).project(project).labelText("Classifier name").tooltip((ObservableValue<String>)tooltipText).savedName(savedName).title(title).build();
    }

    private static boolean promptToSavePredictionImage(ImageData<BufferedImage> imageData, PixelClassifier classifier, String classifierName) {
        Objects.requireNonNull(imageData);
        Objects.requireNonNull(classifier);
        ImageServer server = PixelClassifierTools.createPixelClassificationServer(imageData, (PixelClassifier)classifier);
        ArrayList allWriters = new ArrayList();
        allWriters.addAll(ImageWriterTools.getCompatibleWriters((ImageServer)server, (String)"ome.tif"));
        allWriters.addAll(ImageWriterTools.getCompatibleWriters((ImageServer)server, (String)"ome.zarr"));
        if (allWriters.isEmpty()) {
            allWriters.addAll(ImageWriterTools.getCompatibleWriters((ImageServer)server, null));
        }
        if (allWriters.isEmpty()) {
            Dialogs.showErrorMessage((String)"Save prediction", (String)"Sorry, I could not find any compatible image writers!");
            return false;
        }
        ArrayList<FileChooser.ExtensionFilter> filters = new ArrayList<FileChooser.ExtensionFilter>();
        for (ImageWriter w : allWriters) {
            filters.add(FileChoosers.createExtensionFilter((String)w.getName(), (String[])new String[]{w.getDefaultExtension()}));
        }
        File originalFile = classifierName == null ? null : new File(classifierName);
        File file = FileChoosers.promptToSaveFile((String)"Save prediction", (File)originalFile, (FileChooser.ExtensionFilter[])((FileChooser.ExtensionFilter[])filters.toArray(FileChooser.ExtensionFilter[]::new)));
        if (file == null) {
            return false;
        }
        try {
            String path = file.getAbsolutePath();
            ImageWriterTools.writeImage((ImageServer)server, (String)path);
            if (classifierName != null && !classifierName.isBlank()) {
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Write prediction image", String.format("writePredictionImage(\"%s\", \"%s\")", classifierName, path)));
            }
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Save prediction", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
        }
        return true;
    }

    private static boolean promptToClassifyDetectionsByCentroid(ImageData<BufferedImage> imageData, PixelClassifier classifier, String classifierName) {
        Objects.requireNonNull(imageData);
        Objects.requireNonNull(classifier);
        Collection detections = imageData.getHierarchy().getDetectionObjects();
        if (detections.isEmpty()) {
            Dialogs.showErrorMessage((String)"Classify detections", (String)"This command only supports classifying detections, sorry");
            return false;
        }
        PixelClassifierTools.classifyDetectionsByCentroid(imageData, (PixelClassifier)classifier);
        if (classifierName != null) {
            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Classify detections by centroid", String.format("classifyDetectionsByCentroid(\"%s\")", classifierName)));
        }
        return true;
    }

    public static boolean promptToCreateObjects(ImageData<BufferedImage> imageData, PixelClassifier classifier, String classifierName) {
        ParameterList params;
        String units;
        boolean allIgnored;
        Objects.requireNonNull(imageData);
        Objects.requireNonNull(classifier);
        List<SelectionChoice> choices = PixelClassifierUI.buildChoiceList(imageData.getHierarchy(), SelectionChoice.FULL_IMAGE, SelectionChoice.CURRENT_SELECTION, SelectionChoice.ANNOTATIONS, SelectionChoice.TMA);
        SelectionChoice defaultChoice = choices.contains((Object)SelectionChoice.CURRENT_SELECTION) ? SelectionChoice.CURRENT_SELECTION : (choices.contains((Object)SelectionChoice.ANNOTATIONS) ? SelectionChoice.ANNOTATIONS : choices.get(0));
        SelectionChoice parentChoice = (SelectionChoice)((Object)Dialogs.showChoiceDialog((String)title, (String)"Choose parent objects", choices, (Object)((Object)defaultChoice)));
        if (parentChoice == null) {
            return false;
        }
        List<String> outputObjectTypes = Arrays.asList("Annotation", "Detection");
        Map labels = classifier.getMetadata().getClassificationLabels();
        boolean includeIgnored = allIgnored = !labels.isEmpty() && labels.values().stream().allMatch(p -> p == null || PathClassTools.isIgnoredClass((PathClass)p));
        PixelCalibration cal = imageData.getServer().getPixelCalibration();
        String string = units = cal.unitsMatch2D() ? cal.getPixelWidthUnit() + "^2" : cal.getPixelWidthUnit() + "x" + cal.getPixelHeightUnit();
        if (lastCreateObjectParams != null) {
            params = lastCreateObjectParams.duplicate();
            params.setHiddenParameters(false, (String[])params.getKeyValueParameters(true).keySet().toArray(String[]::new));
            ((BooleanParameter)params.getParameters().get("includeIgnored")).setValue((Object)includeIgnored);
        } else {
            params = new ParameterList().addChoiceParameter("objectType", "New object type", (Object)"Annotation", outputObjectTypes, "Define the type of objects that will be created").addDoubleParameter("minSize", "Minimum object size", 0.0, units, "Minimum size of a region to keep (smaller regions will be dropped)").addDoubleParameter("minHoleSize", "Minimum hole size", 0.0, units, "Minimum size of a hole to keep (smaller holes will be filled)").addBooleanParameter("doSplit", "Split objects", false, "Split multi-part regions into separate objects").addBooleanParameter("clearExisting", "Delete existing objects", false, "Delete any existing objects within the selected object before adding new objects (or entire image if no object is selected)").addBooleanParameter("includeIgnored", "Create objects for ignored classes", includeIgnored, "Create objects for classifications that are usually ignored (e.g. \"Ignore*\", \"Region*\")").addBooleanParameter("selectNew", "Set new objects to selected", false, "Set the newly-created objects to be selected");
        }
        if (!GuiTools.showParameterDialog((String)"Create objects", (ParameterList)params)) {
            return false;
        }
        boolean createDetections = params.getChoiceParameterValue("objectType").equals("Detection");
        boolean doSplit = params.getBooleanParameterValue("doSplit");
        includeIgnored = params.getBooleanParameterValue("includeIgnored");
        double minSize = params.getDoubleParameterValue("minSize");
        double minHoleSize = params.getDoubleParameterValue("minHoleSize");
        boolean clearExisting = params.getBooleanParameterValue("clearExisting");
        boolean selectNew = params.getBooleanParameterValue("selectNew");
        lastCreateObjectParams = params;
        parentChoice.handleSelection(imageData);
        ArrayList<PixelClassifierTools.CreateObjectOptions> options = new ArrayList<PixelClassifierTools.CreateObjectOptions>();
        if (doSplit) {
            options.add(PixelClassifierTools.CreateObjectOptions.SPLIT);
        }
        if (clearExisting) {
            options.add(PixelClassifierTools.CreateObjectOptions.DELETE_EXISTING);
        }
        if (includeIgnored) {
            options.add(PixelClassifierTools.CreateObjectOptions.INCLUDE_IGNORED);
        } else if (allIgnored) {
            Dialogs.showErrorMessage((String)title, (String)"Cannot create objects - all class names have an asterisk to show they should be 'ignored'!");
            return false;
        }
        if (selectNew) {
            options.add(PixelClassifierTools.CreateObjectOptions.SELECT_NEW);
        }
        PixelClassifierTools.CreateObjectOptions[] optionsArray = (PixelClassifierTools.CreateObjectOptions[])options.toArray(PixelClassifierTools.CreateObjectOptions[]::new);
        Object optionsString = "";
        if (!options.isEmpty()) {
            optionsString = ", " + options.stream().map(o -> "\"" + o.name() + "\"").collect(Collectors.joining(", "));
        }
        try {
            if (createDetections) {
                if (PixelClassifierTools.createDetectionsFromPixelClassifier(imageData, (PixelClassifier)classifier, (double)minSize, (double)minHoleSize, (PixelClassifierTools.CreateObjectOptions[])optionsArray)) {
                    if (classifierName != null) {
                        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Pixel classifier create detections", String.format("createDetectionsFromPixelClassifier(\"%s\", %s, %s)", classifierName, minSize, minHoleSize + (String)optionsString)));
                    }
                    return true;
                }
            } else if (PixelClassifierTools.createAnnotationsFromPixelClassifier(imageData, (PixelClassifier)classifier, (double)minSize, (double)minHoleSize, (PixelClassifierTools.CreateObjectOptions[])optionsArray)) {
                if (classifierName != null) {
                    imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Pixel classifier create annotations", String.format("createAnnotationsFromPixelClassifier(\"%s\", %s, %s)", classifierName, minSize, minHoleSize + (String)optionsString)));
                }
                return true;
            }
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)title, (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static List<SelectionChoice> buildChoiceList(PathObjectHierarchy hierarchy, SelectionChoice ... validChoices) {
        ArrayList<SelectionChoice> choices = new ArrayList<SelectionChoice>();
        if (!hierarchy.getSelectionModel().noSelection()) {
            choices.add(SelectionChoice.CURRENT_SELECTION);
        }
        choices.add(SelectionChoice.FULL_IMAGE);
        Set classes = hierarchy.getFlattenedObjectList(null).stream().map(p -> p.getClass()).collect(Collectors.toSet());
        for (SelectionChoice choice : validChoices) {
            if (choice.getObjectClass() == null || !classes.contains(choice.getObjectClass())) continue;
            choices.add(choice);
        }
        return choices;
    }

    private static boolean promptToAddMeasurements(ImageData<BufferedImage> imageData, PixelClassifier classifier, String classifierName) {
        if (imageData == null) {
            GuiTools.showNoImageError((String)title);
            return false;
        }
        PathObjectHierarchy hierarchy = imageData.getHierarchy();
        List<SelectionChoice> choices = PixelClassifierUI.buildChoiceList(imageData.getHierarchy(), SelectionChoice.values());
        SelectionChoice defaultChoice = choices.contains((Object)SelectionChoice.CURRENT_SELECTION) ? SelectionChoice.CURRENT_SELECTION : (choices.contains((Object)SelectionChoice.ANNOTATIONS) ? SelectionChoice.ANNOTATIONS : choices.get(0));
        ParameterList params = new ParameterList().addStringParameter("id", "Measurement name", classifierName == null ? "Classifier" : classifierName, "Choose a base name for measurements - this helps distinguish between measurements from different classifiers").addChoiceParameter("choice", "Select objects", (Object)defaultChoice, choices, "Select the objects");
        if (!GuiTools.showParameterDialog((String)title, (ParameterList)params)) {
            return false;
        }
        String measurementID = params.getStringParameterValue("id");
        SelectionChoice selectionChoice = (SelectionChoice)((Object)params.getChoiceParameterValue("choice"));
        selectionChoice.handleSelection(imageData);
        Set<PathObject> objectsToMeasure = hierarchy.getSelectionModel().getSelectedObjects();
        int n = objectsToMeasure.size();
        if (objectsToMeasure.isEmpty()) {
            objectsToMeasure = Collections.singleton(hierarchy.getRootObject());
            logger.info("Requesting measurements for image");
        } else if (n == 1) {
            logger.info("Requesting measurements for one object");
        } else {
            logger.info("Requesting measurements for {} objects", (Object)n);
        }
        if (PixelClassifierTools.addMeasurementsToSelectedObjects(imageData, (PixelClassifier)classifier, (String)measurementID)) {
            if (classifierName != null) {
                Object idString = measurementID == null ? "null" : "\"" + measurementID + "\"";
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Pixel classifier measurements", String.format("addPixelClassifierMeasurements(\"%s\", %s)", classifierName, idString)));
            }
            return true;
        }
        return false;
    }

    private static enum SelectionChoice {
        CURRENT_SELECTION,
        ANNOTATIONS,
        DETECTIONS,
        CELLS,
        TILES,
        TMA,
        FULL_IMAGE;


        private void handleSelection(ImageData<?> imageData) {
            switch (this.ordinal()) {
                case 6: {
                    Commands.resetSelection(imageData);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    Commands.selectObjectsByClass(imageData, this.getObjectClass());
                    break;
                }
            }
        }

        private Class<? extends PathObject> getObjectClass() {
            switch (this.ordinal()) {
                case 1: {
                    return PathAnnotationObject.class;
                }
                case 3: {
                    return PathCellObject.class;
                }
                case 2: {
                    return PathDetectionObject.class;
                }
                case 5: {
                    return TMACoreObject.class;
                }
                case 4: {
                    return PathTileObject.class;
                }
            }
            return null;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 1: {
                    return "All annotations";
                }
                case 3: {
                    return "All cells";
                }
                case 0: {
                    return "Current selection";
                }
                case 2: {
                    return "All detections";
                }
                case 5: {
                    return "TMA cores";
                }
                case 6: {
                    return "Full image";
                }
                case 4: {
                    return "All tiles";
                }
            }
            throw new IllegalArgumentException("Unknown enum " + String.valueOf((Object)this));
        }
    }
}

