/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import ij.CompositeImage;
import ij.ImagePlus;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.TextAlignment;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.bytedeco.javacpp.indexer.FloatIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_ml.ANN_MLP;
import org.bytedeco.opencv.opencv_ml.KNearest;
import org.bytedeco.opencv.opencv_ml.LogisticRegression;
import org.bytedeco.opencv.opencv_ml.RTrees;
import org.bytedeco.opencv.opencv_ml.TrainData;
import org.controlsfx.control.ListSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.imagej.gui.IJExtension;
import qupath.imagej.tools.IJTools;
import qupath.lib.classifiers.Normalization;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.classifiers.pixel.PixelClassifierMetadata;
import qupath.lib.common.GeneralTools;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.commands.MiniViewers;
import qupath.lib.gui.dialogs.ProjectDialogs;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.prefs.PathPrefs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.RegionFilter;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.PathImage;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;
import qupath.opencv.ml.FeaturePreprocessor;
import qupath.opencv.ml.OpenCVClassifiers;
import qupath.opencv.ml.pixel.PixelClassifiers;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.ops.ImageDataServer;
import qupath.opencv.ops.ImageOp;
import qupath.opencv.ops.ImageOps;
import qupath.process.gui.commands.ml.BoundaryStrategy;
import qupath.process.gui.commands.ml.ClassificationResolution;
import qupath.process.gui.commands.ml.FeatureNormalization;
import qupath.process.gui.commands.ml.FeatureRenderer;
import qupath.process.gui.commands.ml.ImageDataTransformerBuilder;
import qupath.process.gui.commands.ml.PixelClassifierTraining;
import qupath.process.gui.commands.ml.PixelClassifierUI;

public class PixelClassifierPane {
    private static final Logger logger = LoggerFactory.getLogger(PixelClassifierPane.class);
    private static ObservableList<ImageDataTransformerBuilder> defaultFeatureCalculatorBuilders = FXCollections.observableArrayList();
    private QuPathGUI qupath;
    private GridPane pane;
    private ObservableList<ClassificationResolution> resolutions = FXCollections.observableArrayList();
    private ComboBox<ClassificationResolution> comboResolutions = new ComboBox(this.resolutions);
    private ReadOnlyObjectProperty<ClassificationResolution> selectedResolution;
    private ComboBox<String> comboDisplayFeatures = new ComboBox();
    private Slider sliderFeatureOpacity = new Slider(0.0, 1.0, 1.0);
    private Spinner<Double> spinFeatureMin = FXUtils.createDynamicStepSpinner((double)-1.7976931348623157E308, (double)Double.MAX_VALUE, (double)0.0, (double)0.1, (int)1);
    private Spinner<Double> spinFeatureMax = FXUtils.createDynamicStepSpinner((double)-1.7976931348623157E308, (double)Double.MAX_VALUE, (double)1.0, (double)0.1, (int)1);
    private String DEFAULT_CLASSIFICATION_OVERLAY = "Show classification";
    private List<ProjectImageEntry<BufferedImage>> trainingEntries = new ArrayList<ProjectImageEntry<BufferedImage>>();
    private Map<ProjectImageEntry<BufferedImage>, ImageData<BufferedImage>> trainingMap = new WeakHashMap<ProjectImageEntry<BufferedImage>, ImageData<BufferedImage>>();
    private MiniViewers.MiniViewerManager miniViewer;
    private BooleanProperty livePrediction = new SimpleBooleanProperty(false);
    private ReadOnlyObjectProperty<OpenCVClassifiers.OpenCVStatModel> selectedClassifier;
    private ReadOnlyObjectProperty<ImageDataTransformerBuilder> selectedFeatureCalculatorBuilder;
    private ReadOnlyObjectProperty<ImageServerMetadata.ChannelType> selectedOutputType;
    private StringProperty cursorLocation = new SimpleStringProperty();
    private PieChart pieChart;
    private HierarchyListener hierarchyListener = new HierarchyListener();
    private ObjectProperty<PixelClassifier> currentClassifier = new SimpleObjectProperty();
    private PixelClassificationOverlay overlay;
    private PixelClassificationOverlay featureOverlay;
    private FeatureRenderer featureRenderer;
    private ChangeListener<ImageData<BufferedImage>> imageDataListener = this::handleImageDataChange;
    private Stage stage;
    private MouseListener mouseListener = new MouseListener();
    private PixelClassifierTraining helper;
    private FeatureNormalization normalization = new FeatureNormalization();
    private ImageOp preprocessingOp = null;
    private boolean reweightSamples = false;
    private int maxSamples = 100000;
    private int rngSeed = 100;
    private IntegerProperty nThreads = PathPrefs.createPersistentPreference((String)"pixelClassificationThreads", (int)-1);

    private void handleImageDataChange(ObservableValue<? extends ImageData<BufferedImage>> observable, ImageData<BufferedImage> oldValue, ImageData<BufferedImage> newValue) {
        if (oldValue != null) {
            oldValue.getHierarchy().removeListener((PathObjectHierarchyListener)this.hierarchyListener);
        }
        if (newValue != null) {
            newValue.getHierarchy().addListener((PathObjectHierarchyListener)this.hierarchyListener);
        }
        this.updateTitle();
        this.updateAvailableResolutions(newValue);
    }

    public PixelClassifierPane(QuPathGUI qupath) {
        this.qupath = qupath;
        this.helper = new PixelClassifierTraining(null);
        this.featureRenderer = new FeatureRenderer(qupath.getImageRegionStore());
        this.initialize();
    }

    private void initialize() {
        ImageData imageData = this.qupath.getImageData();
        int row = 0;
        this.pane = new GridPane();
        Label labelClassifier = new Label("Classifier");
        ComboBox comboClassifier = new ComboBox();
        labelClassifier.setLabelFor((Node)comboClassifier);
        this.selectedClassifier = comboClassifier.getSelectionModel().selectedItemProperty();
        this.selectedClassifier.addListener((v, o, n) -> this.updateClassifier());
        Button btnEditClassifier = new Button("Edit");
        btnEditClassifier.setOnAction(e -> this.editClassifierParameters());
        btnEditClassifier.disableProperty().bind((ObservableValue)this.selectedClassifier.isNull());
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose classifier type (RTrees or ANN_MLP are generally good choices)", (Node[])new Node[]{labelClassifier, comboClassifier, comboClassifier, btnEditClassifier});
        Label labelResolution = new Label("Resolution");
        labelResolution.setLabelFor(this.comboResolutions);
        Button btnResolution = new Button("Add");
        btnResolution.setOnAction(e -> this.addResolution());
        this.selectedResolution = this.comboResolutions.getSelectionModel().selectedItemProperty();
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose the base image resolution based upon required detail in the classification (see preview on the right)", (Node[])new Node[]{labelResolution, this.comboResolutions, this.comboResolutions, btnResolution});
        Label labelFeatures = new Label("Features");
        ComboBox comboFeatures = new ComboBox();
        comboFeatures.getItems().add((Object)new ImageDataTransformerBuilder.DefaultFeatureCalculatorBuilder((ImageData<BufferedImage>)imageData));
        labelFeatures.setLabelFor((Node)comboFeatures);
        this.selectedFeatureCalculatorBuilder = comboFeatures.getSelectionModel().selectedItemProperty();
        Button btnShowFeatures = new Button("Show");
        btnShowFeatures.setOnAction(e -> this.showFeatures());
        Button btnCustomizeFeatures = new Button("Edit");
        btnCustomizeFeatures.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            ImageDataTransformerBuilder calc = (ImageDataTransformerBuilder)this.selectedFeatureCalculatorBuilder.get();
            return calc == null || !calc.canCustomize((ImageData<BufferedImage>)imageData);
        }, (Observable[])new Observable[]{this.selectedFeatureCalculatorBuilder}));
        btnCustomizeFeatures.setOnAction(e -> {
            if (((ImageDataTransformerBuilder)this.selectedFeatureCalculatorBuilder.get()).doCustomize((ImageData<BufferedImage>)imageData)) {
                this.updateFeatureCalculator();
            }
        });
        comboFeatures.getItems().addAll(defaultFeatureCalculatorBuilders);
        comboFeatures.getSelectionModel().select(0);
        comboFeatures.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateFeatureCalculator());
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Select features for the classifier", (Node[])new Node[]{labelFeatures, comboFeatures, btnCustomizeFeatures, btnShowFeatures});
        Label labelOutput = new Label("Output");
        ComboBox comboOutput = new ComboBox();
        comboOutput.getItems().addAll((Object[])new ImageServerMetadata.ChannelType[]{ImageServerMetadata.ChannelType.CLASSIFICATION, ImageServerMetadata.ChannelType.PROBABILITY});
        this.selectedOutputType = comboOutput.getSelectionModel().selectedItemProperty();
        this.selectedOutputType.addListener((v, o, n) -> this.updateClassifier());
        comboOutput.getSelectionModel().clearAndSelect(0);
        Button btnShowOutput = new Button("Show");
        btnShowOutput.setOnAction(e -> this.showOutput());
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose whether to output classifications only, or estimated probabilities per class (not all classifiers support probabilities, which also require more memory)", (Node[])new Node[]{labelOutput, comboOutput, comboOutput, btnShowOutput});
        Label labelRegion = new Label("Region");
        ComboBox<RegionFilter> comboRegionFilter = PixelClassifierUI.createRegionFilterCombo(this.qupath.getOverlayOptions());
        GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Control where the pixel classification is applied during preview", (Node[])new Node[]{labelRegion, comboRegionFilter, comboRegionFilter, comboRegionFilter});
        Button btnAdvancedOptions = new Button("Advanced options");
        btnAdvancedOptions.setTooltip(new Tooltip("Advanced options to customize preprocessing and classifier behavior"));
        btnAdvancedOptions.setOnAction(e -> {
            if (this.showAdvancedOptions()) {
                this.updateClassifier();
            }
        });
        Button btnProject = new Button("Load training");
        btnProject.setTooltip(new Tooltip("Train using annotations from more images in the current project"));
        btnProject.setOnAction(e -> {
            if (this.promptToLoadTrainingImages()) {
                this.updateClassifier();
                int n = this.trainingEntries.size();
                if (n > 0) {
                    btnProject.setText("Load training (" + n + ")");
                } else {
                    btnProject.setText("Load training");
                }
            }
        });
        btnProject.disableProperty().bind((ObservableValue)this.qupath.projectProperty().isNull());
        ToggleButton btnLive = new ToggleButton("Live prediction");
        btnLive.selectedProperty().bindBidirectional((Property)this.livePrediction);
        btnLive.setTooltip(new Tooltip("Toggle whether to calculate classification 'live' while viewing the image"));
        this.livePrediction.addListener((v, o, n) -> {
            if (this.overlay == null) {
                if (n.booleanValue()) {
                    this.updateClassifier((boolean)n);
                    return;
                }
            } else {
                this.overlay.setLivePrediction(n.booleanValue());
            }
            if (this.featureOverlay != null) {
                this.featureOverlay.setLivePrediction(n.booleanValue());
            }
        });
        GridPane panePredict = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnProject, btnAdvancedOptions});
        this.pane.add((Node)panePredict, 0, row++, this.pane.getColumnCount(), 1);
        this.pane.add((Node)btnLive, 0, row++, this.pane.getColumnCount(), 1);
        this.pieChart = new PieChart();
        this.pieChart.getStyleClass().add((Object)"training-chart");
        this.pieChart.setAnimated(false);
        this.pieChart.setLabelsVisible(false);
        this.pieChart.setLegendVisible(true);
        this.pieChart.setMinSize(40.0, 40.0);
        this.pieChart.setPrefSize(120.0, 120.0);
        this.pieChart.setLegendSide(Side.RIGHT);
        BorderPane paneChart = new BorderPane((Node)this.pieChart);
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{paneChart});
        GridPaneUtils.setFillHeight((Boolean)Boolean.TRUE, (Node[])new Node[]{paneChart});
        GridPaneUtils.setVGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{paneChart});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{paneChart});
        this.pane.add((Node)paneChart, 0, row++, this.pane.getColumnCount(), 1);
        Label labelCursor = new Label();
        labelCursor.textProperty().bindBidirectional((Property)this.cursorLocation);
        labelCursor.setAlignment(Pos.CENTER);
        labelCursor.setTextAlignment(TextAlignment.CENTER);
        labelCursor.setContentDisplay(ContentDisplay.CENTER);
        labelCursor.setWrapText(true);
        labelCursor.setMaxHeight(Double.MAX_VALUE);
        labelCursor.setMinWidth(100.0);
        labelCursor.setPrefWidth(390.0);
        labelCursor.setMaxWidth(390.0);
        labelCursor.setTooltip(new Tooltip("Prediction for current cursor location"));
        paneChart.setBottom((Node)labelCursor);
        paneChart.setMaxWidth(400.0);
        comboClassifier.getItems().addAll((Object[])new OpenCVClassifiers.OpenCVStatModel[]{OpenCVClassifiers.createStatModel(RTrees.class), OpenCVClassifiers.createStatModel(ANN_MLP.class), OpenCVClassifiers.createStatModel(LogisticRegression.class), OpenCVClassifiers.createStatModel(KNearest.class)});
        comboClassifier.getSelectionModel().clearAndSelect(1);
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{this.comboResolutions, comboClassifier, comboFeatures});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{this.comboResolutions, comboClassifier, comboFeatures});
        this.miniViewer = MiniViewers.createManager((QuPathViewer)this.qupath.getViewer());
        GridPane viewerPane = this.miniViewer.getPane();
        Tooltip.install((Node)viewerPane, (Tooltip)new Tooltip("View image at classification resolution"));
        this.updateAvailableResolutions((ImageData<BufferedImage>)imageData);
        this.selectedResolution.addListener((v, o, n) -> {
            this.updateResolution((ClassificationResolution)n);
            this.updateClassifier();
            this.ensureOverlaySet();
        });
        if (!this.comboResolutions.getItems().isEmpty()) {
            this.comboResolutions.getSelectionModel().clearAndSelect(this.resolutions.size() / 2);
        }
        this.pane.setHgap(5.0);
        this.pane.setVgap(6.0);
        SimpleStringProperty classifierName = new SimpleStringProperty(null);
        GridPane panePostProcess = GridPaneUtils.createRowGrid((Node[])new Node[]{PixelClassifierUI.createSavePixelClassifierPane((ObjectExpression<Project<BufferedImage>>)this.qupath.projectProperty(), this.currentClassifier, (StringProperty)classifierName), PixelClassifierUI.createPixelClassifierButtons((ObjectExpression<ImageData<BufferedImage>>)this.qupath.imageDataProperty(), this.currentClassifier, (StringExpression)classifierName)});
        panePostProcess.setVgap(5.0);
        this.pane.add((Node)panePostProcess, 0, row++, this.pane.getColumnCount(), 1);
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])((Region[])this.pane.getChildren().stream().filter(p -> p instanceof Region).toArray(Region[]::new)));
        BorderPane viewerBorderPane = new BorderPane((Node)viewerPane);
        this.comboDisplayFeatures.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.ensureOverlaySet());
        this.comboDisplayFeatures.setMaxWidth(Double.MAX_VALUE);
        this.spinFeatureMin.setPrefWidth(100.0);
        this.spinFeatureMax.setPrefWidth(100.0);
        this.spinFeatureMin.valueProperty().addListener((v, o, n) -> this.updateFeatureDisplayRange());
        this.spinFeatureMax.valueProperty().addListener((v, o, n) -> this.updateFeatureDisplayRange());
        this.sliderFeatureOpacity.valueProperty().addListener((v, o, n) -> {
            if (this.featureOverlay != null) {
                this.featureOverlay.setOpacity(n.doubleValue());
            }
            if (this.overlay != null) {
                this.overlay.setOpacity(n.doubleValue());
            }
            this.qupath.getViewerManager().repaintAllViewers();
        });
        Button btnFeatureAuto = new Button("Auto");
        btnFeatureAuto.setOnAction(e -> this.autoFeatureContrast());
        this.comboDisplayFeatures.getItems().setAll((Object[])new String[]{this.DEFAULT_CLASSIFICATION_OVERLAY});
        this.comboDisplayFeatures.getSelectionModel().select((Object)this.DEFAULT_CLASSIFICATION_OVERLAY);
        BooleanBinding featureDisableBinding = this.comboDisplayFeatures.valueProperty().isEqualTo((Object)this.DEFAULT_CLASSIFICATION_OVERLAY).or((ObservableBooleanValue)this.comboDisplayFeatures.valueProperty().isNull());
        btnFeatureAuto.disableProperty().bind((ObservableValue)featureDisableBinding);
        btnFeatureAuto.setMaxHeight(Double.MAX_VALUE);
        this.spinFeatureMin.disableProperty().bind((ObservableValue)featureDisableBinding);
        this.spinFeatureMin.setEditable(true);
        FXUtils.restrictTextFieldInputToNumber((TextField)this.spinFeatureMin.getEditor(), (boolean)true);
        FXUtils.resetSpinnerNullToPrevious(this.spinFeatureMin);
        this.spinFeatureMax.disableProperty().bind((ObservableValue)featureDisableBinding);
        this.spinFeatureMax.setEditable(true);
        FXUtils.restrictTextFieldInputToNumber((TextField)this.spinFeatureMax.getEditor(), (boolean)true);
        FXUtils.resetSpinnerNullToPrevious(this.spinFeatureMax);
        GridPane paneFeatures = new GridPane();
        this.spinFeatureMax.setTooltip(new Tooltip("Choose classification result or feature overlay to display (Warning: This requires a lot of memory & computation!)"));
        this.spinFeatureMin.setTooltip(new Tooltip("Min display value for feature overlay"));
        this.spinFeatureMax.setTooltip(new Tooltip("Max display value for feature overlay"));
        this.sliderFeatureOpacity.setTooltip(new Tooltip("Adjust classification/feature overlay opacity"));
        GridPaneUtils.addGridRow((GridPane)paneFeatures, (int)0, (int)0, null, (Node[])new Node[]{this.comboDisplayFeatures, this.comboDisplayFeatures, this.comboDisplayFeatures, this.comboDisplayFeatures});
        GridPaneUtils.addGridRow((GridPane)paneFeatures, (int)1, (int)0, null, (Node[])new Node[]{this.sliderFeatureOpacity, this.spinFeatureMin, this.spinFeatureMax, btnFeatureAuto});
        var factory = new Callback<ListView<String>, ListCell<String>>(this){

            public ListCell<String> call(ListView<String> param) {
                ListCell<String> listCell = new ListCell<String>(this){

                    public void updateItem(String value, boolean empty) {
                        super.updateItem((Object)value, empty);
                        if (value == null || empty) {
                            this.setText(null);
                        } else {
                            this.setText(value);
                        }
                    }
                };
                listCell.setTextOverrun(OverrunStyle.ELLIPSIS);
                return listCell;
            }
        };
        this.comboDisplayFeatures.setCellFactory((Callback)factory);
        this.comboDisplayFeatures.setButtonCell(factory.call(null));
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{this.comboDisplayFeatures, this.sliderFeatureOpacity});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{this.comboDisplayFeatures, this.sliderFeatureOpacity});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{this.comboDisplayFeatures, this.sliderFeatureOpacity});
        paneFeatures.setHgap(5.0);
        paneFeatures.setVgap(5.0);
        paneFeatures.setPadding(new Insets(5.0));
        paneFeatures.prefWidthProperty().bind((ObservableValue)viewerBorderPane.prefWidthProperty());
        viewerBorderPane.setBottom((Node)paneFeatures);
        BorderPane splitPane = new BorderPane((Node)viewerBorderPane);
        splitPane.setLeft((Node)this.pane);
        this.pane.setMinWidth(400.0);
        BorderPane fullPane = splitPane;
        this.pane.setPadding(new Insets(5.0));
        this.stage = new Stage();
        this.stage.setScene(new Scene((Parent)fullPane));
        this.stage.setMinHeight(400.0);
        this.stage.setMinWidth(600.0);
        this.stage.sizeToScene();
        this.stage.initOwner((Window)QuPathGUI.getInstance().getStage());
        this.updateTitle();
        this.updateFeatureCalculator();
        GridPaneUtils.setMinWidth((double)Double.NEGATIVE_INFINITY, (Region[])((Region[])FXUtils.getContentsOfType((Parent)this.stage.getScene().getRoot(), Region.class, (boolean)true).toArray(Region[]::new)));
        comboRegionFilter.setPrefWidth(100.0);
        this.stage.show();
        this.stage.setOnCloseRequest(e -> this.destroy());
        this.qupath.getStage().addEventFilter(MouseEvent.MOUSE_MOVED, (EventHandler)this.mouseListener);
        this.qupath.imageDataProperty().addListener(this.imageDataListener);
        if (this.qupath.getImageData() != null) {
            this.qupath.getImageData().getHierarchy().addListener((PathObjectHierarchyListener)this.hierarchyListener);
        }
        this.stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                    PathOverlay currentOverlay = viewer.getCustomPixelLayerOverlay();
                    if (currentOverlay == this.featureOverlay || currentOverlay == this.overlay) continue;
                    this.ensureOverlaySet();
                    break;
                }
            }
        });
        this.nThreads.addListener((v, o, n) -> {
            if (n == null) {
                return;
            }
            if (this.overlay != null) {
                this.overlay.setMaxThreads(n.intValue());
            }
            if (this.featureOverlay != null) {
                this.featureOverlay.setMaxThreads(n.intValue());
            }
        });
    }

    private Collection<ImageData<BufferedImage>> getTrainingImageData() {
        ImageData imageData = this.qupath.getImageData();
        if (imageData == null) {
            logger.warn("Cannot train classifier - a valid image needs to be open in the current viewer");
            return Collections.emptyList();
        }
        ArrayList<ImageData<BufferedImage>> list = new ArrayList<ImageData<BufferedImage>>();
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            ImageData tempData = viewer.getImageData();
            if (tempData == null || !PixelClassifierPane.compatibleChannels(imageData.getServer(), tempData.getServer())) continue;
            list.add((ImageData<BufferedImage>)tempData);
        }
        if (!this.trainingEntries.isEmpty()) {
            Collection currentEntries = ProjectDialogs.getCurrentImages((QuPathGUI)this.qupath);
            for (ProjectImageEntry<BufferedImage> entry : this.trainingEntries) {
                try {
                    ImageData<BufferedImage> tempData;
                    if (currentEntries.contains(entry)) {
                        logger.debug("Will not load data for {} - will use the training annotations from the open viewer", entry);
                        tempData = this.trainingMap.remove(entry);
                        if (tempData == null) continue;
                        tempData.getServer().close();
                        continue;
                    }
                    tempData = this.trainingMap.get(entry);
                    if (tempData == null) {
                        tempData = entry.readImageData();
                        this.trainingMap.put(entry, tempData);
                    }
                    if (!PixelClassifierPane.compatibleChannels(imageData.getServer(), tempData.getServer())) continue;
                    list.add(tempData);
                }
                catch (Exception e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return list;
    }

    private static boolean compatibleChannels(ImageServer<?> server, ImageServer<?> server2) {
        if (server == server2) {
            return true;
        }
        if (server.nChannels() != server2.nChannels()) {
            return false;
        }
        for (int c = 0; c < server.nChannels(); ++c) {
            if (server.getChannel(c).getName().equals(server2.getChannel(c).getName())) continue;
            return false;
        }
        return true;
    }

    public static synchronized boolean installDefaultFeatureClassificationBuilder(ImageDataTransformerBuilder builder) {
        if (!defaultFeatureCalculatorBuilders.contains((Object)builder)) {
            defaultFeatureCalculatorBuilders.add((Object)builder);
            return true;
        }
        return false;
    }

    private void updateTitle() {
        if (this.stage == null) {
            return;
        }
        this.stage.setTitle("Train pixel classifier");
    }

    private void updateAvailableResolutions(ImageData<BufferedImage> imageData) {
        ClassificationResolution selected = (ClassificationResolution)this.selectedResolution.get();
        if (imageData == null) {
            return;
        }
        List<ClassificationResolution> requestedResolutions = ClassificationResolution.getDefaultResolutions(imageData, selected);
        if (!this.resolutions.equals(requestedResolutions)) {
            this.resolutions.setAll(ClassificationResolution.getDefaultResolutions(imageData, selected));
            this.comboResolutions.getSelectionModel().select((Object)selected);
        }
    }

    private void updateFeatureCalculator() {
        int nFeatures;
        PixelCalibration cal = this.getSelectedResolution();
        ImageData imageData = this.qupath.getImageData();
        ImageDataTransformerBuilder featureOpBuilder = (ImageDataTransformerBuilder)this.selectedFeatureCalculatorBuilder.get();
        ImageDataOp featureOp = featureOpBuilder.build((ImageData<BufferedImage>)imageData, cal);
        if (featureOpBuilder instanceof ImageDataTransformerBuilder.DefaultFeatureCalculatorBuilder && (nFeatures = featureOp.getChannels(imageData).size()) > 512) {
            Dialogs.showErrorNotification((String)"Pixel classifier", (String)("Too many features! Requested " + featureOp.getChannels(imageData).size() + " but maximum is 512.\nFeatures will not be updated - please select a smaller number and continue training."));
            return;
        }
        this.helper.setFeatureOp(featureOp);
        ImageDataServer<BufferedImage> featureServer = this.helper.getFeatureServer((ImageData<BufferedImage>)imageData);
        if (featureServer == null) {
            this.comboDisplayFeatures.getItems().setAll((Object[])new String[]{this.DEFAULT_CLASSIFICATION_OVERLAY});
        } else {
            ArrayList<String> featureNames = new ArrayList<String>();
            featureNames.add(this.DEFAULT_CLASSIFICATION_OVERLAY);
            for (ImageChannel channel : featureServer.getMetadata().getChannels()) {
                featureNames.add(channel.getName());
            }
            this.comboDisplayFeatures.getItems().setAll(featureNames);
        }
        this.comboDisplayFeatures.getSelectionModel().select((Object)this.DEFAULT_CLASSIFICATION_OVERLAY);
        this.updateClassifier();
    }

    private void autoFeatureContrast() {
        DirectServerChannelInfo selectedChannel;
        DirectServerChannelInfo directServerChannelInfo = selectedChannel = this.featureRenderer == null ? null : this.featureRenderer.getSelectedChannel();
        if (selectedChannel != null) {
            this.featureRenderer.autoSetDisplayRange();
            double min = selectedChannel.getMinDisplay();
            double max = selectedChannel.getMaxDisplay();
            this.spinFeatureMin.getValueFactory().setValue((Object)min);
            this.spinFeatureMax.getValueFactory().setValue((Object)max);
        }
    }

    private void ensureOverlaySet() {
        if (this.featureOverlay != null) {
            this.featureOverlay.stop();
            this.featureOverlay = null;
        }
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            if (viewer.getCustomPixelLayerOverlay() != this.featureOverlay) continue;
            viewer.resetCustomPixelLayerOverlay();
        }
        ImageData imageData = this.qupath.getImageData();
        if (imageData == null) {
            return;
        }
        String featureName = (String)this.comboDisplayFeatures.getSelectionModel().getSelectedItem();
        if (this.DEFAULT_CLASSIFICATION_OVERLAY.equals(featureName)) {
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                viewer.setCustomPixelLayerOverlay((PathOverlay)this.overlay);
            }
            return;
        }
        int channel = -1;
        ImageDataServer<BufferedImage> featureServer = this.helper.getFeatureServer((ImageData<BufferedImage>)imageData);
        if (featureServer != null && featureName != null) {
            for (int c = 0; c < featureServer.nChannels(); ++c) {
                if (!featureName.equals(featureServer.getChannel(c).getName())) continue;
                channel = c;
                break;
            }
            if (channel >= 0) {
                this.featureRenderer.setChannel((ImageServer<BufferedImage>)featureServer, channel, (Double)this.spinFeatureMin.getValue(), (Double)this.spinFeatureMax.getValue());
                this.featureOverlay = PixelClassificationOverlay.create((OverlayOptions)this.qupath.getOverlayOptions(), data -> this.helper.getFeatureServer((ImageData<BufferedImage>)data), (ImageRenderer)this.featureRenderer);
                this.featureOverlay.setMaxThreads(this.getLivePredictionThreads());
                this.featureOverlay.setLivePrediction(true);
                this.featureOverlay.setOpacity(this.sliderFeatureOpacity.getValue());
                this.featureOverlay.setLivePrediction(this.livePrediction.get());
                this.autoFeatureContrast();
            }
        }
        if (this.featureOverlay != null) {
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                viewer.setCustomPixelLayerOverlay((PathOverlay)this.featureOverlay);
            }
        }
    }

    int getLivePredictionThreads() {
        int n = this.nThreads.get();
        return n < 0 ? PathPrefs.numCommandThreadsProperty().get() : Math.max(n, 1);
    }

    private void updateFeatureDisplayRange() {
        if (this.featureRenderer == null || this.spinFeatureMin.getValue() == null || this.spinFeatureMax.getValue() == null) {
            return;
        }
        this.featureRenderer.setRange((Double)this.spinFeatureMin.getValue(), (Double)this.spinFeatureMax.getValue());
        this.qupath.getViewerManager().repaintAllViewers();
    }

    private void updateClassifier() {
        this.updateClassifier(this.livePrediction.get());
    }

    private void updateClassifier(boolean doClassification) {
        if (doClassification) {
            this.doClassification();
        } else {
            this.replaceOverlay(null);
        }
    }

    private boolean showAdvancedOptions() {
        ParameterList params;
        BoundaryStrategy existingStrategy = this.helper.getBoundaryStrategy();
        ArrayList<BoundaryStrategy> boundaryStrategies = new ArrayList<BoundaryStrategy>();
        boundaryStrategies.add(BoundaryStrategy.getSkipBoundaryStrategy());
        boundaryStrategies.add(BoundaryStrategy.getDerivedBoundaryStrategy(1.0));
        for (PathClass pathClass : QuPathGUI.getInstance().getAvailablePathClasses()) {
            boundaryStrategies.add(BoundaryStrategy.getClassifyBoundaryStrategy(pathClass, 1.0));
        }
        String PCA_NONE = "No feature reduction";
        String PCA_BASIC = "Do PCA projection";
        String PCA_NORM = "Do PCA projection + normalize output";
        String pcaChoice = PCA_NONE;
        if (this.normalization.getPCARetainedVariance() > 0.0) {
            pcaChoice = this.normalization.doPCANormalize() ? PCA_NORM : PCA_BASIC;
        }
        if (!GuiTools.showParameterDialog((String)"Advanced options", (ParameterList)(params = new ParameterList().addTitleParameter("Live prediction").addIntParameter("numThreads", "Number of threads", this.nThreads.get(), null, "Maximum number of threads to use for live prediction, or -1 to use default threads").addTitleParameter("Training data").addIntParameter("maxSamples", "Maximum samples", this.maxSamples, null, "Maximum number of training samples - only needed if you have a lot of annotations, slowing down training").addIntParameter("rngSeed", "RNG seed", this.rngSeed, null, "Seed for the random number generator used when selecting training samples").addBooleanParameter("reweightSamples", "Reweight samples", this.reweightSamples, "Weight training samples according to frequency").addTitleParameter("Preprocessing").addChoiceParameter("normalization", "Feature normalization", (Object)this.normalization.getNormalization(), Arrays.asList(Normalization.values()), "Method to normalize features - use only if needed, may make no difference with some common classifiers").addChoiceParameter("featureReduction", "Feature reduction", (Object)pcaChoice, List.of(PCA_NONE, PCA_BASIC, PCA_NORM), "Use Principal Component Analysis for feature reduction (must also specify retained variance)").addDoubleParameter("pcaRetainedVariance", "PCA retained variance", this.normalization.getPCARetainedVariance(), "", "Retained variance if applying Principal Component Analysis for dimensionality reduction. Should be between 0 and 1; if <= 0 PCA will not be applied.").addTitleParameter("Annotation boundaries").addChoiceParameter("boundaryStrategy", "Boundary strategy", (Object)this.helper.getBoundaryStrategy(), boundaryStrategies, "Choose how annotation boundaries should influence classifier training").addDoubleParameter("boundaryThickness", "Boundary thickness", existingStrategy.getBoundaryThickness(), "pixels", "Set the boundary thickness whenever annotation boundaries are trained separately")))) {
            return false;
        }
        this.reweightSamples = params.getBooleanParameterValue("reweightSamples");
        this.maxSamples = params.getIntParameterValue("maxSamples");
        this.rngSeed = params.getIntParameterValue("rngSeed");
        pcaChoice = (String)params.getChoiceParameterValue("featureReduction");
        boolean pcaNormalize = PCA_NORM.equals(pcaChoice);
        double pcaRetainedVariance = PCA_NONE.equals(pcaChoice) ? 0.0 : params.getDoubleParameterValue("pcaRetainedVariance");
        this.normalization.setNormalization((Normalization)params.getChoiceParameterValue("normalization"));
        this.normalization.setPCARetainedVariance(pcaRetainedVariance);
        this.normalization.setPCANormalize(pcaNormalize);
        this.nThreads.set(params.getIntParameterValue("numThreads").intValue());
        BoundaryStrategy strategy = (BoundaryStrategy)params.getChoiceParameterValue("boundaryStrategy");
        strategy = BoundaryStrategy.setThickness(strategy, params.getDoubleParameterValue("boundaryThickness"));
        this.helper.setBoundaryStrategy(strategy);
        return true;
    }

    private void doClassification() {
        OpenCVClassifiers.RTreesClassifier trees;
        PixelClassifierTraining.ClassifierTrainingData trainingData;
        ImageData imageData = this.qupath.getImageData();
        if (imageData == null && !this.qupath.getAllViewers().stream().anyMatch(v -> v.getImageData() != null)) {
            logger.debug("doClassification() called, but no images are open");
            return;
        }
        OpenCVClassifiers.OpenCVStatModel model = (OpenCVClassifiers.OpenCVStatModel)this.selectedClassifier.get();
        if (model == null) {
            Dialogs.showErrorNotification((String)"Pixel classifier", (String)"No classifier selected!");
            return;
        }
        try {
            Collection<ImageData<BufferedImage>> trainingImages = this.getTrainingImageData();
            if (trainingImages.size() > 1) {
                logger.info("Creating training data from {} images", (Object)trainingImages.size());
            }
            trainingData = this.helper.createTrainingData(trainingImages);
        }
        catch (Exception e) {
            logger.error("Error when updating training data", (Throwable)e);
            return;
        }
        if (trainingData == null) {
            this.resetPieChart();
            return;
        }
        opencv_core.setRNGSeed((int)this.rngSeed);
        int actualMaxSamples = this.maxSamples;
        TrainData trainData = trainingData.getTrainData();
        if (actualMaxSamples > 0 && trainData.getNTrainSamples() > actualMaxSamples) {
            trainData.setTrainTestSplit(actualMaxSamples, true);
        } else {
            trainData.shuffleTrainTest();
        }
        FeaturePreprocessor preprocessor = this.normalization.build(trainData.getTrainSamples(), false);
        this.preprocessingOp = preprocessor.doesSomething() ? ImageOps.ML.preprocessor((FeaturePreprocessor)preprocessor) : null;
        Map<PathClass, Integer> labels = trainingData.getLabelMap();
        Mat targets = trainData.getTrainResponses();
        IntBuffer buffer = (IntBuffer)targets.createBuffer();
        int n = (int)targets.total();
        int[] rawCounts = new int[labels.size()];
        for (int i = 0; i < n; ++i) {
            int n2 = buffer.get(i);
            rawCounts[n2] = rawCounts[n2] + 1;
        }
        LinkedHashMap<PathClass, Integer> counts = new LinkedHashMap<PathClass, Integer>();
        for (Map.Entry<PathClass, Integer> entry : labels.entrySet()) {
            counts.put(entry.getKey(), rawCounts[entry.getValue()]);
        }
        this.updatePieChart(counts);
        Mat weights = null;
        if (this.reweightSamples) {
            int i;
            weights = new Mat(n, 1, opencv_core.CV_32FC1);
            FloatIndexer bufferWeights = (FloatIndexer)weights.createIndexer();
            float[] weightArray = new float[rawCounts.length];
            for (i = 0; i < weightArray.length; ++i) {
                int c2 = rawCounts[i];
                weightArray[i] = c2 == 0 ? 1.0f : (float)n / (float)c2;
            }
            for (i = 0; i < n; ++i) {
                int label = buffer.get(i);
                bufferWeights.put((long)i, weightArray[label]);
            }
            bufferWeights.release();
        }
        Mat trainSamples = trainData.getTrainSamples();
        Mat trainResponses = trainData.getTrainResponses();
        preprocessor.apply(trainSamples, false);
        trainData = model.createTrainData(trainSamples, trainResponses, weights, false);
        logger.info("Training data: {} x {}, Target data: {} x {}", new Object[]{trainSamples.rows(), trainSamples.cols(), trainResponses.rows(), trainResponses.cols()});
        model.train(trainData);
        Mat test = trainData.getTestSamples();
        String testSet = "HELD-OUT TRAINING SET";
        if (test.empty()) {
            test = trainSamples;
            testSet = "TRAINING SET";
        } else {
            preprocessor.apply(test, false);
            buffer = (IntBuffer)trainData.getTestNormCatResponses().createBuffer();
        }
        Mat testResults = new Mat();
        model.predict(test, testResults, null);
        IntBuffer bufferResults = (IntBuffer)testResults.createBuffer();
        int nTest = testResults.rows();
        int nCorrect = 0;
        for (int i = 0; i < nTest; ++i) {
            if (bufferResults.get(i) != buffer.get(i)) continue;
            ++nCorrect;
        }
        logger.info("Current accuracy on the {}: {} %", (Object)testSet, (Object)GeneralTools.formatNumber((double)((double)nCorrect * 100.0 / (double)n), (int)1));
        if (model instanceof OpenCVClassifiers.RTreesClassifier && (trees = (OpenCVClassifiers.RTreesClassifier)model).hasFeatureImportance() && imageData != null) {
            PixelClassifierPane.logVariableImportance(trees, this.helper.getFeatureOp().getChannels(imageData).stream().map(c -> c.getName()).toList());
        }
        trainData.close();
        ImageDataOp featureCalculator = this.helper.getFeatureOp();
        if (this.preprocessingOp != null) {
            featureCalculator = featureCalculator.appendOps(new ImageOp[]{this.preprocessingOp});
        }
        int inputWidth = 512;
        int inputHeight = 512;
        PixelCalibration cal = this.helper.getResolution();
        ImageServerMetadata.ChannelType channelType = ImageServerMetadata.ChannelType.CLASSIFICATION;
        if (model.supportsProbabilities()) {
            channelType = (ImageServerMetadata.ChannelType)this.selectedOutputType.get();
        }
        TreeMap<Integer, PathClass> labels2 = new TreeMap<Integer, PathClass>();
        for (Map.Entry<PathClass, Integer> entry : labels.entrySet()) {
            PathClass previous = labels2.put(entry.getValue(), entry.getKey());
            if (previous == null) continue;
            logger.warn("Duplicate label found! {} matches with {} and {}, only the latter be used", new Object[]{entry.getValue(), previous, entry.getKey()});
        }
        List channels = ServerTools.classificationLabelsToChannels(labels2, (boolean)true);
        PixelClassifierMetadata metadata = new PixelClassifierMetadata.Builder().inputResolution(cal).inputShape(inputWidth, inputHeight).setChannelType(channelType).outputChannels((Collection)channels).build();
        this.currentClassifier.set((Object)PixelClassifiers.createClassifier((OpenCVClassifiers.OpenCVStatModel)model, (ImageDataOp)featureCalculator, (PixelClassifierMetadata)metadata, (boolean)true));
        PixelClassificationOverlay overlay = PixelClassificationOverlay.create((OverlayOptions)this.qupath.getOverlayOptions(), (PixelClassifier)((PixelClassifier)this.currentClassifier.get()), (int)this.getLivePredictionThreads());
        this.replaceOverlay(overlay);
    }

    private void resetPieChart() {
        this.updatePieChart(Collections.emptyMap());
    }

    private void updatePieChart(Map<PathClass, Integer> counts) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.updatePieChart(counts));
            return;
        }
        ChartTools.setPieChartData((PieChart)this.pieChart, counts, PathClass::toString, p -> ColorToolsFX.getCachedColor((Integer)p.getColor()), (boolean)true, (!counts.isEmpty() ? 1 : 0) != 0);
        if (counts.isEmpty()) {
            this.pieChart.setTitle(null);
        } else {
            this.pieChart.setTitle("Training data");
        }
    }

    static boolean logVariableImportance(OpenCVClassifiers.RTreesClassifier trees, List<String> features) {
        double[] importance = trees.getFeatureImportance();
        if (importance == null) {
            return false;
        }
        try {
            int[] sorted = IntStream.range(0, importance.length).boxed().sorted((a, b) -> -Double.compare(importance[a], importance[b])).mapToInt(i -> i).toArray();
            if (sorted.length != features.size()) {
                return false;
            }
            StringBuilder sb = new StringBuilder("Variable importance:");
            for (int ind : sorted) {
                sb.append("\n");
                sb.append(String.format("%.4f \t %s", importance[ind], features.get(ind)));
            }
            logger.info(sb.toString());
            return true;
        }
        catch (Exception e) {
            logger.debug("Error logging feature importance: {}", (Object)e.getLocalizedMessage());
            return false;
        }
    }

    private void replaceOverlay(PixelClassificationOverlay newOverlay) {
        if (!Platform.isFxApplicationThread()) {
            Platform.runLater(() -> this.replaceOverlay(newOverlay));
            return;
        }
        if (this.overlay != null) {
            this.overlay.stop();
        }
        this.overlay = newOverlay;
        if (this.overlay != null) {
            this.overlay.setLivePrediction(this.livePrediction.get());
            this.overlay.setOpacity(this.sliderFeatureOpacity.getValue());
        }
        this.ensureOverlaySet();
    }

    private void destroy() {
        if (this.overlay != null) {
            this.overlay.stop();
        }
        this.qupath.imageDataProperty().removeListener(this.imageDataListener);
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            PathObjectHierarchy hierarchy;
            viewer.resetCustomPixelLayerOverlay();
            if (this.featureOverlay != null) {
                viewer.getCustomOverlayLayers().remove((Object)this.featureOverlay);
                this.featureOverlay.stop();
            }
            if ((hierarchy = viewer.getHierarchy()) == null) continue;
            hierarchy.removeListener((PathObjectHierarchyListener)this.hierarchyListener);
        }
        this.featureOverlay = null;
        this.overlay = null;
        if (this.stage != null && this.stage.isShowing()) {
            this.stage.close();
        }
        for (ImageData<BufferedImage> data : this.trainingMap.values()) {
            try {
                data.getServer().close();
            }
            catch (Exception e) {
                logger.warn("Error closing server: " + e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.trainingEntries.clear();
        this.trainingMap.clear();
    }

    private boolean editClassifierParameters() {
        OpenCVClassifiers.OpenCVStatModel model = (OpenCVClassifiers.OpenCVStatModel)this.selectedClassifier.get();
        if (model == null) {
            Dialogs.showErrorMessage((String)"Edit parameters", (String)"No classifier selected!");
            return false;
        }
        GuiTools.showParameterDialog((String)"Edit parameters", (ParameterList)model.getParameterList());
        this.updateClassifier();
        return true;
    }

    private boolean showOutput() {
        ImageServer server;
        if (this.overlay == null) {
            Dialogs.showErrorMessage((String)"Show output", (String)"No pixel classifier has been trained yet!");
            return false;
        }
        QuPathViewer viewer = this.qupath.getViewer();
        ImageData imageData = viewer.getImageData();
        ImageServer imageServer = server = imageData == null ? null : this.overlay.getPixelClassificationServer(imageData);
        if (server == null) {
            return false;
        }
        PathObject selected = viewer.getSelectedObject();
        ROI roi = selected == null ? null : selected.getROI();
        double downsample = server.getDownsampleForResolution(0);
        RegionRequest request = roi == null ? RegionRequest.createInstance((String)server.getPath(), (double)downsample, (int)0, (int)0, (int)server.getWidth(), (int)server.getHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition()) : RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)selected.getROI());
        long estimatedPixels = (long)Math.ceil((double)request.getWidth() / request.getDownsample()) * (long)Math.ceil((double)request.getHeight() / request.getDownsample());
        double estimatedMB = (double)(estimatedPixels * (long)server.nChannels() * (long)server.getPixelType().getBytesPerPixel()) / 1048576.0;
        if (estimatedPixels >= 0x7FFFFFEFL) {
            Dialogs.showErrorMessage((String)"Extract output", (String)"Requested region is too big! Try selecting a smaller region.");
            return false;
        }
        if (estimatedMB >= 200.0 && !Dialogs.showConfirmDialog((String)"Extract output", (String)String.format("Extracting this region will require approximately %.1f MB - are you sure you want to try this?", estimatedMB))) {
            return false;
        }
        try {
            PathImage pathImage = IJTools.convertToImagePlus((ImageServer)server, (RegionRequest)request);
            ImagePlus imp = (ImagePlus)pathImage.getImage();
            if (imp instanceof CompositeImage && server.getMetadata().getChannelType() != ImageServerMetadata.ChannelType.CLASSIFICATION) {
                ((CompositeImage)imp).setDisplayMode(3);
            }
            if (roi != null && !(roi instanceof RectangleROI)) {
                imp.setRoi(IJTools.convertToIJRoi((ROI)roi, (PathImage)pathImage));
            }
            IJExtension.getImageJInstance();
            imp.show();
            return true;
        }
        catch (IOException e) {
            logger.error("Error showing output", (Throwable)e);
            return false;
        }
    }

    private boolean showFeatures() {
        QuPathViewer viewer = this.qupath.getViewer();
        ImageData imageData = viewer.getImageData();
        double cx = viewer.getCenterPixelX();
        double cy = viewer.getCenterPixelY();
        if (imageData == null) {
            return false;
        }
        try {
            ImageDataOp op = this.helper.getFeatureOp();
            if (this.preprocessingOp != null) {
                op = op.appendOps(new ImageOp[]{this.preprocessingOp});
            }
            ImageDataServer featureServer = ImageOps.buildServer((ImageData)imageData, (ImageDataOp)op, (PixelCalibration)this.helper.getResolution());
            double downsample = featureServer.getDownsampleForResolution(0);
            int tw = (int)((double)featureServer.getMetadata().getPreferredTileWidth() * downsample);
            int th = (int)((double)featureServer.getMetadata().getPreferredTileHeight() * downsample);
            int x = (int)GeneralTools.clipValue((double)(cx - (double)tw / 2.0), (double)0.0, (double)(featureServer.getWidth() - tw));
            int y = (int)GeneralTools.clipValue((double)(cy - (double)th / 2.0), (double)0.0, (double)(featureServer.getHeight() - th));
            RegionRequest request = RegionRequest.createInstance((String)featureServer.getPath(), (double)downsample, (int)x, (int)y, (int)tw, (int)th, (int)viewer.getZPosition(), (int)viewer.getTPosition());
            ImagePlus imp = (ImagePlus)IJTools.convertToImagePlus((ImageServer)featureServer, (RegionRequest)request).getImage();
            CompositeImage impComp = new CompositeImage(imp, 3);
            impComp.setDimensions(imp.getStackSize(), 1, 1);
            for (int s = 1; s <= imp.getStackSize(); ++s) {
                impComp.setPosition(s);
                impComp.resetDisplayRange();
            }
            impComp.setPosition(1);
            IJExtension.getImageJInstance();
            impComp.show();
            featureServer.close();
            return true;
        }
        catch (Exception e) {
            logger.error("Error calculating features", (Throwable)e);
            return false;
        }
    }

    private boolean addResolution() {
        ClassificationResolution res;
        ImageServer server;
        ImageData imageData = this.qupath.getImageData();
        ImageServer imageServer = server = imageData == null ? null : imageData.getServer();
        if (server == null) {
            GuiTools.showNoImageError((String)"Add resolution");
            return false;
        }
        String units = null;
        Double pixelSize = null;
        PixelCalibration cal = server.getPixelCalibration();
        if (cal.hasPixelSizeMicrons()) {
            pixelSize = Dialogs.showInputDialog((String)"Add resolution", (String)("Enter requested pixel size in " + GeneralTools.micrometerSymbol()), (Double)1.0);
            units = PixelCalibration.MICROMETER;
        } else {
            pixelSize = Dialogs.showInputDialog((String)"Add resolution", (String)"Enter requested downsample factor", (Double)1.0);
        }
        if (pixelSize == null) {
            return false;
        }
        if (PixelCalibration.MICROMETER.equals(units)) {
            double scale = pixelSize / cal.getAveragedPixelSizeMicrons();
            res = new ClassificationResolution("Custom", cal.createScaledInstance(scale, scale, 1.0));
        } else {
            res = new ClassificationResolution("Custom", cal.createScaledInstance(pixelSize.doubleValue(), pixelSize.doubleValue(), 1.0));
        }
        ArrayList<ClassificationResolution> temp = new ArrayList<ClassificationResolution>((Collection<ClassificationResolution>)this.resolutions);
        temp.add(res);
        Collections.sort(temp, Comparator.comparingDouble(w -> w.cal.getAveragedPixelSize().doubleValue()));
        this.resolutions.setAll(temp);
        this.comboResolutions.getSelectionModel().select((Object)res);
        return true;
    }

    private PixelCalibration getSelectedResolution() {
        return ((ClassificationResolution)this.selectedResolution.get()).cal;
    }

    private void updateResolution(ClassificationResolution resolution) {
        ImageServer server;
        ImageServer imageServer = server = this.qupath.getImageData() == null ? null : this.qupath.getImageData().getServer();
        if (server == null || this.miniViewer == null || resolution == null) {
            return;
        }
        Tooltip.install((Node)this.miniViewer.getPane(), (Tooltip)new Tooltip("Classification resolution: \n" + String.valueOf(resolution)));
        this.helper.setResolution(resolution.cal);
        this.miniViewer.setDownsample(resolution.cal.getAveragedPixelSize().doubleValue() / server.getPixelCalibration().getAveragedPixelSize().doubleValue());
    }

    private boolean promptToLoadTrainingImages() {
        Project project = this.qupath.getProject();
        if (project == null) {
            GuiTools.showNoProjectError((String)"Pixel classifier");
            return false;
        }
        ListSelectionView listView = ProjectDialogs.createImageChoicePane((QuPathGUI)this.qupath, (List)project.getImageList(), this.trainingEntries, (String)"Specified image is open!");
        BorderPane pane = new BorderPane((Node)listView);
        pane.setTop((Node)new Label("Select images to use for training the pixel classifier.\nNote that more images will require more memory and more processing time!"));
        if (Dialogs.builder().title("Pixel classifier training images").content((Node)pane).resizable().buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL) == ButtonType.CANCEL) {
            return false;
        }
        this.trainingEntries.clear();
        this.trainingEntries.addAll((Collection<ProjectImageEntry<BufferedImage>>)listView.getTargetItems());
        return true;
    }

    class HierarchyListener
    implements PathObjectHierarchyListener {
        HierarchyListener() {
        }

        public void hierarchyChanged(PathObjectHierarchyEvent event) {
            if (!(event.isChanging() || event.isObjectMeasurementEvent() || !event.isStructureChangeEvent() && !event.isObjectClassificationEvent() && event.getChangedObjects().isEmpty() || !event.isObjectClassificationEvent() && !event.getChangedObjects().stream().anyMatch(p -> p.getPathClass() != null) || !event.getChangedObjects().stream().anyMatch(PathObject::isAnnotation) || event.isAddedOrRemovedEvent() && event.getChangedObjects().stream().allMatch(PathObject::isLocked))) {
                PixelClassifierPane.this.updateClassifier();
            }
        }
    }

    class MouseListener
    implements EventHandler<MouseEvent> {
        MouseListener() {
        }

        public void handle(MouseEvent event) {
            if (PixelClassifierPane.this.overlay == null) {
                return;
            }
            for (QuPathViewer viewer : PixelClassifierPane.this.qupath.getAllViewers()) {
                Point2D local;
                Pane view = viewer.getView();
                if (!view.contains(local = view.screenToLocal(event.getScreenX(), event.getScreenY()))) continue;
                this.updateCursorLocation(viewer, local);
                return;
            }
        }

        void updateCursorLocation(QuPathViewer viewer, Point2D localPoint) {
            java.awt.geom.Point2D p = viewer.componentPointToImagePoint(localPoint.getX(), localPoint.getY(), null, false);
            ImageServer server = PixelClassifierPane.this.overlay.getPixelClassificationServer(viewer.getImageData());
            String results = null;
            if (server != null) {
                results = PixelClassificationOverlay.getDefaultLocationString((ImageServer)server, (double)p.getX(), (double)p.getY(), (int)viewer.getZPosition(), (int)viewer.getTPosition());
            }
            if (results == null) {
                PixelClassifierPane.this.cursorLocation.set((Object)"");
            } else {
                PixelClassifierPane.this.cursorLocation.set(results);
            }
        }
    }
}

