/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import org.controlsfx.control.CheckComboBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.ops.ImageOp;
import qupath.opencv.ops.ImageOps;
import qupath.opencv.tools.MultiscaleFeatures;

abstract class ImageDataTransformerBuilder {
    private static final Logger logger = LoggerFactory.getLogger(ImageDataTransformerBuilder.class);

    ImageDataTransformerBuilder() {
    }

    public abstract ImageDataOp build(ImageData<BufferedImage> var1, PixelCalibration var2);

    public boolean canCustomize(ImageData<BufferedImage> imageData) {
        return false;
    }

    public boolean doCustomize(ImageData<BufferedImage> imageData) {
        throw new UnsupportedOperationException("Cannot customize this feature calculator!");
    }

    static Collection<ColorTransforms.ColorTransform> getAvailableChannels(ImageData<?> imageData) {
        ArrayList<ColorTransforms.ColorTransform> list = new ArrayList<ColorTransforms.ColorTransform>();
        for (String name : ImageDataTransformerBuilder.getAvailableUniqueChannelNames(imageData.getServer())) {
            list.add(ColorTransforms.createChannelExtractor((String)name));
        }
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        if (stains != null) {
            list.add(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)1));
            list.add(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)2));
            list.add(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)3));
        }
        return list;
    }

    static Collection<String> getAvailableUniqueChannelNames(ImageServer<?> server) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        int i = 1;
        for (ImageChannel c : server.getMetadata().getChannels()) {
            String name = c.getName();
            if (!set.contains(name)) {
                set.add(name);
            } else {
                logger.warn("Found duplicate channel name! Will skip channel {} (name '{}')", (Object)i, (Object)name);
            }
            ++i;
        }
        return set;
    }

    static class DefaultFeatureCalculatorBuilder
    extends ImageDataTransformerBuilder {
        private static final Logger logger = LoggerFactory.getLogger(DefaultFeatureCalculatorBuilder.class);
        private final GridPane pane;
        private final CheckComboBox<ColorTransforms.ColorTransform> comboChannels;
        private final ObservableList<ColorTransforms.ColorTransform> selectedChannels;
        private final ObservableList<Double> selectedSigmas;
        private final ObservableList<MultiscaleFeatures.MultiscaleFeature> selectedFeatures;
        private final ObservableList<NormalizationType> localNormalizations = FXCollections.observableArrayList((Object[])NormalizationType.values());
        private final ObservableObjectValue<NormalizationType> normalization;
        private final ObservableObjectValue<Double> normalizationSigma;
        private final boolean do3D = false;

        public DefaultFeatureCalculatorBuilder(ImageData<BufferedImage> imageData) {
            ImageServer server;
            int row = 0;
            this.pane = new GridPane();
            Label labelChannels = new Label("Channels");
            this.comboChannels = new CheckComboBox();
            FXUtils.installSelectAllOrNoneMenu(this.comboChannels);
            ImageServer imageServer = server = imageData == null ? null : imageData.getServer();
            if (server != null) {
                this.comboChannels.getItems().setAll(DefaultFeatureCalculatorBuilder.getAvailableChannels(imageData));
                this.comboChannels.getCheckModel().checkIndices(IntStream.range(0, imageData.getServer().nChannels()).toArray());
            }
            this.comboChannels.titleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                int n = this.comboChannels.getCheckModel().getCheckedItems().size();
                if (n == 0) {
                    return "No channels selected!";
                }
                if (n == 1) {
                    return "1 channel selected";
                }
                return n + " channels selected";
            }, (Observable[])new Observable[]{this.comboChannels.getCheckModel().getCheckedItems()}));
            CheckComboBox comboScales = new CheckComboBox();
            FXUtils.installSelectAllOrNoneMenu((CheckComboBox)comboScales);
            Label labelScales = new Label("Scales");
            comboScales.getItems().addAll((Object[])new Double[]{0.5, 1.0, 2.0, 4.0, 8.0, 12.0, 16.0, 24.0, 32.0});
            comboScales.getCheckModel().check(1);
            this.selectedSigmas = comboScales.getCheckModel().getCheckedItems();
            this.selectedChannels = this.comboChannels.getCheckModel().getCheckedItems();
            CheckComboBox comboFeatures = new CheckComboBox();
            FXUtils.installSelectAllOrNoneMenu((CheckComboBox)comboFeatures);
            Label labelFeatures = new Label("Features");
            List<MultiscaleFeatures.MultiscaleFeature> compatibleFilters = Arrays.stream(MultiscaleFeatures.MultiscaleFeature.values()).filter(MultiscaleFeatures.MultiscaleFeature::supports2D).toList();
            comboFeatures.getItems().addAll(compatibleFilters);
            comboFeatures.getCheckModel().check((Object)MultiscaleFeatures.MultiscaleFeature.GAUSSIAN);
            this.selectedFeatures = comboFeatures.getCheckModel().getCheckedItems();
            comboFeatures.titleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                int n = this.selectedFeatures.size();
                if (n == 0) {
                    return "No features selected!";
                }
                if (n == 1) {
                    return "1 feature selected";
                }
                return n + " features selected";
            }, (Observable[])new Observable[]{this.selectedFeatures}));
            Label labelNormalize = new Label("Local normalization");
            ComboBox comboNormalize = new ComboBox(this.localNormalizations);
            this.normalization = comboNormalize.getSelectionModel().selectedItemProperty();
            comboNormalize.getSelectionModel().selectFirst();
            Label labelNormalizeScale = new Label("Local normalization scale");
            Spinner spinnerNormalize = new Spinner(0.0, 32.0, 8.0, 1.0);
            this.normalizationSigma = spinnerNormalize.valueProperty();
            spinnerNormalize.setEditable(true);
            FXUtils.restrictTextFieldInputToNumber((TextField)spinnerNormalize.getEditor(), (boolean)true);
            FXUtils.resetSpinnerNullToPrevious((Spinner)spinnerNormalize);
            spinnerNormalize.focusedProperty().addListener((v, o, n) -> {
                if (spinnerNormalize.getEditor().getText().isEmpty()) {
                    spinnerNormalize.getValueFactory().valueProperty().set((Object)0.0);
                }
            });
            GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{this.comboChannels, comboFeatures, comboScales, comboNormalize, spinnerNormalize});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose the image channels used to calculate features", (Node[])new Node[]{labelChannels, this.comboChannels});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose the feature scales", (Node[])new Node[]{labelScales, comboScales});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose the features", (Node[])new Node[]{labelFeatures, comboFeatures});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Apply local intensity (Gaussian-weighted) normalization before calculating features", (Node[])new Node[]{labelNormalize, comboNormalize});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Amount of smoothing to apply for local normalization", (Node[])new Node[]{labelNormalizeScale, spinnerNormalize});
            this.pane.setHgap(5.0);
            this.pane.setVgap(6.0);
        }

        @Override
        public ImageDataOp build(ImageData<BufferedImage> imageData, PixelCalibration resolution) {
            if (this.selectedFeatures == null || this.selectedSigmas == null) {
                throw new IllegalArgumentException("Features and scales must be selected!");
            }
            MultiscaleFeatures.MultiscaleFeature[] features = (MultiscaleFeatures.MultiscaleFeature[])this.selectedFeatures.toArray(MultiscaleFeatures.MultiscaleFeature[]::new);
            double[] sigmas = this.selectedSigmas.stream().mapToDouble(d -> d).toArray();
            double varianceScaleRatio = 1.0;
            ArrayList<ImageOp> ops = new ArrayList<ImageOp>();
            for (double sigma : sigmas) {
                ops.add(ImageOps.Filters.features(Arrays.asList(features), (double)sigma, (double)sigma));
            }
            ImageOp op = ImageOps.Core.splitMerge(ops);
            double localNormalizeSigma = (Double)this.normalizationSigma.get();
            ImageOp opNormalize = null;
            if (localNormalizeSigma > 0.0) {
                switch (((NormalizationType)((Object)this.normalization.get())).ordinal()) {
                    case 1: {
                        opNormalize = ImageOps.Normalize.localNormalization((double)localNormalizeSigma, (double)0.0);
                        break;
                    }
                    case 2: {
                        opNormalize = ImageOps.Normalize.localNormalization((double)localNormalizeSigma, (double)(localNormalizeSigma * varianceScaleRatio));
                        break;
                    }
                    case 3: {
                        int radius = (int)Math.ceil(localNormalizeSigma);
                        opNormalize = ImageOps.Normalize.localNormalizationMinMax((int)radius, (double)0.0);
                        break;
                    }
                    case 4: {
                        int radius2 = (int)Math.ceil(localNormalizeSigma);
                        opNormalize = ImageOps.Normalize.localNormalizationMinMax((int)radius2, (double)localNormalizeSigma);
                        break;
                    }
                }
            }
            if (opNormalize != null) {
                op = ImageOps.Core.sequential((ImageOp[])new ImageOp[]{opNormalize, op});
            }
            return ImageOps.buildImageDataOp(this.selectedChannels).appendOps(new ImageOp[]{op});
        }

        @Override
        public boolean canCustomize(ImageData<BufferedImage> imageData) {
            return true;
        }

        @Override
        public boolean doCustomize(ImageData<BufferedImage> imageData) {
            boolean success;
            ImageServer server;
            ImageServer imageServer = server = imageData == null ? null : imageData.getServer();
            if (server != null) {
                ArrayList<ColorTransforms.ColorTransform> channels = new ArrayList<ColorTransforms.ColorTransform>(DefaultFeatureCalculatorBuilder.getAvailableChannels(imageData));
                if (!this.comboChannels.getItems().equals(channels)) {
                    logger.warn("Image channels changed - will update & select all channels for the feature calculator");
                    this.comboChannels.getCheckModel().clearChecks();
                    this.comboChannels.getItems().setAll(channels);
                    this.comboChannels.getCheckModel().checkIndices(IntStream.range(0, imageData.getServer().nChannels()).toArray());
                }
            }
            if (success = Dialogs.showMessageDialog((String)"Select features", (Node)this.pane)) {
                if (this.selectedChannels == null || this.selectedChannels.isEmpty()) {
                    Dialogs.showErrorNotification((String)"Pixel classifier", (String)"No channels selected!");
                    return false;
                }
                if (this.selectedFeatures == null || this.selectedFeatures.isEmpty()) {
                    Dialogs.showErrorNotification((String)"Pixel classifier", (String)"No features selected!");
                    return false;
                }
            }
            return success;
        }

        public String toString() {
            return "Default multiscale features 2D";
        }

        private static enum NormalizationType {
            NONE,
            GAUSSIAN_MEAN,
            GAUSSIAN_MEAN_VARIANCE,
            LOCAL_MIN_MAX,
            LOCAL_MIN_MAX_SMOOTHED;


            public String toString() {
                return switch (this.ordinal()) {
                    case 1 -> "Local mean subtraction only";
                    case 2 -> "Local mean & variance";
                    case 3 -> "Local min & max";
                    case 4 -> "Local min & max smoothed";
                    case 0 -> "None";
                    default -> throw new IllegalArgumentException("Unknown normalization " + String.valueOf((Object)this));
                };
            }
        }
    }
}

