/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import java.awt.image.BufferedImage;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import qupath.lib.display.ChannelDisplayMode;
import qupath.lib.display.DirectServerChannelInfo;
import qupath.lib.display.ImageDisplay;
import qupath.lib.gui.images.stores.AbstractImageRenderer;
import qupath.lib.gui.images.stores.DefaultImageRegionStore;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;

class FeatureRenderer
extends AbstractImageRenderer {
    private final DefaultImageRegionStore store;
    private DirectServerChannelInfo selectedChannel = null;
    private WeakReference<ImageData<BufferedImage>> currentData;
    private final AtomicLong eventCount = new AtomicLong();

    FeatureRenderer(DefaultImageRegionStore store) {
        this.store = store;
    }

    public void setChannel(ImageServer<BufferedImage> server, int channel, double min, double max) {
        ImageData temp;
        ImageData imageData = temp = this.currentData == null ? null : (ImageData)this.currentData.get();
        if (temp == null || temp.getServer() != server) {
            temp = new ImageData(server);
            this.currentData = new WeakReference<ImageData>(temp);
        }
        this.selectedChannel = new DirectServerChannelInfo(temp, channel);
        this.selectedChannel.setLUTColor(255, 255, 255);
        this.setRange(min, max);
        this.eventCount.incrementAndGet();
    }

    public void setRange(double min, double max) {
        if (this.selectedChannel != null) {
            this.selectedChannel.setMinDisplay((float)min);
            this.selectedChannel.setMaxDisplay((float)max);
            this.eventCount.incrementAndGet();
        }
    }

    public DirectServerChannelInfo getSelectedChannel() {
        return this.selectedChannel;
    }

    void autoSetDisplayRange() {
        if (this.selectedChannel == null) {
            return;
        }
        ImageData imageData = (ImageData)this.currentData.get();
        Map tiles = this.store == null || imageData == null ? Collections.emptyMap() : this.store.getCachedTilesForServer(imageData.getServer());
        float maxVal = Float.NEGATIVE_INFINITY;
        float minVal = Float.POSITIVE_INFINITY;
        float[] pixels = null;
        for (BufferedImage tile : tiles.values()) {
            int n = tile.getWidth() * tile.getHeight();
            if (pixels != null && pixels.length < n) {
                pixels = null;
            }
            for (float v : pixels = tile.getRaster().getSamples(0, 0, tile.getWidth(), tile.getHeight(), this.selectedChannel.getChannel(), pixels)) {
                if (!Float.isFinite(v)) continue;
                if (v > maxVal) {
                    maxVal = v;
                }
                if (!(v < minVal)) continue;
                minVal = v;
            }
        }
        if (Float.isFinite(maxVal)) {
            this.selectedChannel.setMaxDisplay(maxVal);
        } else {
            this.selectedChannel.setMaxDisplay(1.0f);
        }
        if (Float.isFinite(minVal)) {
            this.selectedChannel.setMinDisplay(minVal);
        } else {
            this.selectedChannel.setMinDisplay(0.0f);
        }
        this.eventCount.incrementAndGet();
    }

    public BufferedImage applyTransforms(BufferedImage imgInput, BufferedImage imgOutput) {
        return ImageDisplay.applyTransforms((BufferedImage)imgInput, (BufferedImage)imgOutput, Collections.singletonList(this.selectedChannel), (ChannelDisplayMode)ChannelDisplayMode.GRAYSCALE);
    }

    public long getLastChangeTimestamp() {
        return this.eventCount.get();
    }
}

