/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import org.bytedeco.opencv.opencv_core.Mat;
import qupath.lib.classifiers.Normalization;
import qupath.opencv.ml.FeaturePreprocessor;

class FeatureNormalization {
    private Normalization normalization = Normalization.NONE;
    private double missingValue = 0.0;
    private double pcaRetained = 0.0;
    private boolean pcaNormalize = true;

    FeatureNormalization() {
    }

    public void setNormalization(Normalization normalization) {
        if (this.normalization == normalization) {
            return;
        }
        this.normalization = normalization;
    }

    public Normalization getNormalization() {
        return this.normalization;
    }

    public void setPCARetainedVariance(double retained) {
        if (this.pcaRetained == retained) {
            return;
        }
        this.pcaRetained = retained;
    }

    public double getPCARetainedVariance() {
        return this.pcaRetained;
    }

    public void setPCANormalize(boolean normalize) {
        if (this.pcaNormalize == normalize) {
            return;
        }
        this.pcaNormalize = normalize;
    }

    public boolean doPCANormalize() {
        return this.pcaNormalize;
    }

    public FeaturePreprocessor build(Mat matTraining, boolean applyToTraining) {
        return FeaturePreprocessor.builder().normalize(this.normalization).pca(this.pcaRetained, this.pcaNormalize).missingValue(this.missingValue).build(matTraining, applyToTraining);
    }
}

