/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import qupath.lib.common.GeneralTools;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.PixelCalibration;

public class ClassificationResolution {
    private static List<String> resolutionNames = Arrays.asList("Full", "Very high", "High", "Moderate", "Low", "Very low", "Extremely low");
    private final String name;
    final PixelCalibration cal;

    ClassificationResolution(String name, PixelCalibration cal) {
        this.name = name;
        this.cal = cal;
    }

    public String getName() {
        return this.name;
    }

    public PixelCalibration getPixelCalibration() {
        return this.cal;
    }

    public String toString() {
        if (this.cal.hasPixelSizeMicrons()) {
            return String.format("%s (%.2f %s/px)", this.name, this.cal.getAveragedPixelSizeMicrons(), GeneralTools.micrometerSymbol());
        }
        return String.format("%s (downsample = %.2f)", this.name, this.cal.getAveragedPixelSize().doubleValue());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cal == null ? 0 : this.cal.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ClassificationResolution other = (ClassificationResolution)obj;
        if (this.cal == null ? other.cal != null : !this.cal.equals((Object)other.cal)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public static List<ClassificationResolution> getDefaultResolutions(ImageData<?> imageData, ClassificationResolution selected) {
        ArrayList<ClassificationResolution> temp = new ArrayList<ClassificationResolution>();
        PixelCalibration cal = imageData.getServer().getPixelCalibration();
        int scale = 1;
        for (String name : resolutionNames) {
            ClassificationResolution newResolution = new ClassificationResolution(name, cal.createScaledInstance((double)scale, (double)scale, 1.0));
            if (Objects.equals(selected, newResolution)) {
                temp.add(selected);
            } else {
                temp.add(newResolution);
            }
            scale *= 2;
        }
        if (selected == null) {
            selected = (ClassificationResolution)temp.get(0);
        } else if (!temp.contains(selected)) {
            temp.add(selected);
        }
        return temp;
    }
}

