/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.ml;

import qupath.lib.common.ColorTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.classes.PathClassTools;

public class BoundaryStrategy {
    private static BoundaryStrategy SKIP_STRATEGY = new BoundaryStrategy(Strategy.SKIP, null, 0.0);
    private Strategy strategy = Strategy.SKIP;
    private PathClass fixedClass;
    private double thickness = 1.0;

    private BoundaryStrategy(Strategy strategy, PathClass pathClass, double thickness) {
        this.strategy = strategy;
        this.fixedClass = pathClass;
        this.thickness = thickness;
    }

    public double getBoundaryThickness() {
        return this.thickness;
    }

    public PathClass getBoundaryClass(PathClass pathClass) {
        if (pathClass == null || PathClassTools.isIgnoredClass((PathClass)pathClass)) {
            return null;
        }
        switch (this.strategy.ordinal()) {
            case 1: {
                return this.fixedClass;
            }
            case 3: {
                return PathClass.getInstance((PathClass)pathClass, (String)"Boundary*", (Integer)ColorTools.makeScaledRGB((int)pathClass.getColor(), (double)0.5));
            }
            case 2: {
                return pathClass;
            }
        }
        return null;
    }

    public String toString() {
        switch (this.strategy.ordinal()) {
            case 1: {
                return "Boundary strategy: Classify as " + String.valueOf(this.fixedClass);
            }
            case 3: {
                return "Boundary strategy: Create derived class";
            }
            case 2: {
                return "Boundary strategy: Keep classification";
            }
        }
        return "Boundary strategy: Skip";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.fixedClass == null ? 0 : this.fixedClass.hashCode());
        result = 31 * result + (this.strategy == null ? 0 : this.strategy.hashCode());
        long temp = Double.doubleToLongBits(this.thickness);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoundaryStrategy other = (BoundaryStrategy)obj;
        if (this.fixedClass == null ? other.fixedClass != null : !this.fixedClass.equals(other.fixedClass)) {
            return false;
        }
        if (this.strategy != other.strategy) {
            return false;
        }
        return Double.doubleToLongBits(this.thickness) == Double.doubleToLongBits(other.thickness);
    }

    public static BoundaryStrategy getClassifyBoundaryStrategy(PathClass pathClass, double thickness) {
        if (pathClass == null || thickness <= 0.0) {
            return BoundaryStrategy.getSkipBoundaryStrategy();
        }
        return new BoundaryStrategy(Strategy.CLASSIFY, pathClass, thickness);
    }

    public static BoundaryStrategy getDerivedBoundaryStrategy(double thickness) {
        if (thickness <= 0.0) {
            return BoundaryStrategy.getSkipBoundaryStrategy();
        }
        return new BoundaryStrategy(Strategy.DERIVE, null, thickness);
    }

    public static BoundaryStrategy getSkipBoundaryStrategy() {
        return SKIP_STRATEGY;
    }

    public static BoundaryStrategy setThickness(BoundaryStrategy strategy, double thickness) {
        if (strategy.thickness == thickness) {
            return strategy;
        }
        if (thickness <= 0.0 || SKIP_STRATEGY.equals(strategy)) {
            return BoundaryStrategy.getSkipBoundaryStrategy();
        }
        return new BoundaryStrategy(strategy.strategy, strategy.fixedClass, thickness);
    }

    private static enum Strategy {
        SKIP,
        CLASSIFY,
        SAME,
        DERIVE;

    }
}

