/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.density;

import ij.CompositeImage;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringBinding;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.imagej.gui.IJExtension;
import qupath.imagej.tools.IJTools;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.color.ColorToolsAwt;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.actions.ActionTools;
import qupath.lib.gui.images.servers.RenderedImageServer;
import qupath.lib.gui.images.stores.ColorModelRenderer;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.TileRequest;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectPredicates;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.lib.regions.RegionRequest;
import qupath.lib.scripting.QP;
import qupath.opencv.ml.pixel.PixelClassifierTools;
import qupath.process.gui.commands.ui.SaveResourcePaneBuilder;

public class DensityMapUI {
    private static final Logger logger = LoggerFactory.getLogger(DensityMapUI.class);
    private static final String title = "Density maps";
    public static final PathClass ANY_CLASS_OR_NONE = PathClass.fromString((String)UUID.randomUUID().toString());
    public static final PathClass ANY_SPECIFIED_CLASS = PathClass.fromString((String)UUID.randomUUID().toString());
    public static final PathClass ANY_POSITIVE_CLASS = PathClass.fromString((String)UUID.randomUUID().toString());

    public static Pane createSaveDensityMapPane(ObjectExpression<Project<BufferedImage>> project, ObjectExpression<DensityMaps.DensityMapBuilder> densityMap, StringProperty savedName) {
        logger.trace("Creating 'Save density map' pane");
        String tooltipTextYes = "Save density map in the current project - this is required to use the density map later (e.g. to create objects, measurements)";
        String tooltipTextNo = "Cannot save a density map outside a project. Please create a project to save the classifier.";
        StringBinding tooltipText = Bindings.when((ObservableBooleanValue)project.isNull()).then((ObservableStringValue)Bindings.createStringBinding(() -> tooltipTextNo, (Observable[])new Observable[]{project})).otherwise((ObservableStringValue)Bindings.createStringBinding(() -> tooltipTextYes, (Observable[])new Observable[]{project}));
        return new SaveResourcePaneBuilder<DensityMaps.DensityMapBuilder>(DensityMaps.DensityMapBuilder.class, densityMap).project(project).labelText("Save map").textFieldPrompt("Enter name").savedName(savedName).tooltip((ObservableValue<String>)tooltipText).title(title).build();
    }

    static List<MinMax> getMinMax(ImageServer<BufferedImage> server) throws IOException {
        return MinMaxFinder.getMinMax(server, -1, 0.0f);
    }

    static Action createDensityMapAction(String text, ObjectExpression<ImageData<BufferedImage>> imageData, ObjectExpression<DensityMaps.DensityMapBuilder> builder, ObservableStringValue densityMapName, ObservableBooleanValue disableButtons, DensityMapButtonCommand consumer, String tooltip) {
        Action action = new Action(text, e -> consumer.fire((ActionEvent)e, (ImageData<BufferedImage>)((ImageData)imageData.get()), (DensityMaps.DensityMapBuilder)builder.get(), (String)densityMapName.get()));
        if (tooltip != null) {
            action.setLongText(tooltip);
        }
        if (disableButtons != null) {
            action.disabledProperty().bind((ObservableValue)disableButtons);
        }
        return action;
    }

    public static Pane createButtonPane(QuPathGUI qupath, ObjectExpression<ImageData<BufferedImage>> imageData, ObjectExpression<DensityMaps.DensityMapBuilder> builder, StringExpression densityMapName, ObjectExpression<PixelClassificationOverlay> overlay, boolean enableUnsavedButton) {
        logger.trace("Creating button pane");
        SimpleBooleanProperty allowWithoutSaving = new SimpleBooleanProperty(!enableUnsavedButton);
        BooleanBinding disableButtons = imageData.isNull().or((ObservableBooleanValue)builder.isNull()).or((ObservableBooleanValue)densityMapName.isEmpty().and((ObservableBooleanValue)allowWithoutSaving.not()));
        Action actionHotspots = DensityMapUI.createDensityMapAction("Find hotspots", imageData, builder, (ObservableStringValue)densityMapName, (ObservableBooleanValue)disableButtons, new HotspotFinder(qupath, overlay), "Find the hotspots in the density map with highest values");
        Button btnHotspots = ActionTools.createButton((Action)actionHotspots);
        Action actionThreshold = DensityMapUI.createDensityMapAction("Threshold", imageData, builder, (ObservableStringValue)densityMapName, (ObservableBooleanValue)disableButtons, new ContourTracer(qupath, overlay), "Threshold to identify high-density regions");
        Button btnThreshold = ActionTools.createButton((Action)actionThreshold);
        Action actionExport = DensityMapUI.createDensityMapAction("Export map", imageData, builder, (ObservableStringValue)densityMapName, (ObservableBooleanValue)disableButtons, new DensityMapExporter(qupath, overlay), "Export the density map as an image");
        Button btnExport = ActionTools.createButton((Action)actionExport);
        GridPane buttonPane = GridPaneUtils.createColumnGrid((Node[])new Node[]{btnHotspots, btnThreshold, btnExport});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{btnHotspots, btnExport, btnThreshold});
        BorderPane pane = new BorderPane((Node)buttonPane);
        if (enableUnsavedButton) {
            ContextMenu menu = new ContextMenu();
            CheckMenuItem miWithoutSaving = new CheckMenuItem("Enable buttons for unsaved density maps");
            miWithoutSaving.selectedProperty().bindBidirectional((Property)allowWithoutSaving);
            menu.getItems().addAll((Object[])new MenuItem[]{miWithoutSaving});
            Button btnAdvanced = GuiTools.createMoreButton((ContextMenu)menu, (Side)Side.RIGHT);
            pane.setRight((Node)btnAdvanced);
        }
        return pane;
    }

    static class MinMaxFinder {
        private static Map<String, List<MinMax>> cache = Collections.synchronizedMap(new HashMap());

        MinMaxFinder() {
        }

        static List<MinMax> getMinMax(ImageServer<BufferedImage> server, int countBand, float minCount) throws IOException {
            String key = server.getPath() + "?count=" + countBand + "&minCount=" + minCount;
            List<MinMax> minMax = cache.get(key);
            if (minMax == null) {
                logger.trace("Calculating min & max for {}", server);
                minMax = MinMaxFinder.calculateMinMax(server, countBand, minCount);
                cache.put(key, minMax);
            } else {
                logger.trace("Using cached min & max for {}", server);
            }
            return minMax;
        }

        private static List<MinMax> calculateMinMax(ImageServer<BufferedImage> server, int countBand, float minCount) throws IOException {
            Map<RegionRequest, BufferedImage> tiles = MinMaxFinder.getAllTiles(server, 0, false);
            if (tiles == null) {
                return null;
            }
            boolean countsFromSameBand = countBand < 0;
            int nBands = server.nChannels();
            List<MinMax> results = IntStream.range(0, nBands).mapToObj(i -> new MinMax()).toList();
            float[] pixels = null;
            float[] countPixels = null;
            for (BufferedImage img : tiles.values()) {
                WritableRaster raster = img.getRaster();
                int w = raster.getWidth();
                int h = raster.getHeight();
                if (pixels == null || pixels.length < w * h) {
                    pixels = new float[w * h];
                    if (!countsFromSameBand) {
                        countPixels = new float[w * h];
                    }
                }
                countPixels = !countsFromSameBand ? raster.getSamples(0, 0, w, h, countBand, countPixels) : null;
                for (int band = 0; band < nBands; ++band) {
                    int i2;
                    MinMax minMax = results.get(band);
                    pixels = raster.getSamples(0, 0, w, h, band, pixels);
                    if (countsFromSameBand) {
                        for (i2 = 0; i2 < w * h; ++i2) {
                            if (!(pixels[i2] > minCount)) continue;
                            minMax.update(pixels[i2]);
                        }
                        continue;
                    }
                    for (i2 = 0; i2 < w * h; ++i2) {
                        if (!(countPixels[i2] > minCount)) continue;
                        minMax.update(pixels[i2]);
                    }
                }
            }
            return Collections.unmodifiableList(results);
        }

        private static Map<RegionRequest, BufferedImage> getAllTiles(ImageServer<BufferedImage> server, int level, boolean ignoreInterrupts) throws IOException {
            LinkedHashMap<RegionRequest, BufferedImage> map = new LinkedHashMap<RegionRequest, BufferedImage>();
            Collection tiles = server.getTileRequestManager().getTileRequestsForLevel(level);
            for (TileRequest tile : tiles) {
                BufferedImage imgTile;
                if (!ignoreInterrupts && Thread.currentThread().isInterrupted()) {
                    return null;
                }
                RegionRequest region = tile.getRegionRequest();
                if (server.isEmptyRegion(region) || (imgTile = (BufferedImage)server.readRegion(region)) == null) continue;
                map.put(region, imgTile);
            }
            return map;
        }
    }

    private static abstract class DensityMapButtonCommand {
        protected QuPathGUI qupath;
        protected ObjectExpression<PixelClassificationOverlay> overlay;
        private BooleanProperty previewThreshold = new SimpleBooleanProperty(true);
        private ColorModel previousColorModel;

        public DensityMapButtonCommand(QuPathGUI qupath, ObjectExpression<PixelClassificationOverlay> overlay) {
            this.qupath = qupath;
            this.overlay = overlay;
            this.previewThreshold.addListener((v, o, n) -> this.updateRenderer());
        }

        protected ColorModelRenderer getRenderer() {
            ImageRenderer renderer;
            PixelClassificationOverlay o;
            PixelClassificationOverlay pixelClassificationOverlay = o = this.overlay == null ? null : (PixelClassificationOverlay)this.overlay.get();
            if (o == null) {
                return null;
            }
            ImageRenderer imageRenderer = renderer = o == null ? null : o.getRenderer();
            if (renderer == null && !o.rendererProperty().isBound()) {
                renderer = new ColorModelRenderer(null);
                o.setRenderer(renderer);
            }
            return renderer instanceof ColorModelRenderer ? (ColorModelRenderer)renderer : null;
        }

        protected Window getOwner(ActionEvent event) {
            Object source = event.getSource();
            if (source instanceof Node) {
                Scene scene = ((Node)source).getScene();
                return scene == null ? null : scene.getWindow();
            }
            return null;
        }

        public abstract void fire(ActionEvent var1, ImageData<BufferedImage> var2, DensityMaps.DensityMapBuilder var3, String var4);

        protected void saveColorModel() {
            ColorModelRenderer renderer = this.getRenderer();
            if (renderer != null) {
                this.previousColorModel = renderer.getColorModel();
            }
        }

        protected void restoreColorModel() {
            ColorModelRenderer renderer = this.getRenderer();
            if (renderer != null) {
                renderer.setColorModel(this.previousColorModel);
                this.qupath.getViewerManager().repaintAllViewers();
            }
        }

        protected void updateRenderer() {
            if (!this.previewThreshold.get()) {
                this.restoreColorModel();
                return;
            }
            ColorModelRenderer renderer = this.getRenderer();
            if (renderer != null) {
                this.customUpdateRenderer(renderer);
            }
        }

        protected abstract void customUpdateRenderer(ColorModelRenderer var1);

        protected void updateRenderer(ColorModelRenderer renderer, PathClass aboveThreshold, ThresholdColorModels.ColorModelThreshold threshold) {
            Color transparent = ColorToolsAwt.getCachedColor((Integer)0, (boolean)true);
            Color above = ColorToolsAwt.getCachedColor((Integer)aboveThreshold.getColor());
            ThresholdColorModels.ThresholdColorModel colorModel = new ThresholdColorModels.ThresholdColorModel(threshold, transparent, transparent, above);
            renderer.setColorModel((ColorModel)colorModel);
            this.qupath.getViewerManager().repaintAllViewers();
        }

        protected TitledPane createOverlayPane() {
            GridPane paneOverlay = new GridPane();
            int row2 = 0;
            CheckBox cbLayer = new CheckBox("Show overlay");
            cbLayer.selectedProperty().bindBidirectional((Property)this.qupath.getOverlayOptions().showPixelClassificationProperty());
            GridPaneUtils.addGridRow((GridPane)paneOverlay, (int)row2++, (int)0, (String)"Show or hide the overlay", (Node[])new Node[]{cbLayer, cbLayer});
            CheckBox cbPreviewThreshold = new CheckBox("Preview threshold");
            cbPreviewThreshold.selectedProperty().bindBidirectional((Property)this.previewThreshold);
            GridPaneUtils.addGridRow((GridPane)paneOverlay, (int)row2++, (int)0, (String)"Override the main density map overlay to preview the current thresholds", (Node[])new Node[]{cbPreviewThreshold, cbPreviewThreshold});
            CheckBox cbDetections = new CheckBox("Show detections");
            cbDetections.selectedProperty().bindBidirectional((Property)this.qupath.getOverlayOptions().showDetectionsProperty());
            GridPaneUtils.addGridRow((GridPane)paneOverlay, (int)row2++, (int)0, (String)"Show or hide detections on the image", (Node[])new Node[]{cbDetections, cbDetections});
            Slider sliderOpacity = new Slider(0.0, 1.0, 0.5);
            sliderOpacity.valueProperty().bindBidirectional((Property)this.qupath.getOverlayOptions().opacityProperty());
            Label labelOpacity = new Label("Opacity");
            GridPaneUtils.addGridRow((GridPane)paneOverlay, (int)row2++, (int)0, (String)"Control the overlay opacity", (Node[])new Node[]{labelOpacity, sliderOpacity});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{paneOverlay, sliderOpacity, cbLayer, cbDetections, cbPreviewThreshold});
            paneOverlay.setHgap(5.0);
            paneOverlay.setVgap(5.0);
            TitledPane titledOverlay = new TitledPane("Overlay", (Node)paneOverlay);
            titledOverlay.setExpanded(false);
            FXUtils.simplifyTitledPane((TitledPane)titledOverlay, (boolean)true);
            titledOverlay.heightProperty().addListener((v, o, n) -> titledOverlay.getScene().getWindow().sizeToScene());
            return titledOverlay;
        }
    }

    static class HotspotFinder
    extends DensityMapButtonCommand {
        private IntegerProperty nHotspots = new SimpleIntegerProperty(1);
        private DoubleProperty thresholdCounts = new SimpleDoubleProperty(1.0);
        private BooleanProperty deletePrevious = new SimpleBooleanProperty(false);
        private BooleanProperty strictPeaks = new SimpleBooleanProperty(true);
        private int band = 0;
        private int bandCounts = -1;
        private PathClass aboveThreshold;

        public HotspotFinder(QuPathGUI qupath, ObjectExpression<PixelClassificationOverlay> overlay) {
            super(qupath, overlay);
            this.thresholdCounts.addListener((v, o, n) -> this.updateRenderer());
        }

        boolean showDialog(ImageServer<BufferedImage> densityServer, ColorModelRenderer renderer, Window owner) throws IOException {
            int tfWidth = 6;
            Label labelNum = new Label("Num hotspots");
            Slider sliderNum = new Slider(1.0, 10.0, 1.0);
            sliderNum.setMajorTickUnit(1.0);
            sliderNum.setMinorTickCount(0);
            sliderNum.setSnapToTicks(true);
            sliderNum.valueProperty().bindBidirectional((Property)this.nHotspots);
            TextField tfNum = new TextField();
            tfNum.setPrefColumnCount(tfWidth);
            FXUtils.bindSliderAndTextField((Slider)sliderNum, (TextField)tfNum, (boolean)false, (int)0);
            labelNum.setLabelFor((Node)sliderNum);
            Label labelCounts = new Label("Min object count");
            List<MinMax> minMaxAll = DensityMapUI.getMinMax(densityServer);
            int max = (int)Math.ceil(minMaxAll.get((int)this.bandCounts).maxValue);
            Slider sliderCounts = new Slider(0.0, (double)max, 1.0);
            sliderCounts.setMajorTickUnit(10.0);
            sliderCounts.setMinorTickCount(9);
            sliderCounts.setSnapToTicks(true);
            sliderCounts.valueProperty().bindBidirectional((Property)this.thresholdCounts);
            TextField tfCounts = new TextField();
            tfCounts.setPrefColumnCount(tfWidth);
            FXUtils.bindSliderAndTextField((Slider)sliderCounts, (TextField)tfCounts, (boolean)false, (int)0);
            labelCounts.setLabelFor((Node)sliderCounts);
            CheckBox cbPeaks = new CheckBox("Density peaks only");
            cbPeaks.selectedProperty().bindBidirectional((Property)this.strictPeaks);
            CheckBox cbDeletePrevious = new CheckBox("Delete existing hotspots");
            cbDeletePrevious.selectedProperty().bindBidirectional((Property)this.deletePrevious);
            GridPane pane = new GridPane();
            int row = 0;
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Maximum number of hotspots to create", (Node[])new Node[]{labelNum, sliderNum, tfNum});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"The minimum number of objects required.\nThis can eliminate hotspots based on just 1 or 2 objects.", (Node[])new Node[]{labelCounts, sliderCounts, tfCounts});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Limit hotspots to peaks in the density map only.\nThis is a stricter criteria that can result in fewer hotspots being found, however those that *are* found are more distinct.", (Node[])new Node[]{cbPeaks, cbPeaks, cbPeaks});
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Delete existing hotspots similar to those being created.", (Node[])new Node[]{cbDeletePrevious, cbDeletePrevious, cbDeletePrevious});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{sliderNum, sliderCounts, cbDeletePrevious, cbPeaks});
            TitledPane titledPane = new TitledPane("Hotspot parameters", (Node)pane);
            titledPane.setExpanded(true);
            titledPane.setCollapsible(false);
            FXUtils.simplifyTitledPane((TitledPane)titledPane, (boolean)true);
            BorderPane paneMain = new BorderPane((Node)titledPane);
            if (renderer != null) {
                paneMain.setBottom((Node)this.createOverlayPane());
                this.updateRenderer();
            }
            pane.setVgap(5.0);
            pane.setHgap(5.0);
            return Dialogs.builder().modality(Modality.WINDOW_MODAL).content((Node)paneMain).title(DensityMapUI.title).owner(owner).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).build().showAndWait().orElse(ButtonType.CANCEL) == ButtonType.APPLY;
        }

        @Override
        protected void customUpdateRenderer(ColorModelRenderer renderer) {
            if (renderer == null || this.aboveThreshold == null || this.bandCounts < 0) {
                return;
            }
            ThresholdColorModels.ColorModelThreshold threshold = ThresholdColorModels.ColorModelThreshold.create(4, this.bandCounts, this.thresholdCounts.get());
            this.updateRenderer(renderer, this.aboveThreshold, threshold);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(ActionEvent event, ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder builder, String densityMapName) {
            block11: {
                if (imageData == null || builder == null) {
                    Dialogs.showErrorMessage((String)DensityMapUI.title, (String)"No density map found!");
                    return;
                }
                ImageServer densityServer = builder.buildServer(imageData);
                ColorModelRenderer renderer = this.getRenderer();
                this.saveColorModel();
                try {
                    this.bandCounts = densityServer.nChannels() - 1;
                    ImageChannel channel = densityServer.getChannel(this.band);
                    this.aboveThreshold = PathClass.fromString((String)channel.getName(), (Integer)channel.getColor());
                    if (!this.showDialog((ImageServer<BufferedImage>)densityServer, renderer, this.getOwner(event))) {
                        return;
                    }
                    double radius = builder.buildParameters().getRadius();
                    int numHotspots = this.nHotspots.get();
                    double minDensity = this.thresholdCounts.get();
                    boolean peaksOnly = this.strictPeaks.get();
                    boolean deleteExisting = this.deletePrevious.get();
                    try {
                        PathObjectHierarchy hierarchy = imageData.getHierarchy();
                        DensityMaps.findHotspots((PathObjectHierarchy)hierarchy, (ImageServer)densityServer, (int)this.band, (int)numHotspots, (double)radius, (double)minDensity, (PathClass)this.aboveThreshold, (boolean)deleteExisting, (boolean)peaksOnly);
                        if (densityMapName != null) {
                            imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Density map find hotspots", String.format("findDensityMapHotspots(\"%s\", %d, %d, %f, %s, %s)", densityMapName, this.band, numHotspots, minDensity, deleteExisting, peaksOnly)));
                            break block11;
                        }
                        logger.warn("Density map not saved - cannot log step to workflow");
                    }
                    catch (IOException e) {
                        Dialogs.showErrorNotification((String)DensityMapUI.title, (Throwable)e);
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    logger.error(e.getLocalizedMessage(), (Throwable)e);
                    return;
                }
                finally {
                    this.restoreColorModel();
                    this.aboveThreshold = null;
                }
            }
        }
    }

    static class ContourTracer
    extends DensityMapButtonCommand {
        private DoubleProperty threshold = new SimpleDoubleProperty(Double.NaN);
        private DoubleProperty thresholdCounts = new SimpleDoubleProperty(1.0);
        private BooleanProperty deleteExisting = new SimpleBooleanProperty(false);
        private BooleanProperty split = new SimpleBooleanProperty(false);
        private BooleanProperty select = new SimpleBooleanProperty(false);
        private PathClass aboveThreshold;
        private int bandThreshold = 0;
        private int bandCounts = -1;

        ContourTracer(QuPathGUI qupath, ObjectExpression<PixelClassificationOverlay> overlay) {
            super(qupath, overlay);
            this.threshold.addListener((v, o, n) -> this.updateRenderer());
            this.thresholdCounts.addListener((v, o, n) -> this.updateRenderer());
        }

        boolean showDialog(ImageServer<BufferedImage> densityServer, ColorModelRenderer renderer, Window owner) throws IOException {
            boolean includeCounts;
            List<MinMax> minMaxAll = DensityMapUI.getMinMax(densityServer);
            MinMax minMax = minMaxAll.get(this.bandThreshold);
            Slider slider = new Slider(0.0, (double)((int)Math.ceil(minMax.getMaxValue())), (double)((int)(minMax.getMaxValue() / 2.0)));
            slider.setMinorTickCount((int)(slider.getMax() + 1.0));
            TextField tfThreshold = new TextField();
            tfThreshold.setPrefColumnCount(6);
            FXUtils.bindSliderAndTextField((Slider)slider, (TextField)tfThreshold, (boolean)false, (int)2);
            double t = this.threshold.get();
            if (!Double.isFinite(t) || t > slider.getMax() || t < slider.getMin()) {
                this.threshold.set(slider.getValue());
            }
            slider.valueProperty().bindBidirectional((Property)this.threshold);
            int row = 0;
            GridPane pane = new GridPane();
            Label labelThreshold = new Label("Density threshold");
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Threshold to identify high-density regions.", (Node[])new Node[]{labelThreshold, slider, tfThreshold});
            boolean bl = includeCounts = densityServer.nChannels() > 1;
            if (includeCounts) {
                this.bandCounts = densityServer.nChannels() - 1;
                MinMax minMaxCounts = minMaxAll.get(this.bandCounts);
                int max = (int)Math.ceil(minMaxCounts.getMaxValue());
                Slider sliderCounts = new Slider(0.0, (double)max, (double)((int)(minMaxCounts.getMaxValue() / 2.0)));
                sliderCounts.setMajorTickUnit(10.0);
                sliderCounts.setMinorTickCount(9);
                sliderCounts.setSnapToTicks(true);
                TextField tfThresholdCounts = new TextField();
                tfThresholdCounts.setPrefColumnCount(6);
                FXUtils.bindSliderAndTextField((Slider)sliderCounts, (TextField)tfThresholdCounts, (boolean)false, (int)0);
                double tc = this.thresholdCounts.get();
                if (tc > sliderCounts.getMax()) {
                    this.thresholdCounts.set(1.0);
                }
                sliderCounts.valueProperty().bindBidirectional((Property)this.thresholdCounts);
                Label labelCounts = new Label("Min object count");
                GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"The minimum number of objects required.\nUsed in combination with the density threshold to remove outliers (i.e. high density based on just 1 or 2 objects).", (Node[])new Node[]{labelCounts, sliderCounts, tfThresholdCounts});
            }
            CheckBox cbDeleteExisting = new CheckBox("Delete existing similar annotations");
            cbDeleteExisting.selectedProperty().bindBidirectional((Property)this.deleteExisting);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Delete existing annotations that share the same classification as the new annotations", (Node[])new Node[]{cbDeleteExisting, cbDeleteExisting, cbDeleteExisting});
            CheckBox cbSplit = new CheckBox("Split new annotations");
            cbSplit.selectedProperty().bindBidirectional((Property)this.split);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Split new, multi-part annotations into separate polygons", (Node[])new Node[]{cbSplit, cbSplit, cbSplit});
            CheckBox cbSelect = new CheckBox("Select new annotations");
            cbSelect.selectedProperty().bindBidirectional((Property)this.select);
            GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Automatically set new annotations to be selected.\nThis is useful if the next step involves manipulating the annotations (e.g. setting another classification).", (Node[])new Node[]{cbSelect, cbSelect, cbSelect});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{slider, cbDeleteExisting, cbSplit, cbSelect});
            TitledPane titledPane = new TitledPane("Threshold parameters", (Node)pane);
            titledPane.setExpanded(true);
            titledPane.setCollapsible(false);
            FXUtils.simplifyTitledPane((TitledPane)titledPane, (boolean)true);
            BorderPane paneMain = new BorderPane((Node)titledPane);
            if (renderer != null) {
                paneMain.setBottom((Node)this.createOverlayPane());
                this.updateRenderer();
            }
            pane.setVgap(5.0);
            pane.setHgap(5.0);
            return Dialogs.builder().modality(Modality.WINDOW_MODAL).content((Node)paneMain).title(DensityMapUI.title).owner(owner).buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).build().showAndWait().orElse(ButtonType.CANCEL) == ButtonType.APPLY;
        }

        @Override
        protected void customUpdateRenderer(ColorModelRenderer renderer) {
            if (renderer == null || this.aboveThreshold == null) {
                return;
            }
            ThresholdColorModels.ColorModelThreshold colorModelThreshold = this.bandCounts >= 0 ? ThresholdColorModels.ColorModelThreshold.create(4, Map.of(this.bandThreshold, this.threshold.get(), this.bandCounts, this.thresholdCounts.get())) : ThresholdColorModels.ColorModelThreshold.create(4, this.bandThreshold, this.threshold.get());
            this.updateRenderer(renderer, this.aboveThreshold, colorModelThreshold);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fire(ActionEvent event, ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder builder, String densityMapName) {
            if (imageData == null || builder == null) {
                Dialogs.showErrorMessage((String)DensityMapUI.title, (String)"No image available!");
                return;
            }
            ImageServer densityServer = builder.buildServer(imageData);
            ColorModelRenderer renderer = this.getRenderer();
            this.saveColorModel();
            try {
                this.bandThreshold = 0;
                this.bandCounts = -1;
                ImageChannel channel = densityServer.getChannel(this.bandThreshold);
                this.aboveThreshold = PathClass.fromString((String)channel.getName(), (Integer)channel.getColor());
                if (!this.showDialog((ImageServer<BufferedImage>)densityServer, renderer, this.getOwner(event))) {
                    return;
                }
            }
            catch (IOException e2) {
                logger.error(e2.getLocalizedMessage(), (Throwable)e2);
                return;
            }
            finally {
                this.restoreColorModel();
                this.aboveThreshold = null;
            }
            double countThreshold = this.thresholdCounts.get();
            double threshold = this.threshold.get();
            boolean doDelete = this.deleteExisting.get();
            boolean doSplit = this.split.get();
            boolean doSelect = this.select.get();
            ArrayList<PixelClassifierTools.CreateObjectOptions> options = new ArrayList<PixelClassifierTools.CreateObjectOptions>();
            if (doDelete) {
                options.add(PixelClassifierTools.CreateObjectOptions.DELETE_EXISTING);
            }
            if (doSplit) {
                options.add(PixelClassifierTools.CreateObjectOptions.SPLIT);
            }
            if (doSelect) {
                options.add(PixelClassifierTools.CreateObjectOptions.SELECT_NEW);
            }
            Map<Integer, Double> thresholds = this.bandCounts > 0 ? Map.of(this.bandThreshold, threshold, this.bandCounts, countThreshold) : Map.of(this.bandThreshold, threshold);
            String pathClassName = densityServer.getChannel(0).getName();
            try {
                DensityMaps.threshold((PathObjectHierarchy)imageData.getHierarchy(), (ImageServer)densityServer, thresholds, (String)pathClassName, (PixelClassifierTools.CreateObjectOptions[])((PixelClassifierTools.CreateObjectOptions[])options.toArray(PixelClassifierTools.CreateObjectOptions[]::new)));
            }
            catch (IOException e1) {
                Dialogs.showErrorMessage((String)DensityMapUI.title, (Throwable)e1);
                logger.error(e1.getMessage(), (Throwable)e1);
                return;
            }
            if (densityMapName != null) {
                Object optionsString = "";
                if (!options.isEmpty()) {
                    optionsString = ", " + options.stream().map(o -> "\"" + o.name() + "\"").collect(Collectors.joining(", "));
                }
                String thresholdString = "[" + thresholds.entrySet().stream().map(e -> String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue())).collect(Collectors.joining(", ")) + "]";
                imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Density map create annotations", String.format("createAnnotationsFromDensityMap(\"%s\", %s, \"%s\"%s)", densityMapName, thresholdString.toString(), pathClassName, optionsString)));
            }
        }
    }

    static class DensityMapExporter
    extends DensityMapButtonCommand {
        public DensityMapExporter(QuPathGUI qupath, ObjectExpression<PixelClassificationOverlay> overlay) {
            super(qupath, overlay);
        }

        @Override
        public void fire(ActionEvent event, ImageData<BufferedImage> imageData, DensityMaps.DensityMapBuilder builder, String densityMapName) {
            if (imageData == null || builder == null) {
                Dialogs.showErrorMessage((String)DensityMapUI.title, (String)"No density map is available!");
                return;
            }
            ImageServer densityMapServer = builder.buildServer(imageData);
            Dialog dialog = new Dialog();
            dialog.setTitle(DensityMapUI.title);
            dialog.setHeaderText("How do you want to export the density map?");
            dialog.setContentText("Choose 'Raw values' or 'Send to ImageJ' if you need the original counts, or 'Color overlay' if you want to keep the same visual appearance.");
            ButtonType btOrig = new ButtonType("Raw values");
            ButtonType btColor = new ButtonType("Color overlay");
            ButtonType btImageJ = new ButtonType("Send to ImageJ");
            dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{btOrig, btColor, btImageJ, ButtonType.CANCEL});
            ButtonType response = dialog.showAndWait().orElse(ButtonType.CANCEL);
            try {
                if (btOrig.equals(response)) {
                    this.promptToSaveRawImage(imageData, (ImageServer<BufferedImage>)densityMapServer, densityMapName);
                } else if (btColor.equals(response)) {
                    this.promptToSaveColorImage((ImageServer<BufferedImage>)densityMapServer, null);
                } else if (btImageJ.equals(response)) {
                    this.sendToImageJ((ImageServer<BufferedImage>)densityMapServer);
                }
            }
            catch (IOException e) {
                Dialogs.showErrorNotification((String)DensityMapUI.title, (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
            }
        }

        @Override
        protected void customUpdateRenderer(ColorModelRenderer renderer) {
        }

        private void promptToSaveRawImage(ImageData<BufferedImage> imageData, ImageServer<BufferedImage> densityMap, String densityMapName) throws IOException {
            File file = FileChoosers.promptToSaveFile((String)DensityMapUI.title, (File)(densityMapName == null ? null : new File(densityMapName)), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"ImageJ tif", (String[])new String[]{".tif"})});
            if (file != null) {
                try {
                    QP.writeImage(densityMap, (String)file.getAbsolutePath());
                    if (densityMapName != null && !densityMapName.isBlank()) {
                        String path = file.getAbsolutePath();
                        imageData.getHistoryWorkflow().addStep((WorkflowStep)new DefaultScriptableWorkflowStep("Write density map image", String.format("writeDensityMapImage(\"%s\", \"%s\")", densityMapName, path)));
                    }
                }
                catch (IOException e) {
                    Dialogs.showErrorMessage((String)"Save prediction", (Throwable)e);
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }

        private void promptToSaveColorImage(ImageServer<BufferedImage> densityMap, ColorModel colorModel) throws IOException {
            String ext;
            String fmt;
            ImageServer server = RenderedImageServer.createRenderedServer(densityMap, (ImageRenderer)new ColorModelRenderer(colorModel));
            if (server.nResolutions() == 1 && server.nTimepoints() == 1 && server.nZSlices() == 1) {
                fmt = "PNG";
                ext = ".png";
            } else {
                fmt = "ImageJ tif";
                ext = ".tif";
            }
            File file = FileChoosers.promptToSaveFile((String)DensityMapUI.title, null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)fmt, (String[])new String[]{ext})});
            if (file != null) {
                QP.writeImage((ImageServer)server, (String)file.getAbsolutePath());
            }
        }

        private void sendToImageJ(ImageServer<BufferedImage> densityMap) throws IOException {
            if (densityMap == null) {
                Dialogs.showErrorMessage((String)DensityMapUI.title, (String)"No density map is available!");
                return;
            }
            IJExtension.getImageJInstance();
            ImagePlus imp = IJTools.extractHyperstack(densityMap, null);
            if (imp instanceof CompositeImage) {
                ((CompositeImage)imp).resetDisplayRanges();
            }
            imp.show();
        }
    }

    static class ThresholdColorModels {
        ThresholdColorModels() {
        }

        static class ThresholdColorModel
        extends ColorModel {
            private ColorModelThreshold threshold;
            protected Color above;
            protected Color equals;
            protected Color below;

            public ThresholdColorModel(ColorModelThreshold threshold, Color below, Color equals, Color above) {
                super(threshold.getBits());
                this.threshold = threshold;
                this.below = below;
                this.equals = equals;
                this.above = above;
            }

            @Override
            public int getRed(int pixel) {
                throw new IllegalArgumentException();
            }

            @Override
            public int getGreen(int pixel) {
                throw new IllegalArgumentException();
            }

            @Override
            public int getBlue(int pixel) {
                throw new IllegalArgumentException();
            }

            @Override
            public int getAlpha(int pixel) {
                throw new IllegalArgumentException();
            }

            @Override
            public int getRed(Object pixel) {
                return this.getColor(pixel).getRed();
            }

            @Override
            public int getGreen(Object pixel) {
                return this.getColor(pixel).getGreen();
            }

            @Override
            public int getBlue(Object pixel) {
                return this.getColor(pixel).getBlue();
            }

            @Override
            public int getAlpha(Object pixel) {
                return this.getColor(pixel).getAlpha();
            }

            public Color getColor(Object input) {
                int cmp = this.threshold.threshold(input);
                if (cmp > 0) {
                    return this.above;
                }
                if (cmp < 0) {
                    return this.below;
                }
                return this.equals;
            }

            @Override
            public boolean isCompatibleRaster(Raster raster) {
                return raster.getTransferType() == this.threshold.getTransferType();
            }
        }

        static class MultiBandThreshold
        extends ColorModelThreshold {
            private int n;
            private int[] bands;
            private double[] thresholds;

            MultiBandThreshold(int transferType, Map<Integer, ? extends Number> thresholds) {
                super(transferType);
                this.n = thresholds.size();
                this.bands = new int[this.n];
                this.thresholds = new double[this.n];
                int i = 0;
                for (Map.Entry<Integer, ? extends Number> entry : thresholds.entrySet()) {
                    this.bands[i] = entry.getKey();
                    this.thresholds[i] = entry.getValue().doubleValue();
                    ++i;
                }
            }

            @Override
            protected int threshold(Object input) {
                int sum = 0;
                for (int i = 0; i < this.n; ++i) {
                    double val = this.getValue(input, this.bands[i]);
                    int cmp = Double.compare(val, this.thresholds[i]);
                    if (cmp < 0) {
                        return -1;
                    }
                    sum += cmp;
                }
                return sum;
            }
        }

        static class SingleBandThreshold
        extends ColorModelThreshold {
            private int band;
            private double threshold;

            SingleBandThreshold(int transferType, int band, double threshold) {
                super(transferType);
                this.band = band;
                this.threshold = threshold;
            }

            @Override
            protected int threshold(Object input) {
                return Double.compare(this.getValue(input, this.band), this.threshold);
            }
        }

        static abstract class ColorModelThreshold {
            private int transferType;

            static ColorModelThreshold create(int transferType, int band, double threshold) {
                return new SingleBandThreshold(transferType, band, threshold);
            }

            static ColorModelThreshold create(int transferType, Map<Integer, ? extends Number> thresholds) {
                if (thresholds.size() == 1) {
                    Map.Entry<Integer, ? extends Number> entry = thresholds.entrySet().iterator().next();
                    return ColorModelThreshold.create(transferType, entry.getKey(), entry.getValue().doubleValue());
                }
                return new MultiBandThreshold(transferType, thresholds);
            }

            ColorModelThreshold(int transferType) {
                this.transferType = transferType;
            }

            protected int getTransferType() {
                return this.transferType;
            }

            protected int getBits() {
                return DataBuffer.getDataTypeSize(this.transferType);
            }

            protected double getValue(Object input, int band) {
                if (input instanceof float[]) {
                    return ((float[])input)[band];
                }
                if (input instanceof double[]) {
                    return ((double[])input)[band];
                }
                if (input instanceof int[]) {
                    return ((int[])input)[band];
                }
                if (input instanceof byte[]) {
                    return ((byte[])input)[band] & 0xFF;
                }
                if (input instanceof short[]) {
                    short val = ((short[])input)[band];
                    if (this.transferType == 2) {
                        return val;
                    }
                    return val & 0xFFFF;
                }
                return Double.NaN;
            }

            protected abstract int threshold(Object var1);
        }
    }

    static class MinMax {
        private float minValue = Float.POSITIVE_INFINITY;
        private float maxValue = Float.NEGATIVE_INFINITY;

        MinMax() {
        }

        private void update(float val) {
            if (Float.isNaN(val)) {
                return;
            }
            if (val < this.minValue) {
                this.minValue = val;
            }
            if (val > this.maxValue) {
                this.maxValue = val;
            }
        }

        public double getMinValue() {
            return this.minValue;
        }

        public double getMaxValue() {
            return this.maxValue;
        }
    }

    static enum DensityMapObjects {
        DETECTIONS(PathObjectFilter.DETECTIONS_ALL),
        CELLS(PathObjectFilter.CELLS),
        POINT_ANNOTATIONS(PathObjectPredicates.filter((PathObjectFilter)PathObjectFilter.ANNOTATIONS).and(PathObjectPredicates.filter((PathObjectFilter)PathObjectFilter.ROI_POINT)));

        private final PathObjectPredicates.PathObjectPredicate predicate;

        private DensityMapObjects(PathObjectFilter filter) {
            this(PathObjectPredicates.filter((PathObjectFilter)filter));
        }

        private DensityMapObjects(PathObjectPredicates.PathObjectPredicate predicate) {
            this.predicate = predicate;
        }

        public PathObjectPredicates.PathObjectPredicate getPredicate() {
            return this.predicate;
        }

        public String toString() {
            switch (this.ordinal()) {
                case 0: {
                    return "All detections";
                }
                case 1: {
                    return "All cells";
                }
                case 2: {
                    return "Point annotations";
                }
            }
            throw new IllegalArgumentException("Unknown enum " + String.valueOf((Object)this));
        }
    }
}

