/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands.density;

import com.google.gson.Gson;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.heatmaps.ColorModels;
import qupath.lib.analysis.heatmaps.DensityMaps;
import qupath.lib.color.ColorMaps;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.images.stores.ColorModelRenderer;
import qupath.lib.gui.images.stores.ImageRenderer;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.ImageInterpolation;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.QuPathViewerListener;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.io.GsonTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectPredicates;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.projects.Project;
import qupath.process.gui.commands.density.DensityMapUI;

public class DensityMapDialog {
    private static final Logger logger = LoggerFactory.getLogger(DensityMapDialog.class);
    private QuPathGUI qupath;
    private final Stage stage;
    private final ObservableDensityMapBuilder densityMapBuilder = new ObservableDensityMapBuilder();
    private final ObservableColorModelBuilder colorModelBuilder = new ObservableColorModelBuilder();
    private final ObjectExpression<DensityMaps.DensityMapBuilder> combinedBuilder = Bindings.createObjectBinding(() -> {
        DensityMaps.DensityMapBuilder b = (DensityMaps.DensityMapBuilder)this.densityMapBuilder.getBuilderProperty().get();
        ColorModels.ColorModelBuilder c = (ColorModels.ColorModelBuilder)this.colorModelBuilder.getBuilderProperty().get();
        if (b == null || c == null) {
            return b;
        }
        DensityMaps.DensityMapBuilder builder2 = DensityMaps.builder((DensityMaps.DensityMapBuilder)b).colorModel(c);
        return builder2;
    }, (Observable[])new Observable[]{this.densityMapBuilder.getBuilderProperty(), this.colorModelBuilder.getBuilderProperty()});
    private final ObjectProperty<ImageInterpolation> interpolation = new SimpleObjectProperty((Object)ImageInterpolation.NEAREST);
    private HierarchyClassifierOverlayManager manager;
    private final double textFieldWidth = 80.0;
    private final double hGap = 5.0;
    private final double vGap = 5.0;

    public DensityMapDialog(QuPathGUI qupath) {
        this.qupath = qupath;
        logger.debug("Constructing density map dialog");
        Pane paneParams = this.buildAllObjectsPane(this.densityMapBuilder);
        TitledPane titledPaneParams = new TitledPane("Create density map", (Node)paneParams);
        titledPaneParams.setExpanded(true);
        titledPaneParams.setCollapsible(false);
        FXUtils.simplifyTitledPane((TitledPane)titledPaneParams, (boolean)true);
        Pane paneDisplay = this.buildDisplayPane(this.colorModelBuilder);
        TitledPane titledPaneDisplay = new TitledPane("Customize appearance", (Node)paneDisplay);
        titledPaneDisplay.setExpanded(false);
        FXUtils.simplifyTitledPane((TitledPane)titledPaneDisplay, (boolean)true);
        GridPane pane = this.createGridPane();
        int row = 0;
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{titledPaneParams, titledPaneParams, titledPaneParams});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{titledPaneDisplay, titledPaneDisplay, titledPaneDisplay});
        ToggleButton btnAutoUpdate = new ToggleButton("Live update");
        btnAutoUpdate.setSelected(this.densityMapBuilder.autoUpdate.get());
        btnAutoUpdate.setMaxWidth(Double.MAX_VALUE);
        btnAutoUpdate.selectedProperty().bindBidirectional((Property)this.densityMapBuilder.autoUpdate);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Automatically update the density map. Turn this off if changing parameters and heatmap generation is slow.", (Node[])new Node[]{btnAutoUpdate, btnAutoUpdate, btnAutoUpdate});
        SimpleStringProperty densityMapName = new SimpleStringProperty();
        Pane savePane = DensityMapUI.createSaveDensityMapPane((ObjectExpression<Project<BufferedImage>>)qupath.projectProperty(), this.combinedBuilder, (StringProperty)densityMapName);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{savePane, savePane, savePane});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{savePane});
        Pane buttonPane = DensityMapUI.createButtonPane(qupath, (ObjectExpression<ImageData<BufferedImage>>)qupath.imageDataProperty(), this.combinedBuilder, (StringExpression)densityMapName, (ObjectExpression<PixelClassificationOverlay>)Bindings.createObjectBinding(() -> this.manager == null ? null : this.manager.overlay, (Observable[])new Observable[0]), true);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{buttonPane, buttonPane, buttonPane});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{btnAutoUpdate, buttonPane});
        pane.setPadding(new Insets(10.0));
        this.stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.setResizable(false);
        this.stage.initOwner((Window)qupath.getStage());
        this.stage.setTitle("Density map");
        titledPaneDisplay.heightProperty().addListener((v, o, n) -> this.stage.sizeToScene());
        this.manager = new HierarchyClassifierOverlayManager(qupath, (ObservableValue<DensityMaps.DensityMapBuilder>)this.densityMapBuilder.builder, this.colorModelBuilder.colorModel, (ObservableValue<ImageInterpolation>)this.interpolation);
        this.manager.currentDensityMap.addListener((v, o, n) -> this.colorModelBuilder.updateDisplayRanges((ImageServer<BufferedImage>)n));
        this.stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.manager.updateViewers();
            }
        });
    }

    private ObservableList<PathClass> createObservablePathClassList(PathClass ... defaultClasses) {
        ObservableList available = this.qupath.getAvailablePathClasses();
        if (defaultClasses.length == 0) {
            return available;
        }
        ObservableList list = FXCollections.observableArrayList((Object[])defaultClasses);
        available.addListener(c -> DensityMapDialog.updateList((ObservableList<PathClass>)list, (ObservableList<PathClass>)available, defaultClasses));
        DensityMapDialog.updateList((ObservableList<PathClass>)list, (ObservableList<PathClass>)available, defaultClasses);
        return list;
    }

    private static void updateList(ObservableList<PathClass> mainList, ObservableList<PathClass> originalList, PathClass ... additionalItems) {
        LinkedHashSet<PathClass> temp = new LinkedHashSet<PathClass>();
        for (PathClass t : additionalItems) {
            temp.add(t);
        }
        temp.addAll((Collection<PathClass>)originalList);
        mainList.setAll(temp);
    }

    private Pane buildAllObjectsPane(ObservableDensityMapBuilder params) {
        ComboBox comboObjectType = new ComboBox();
        comboObjectType.getItems().setAll((Object[])DensityMapUI.DensityMapObjects.values());
        comboObjectType.getSelectionModel().select((Object)DensityMapUI.DensityMapObjects.DETECTIONS);
        params.allObjectTypes.bind((ObservableValue)comboObjectType.getSelectionModel().selectedItemProperty());
        ComboBox comboAllObjects = new ComboBox(this.createObservablePathClassList(DensityMapUI.ANY_CLASS_OR_NONE, DensityMapUI.ANY_SPECIFIED_CLASS));
        comboAllObjects.setButtonCell(FXUtils.createCustomListCell(this::classificationText));
        comboAllObjects.setCellFactory(c -> FXUtils.createCustomListCell(this::classificationText));
        params.allObjectClass.bind((ObservableValue)comboAllObjects.getSelectionModel().selectedItemProperty());
        comboAllObjects.getSelectionModel().selectFirst();
        ComboBox comboPrimary = new ComboBox(this.createObservablePathClassList(DensityMapUI.ANY_CLASS_OR_NONE, DensityMapUI.ANY_POSITIVE_CLASS));
        comboPrimary.setButtonCell(FXUtils.createCustomListCell(this::classificationText));
        comboPrimary.setCellFactory(c -> FXUtils.createCustomListCell(this::classificationText));
        params.densityObjectClass.bind((ObservableValue)comboPrimary.getSelectionModel().selectedItemProperty());
        comboPrimary.getSelectionModel().selectFirst();
        ComboBox comboDensityType = new ComboBox();
        comboDensityType.getItems().setAll((Object[])DensityMaps.DensityMapType.values());
        comboDensityType.getSelectionModel().select((Object)DensityMaps.DensityMapType.SUM);
        params.densityType.bind((ObservableValue)comboDensityType.getSelectionModel().selectedItemProperty());
        GridPane pane = this.createGridPane();
        int row = 0;
        Label labelObjects = this.createTitleLabel("Choose all objects to include");
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{labelObjects, labelObjects, labelObjects});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select objects used to generate the density map.\nUse 'All detections' to include all detection objects (including cells and tiles).\nUse 'All cells' to include cell objects only.\nUse 'Point annotations' to use annotated points rather than detections.", (Node[])new Node[]{new Label("Object type"), comboObjectType, comboObjectType});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select object classifications to include.\nUse this to filter out detections that should not contribute to the density map at all.\nFor example, this can be used to selectively consider tumor cells and ignore everything else.\nIf used in combination with 'Secondary class' and 'Density type: Objects %', the 'Secondary class' defines the numerator and the 'Main class' defines the denominator.", (Node[])new Node[]{new Label("Main class"), comboAllObjects, comboAllObjects});
        Label labelDensities = this.createTitleLabel("Define density map");
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{labelDensities});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Calculate the density of objects containing a specified classification.\nIf used in combination with 'Main class' and 'Density type: Objects %', the 'Secondary class' defines the numerator and the 'Main class' defines the denominator.\nFor example, choose 'Main class: Tumor', 'Secondary class: Positive' and 'Density type: Objects %' to define density as the proportion of tumor cells that are positive.", (Node[])new Node[]{new Label("Secondary class"), comboPrimary, comboPrimary});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select method of normalizing densities.\nChoose whether to show raw counts, or normalize densities by area or the number of objects locally.\nThis can be used to distinguish between the total number of objects in an area with a given classification, and the proportion of objects within the area with that classification.\nGaussian weighting gives a smoother result, but it can be harder to interpret.", (Node[])new Node[]{new Label("Density type"), comboDensityType, comboDensityType});
        Slider sliderRadius = new Slider(0.0, 1000.0, params.radius.get());
        sliderRadius.valueProperty().bindBidirectional((Property)params.radius);
        this.initializeSliderSnapping(sliderRadius, 50.0, 1.0, 0.1);
        TextField tfRadius = this.createTextField();
        boolean expandSliderLimits = true;
        FXUtils.bindSliderAndTextField((Slider)sliderRadius, (TextField)tfRadius, (boolean)expandSliderLimits, (int)2);
        GuiTools.installRangePrompt((Slider)sliderRadius);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)("Select smoothing radius used to calculate densities.\nThis is defined in calibrated pixel units (e.g. " + GeneralTools.micrometerSymbol() + " if available)."), (Node[])new Node[]{new Label("Density radius"), sliderRadius, tfRadius});
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{comboObjectType, comboPrimary, comboAllObjects, comboDensityType, sliderRadius});
        return pane;
    }

    private Pane buildDisplayPane(ObservableColorModelBuilder displayParams) {
        ComboBox comboColorMap = new ComboBox();
        comboColorMap.getItems().setAll(ColorMaps.getColorMaps().values());
        if (comboColorMap.getSelectionModel().getSelectedItem() == null) {
            comboColorMap.getSelectionModel().select((Object)ColorMaps.getDefaultColorMap());
        }
        displayParams.colorMap.bind((ObservableValue)comboColorMap.getSelectionModel().selectedItemProperty());
        ComboBox comboInterpolation = new ComboBox();
        GridPane paneDisplay = this.createGridPane();
        int rowDisplay = 0;
        Label labelColormap = this.createTitleLabel("Colors");
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Customize the colors of the density map", (Node[])new Node[]{labelColormap, labelColormap, labelColormap});
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Choose the colormap to use for display", (Node[])new Node[]{new Label("Colormap"), comboColorMap, comboColorMap});
        GridPane spinnerGrid = new GridPane();
        int spinnerRow = 0;
        Spinner<Double> spinnerMin = this.createSpinner(displayParams.minDisplay, 10.0);
        Spinner<Double> spinnerMax = this.createSpinner(displayParams.maxDisplay, 10.0);
        spinnerGrid.setHgap(5.0);
        spinnerGrid.setVgap(5.0);
        ToggleButton toggleAuto = new ToggleButton("Auto");
        toggleAuto.selectedProperty().bindBidirectional((Property)displayParams.autoUpdateDisplayRange);
        spinnerMin.disableProperty().bind((ObservableValue)toggleAuto.selectedProperty());
        spinnerMax.disableProperty().bind((ObservableValue)toggleAuto.selectedProperty());
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{spinnerMin, spinnerMax});
        GridPaneUtils.addGridRow((GridPane)spinnerGrid, (int)spinnerRow++, (int)0, null, (Node[])new Node[]{new Label("Min"), spinnerMin, new Label("Max"), spinnerMax, toggleAuto});
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Set the min/max density values for the colormap.\nThis determines how the colors in the colormap relate to density values.\nChoose 'Auto' to assign colors based upon the full range of the values in the current density map.", (Node[])new Node[]{new Label("Range"), spinnerGrid, spinnerGrid});
        Label labelAlpha = this.createTitleLabel("Opacity");
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Customize the opacity (alpha) of the density map.\nNote that this is based upon the count of all objects.", (Node[])new Node[]{labelAlpha, labelAlpha, labelAlpha});
        GridPane spinnerGridAlpha = new GridPane();
        spinnerRow = 0;
        Spinner<Double> spinnerMinAlpha = this.createSpinner(displayParams.minAlpha, 10.0);
        Spinner<Double> spinnerMaxAlpha = this.createSpinner(displayParams.maxAlpha, 10.0);
        spinnerGridAlpha.setHgap(5.0);
        spinnerGridAlpha.setVgap(5.0);
        ToggleButton toggleAutoAlpha = new ToggleButton("Auto");
        toggleAutoAlpha.selectedProperty().bindBidirectional((Property)displayParams.autoUpdateAlphaRange);
        spinnerMinAlpha.disableProperty().bind((ObservableValue)toggleAutoAlpha.selectedProperty());
        spinnerMaxAlpha.disableProperty().bind((ObservableValue)toggleAutoAlpha.selectedProperty());
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{spinnerMinAlpha, spinnerMaxAlpha});
        GridPaneUtils.addGridRow((GridPane)spinnerGridAlpha, (int)spinnerRow++, (int)0, null, (Node[])new Node[]{new Label("Min"), spinnerMinAlpha, new Label("Max"), spinnerMaxAlpha, toggleAutoAlpha});
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Set the min/max density values for the opacity range.\nThis can used in combination with 'Gamma' to adjust the opacity according to the number or density of objects. Use 'Auto' to use the full display range for the current image.", (Node[])new Node[]{new Label("Range"), spinnerGridAlpha, spinnerGridAlpha});
        Slider sliderGamma = new Slider(0.0, 5.0, displayParams.gamma.get());
        sliderGamma.valueProperty().bindBidirectional((Property)displayParams.gamma);
        this.initializeSliderSnapping(sliderGamma, 0.1, 1.0, 0.1);
        TextField tfGamma = this.createTextField();
        FXUtils.bindSliderAndTextField((Slider)sliderGamma, (TextField)tfGamma, (boolean)false, (int)1);
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Control how the opacity of the density map changes between min & max values.\nChoose zero for an opaque map.", (Node[])new Node[]{new Label("Gamma"), sliderGamma, tfGamma});
        Label labelSmoothness = this.createTitleLabel("Smoothness");
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Customize density map interpolation (visual smoothness)", (Node[])new Node[]{labelSmoothness});
        GridPaneUtils.addGridRow((GridPane)paneDisplay, (int)rowDisplay++, (int)0, (String)"Choose how the density map should be interpolated.\nThis impacts the visual smoothness, especially if the density radius is small and the image is viewed while zoomed in.", (Node[])new Node[]{new Label("Interpolation"), comboInterpolation, comboInterpolation});
        comboInterpolation.getItems().setAll((Object[])ImageInterpolation.values());
        comboInterpolation.getSelectionModel().select((Object)ImageInterpolation.NEAREST);
        this.interpolation.bind((ObservableValue)comboInterpolation.getSelectionModel().selectedItemProperty());
        GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{comboColorMap, comboInterpolation, sliderGamma});
        return paneDisplay;
    }

    Spinner<Double> createSpinner(ObjectProperty<Double> property, double step) {
        Spinner spinner = FXUtils.createDynamicStepSpinner((double)0.0, (double)Double.MAX_VALUE, (double)1.0, (double)0.1, (int)1);
        property.bindBidirectional((Property)spinner.getValueFactory().valueProperty());
        spinner.setEditable(true);
        spinner.getEditor().setPrefColumnCount(6);
        FXUtils.restrictTextFieldInputToNumber((TextField)spinner.getEditor(), (boolean)true);
        FXUtils.resetSpinnerNullToPrevious((Spinner)spinner);
        return spinner;
    }

    Label createTitleLabel(String text) {
        Label label = new Label(text);
        label.setStyle("-fx-font-weight: bold;");
        label.setMaxWidth(Double.MAX_VALUE);
        return label;
    }

    GridPane createGridPane() {
        GridPane pane = new GridPane();
        pane.setVgap(5.0);
        pane.setHgap(5.0);
        return pane;
    }

    TextField createTextField() {
        TextField textField = new TextField();
        textField.setMaxWidth(80.0);
        return textField;
    }

    public boolean updateDefaults(ImageData<BufferedImage> imageData) {
        if (imageData == null) {
            return false;
        }
        logger.debug("Updating density map defaults for {}", imageData);
        ImageServer server = imageData.getServer();
        double pixelSize = Math.round(server.getPixelCalibration().getAveragedPixelSize().doubleValue() * 10.0);
        pixelSize *= 100.0;
        pixelSize = Math.min(pixelSize, (double)Math.min(server.getHeight(), server.getWidth()) / 20.0);
        this.densityMapBuilder.radius.set(pixelSize);
        return true;
    }

    private void initializeSliderSnapping(Slider slider, double blockIncrement, double majorTicks, double minorTicks) {
        slider.setBlockIncrement(blockIncrement);
        slider.setMajorTickUnit(majorTicks);
        slider.setMinorTickCount((int)Math.round(majorTicks / minorTicks) - 1);
        slider.setSnapToTicks(true);
    }

    private String classificationText(PathClass pathClass) {
        if (pathClass == null) {
            pathClass = PathClass.NULL_CLASS;
        }
        if (pathClass == DensityMapUI.ANY_CLASS_OR_NONE) {
            return "Any or none";
        }
        if (pathClass == DensityMapUI.ANY_SPECIFIED_CLASS) {
            return "Any class (exclude unclassified)";
        }
        if (pathClass == DensityMapUI.ANY_POSITIVE_CLASS) {
            return "Positive (inc. 1+, 2+, 3+)";
        }
        return pathClass.toString();
    }

    public void deregister() {
        logger.debug("Deregistering density map dialog");
        this.manager.shutdown();
    }

    public Stage getStage() {
        return this.stage;
    }

    static class ObservableDensityMapBuilder {
        private static final Logger logger = LoggerFactory.getLogger(ObservableDensityMapBuilder.class);
        private ObjectProperty<DensityMapUI.DensityMapObjects> allObjectTypes = new SimpleObjectProperty((Object)DensityMapUI.DensityMapObjects.DETECTIONS);
        private ObjectProperty<PathClass> allObjectClass = new SimpleObjectProperty((Object)DensityMapUI.ANY_CLASS_OR_NONE);
        private ObjectProperty<PathClass> densityObjectClass = new SimpleObjectProperty((Object)DensityMapUI.ANY_CLASS_OR_NONE);
        private ObjectProperty<DensityMaps.DensityMapType> densityType = new SimpleObjectProperty((Object)DensityMaps.DensityMapType.SUM);
        private DoubleProperty radius = new SimpleDoubleProperty(10.0);
        private final BooleanProperty autoUpdate = new SimpleBooleanProperty(true);
        private final ObjectProperty<DensityMaps.DensityMapBuilder> builder = new SimpleObjectProperty();
        private Gson gson = GsonTools.getInstance();

        ObservableDensityMapBuilder() {
            this.allObjectTypes.addListener((v, o, n) -> this.updateBuilder());
            this.allObjectClass.addListener((v, o, n) -> this.updateBuilder());
            this.densityObjectClass.addListener((v, o, n) -> this.updateBuilder());
            this.densityType.addListener((v, o, n) -> this.updateBuilder());
            this.radius.addListener((v, o, n) -> this.updateBuilder());
            this.autoUpdate.addListener((v, o, n) -> this.updateBuilder());
        }

        public ObjectProperty<DensityMaps.DensityMapBuilder> getBuilderProperty() {
            return this.builder;
        }

        private void updateBuilder() {
            if (!this.autoUpdate.get()) {
                return;
            }
            DensityMaps.DensityMapBuilder newBuilder = this.createBuilder();
            DensityMaps.DensityMapBuilder currentBuilder = (DensityMaps.DensityMapBuilder)this.builder.get();
            if (!(newBuilder == null || Objects.equals(newBuilder, currentBuilder) || currentBuilder != null && Objects.equals(this.gson.toJson((Object)currentBuilder), this.gson.toJson((Object)newBuilder)))) {
                logger.debug("Setting DensityMapBuilder to {}", (Object)newBuilder);
                this.builder.set((Object)newBuilder);
                return;
            }
            logger.trace("Skipping DensityMapBuilder update");
        }

        private PathObjectPredicates.PathObjectPredicate updatePredicate(PathObjectPredicates.PathObjectPredicate predicate, PathClass pathClass) {
            if (pathClass == DensityMapUI.ANY_CLASS_OR_NONE) {
                return predicate;
            }
            PathObjectPredicates.PathObjectPredicate pathClassPredicate = pathClass == DensityMapUI.ANY_SPECIFIED_CLASS ? PathObjectPredicates.filter((PathObjectFilter)PathObjectFilter.CLASSIFIED) : (pathClass == DensityMapUI.ANY_POSITIVE_CLASS ? PathObjectPredicates.positiveClassification((boolean)true) : (pathClass == null || pathClass.getName() == null ? PathObjectPredicates.exactClassification((PathClass[])new PathClass[]{null}) : (pathClass.isDerivedClass() ? PathObjectPredicates.exactClassification((PathClass[])new PathClass[]{pathClass}) : PathObjectPredicates.containsClassification((String[])new String[]{pathClass.getName()}))));
            return predicate == null ? pathClassPredicate : predicate.and(pathClassPredicate);
        }

        private DensityMaps.DensityMapBuilder createBuilder() {
            boolean bothAnyObject;
            logger.trace("Creating new DensityMapBuilder");
            PathObjectPredicates.PathObjectPredicate allObjectsFilter = ((DensityMapUI.DensityMapObjects)((Object)this.allObjectTypes.get())).getPredicate();
            PathClass primaryClass = (PathClass)this.allObjectClass.get();
            allObjectsFilter = this.updatePredicate(allObjectsFilter, primaryClass);
            DensityMaps.DensityMapType densityType = (DensityMaps.DensityMapType)this.densityType.get();
            boolean isPercent = densityType == DensityMaps.DensityMapType.PERCENT;
            PathClass densityClass = (PathClass)this.densityObjectClass.get();
            if (densityClass == null) {
                densityClass = DensityMapUI.ANY_CLASS_OR_NONE;
            }
            if (densityClass == DensityMapUI.ANY_CLASS_OR_NONE && primaryClass != null) {
                densityClass = primaryClass;
            }
            PathObjectPredicates.PathObjectPredicate densityObjectsFilter = this.updatePredicate(null, densityClass);
            boolean bl = bothAnyObject = isPercent && densityClass == DensityMapUI.ANY_CLASS_OR_NONE && primaryClass == DensityMapUI.ANY_CLASS_OR_NONE;
            if (densityObjectsFilter == null && bothAnyObject) {
                densityObjectsFilter = allObjectsFilter;
            }
            DensityMaps.DensityMapBuilder builder = DensityMaps.builder((PathObjectPredicates.PathObjectPredicate)allObjectsFilter);
            builder.type(densityType);
            if (densityObjectsFilter != null) {
                String primaryClassName;
                String densityClassName = densityClass.toString();
                if (densityClass == DensityMapUI.ANY_POSITIVE_CLASS) {
                    densityClassName = "Positive";
                } else if (bothAnyObject) {
                    densityClassName = "Density";
                }
                String string = primaryClassName = primaryClass == null ? PathClass.NULL_CLASS.toString() : primaryClass.toString();
                Object filterName = primaryClass == DensityMapUI.ANY_CLASS_OR_NONE || primaryClass == DensityMapUI.ANY_SPECIFIED_CLASS ? densityClassName : (!isPercent && densityClass == primaryClass ? densityClassName : primaryClassName + ": " + densityClassName);
                builder.addDensities((String)filterName, densityObjectsFilter);
            }
            builder.radius(this.radius.get());
            logger.debug("Created {}", (Object)builder);
            return builder;
        }
    }

    static class ObservableColorModelBuilder {
        private static final Logger logger = LoggerFactory.getLogger(ObservableColorModelBuilder.class);
        private final ObjectProperty<ColorMaps.ColorMap> colorMap = new SimpleObjectProperty();
        private int alphaCountBand = -1;
        private ObjectProperty<Double> minAlpha = new SimpleObjectProperty((Object)0.0);
        private ObjectProperty<Double> maxAlpha = new SimpleObjectProperty((Object)1.0);
        private final DoubleProperty gamma = new SimpleDoubleProperty(1.0);
        private final ObjectProperty<Double> minDisplay = new SimpleObjectProperty((Object)0.0);
        private final ObjectProperty<Double> maxDisplay = new SimpleObjectProperty((Object)1.0);
        private final BooleanProperty autoUpdateDisplayRange = new SimpleBooleanProperty(true);
        private final BooleanProperty autoUpdateAlphaRange = new SimpleBooleanProperty(true);
        private final ObjectProperty<ColorModels.ColorModelBuilder> builder = new SimpleObjectProperty();
        private final ObservableValue<ColorModel> colorModel = Bindings.createObjectBinding(() -> {
            ColorModels.ColorModelBuilder b = (ColorModels.ColorModelBuilder)this.builder.get();
            return b == null ? null : b.build();
        }, (Observable[])new Observable[]{this.builder});
        private boolean updating = false;
        private ImageServer<BufferedImage> lastMap;

        ObservableColorModelBuilder() {
            this.colorMap.addListener((v, o, n) -> this.updateColorModel());
            this.minDisplay.addListener((v, o, n) -> this.updateColorModel());
            this.maxDisplay.addListener((v, o, n) -> this.updateColorModel());
            this.minAlpha.addListener((v, o, n) -> this.updateColorModel());
            this.maxAlpha.addListener((v, o, n) -> this.updateColorModel());
            this.gamma.addListener((v, o, n) -> this.updateColorModel());
            this.autoUpdateDisplayRange.addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.updateDisplayRanges(this.lastMap);
                }
            });
            this.autoUpdateAlphaRange.addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.updateDisplayRanges(this.lastMap);
                }
            });
        }

        public ObjectProperty<ColorModels.ColorModelBuilder> getBuilderProperty() {
            return this.builder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDisplayRanges(ImageServer<BufferedImage> densityMapServer) {
            this.lastMap = densityMapServer;
            if (densityMapServer == null) {
                return;
            }
            assert (Platform.isFxApplicationThread());
            try {
                double maxDisplayValue;
                this.updating = true;
                boolean autoUpdateSomething = this.autoUpdateDisplayRange.get() || this.autoUpdateAlphaRange.get();
                int alphaCountBand = -1;
                if (densityMapServer.getChannel(densityMapServer.nChannels() - 1).getName().equals("Counts")) {
                    alphaCountBand = densityMapServer.nChannels() - 1;
                }
                List<DensityMapUI.MinMax> minMax = null;
                if (alphaCountBand > 0 || autoUpdateSomething) {
                    try {
                        minMax = DensityMapUI.getMinMax(densityMapServer);
                        if (minMax == null) {
                            logger.debug("Min/max calculation interrupted!");
                            return;
                        }
                    }
                    catch (IOException e) {
                        logger.warn("Error setting display ranges: " + e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (this.autoUpdateAlphaRange.get()) {
                    this.minAlpha.set((Object)1.0E-6);
                    int band = Math.max(alphaCountBand, 0);
                    this.maxAlpha.set((Object)Math.max((Double)this.minAlpha.get(), minMax.get(band).getMaxValue()));
                }
                this.alphaCountBand = alphaCountBand;
                double d = maxDisplayValue = minMax == null ? ((Double)this.maxDisplay.get()).doubleValue() : minMax.get(0).getMaxValue();
                if (maxDisplayValue <= 0.0) {
                    maxDisplayValue = 1.0;
                }
                double minDisplayValue = 0.0;
                if (this.autoUpdateDisplayRange.get()) {
                    this.minDisplay.set((Object)minDisplayValue);
                    this.maxDisplay.set((Object)maxDisplayValue);
                }
            }
            finally {
                this.updating = false;
            }
            this.updateColorModel();
        }

        private void updateColorModel() {
            if (this.updating) {
                logger.trace("Skipping color model update (updating flag is 'true')");
                return;
            }
            ColorMaps.ColorMap selectedColorMap = (ColorMaps.ColorMap)this.colorMap.get();
            if (selectedColorMap == null) {
                logger.warn("Selected color map is null! Cannot create color model.");
                return;
            }
            logger.debug("Updating color model for {}", (Object)selectedColorMap.getName());
            int band = 0;
            ColorModels.ColorModelBuilder newBuilder = ColorModels.createColorModelBuilder((ColorModels.DisplayBand)ColorModels.createBand((String)selectedColorMap.getName(), (int)band, (double)((Double)this.minDisplay.get()), (double)((Double)this.maxDisplay.get())), (ColorModels.DisplayBand)ColorModels.createBand(null, (int)this.alphaCountBand, (double)((Double)this.minAlpha.get()), (double)((Double)this.maxAlpha.get()), (double)this.gamma.get()));
            ColorModels.ColorModelBuilder oldBuilder = (ColorModels.ColorModelBuilder)this.builder.getValue();
            try {
                Gson gson = GsonTools.getInstance();
                if (oldBuilder != null && Objects.equals(gson.toJson((Object)newBuilder), gson.toJson((Object)oldBuilder))) {
                    return;
                }
            }
            catch (Exception e) {
                logger.debug("Exception testing color model builders: " + e.getLocalizedMessage(), (Throwable)e);
            }
            this.builder.set((Object)newBuilder);
        }
    }

    static class HierarchyClassifierOverlayManager
    implements PathObjectHierarchyListener,
    QuPathViewerListener {
        private static final Logger logger = LoggerFactory.getLogger(HierarchyClassifierOverlayManager.class);
        private final QuPathGUI qupath;
        private final Set<QuPathViewer> currentViewers = new HashSet<QuPathViewer>();
        private ObservableValue<ImageRenderer> renderer;
        private final PixelClassificationOverlay overlay;
        private final ObservableValue<DensityMaps.DensityMapBuilder> builder;
        private Map<ImageData<BufferedImage>, ImageServer<BufferedImage>> classifierServerMap = Collections.synchronizedMap(new HashMap());
        private ExecutorService pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"density-maps", (boolean)true));
        private Map<QuPathViewer, Future<?>> tasks = Collections.synchronizedMap(new HashMap());
        private ObjectProperty<ImageServer<BufferedImage>> currentDensityMap = new SimpleObjectProperty();

        HierarchyClassifierOverlayManager(QuPathGUI qupath, ObservableValue<DensityMaps.DensityMapBuilder> builder, ObservableValue<ColorModel> colorModel, ObservableValue<ImageInterpolation> interpolation) {
            this.qupath = qupath;
            this.builder = builder;
            OverlayOptions options = qupath.getOverlayOptions();
            this.renderer = Bindings.createObjectBinding(() -> new ColorModelRenderer((ColorModel)colorModel.getValue()), (Observable[])new Observable[]{colorModel});
            this.overlay = PixelClassificationOverlay.create((OverlayOptions)options, this.classifierServerMap, (ImageRenderer)((ImageRenderer)this.renderer.getValue()));
            this.updateViewers();
            this.overlay.interpolationProperty().bind(interpolation);
            this.overlay.interpolationProperty().addListener((v, o, n) -> this.repaintAllViewers());
            this.overlay.rendererProperty().bind(this.renderer);
            this.renderer.addListener((v, o, n) -> this.repaintAllViewers());
            this.overlay.setLivePrediction(true);
            builder.addListener((v, o, n) -> this.updateDensityServers());
            this.updateDensityServers();
        }

        private void repaintAllViewers() {
            this.qupath.getViewerManager().repaintAllViewers();
        }

        void updateViewers() {
            logger.trace("Updating density server for all viewers");
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                viewer.setCustomPixelLayerOverlay((PathOverlay)this.overlay);
                if (this.currentViewers.contains(viewer)) continue;
                viewer.addViewerListener((QuPathViewerListener)this);
                PathObjectHierarchy hierarchy = viewer.getHierarchy();
                if (hierarchy != null) {
                    hierarchy.addListener((PathObjectHierarchyListener)this);
                }
                this.currentViewers.add(viewer);
                this.updateDensityServer(viewer);
            }
        }

        public void hierarchyChanged(PathObjectHierarchyEvent event) {
            if (event.isChanging()) {
                return;
            }
            this.qupath.getAllViewers().stream().filter(v -> v.getHierarchy() == event.getHierarchy()).forEach(v -> this.updateDensityServer((QuPathViewer)v));
        }

        public void imageDataChanged(QuPathViewer viewer, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
            logger.debug("ImageData changed from {} to {}", imageDataOld, imageDataNew);
            if (imageDataOld != null) {
                imageDataOld.getHierarchy().removeListener((PathObjectHierarchyListener)this);
            }
            if (imageDataNew != null) {
                imageDataNew.getHierarchy().addListener((PathObjectHierarchyListener)this);
            }
            this.updateDensityServer(viewer);
        }

        private void updateDensityServers() {
            this.classifierServerMap.clear();
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                this.updateDensityServer(viewer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateDensityServer(QuPathViewer viewer) {
            if (Platform.isFxApplicationThread()) {
                Map<QuPathViewer, Future<?>> map = this.tasks;
                synchronized (map) {
                    Future<?> task = this.tasks.get(viewer);
                    if (task != null && !task.isDone()) {
                        task.cancel(true);
                    }
                    if (!this.pool.isShutdown()) {
                        logger.trace("Submitting updateDensityServer request for {}", (Object)viewer);
                        task = this.pool.submit(() -> this.updateDensityServer(viewer));
                    } else {
                        logger.debug("Skipping updateDensityServer request for {} - pool shutdown", (Object)viewer);
                    }
                    this.tasks.put(viewer, task);
                }
                return;
            }
            ImageData imageData = viewer.getImageData();
            DensityMaps.DensityMapBuilder builder = (DensityMaps.DensityMapBuilder)this.builder.getValue();
            if (imageData == null || builder == null) {
                logger.debug("Removing density server for viewer {}", (Object)viewer);
                this.classifierServerMap.remove(imageData);
            } else {
                if (Thread.interrupted()) {
                    logger.trace("Thread interrupted, skipping density server update");
                    return;
                }
                ImageServer tempServer = builder.buildServer(imageData);
                if (Thread.interrupted()) {
                    logger.trace("Thread interrupted, skipping density server update");
                    return;
                }
                logger.debug("Setting density server {} for {}", (Object)tempServer, (Object)imageData);
                if (viewer == this.qupath.getViewer()) {
                    Platform.runLater(() -> this.currentDensityMap.set((Object)tempServer));
                }
                this.classifierServerMap.put((ImageData<BufferedImage>)imageData, (ImageServer<BufferedImage>)tempServer);
                if (viewer == this.qupath.getViewer()) {
                    this.currentDensityMap.set((Object)tempServer);
                }
                viewer.repaint();
            }
        }

        public void visibleRegionChanged(QuPathViewer viewer, Shape shape) {
        }

        public void selectedObjectChanged(QuPathViewer viewer, PathObject pathObjectSelected) {
        }

        public void viewerClosed(QuPathViewer viewer) {
            this.imageDataChanged(viewer, (ImageData<BufferedImage>)viewer.getImageData(), null);
            viewer.removeViewerListener((QuPathViewerListener)this);
            this.currentViewers.remove(viewer);
        }

        public void shutdown() {
            this.tasks.values().stream().forEach(t -> t.cancel(true));
            this.pool.shutdown();
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                this.imageDataChanged(viewer, (ImageData<BufferedImage>)viewer.getImageData(), null);
                viewer.removeViewerListener((QuPathViewerListener)this);
                if (viewer.getCustomPixelLayerOverlay() != this.overlay) continue;
                viewer.resetCustomPixelLayerOverlay();
            }
            if (this.overlay != null) {
                this.overlay.stop();
            }
        }
    }
}

