/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.dialogs.ParameterPanelFX;
import qupath.lib.gui.panes.ProjectBrowser;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectIO;
import qupath.lib.projects.ProjectImageEntry;

public class SplitProjectTrainingCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SplitProjectTrainingCommand.class);
    public static final String TRAIN_VALIDATION_TEST_METADATA_KEY = "Train/Validation/Test type";
    public static final String VALUE_TRAINING = "Train";
    public static final String VALUE_VALIDATION = "Validation";
    public static final String VALUE_TEST = "Test";
    public static final String VALUE_NONE = "None";
    private final QuPathGUI qupath;
    private TrainTestSplitter splitter;

    public SplitProjectTrainingCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        Project project = this.qupath.getProject();
        if (project == null) {
            Dialogs.showErrorMessage((String)"Split project", (String)"No project available!");
            return;
        }
        Dialog dialog = new Dialog();
        if (this.splitter == null) {
            this.splitter = new TrainTestSplitter();
        }
        dialog.setTitle("Train/Validation/Test split");
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        dialog.getDialogPane().setContent((Node)this.splitter.getPane());
        if (dialog.showAndWait().orElse(ButtonType.CANCEL).equals(ButtonType.OK)) {
            this.splitter.doSplit((Project<BufferedImage>)project);
        }
    }

    static class TrainTestSplitter {
        private BorderPane pane = new BorderPane();
        private ParameterList params;

        TrainTestSplitter() {
            this.init();
        }

        private void init() {
            this.params = new ParameterList().addIntParameter("nTrain", "Training set size", 50, null, "Choose number of images in the training set").addIntParameter("nValidation", "Validation set size", 25, null, "Choose number of images in the validation set").addIntParameter("nTest", "Test set size", 25, null, "Choose number of images in the test set").addBooleanParameter("fixedCounts", "Use absolute set sizes", false, "If checked, use the exact numbers of images specified for each set").addBooleanParameter("generateProjects", "Generate separate projects", false, "If checked, create new .qpproj files if necessary for train/validation/test splits");
            ParameterPanelFX panel = new ParameterPanelFX(this.params);
            this.pane.setCenter((Node)panel.getPane());
        }

        void doSplit(Project<BufferedImage> project) {
            int count;
            if (project == null) {
                logger.warn("Attempted to split null project!");
                return;
            }
            ArrayList entries = project.getImageList();
            if (entries.isEmpty()) {
                Dialogs.showWarningNotification((String)"Train/test split", (String)"No images in the project!");
                return;
            }
            int nTrain = this.params.getIntParameterValue("nTrain");
            int nValidation = this.params.getIntParameterValue("nValidation");
            int nTest = this.params.getIntParameterValue("nTest");
            int nImages = entries.size();
            if (nTrain < 0) {
                if (nValidation < 0 || nTest < 0) {
                    Dialogs.showErrorMessage((String)"Train/test split", (String)"Only one set can be < 0 (meaning 'all other images')!");
                    return;
                }
                nTrain = nImages - nValidation - nTest;
            } else if (nValidation < 0) {
                if (nTest < 0) {
                    Dialogs.showErrorMessage((String)"Train/test split", (String)"Only one set can be < 0 (meaning 'all other images')!");
                    return;
                }
                nValidation = nImages - nTrain - nTest;
            } else if (nTest < 0) {
                nTest = nImages - nTrain - nValidation;
            }
            int nRequested = nTrain + nValidation + nTest;
            boolean fixedCounts = this.params.getBooleanParameterValue("fixedCounts");
            if (fixedCounts && nRequested > entries.size()) {
                Dialogs.showErrorMessage((String)"Train/test split", (String)String.format("Not enough images in project!\n%d available, %d requested.", entries.size(), nRequested));
                return;
            }
            double inc = fixedCounts ? 1.0 : (double)nRequested / (double)entries.size();
            entries = new ArrayList(entries);
            Collections.shuffle(entries);
            ArrayList<ProjectImageEntry> trainEntries = new ArrayList<ProjectImageEntry>();
            ArrayList<ProjectImageEntry> validationEntries = new ArrayList<ProjectImageEntry>();
            ArrayList<ProjectImageEntry> testEntries = new ArrayList<ProjectImageEntry>();
            for (count = 0; (double)count * inc < (double)nTrain && count < entries.size(); ++count) {
                ((ProjectImageEntry)entries.get(count)).putMetadataValue(SplitProjectTrainingCommand.TRAIN_VALIDATION_TEST_METADATA_KEY, SplitProjectTrainingCommand.VALUE_TRAINING);
                trainEntries.add((ProjectImageEntry)entries.get(count));
            }
            while ((double)count * inc < (double)(nTrain + nValidation) && count < entries.size()) {
                ((ProjectImageEntry)entries.get(count)).putMetadataValue(SplitProjectTrainingCommand.TRAIN_VALIDATION_TEST_METADATA_KEY, SplitProjectTrainingCommand.VALUE_VALIDATION);
                validationEntries.add((ProjectImageEntry)entries.get(count));
                ++count;
            }
            while ((double)count * inc < (double)(nTrain + nValidation + nTest) && count < entries.size()) {
                ((ProjectImageEntry)entries.get(count)).putMetadataValue(SplitProjectTrainingCommand.TRAIN_VALIDATION_TEST_METADATA_KEY, SplitProjectTrainingCommand.VALUE_TEST);
                testEntries.add((ProjectImageEntry)entries.get(count));
                ++count;
            }
            while (count < entries.size()) {
                ((ProjectImageEntry)entries.get(count)).putMetadataValue(SplitProjectTrainingCommand.TRAIN_VALIDATION_TEST_METADATA_KEY, SplitProjectTrainingCommand.VALUE_NONE);
                ++count;
            }
            if (Boolean.TRUE.equals(this.params.getBooleanParameterValue("generateProjects"))) {
                Project projectTemp;
                File fileOrig;
                String ext = ProjectIO.getProjectExtension((boolean)true);
                if ("file".equals(project.getURI().getScheme())) {
                    fileOrig = Paths.get(project.getURI()).toFile();
                } else {
                    fileOrig = FileChoosers.promptToSaveFile((String)"Project file", null, (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath project", (String[])new String[]{ext})});
                    if (fileOrig == null) {
                        ProjectBrowser.syncProject(project);
                        return;
                    }
                }
                String baseName = fileOrig.getName();
                if (baseName.toLowerCase().endsWith(ext)) {
                    baseName = baseName.substring(0, baseName.length() - ext.length());
                }
                String nameTrain = baseName + "-train";
                String nameValidation = baseName + "-validation";
                String nameTest = baseName + "-test";
                if (!trainEntries.isEmpty()) {
                    projectTemp = project.createSubProject(nameTrain, trainEntries);
                    ProjectBrowser.syncProject((Project)projectTemp);
                }
                if (!validationEntries.isEmpty()) {
                    projectTemp = project.createSubProject(nameValidation, validationEntries);
                    ProjectBrowser.syncProject((Project)projectTemp);
                }
                if (!testEntries.isEmpty()) {
                    projectTemp = project.createSubProject(nameTest, testEntries);
                    ProjectBrowser.syncProject((Project)projectTemp);
                }
            }
            ProjectBrowser.syncProject(project);
        }

        public Pane getPane() {
            return this.pane;
        }
    }
}

