/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.chart.Axis;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.stage.Modality;
import javafx.stage.Window;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.analysis.stats.Histogram;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.color.StainVector;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartThresholdPane;
import qupath.lib.gui.charts.HistogramChart;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.process.gui.commands.ObjectClassifierLoadCommand;
import qupath.process.gui.commands.ml.ProjectClassifierBindings;

public class SingleMeasurementClassificationCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SingleMeasurementClassificationCommand.class);
    private static String title = "Single measurement classifier";
    private QuPathGUI qupath;
    private Map<QuPathViewer, SingleMeasurementPane> paneMap = new WeakHashMap<QuPathViewer, SingleMeasurementPane>();

    public SingleMeasurementClassificationCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        QuPathViewer viewer = this.qupath.getViewer();
        SingleMeasurementPane pane = this.paneMap.get(viewer);
        if (pane == null) {
            pane = new SingleMeasurementPane(this.qupath, viewer);
            this.paneMap.put(viewer, pane);
        }
        if (pane.dialog != null) {
            pane.dialog.getDialogPane().requestFocus();
        } else {
            pane.show();
        }
    }

    static class SingleMeasurementPane
    implements ChangeListener<ImageData<BufferedImage>> {
        private QuPathGUI qupath;
        private QuPathViewer viewer;
        private GridPane pane;
        private Predicate<String> ALWAYS_TRUE = m -> true;
        private String NO_CHANNEL_FILTER = "No filter (allow all channels)";
        private ComboBox<String> comboChannels = new ComboBox();
        private ComboBox<PathObjectFilter> comboFilter = new ComboBox();
        private Map<String, Double> previousThresholds = new HashMap<String, Double>();
        private ObservableList<String> measurements = FXCollections.observableArrayList();
        private FilteredList<String> measurementsFiltered = this.measurements.filtered(this.ALWAYS_TRUE);
        private ComboBox<String> comboMeasurements = new ComboBox(this.measurementsFiltered);
        private Slider sliderThreshold = new Slider();
        private ComboBox<PathClass> comboAbove;
        private ComboBox<PathClass> comboBelow;
        private CheckBox cbLivePreview = new CheckBox("Live preview");
        private HistogramChart histogramPane = new HistogramChart();
        private ClassificationRequest<BufferedImage> nextRequest;
        private TextField tfSaveName = new TextField();
        private Dialog<ButtonType> dialog;
        private StringProperty titleProperty = new SimpleStringProperty(title);
        private ExecutorService pool;
        private Map<PathObjectHierarchy, Map<PathObject, PathClass>> mapPrevious = new WeakHashMap<PathObjectHierarchy, Map<PathObject, PathClass>>();

        SingleMeasurementPane(QuPathGUI qupath, QuPathViewer viewer) {
            this.qupath = qupath;
            this.viewer = viewer;
            this.comboFilter.getItems().setAll((Object[])new PathObjectFilter[]{PathObjectFilter.DETECTIONS_ALL, PathObjectFilter.DETECTIONS, PathObjectFilter.CELLS, PathObjectFilter.TILES});
            this.comboFilter.getSelectionModel().select((Object)PathObjectFilter.DETECTIONS_ALL);
            TextField tf = new TextField();
            tf.setPrefColumnCount(6);
            FXUtils.bindSliderAndTextField((Slider)this.sliderThreshold, (TextField)tf, (boolean)true);
            GuiTools.installRangePrompt((Slider)this.sliderThreshold);
            this.pane = new GridPane();
            this.pane.setHgap(5.0);
            this.pane.setVgap(5.0);
            this.comboAbove = new ComboBox(qupath.getAvailablePathClasses());
            this.comboBelow = new ComboBox(qupath.getAvailablePathClasses());
            int row = 0;
            Label labelFilter = new Label("Object filter");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Select objects to classify", (Node[])new Node[]{labelFilter, this.comboFilter, this.comboFilter});
            Label labelChannels = new Label("Channel filter");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Optionally filter measurement lists & classifications by channel name", (Node[])new Node[]{labelChannels, this.comboChannels, this.comboChannels});
            Label labelMeasurements = new Label("Measurement");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Select measurement to threshold", (Node[])new Node[]{labelMeasurements, this.comboMeasurements, this.comboMeasurements});
            Label labelThreshold = new Label("Threshold");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Select threshold value", (Node[])new Node[]{labelThreshold, this.sliderThreshold, tf});
            Label labelAbove = new Label("Above threshold");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Specify the classification for objects above (or equal to) the threshold", (Node[])new Node[]{labelAbove, this.comboAbove, this.comboAbove});
            Label labelBelow = new Label("Below threshold");
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Specify the classification for objects below the threshold", (Node[])new Node[]{labelBelow, this.comboBelow, this.comboBelow});
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Turn on/off live preview while changing settings", (Node[])new Node[]{this.cbLivePreview, this.cbLivePreview, this.cbLivePreview});
            Button btnSave = new Button("Save");
            btnSave.setOnAction(e -> {
                this.tryToSave();
                this.tfSaveName.requestFocus();
                btnSave.requestFocus();
            });
            Label labelSave = new Label("Classifier name");
            this.tfSaveName.setMaxWidth(Double.MAX_VALUE);
            this.tfSaveName.setPromptText("Enter object classifier name");
            ProjectClassifierBindings.bindObjectClassifierNameInput(this.tfSaveName, (ObjectExpression<Project<BufferedImage>>)qupath.projectProperty());
            btnSave.setMaxWidth(Double.MAX_VALUE);
            btnSave.disableProperty().bind((ObservableValue)this.comboMeasurements.valueProperty().isNull().or((ObservableBooleanValue)this.tfSaveName.textProperty().isEmpty()));
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Specify name of the classifier - this will be used to save to save the classifier in the current project, so it may be used for scripting later", (Node[])new Node[]{labelSave, this.tfSaveName, btnSave});
            ChartThresholdPane chartPane = new ChartThresholdPane((XYChart)this.histogramPane);
            chartPane.setIsInteractive(true);
            chartPane.addThreshold((ObservableNumberValue)this.sliderThreshold.valueProperty());
            this.histogramPane.getYAxis().setTickLabelsVisible(false);
            this.histogramPane.setAnimated(false);
            GridPaneUtils.setToExpandGridPaneHeight((Node[])new Node[]{chartPane});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{chartPane});
            GridPaneUtils.setToExpandGridPaneWidth((Node[])new Node[]{this.comboFilter, this.comboChannels, this.comboMeasurements, this.sliderThreshold, this.comboAbove, this.comboBelow, this.tfSaveName, this.cbLivePreview});
            chartPane.setPrefSize(200.0, 80.0);
            this.pane.add((Node)SingleMeasurementPane.addLogHistogramCheckbox(chartPane, this.histogramPane), this.pane.getColumnCount(), 0, 1, this.pane.getRowCount() - 1);
            this.comboChannels.valueProperty().addListener((v, o, n) -> this.updateChannelFilter());
            this.comboMeasurements.valueProperty().addListener((v, o, n) -> {
                if (o != null) {
                    this.previousThresholds.put((String)o, this.getThreshold());
                }
                this.updateHistogramAndThreshold();
                this.maybePreview();
            });
            this.sliderThreshold.valueProperty().addListener((v, o, n) -> this.maybePreview());
            this.comboAbove.valueProperty().addListener((v, o, n) -> this.maybePreview());
            this.comboBelow.valueProperty().addListener((v, o, n) -> this.maybePreview());
            this.cbLivePreview.selectedProperty().addListener((v, o, n) -> this.maybePreview());
        }

        static BorderPane addLogHistogramCheckbox(ChartThresholdPane chartPane, HistogramChart histogramPane) {
            CheckBox cbLogHistogram = new CheckBox("Log histogram");
            histogramPane.countsTransformProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
                if (cbLogHistogram.isSelected()) {
                    return HistogramChart.CountsTransformMode.LOGARITHM;
                }
                return HistogramChart.CountsTransformMode.RAW;
            }, (Observable[])new Observable[]{cbLogHistogram.selectedProperty()}));
            Axis axis = histogramPane.getYAxis();
            if (axis instanceof NumberAxis) {
                NumberAxis yAxis = (NumberAxis)axis;
                yAxis.minorTickCountProperty().bind((ObservableValue)Bindings.createIntegerBinding(() -> {
                    if (cbLogHistogram.isSelected()) {
                        return 0;
                    }
                    return 5;
                }, (Observable[])new Observable[]{cbLogHistogram.selectedProperty()}));
            }
            BorderPane.setAlignment((Node)cbLogHistogram, (Pos)Pos.CENTER);
            BorderPane chartBorderPane = new BorderPane((Node)chartPane);
            chartBorderPane.setBottom((Node)cbLogHistogram);
            return chartBorderPane;
        }

        void updateChannelFilter() {
            String selected = (String)this.comboChannels.getSelectionModel().getSelectedItem();
            String selectedMeasurement = (String)this.comboMeasurements.getValue();
            if (selected == null || selected.isBlank() || this.NO_CHANNEL_FILTER.equals(selected)) {
                this.measurementsFiltered.setPredicate(this.ALWAYS_TRUE);
                this.comboMeasurements.getSelectionModel().select((Object)selectedMeasurement);
            } else {
                String lowerSelected = selected.trim().toLowerCase();
                Predicate<String> predicate = m -> m.toLowerCase().contains(lowerSelected);
                if (this.measurements.stream().anyMatch(predicate)) {
                    this.measurementsFiltered.setPredicate(predicate);
                } else {
                    this.measurementsFiltered.setPredicate(this.ALWAYS_TRUE);
                }
                if (this.comboMeasurements.getItems().contains((Object)selectedMeasurement)) {
                    this.comboMeasurements.getSelectionModel().select((Object)selectedMeasurement);
                } else {
                    this.comboMeasurements.valueProperty().set(null);
                }
                ImageData<BufferedImage> imageData = this.getImageData();
                PathClass pathClass = this.qupath.getAvailablePathClasses().stream().filter(p -> p.toString().toLowerCase().contains(lowerSelected)).findFirst().orElse(null);
                if (imageData != null && pathClass != null) {
                    this.comboAbove.getSelectionModel().select((Object)pathClass);
                    this.comboBelow.getSelectionModel().select(null);
                }
            }
        }

        void storeClassificationMap(PathObjectHierarchy hierarchy) {
            if (hierarchy == null) {
                return;
            }
            List pathObjects = hierarchy.getFlattenedObjectList(null);
            this.mapPrevious.put(hierarchy, PathObjectTools.createClassificationMap((Collection)pathObjects));
        }

        public void show() {
            ImageData imageData = this.viewer.getImageData();
            if (imageData == null) {
                GuiTools.showNoImageError((String)title);
                return;
            }
            this.viewer.imageDataProperty().addListener((ChangeListener)this);
            this.storeClassificationMap(imageData.getHierarchy());
            this.refreshOptions();
            this.pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"single-measurement-classifier", (boolean)true));
            this.dialog = new Dialog();
            this.dialog.initOwner((Window)this.qupath.getStage());
            this.dialog.titleProperty().bind((ObservableValue)this.titleProperty);
            this.dialog.getDialogPane().setContent((Node)this.pane);
            this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
            this.dialog.initModality(Modality.NONE);
            this.dialog.getDialogPane().focusedProperty().addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.refreshTitle();
                }
            });
            this.dialog.setOnCloseRequest(e -> {
                boolean applyClassifier = ButtonType.APPLY.equals(this.dialog.getResult());
                this.cleanup(applyClassifier);
            });
            this.dialog.show();
            this.maybePreview();
        }

        void cleanup(boolean applyLastClassifier) {
            this.pool.shutdown();
            try {
                this.pool.awaitTermination(5000L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.debug("Exception waiting for classification to complete: " + e.getLocalizedMessage(), (Throwable)e);
            }
            if (applyLastClassifier) {
                ClassificationRequest<BufferedImage> nextRequest = this.getUpdatedRequest();
                if (nextRequest != null) {
                    nextRequest.doClassification();
                    String name = null;
                    if (this.tfSaveName.getText() != null && !this.tfSaveName.getText().isEmpty()) {
                        name = this.tryToSave();
                    }
                    if (name == null) {
                        Dialogs.showWarningNotification((String)"Object classifier", (String)"Classifier was not saved, so will not appear in the command history");
                    } else {
                        nextRequest.imageData.getHistoryWorkflow().addStep(ObjectClassifierLoadCommand.createObjectClassifierStep(name));
                    }
                }
            } else {
                for (Map.Entry<PathObjectHierarchy, Map<PathObject, PathClass>> entry : this.mapPrevious.entrySet()) {
                    this.resetClassifications(entry.getKey(), entry.getValue());
                }
            }
            this.viewer.imageDataProperty().removeListener((ChangeListener)this);
            this.dialog = null;
        }

        ImageData<BufferedImage> getImageData() {
            return this.viewer.getImageData();
        }

        PathObjectHierarchy getHierarchy() {
            ImageData<BufferedImage> imageData = this.getImageData();
            return imageData == null ? null : imageData.getHierarchy();
        }

        Collection<? extends PathObject> getCurrentObjects() {
            PathObjectHierarchy hierarchy = this.getHierarchy();
            if (hierarchy == null) {
                return Collections.emptyList();
            }
            PathObjectFilter filter = (PathObjectFilter)this.comboFilter.getValue();
            List pathObjects = hierarchy.getFlattenedObjectList(new ArrayList());
            if (filter != null) {
                pathObjects.removeIf(filter.negate());
            }
            return pathObjects;
        }

        String getSelectedMeasurement() {
            return (String)this.comboMeasurements.valueProperty().get();
        }

        double getThreshold() {
            return this.sliderThreshold.getValue();
        }

        void refreshTitle() {
            ImageData<BufferedImage> imageData = this.getImageData();
            Project project = this.qupath.getProject();
            if (imageData == null) {
                this.titleProperty.set((Object)title);
            } else {
                ProjectImageEntry entry;
                String imageName = null;
                if (project != null && (entry = project.getEntry(imageData)) != null) {
                    imageName = entry.getImageName();
                }
                if (imageName == null) {
                    imageName = imageData.getServerMetadata().getName();
                }
                this.titleProperty.set((Object)(title + " (" + imageName + ")"));
            }
        }

        void refreshOptions() {
            this.refreshTitle();
            this.refreshChannels();
            this.updateAvailableMeasurements();
            this.updateHistogramAndThreshold();
        }

        void refreshChannels() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this.NO_CHANNEL_FILTER);
            ImageData<BufferedImage> imageData = this.getImageData();
            if (imageData != null) {
                ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
                if (stains != null) {
                    for (int s = 1; s <= 3; ++s) {
                        StainVector stain = stains.getStain(s);
                        if (stain.isResidual()) continue;
                        list.add(stain.getName());
                    }
                }
                for (ImageChannel channel : imageData.getServerMetadata().getChannels()) {
                    list.add(channel.getName());
                }
            }
            this.comboChannels.getItems().setAll(list);
            if (this.comboChannels.getSelectionModel().getSelectedItem() == null) {
                this.comboChannels.getSelectionModel().selectFirst();
            }
        }

        void resetClassifications(PathObjectHierarchy hierarchy, Map<PathObject, PathClass> mapPrevious) {
            Collection changed = PathObjectTools.restoreClassificationsFromMap(mapPrevious);
            if (hierarchy != null && !changed.isEmpty()) {
                hierarchy.fireObjectClassificationsChangedEvent((Object)this, changed);
            }
        }

        void updateHistogramAndThreshold() {
            String measurement = this.getSelectedMeasurement();
            Collection<? extends PathObject> pathObjects = this.getCurrentObjects();
            if (measurement == null || pathObjects.isEmpty()) {
                this.sliderThreshold.setMin(0.0);
                this.sliderThreshold.setMax(1.0);
                this.sliderThreshold.setValue(0.0);
                this.histogramPane.getHistogramData().clear();
                return;
            }
            double[] allValues = pathObjects.stream().mapToDouble(p -> p.getMeasurementList().get(measurement)).filter(d -> Double.isFinite(d)).toArray();
            DescriptiveStatistics stats = new DescriptiveStatistics(allValues);
            Histogram histogram = new Histogram(allValues, 100, stats.getMin(), stats.getMax());
            this.histogramPane.getHistogramData().setAll((Object[])new HistogramChart.HistogramData[]{HistogramChart.createHistogramData((Histogram)histogram, (Integer)ColorTools.packARGB((int)100, (int)200, (int)20, (int)20))});
            double value = this.previousThresholds.getOrDefault(measurement, stats.getMean());
            this.sliderThreshold.setMin(stats.getMin());
            this.sliderThreshold.setMax(stats.getMax());
            this.sliderThreshold.setValue(value);
        }

        void updateAvailableMeasurements() {
            Set measurements = PathObjectTools.getAvailableFeatures(this.getCurrentObjects());
            this.measurements.setAll((Collection)measurements);
        }

        String tryToSave() {
            Project project = this.qupath.getProject();
            if (project == null) {
                Dialogs.showErrorMessage((String)title, (String)"You need a project to save this classifier!");
                return null;
            }
            String name = GeneralTools.stripInvalidFilenameChars((String)this.tfSaveName.getText());
            if (name.isBlank()) {
                Dialogs.showErrorMessage((String)title, (String)"Please enter a name for the classifier!");
                return null;
            }
            ObjectClassifier<BufferedImage> classifier = this.updateClassifier();
            if (classifier == null) {
                Dialogs.showErrorMessage((String)title, (String)"Not enough information to create a classifier!");
                return null;
            }
            try {
                if (project.getObjectClassifiers().contains(name) && !Dialogs.showConfirmDialog((String)title, (String)("Do you want to overwrite the existing classifier '" + name + "'?"))) {
                    return null;
                }
                project.getObjectClassifiers().put(name, classifier);
                Dialogs.showInfoNotification((String)title, (String)("Saved classifier as '" + name + "'"));
                return name;
            }
            catch (Exception e) {
                Dialogs.showErrorNotification((String)title, (Throwable)e);
                logger.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        void maybePreview() {
            if (!this.cbLivePreview.isSelected() || this.pool == null || this.pool.isShutdown()) {
                return;
            }
            this.nextRequest = this.getUpdatedRequest();
            this.pool.execute(() -> this.processRequest());
        }

        ClassificationRequest<BufferedImage> getUpdatedRequest() {
            ImageData<BufferedImage> imageData = this.getImageData();
            if (imageData == null) {
                return null;
            }
            ObjectClassifier<BufferedImage> classifier = this.updateClassifier();
            if (classifier == null) {
                return null;
            }
            return new ClassificationRequest<BufferedImage>(imageData, classifier);
        }

        ObjectClassifier<BufferedImage> updateClassifier() {
            PathObjectFilter filter = (PathObjectFilter)this.comboFilter.getValue();
            String measurement = this.getSelectedMeasurement();
            double threshold = this.getThreshold();
            PathClass classAbove = (PathClass)this.comboAbove.getValue();
            PathClass classBelow = (PathClass)this.comboBelow.getValue();
            PathClass classEquals = classAbove;
            if (measurement == null || Double.isNaN(threshold)) {
                return null;
            }
            return new ObjectClassifiers.ClassifyByMeasurementBuilder(measurement).threshold(threshold).filter(filter).above(classAbove).equalTo(classEquals).below(classBelow).build();
        }

        synchronized void processRequest() {
            if (this.nextRequest == null || this.nextRequest.isComplete()) {
                return;
            }
            this.nextRequest.doClassification();
        }

        public void changed(ObservableValue<? extends ImageData<BufferedImage>> observable, ImageData<BufferedImage> oldValue, ImageData<BufferedImage> newValue) {
            if (newValue != null && !this.mapPrevious.containsKey(newValue.getHierarchy())) {
                this.storeClassificationMap(newValue.getHierarchy());
            }
            this.refreshOptions();
        }
    }

    static class ClassificationRequest<T> {
        private ImageData<T> imageData;
        private ObjectClassifier<T> classifier;
        private boolean isComplete = false;

        ClassificationRequest(ImageData<T> imageData, ObjectClassifier<T> classifier) {
            this.imageData = imageData;
            this.classifier = classifier;
        }

        public synchronized void doClassification() {
            Collection pathObjects = this.classifier.getCompatibleObjects(this.imageData);
            this.classifier.classifyObjects(this.imageData, pathObjects, true);
            this.imageData.getHierarchy().fireObjectClassificationsChangedEvent(this.classifier, pathObjects);
            this.isComplete = true;
        }

        public synchronized boolean isComplete() {
            return this.isComplete;
        }
    }
}

