/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.binding.StringExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Dimension2D;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.Stage;
import javafx.stage.Window;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.classifiers.pixel.PixelClassifier;
import qupath.lib.color.ColorDeconvolutionStains;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.OverlayOptions;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.gui.viewer.RegionFilter;
import qupath.lib.gui.viewer.overlays.PathOverlay;
import qupath.lib.gui.viewer.overlays.PixelClassificationOverlay;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ColorTransforms;
import qupath.lib.images.servers.ImageChannel;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.projects.Project;
import qupath.opencv.ml.pixel.PixelClassifiers;
import qupath.opencv.ops.ImageDataOp;
import qupath.opencv.ops.ImageOp;
import qupath.opencv.ops.ImageOps;
import qupath.opencv.tools.MultiscaleFeatures;
import qupath.process.gui.commands.ml.ClassificationResolution;
import qupath.process.gui.commands.ml.PixelClassifierUI;

public class SimpleThresholdCommand
implements Runnable {
    private QuPathGUI qupath;
    private Stage stage;
    private Dimension2D dim;
    private ComboBox<ClassificationResolution> comboResolutions = new ComboBox();
    private ReadOnlyObjectProperty<ClassificationResolution> selectedResolution = this.comboResolutions.getSelectionModel().selectedItemProperty();
    private ComboBox<Prefilter> comboPrefilter = new ComboBox();
    private ReadOnlyObjectProperty<Prefilter> selectedPrefilter = this.comboPrefilter.getSelectionModel().selectedItemProperty();
    private ComboBox<PathClass> classificationsBelow = new ComboBox();
    private ComboBox<PathClass> classificationsAbove = new ComboBox();
    private ComboBox<ColorTransforms.ColorTransform> transforms = new ComboBox();
    private ReadOnlyObjectProperty<ColorTransforms.ColorTransform> selectedChannel = this.transforms.getSelectionModel().selectedItemProperty();
    private Spinner<Double> sigmaSpinner = new Spinner((SpinnerValueFactory)new SpinnerValueFactory.DoubleSpinnerValueFactory(0.0, 16.0, 0.0, 0.5));
    private ReadOnlyObjectProperty<Double> sigma = this.sigmaSpinner.valueProperty();
    private Spinner<Double> spinner = FXUtils.createDynamicStepSpinner((double)-1.7976931348623157E308, (double)Double.MAX_VALUE, (double)0.0, (double)0.01, (int)2);
    private ReadOnlyObjectProperty<Double> threshold = this.spinner.valueProperty();
    private ObjectProperty<PixelClassificationOverlay> selectedOverlay = new SimpleObjectProperty();
    private ObjectProperty<PixelClassifier> currentClassifier = new SimpleObjectProperty();
    private Map<QuPathViewer, PathOverlay> map = new WeakHashMap<QuPathViewer, PathOverlay>();

    public SimpleThresholdCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        if (this.qupath.getImageData() == null) {
            GuiTools.showNoImageError((String)"Create thresholder");
            return;
        }
        if (this.stage == null) {
            this.showGUI();
        } else {
            this.updateGUI();
            this.updateClassification();
            if (this.stage.isShowing()) {
                this.stage.toFront();
            } else {
                if (this.dim != null) {
                    this.stage.setWidth(Math.max(300.0, this.dim.getWidth()));
                    this.stage.setHeight(Math.max(200.0, this.dim.getHeight()));
                }
                this.stage.show();
            }
        }
    }

    private void showGUI() {
        GridPane pane = new GridPane();
        this.classificationsAbove.setItems(this.qupath.getAvailablePathClasses());
        this.classificationsBelow.setItems(this.qupath.getAvailablePathClasses());
        int row = 0;
        Label labelResolution = new Label("Resolution");
        labelResolution.setLabelFor(this.comboResolutions);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select image resolution to threshold (higher values mean lower resolution, and faster thresholding)", (Node[])new Node[]{labelResolution, this.comboResolutions, this.comboResolutions});
        Label label = new Label("Channel");
        label.setLabelFor(this.transforms);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select channel to threshold", (Node[])new Node[]{label, this.transforms, this.transforms});
        Label labelPrefilter = new Label("Prefilter");
        labelPrefilter.setLabelFor(this.comboPrefilter);
        this.comboPrefilter.getItems().setAll((Object[])Prefilter.values());
        this.comboPrefilter.getSelectionModel().select((Object)Prefilter.GAUSSIAN);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select image smoothing filter (Gaussian is usually best)", (Node[])new Node[]{labelPrefilter, this.comboPrefilter, this.comboPrefilter});
        label = new Label("Smoothing sigma");
        label.setLabelFor(this.sigmaSpinner);
        Label labelSigma = new Label();
        labelSigma.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.sigma.get() == null ? "" : GeneralTools.formatNumber((double)((Double)this.sigma.get()), (int)2), (Observable[])new Observable[]{this.sigma}));
        labelSigma.setMinWidth(50.0);
        FXUtils.restrictTextFieldInputToNumber((TextField)this.sigmaSpinner.getEditor(), (boolean)true);
        FXUtils.resetSpinnerNullToPrevious(this.sigmaSpinner);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select smoothing sigma value (higher values give a smoother result)", (Node[])new Node[]{label, this.sigmaSpinner, labelSigma});
        label = new Label("Threshold");
        label.setLabelFor(this.spinner);
        Label labelThreshold = new Label();
        labelThreshold.setMinWidth(50.0);
        labelThreshold.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.threshold.get() == null ? "" : GeneralTools.formatNumber((double)((Double)this.threshold.get()), (int)2), (Observable[])new Observable[]{this.threshold}));
        FXUtils.restrictTextFieldInputToNumber((TextField)this.spinner.getEditor(), (boolean)true);
        FXUtils.resetSpinnerNullToPrevious(this.spinner);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select threshold value", (Node[])new Node[]{label, this.spinner, labelThreshold});
        Label labelAbove = new Label("Above threshold");
        labelAbove.setLabelFor(this.classificationsAbove);
        Label labelBelow = new Label("Below threshold");
        labelBelow.setLabelFor(this.classificationsBelow);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select classification for pixels above the threshold.\nDouble-click on labels to switch above & below.", (Node[])new Node[]{labelAbove, this.classificationsAbove, this.classificationsAbove});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Select classification for pixels less than or equal to the threshold.\nDouble-click on labels to switch above & below.", (Node[])new Node[]{labelBelow, this.classificationsBelow, this.classificationsBelow});
        labelAbove.setOnMouseClicked(e -> {
            if (e.getClickCount() == 2) {
                this.switchClassifications();
            }
        });
        labelBelow.setOnMouseClicked(labelAbove.getOnMouseClicked());
        Label labelRegion = new Label("Region");
        ComboBox<RegionFilter> comboRegionFilter = PixelClassifierUI.createRegionFilterCombo(this.qupath.getOverlayOptions());
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Control where the pixel classification is applied during preview", (Node[])new Node[]{labelRegion, comboRegionFilter, comboRegionFilter});
        Button btnSave = new Button("Save as pixel classifier");
        SimpleStringProperty classifierName = new SimpleStringProperty(null);
        GridPane tilePane = GridPaneUtils.createRowGrid((Node[])new Node[]{PixelClassifierUI.createSavePixelClassifierPane((ObjectExpression<Project<BufferedImage>>)this.qupath.projectProperty(), this.currentClassifier, (StringProperty)classifierName), PixelClassifierUI.createPixelClassifierButtons((ObjectExpression<ImageData<BufferedImage>>)this.qupath.imageDataProperty(), this.currentClassifier, (StringExpression)classifierName)});
        tilePane.setVgap(5.0);
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, null, (Node[])new Node[]{tilePane, tilePane, tilePane});
        this.selectedPrefilter.addListener((v, o, n) -> this.updateClassification());
        this.transforms.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateClassification());
        this.sigma.addListener((v, o, n) -> this.updateClassification());
        this.threshold.addListener((v, o, n) -> this.updateClassification());
        this.selectedResolution.addListener((v, o, n) -> this.updateClassification());
        this.classificationsAbove.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateClassification());
        this.classificationsBelow.getSelectionModel().selectedItemProperty().addListener((v, o, n) -> this.updateClassification());
        pane.setVgap(6.0);
        pane.setHgap(6.0);
        pane.setPadding(new Insets(10.0));
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{this.comboResolutions, this.comboPrefilter, this.transforms, this.spinner, this.sigmaSpinner, this.classificationsAbove, this.classificationsBelow, btnSave, tilePane});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{this.comboResolutions, this.comboPrefilter, this.transforms, this.spinner, this.sigmaSpinner, this.classificationsAbove, this.classificationsBelow, btnSave, tilePane});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{this.comboResolutions, this.comboPrefilter, this.transforms, this.spinner, this.sigmaSpinner, this.classificationsAbove, this.classificationsBelow, btnSave, tilePane});
        this.updateGUI();
        pane.setMinSize(250.0, -1.0);
        pane.setMaxSize(-1.0, -1.0);
        this.stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.setTitle("Create thresholder");
        this.stage.initOwner((Window)this.qupath.getStage());
        this.stage.setScene(new Scene((Parent)pane));
        this.stage.show();
        this.stage.setMinHeight(320.0);
        this.stage.setMaxHeight(420.0);
        this.stage.setMinWidth(320.0);
        this.stage.setMaxWidth(420.0);
        this.stage.sizeToScene();
        this.stage.setResizable(true);
        this.stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.ensureOverlays();
            }
        });
        this.stage.setOnHiding(e -> {
            this.dim = new Dimension2D(this.stage.getWidth(), this.stage.getHeight());
            this.resetOverlays();
        });
    }

    private void resetOverlay(QuPathViewer viewer, PathOverlay overlay) {
        if (viewer.getCustomPixelLayerOverlay() == overlay) {
            viewer.resetCustomPixelLayerOverlay();
        }
    }

    private void resetOverlays() {
        for (Map.Entry<QuPathViewer, PathOverlay> entry : this.map.entrySet()) {
            this.resetOverlay(entry.getKey(), entry.getValue());
        }
        PixelClassificationOverlay overlay = (PixelClassificationOverlay)this.selectedOverlay.get();
        if (overlay != null) {
            overlay.stop();
        }
        this.selectedOverlay.set(null);
    }

    private void switchClassifications() {
        PathClass below = (PathClass)this.classificationsBelow.getSelectionModel().getSelectedItem();
        PathClass above = (PathClass)this.classificationsAbove.getSelectionModel().getSelectedItem();
        this.classificationsBelow.getSelectionModel().select((Object)above);
        this.classificationsAbove.getSelectionModel().select((Object)below);
    }

    private void updateGUI() {
        ArrayList<ColorTransforms.ColorTransform> newTransforms;
        QuPathViewer viewer = this.qupath.getViewer();
        ImageData imageData = viewer.getImageData();
        if (imageData == null) {
            this.transforms.getItems().clear();
            this.transforms.setDisable(true);
            this.spinner.setDisable(true);
            this.sigmaSpinner.setDisable(true);
            return;
        }
        this.transforms.setDisable(false);
        this.spinner.setDisable(false);
        this.sigmaSpinner.setDisable(false);
        this.sigmaSpinner.setEditable(true);
        this.spinner.setEditable(true);
        List<ClassificationResolution> newResolutions = ClassificationResolution.getDefaultResolutions(imageData, (ClassificationResolution)this.selectedResolution.get());
        if (!newResolutions.equals(this.comboResolutions.getItems())) {
            this.comboResolutions.getItems().setAll(newResolutions);
        }
        if (this.selectedResolution.get() == null) {
            this.comboResolutions.getSelectionModel().selectLast();
        }
        if (!(newTransforms = new ArrayList<ColorTransforms.ColorTransform>(this.getAvailableTransforms((ImageData<BufferedImage>)imageData))).equals(this.transforms.getItems())) {
            this.transforms.getItems().setAll(newTransforms);
        }
        if (this.transforms.getSelectionModel().getSelectedItem() == null) {
            this.transforms.getSelectionModel().selectFirst();
        }
    }

    private void updateClassification() {
        ColorTransforms.ColorTransform channel = (ColorTransforms.ColorTransform)this.selectedChannel.get();
        Double thresholdValue = (Double)this.threshold.get();
        ClassificationResolution resolution = (ClassificationResolution)this.selectedResolution.get();
        if (channel == null || thresholdValue == null || resolution == null) {
            this.resetOverlays();
            return;
        }
        Prefilter feature = (Prefilter)((Object)this.selectedPrefilter.get());
        double sigmaValue = (Double)this.sigma.get();
        ArrayList<ImageOp> ops = new ArrayList<ImageOp>();
        if (feature != null && sigmaValue > 0.0) {
            ops.add(feature.buildOp(sigmaValue));
        }
        ops.add(ImageOps.Threshold.threshold((double[])new double[]{(Double)this.threshold.get()}));
        LinkedHashMap<Integer, PathClass> classifications = new LinkedHashMap<Integer, PathClass>();
        classifications.put(0, (PathClass)this.classificationsBelow.getSelectionModel().getSelectedItem());
        classifications.put(1, (PathClass)this.classificationsAbove.getSelectionModel().getSelectedItem());
        ImageOp op = ImageOps.Core.sequential(ops);
        ImageDataOp transformer = ImageOps.buildImageDataOp((ColorTransforms.ColorTransform[])new ColorTransforms.ColorTransform[]{channel}).appendOps(new ImageOp[]{op});
        PixelClassifier classifier = PixelClassifiers.createClassifier((ImageDataOp)transformer, (PixelCalibration)resolution.getPixelCalibration(), classifications);
        PixelClassificationOverlay overlay = PixelClassificationOverlay.create((OverlayOptions)this.qupath.getOverlayOptions(), (PixelClassifier)classifier);
        overlay.setLivePrediction(true);
        PixelClassificationOverlay previousOverlay = (PixelClassificationOverlay)this.selectedOverlay.get();
        if (previousOverlay != null) {
            previousOverlay.stop();
        }
        this.selectedOverlay.set((Object)overlay);
        this.currentClassifier.set((Object)classifier);
        this.ensureOverlays();
    }

    private void ensureOverlays() {
        PixelClassificationOverlay overlay = (PixelClassificationOverlay)this.selectedOverlay.get();
        for (QuPathViewer viewer : this.qupath.getAllViewers()) {
            ImageData imageData = viewer.getImageData();
            if (imageData == null) {
                this.resetOverlay(viewer, this.map.get(viewer));
                continue;
            }
            viewer.setMinimumRepaintSpacingMillis(1000L);
            viewer.repaint();
            viewer.setCustomPixelLayerOverlay((PathOverlay)overlay);
            this.map.put(viewer, (PathOverlay)overlay);
            viewer.resetMinimumRepaintSpacingMillis();
        }
    }

    private Collection<ColorTransforms.ColorTransform> getAvailableTransforms(ImageData<BufferedImage> imageData) {
        LinkedHashMap<ColorTransforms.ColorTransform, Double> validChannels = new LinkedHashMap<ColorTransforms.ColorTransform, Double>();
        ImageServer server = imageData.getServer();
        double increment = server.getPixelType().isFloatingPoint() ? 0.1 : 0.5;
        double incrementDeconvolved = 0.05;
        for (ImageChannel channel : server.getMetadata().getChannels()) {
            validChannels.put(ColorTransforms.createChannelExtractor((String)channel.getName()), increment);
        }
        ColorDeconvolutionStains stains = imageData.getColorDeconvolutionStains();
        if (stains != null) {
            validChannels.put(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)1), incrementDeconvolved);
            validChannels.put(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)2), incrementDeconvolved);
            validChannels.put(ColorTransforms.createColorDeconvolvedChannel((ColorDeconvolutionStains)stains, (int)3), incrementDeconvolved);
        }
        if (server.nChannels() > 1) {
            validChannels.put(ColorTransforms.createMeanChannelTransform(), increment);
            validChannels.put(ColorTransforms.createMaximumChannelTransform(), increment);
            validChannels.put(ColorTransforms.createMinimumChannelTransform(), increment);
        }
        return validChannels.keySet();
    }

    private static enum Prefilter {
        GAUSSIAN,
        LAPLACIAN,
        EROSION,
        DILATION,
        OPENING,
        CLOSING,
        GRADIENT_MAG,
        WEIGHTED_STD;


        public ImageOp buildOp(double sigma) {
            if (sigma <= 0.0) {
                return null;
            }
            int radius = (int)Math.round(sigma * 2.0);
            switch (this.ordinal()) {
                case 5: {
                    return ImageOps.Filters.closing((int)radius);
                }
                case 3: {
                    return ImageOps.Filters.maximum((int)radius);
                }
                case 2: {
                    return ImageOps.Filters.minimum((int)radius);
                }
                case 0: {
                    return ImageOps.Filters.gaussianBlur((double)sigma);
                }
                case 6: {
                    return ImageOps.Filters.features(Collections.singletonList(MultiscaleFeatures.MultiscaleFeature.GRADIENT_MAGNITUDE), (double)sigma, (double)sigma);
                }
                case 1: {
                    return ImageOps.Filters.features(Collections.singletonList(MultiscaleFeatures.MultiscaleFeature.LAPLACIAN), (double)sigma, (double)sigma);
                }
                case 4: {
                    return ImageOps.Filters.opening((int)radius);
                }
                case 7: {
                    return ImageOps.Filters.features(Collections.singletonList(MultiscaleFeatures.MultiscaleFeature.WEIGHTED_STD_DEV), (double)sigma, (double)sigma);
                }
            }
            throw new IllegalArgumentException("Unknown filter " + String.valueOf((Object)this));
        }

        public String toString() {
            switch (this.ordinal()) {
                case 5: {
                    return "Morphological closing";
                }
                case 3: {
                    return "Maximum (dilation)";
                }
                case 2: {
                    return "Minimum (erosion)";
                }
                case 0: {
                    return "Gaussian";
                }
                case 6: {
                    return "Gradient magnitude";
                }
                case 1: {
                    return "Laplacian of Gaussian";
                }
                case 4: {
                    return "Morphological opening";
                }
                case 7: {
                    return "Weighted deviation";
                }
            }
            throw new IllegalArgumentException("Unknown filter " + String.valueOf((Object)this));
        }
    }
}

