/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.text.TextAlignment;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.commands.UpdateUrisCommand;
import qupath.lib.images.ImageData;
import qupath.lib.io.GsonTools;
import qupath.lib.io.UriResource;
import qupath.lib.io.UriUpdater;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;

public final class ObjectClassifierLoadCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ObjectClassifierLoadCommand.class);
    private final String title = "Object Classifiers";
    private QuPathGUI qupath;
    private Project<BufferedImage> project;
    private Map<String, ObjectClassifier<BufferedImage>> cachedClassifiers = new HashMap<String, ObjectClassifier<BufferedImage>>();
    private Map<String, ObjectClassifier<BufferedImage>> externalObjectClassifiers;
    private static boolean fixQuietly = true;

    public ObjectClassifierLoadCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        this.project = this.qupath.getProject();
        ListView listClassifiers = new ListView();
        this.externalObjectClassifiers = new HashMap<String, ObjectClassifier<BufferedImage>>();
        listClassifiers.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Label labelPlaceholder = new Label("Object classifiers in the\ncurrent project will appear here");
        labelPlaceholder.setAlignment(Pos.CENTER);
        labelPlaceholder.setTextAlignment(TextAlignment.CENTER);
        listClassifiers.setPlaceholder((Node)labelPlaceholder);
        this.refreshNames((ObservableList<String>)listClassifiers.getItems());
        ContextMenu popup = new ContextMenu();
        MenuItem miAdd = new MenuItem("Add classifier");
        miAdd.setOnAction(e -> {
            List files = FileChoosers.promptForMultipleFiles((String)"Object Classifiers", (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"QuPath classifier file", (String[])new String[]{"*.json"})});
            if (files == null || files.isEmpty()) {
                return;
            }
            try {
                this.addClassifierFiles(files);
                ArrayList<String> updatedNames = new ArrayList<String>();
                updatedNames.addAll(this.project.getPixelClassifiers().getNames());
                updatedNames.addAll(this.externalObjectClassifiers.keySet());
            }
            catch (IOException ex) {
                Dialogs.showErrorMessage((String)"Object Classifiers", (Throwable)ex);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        });
        MenuItem miRemove = new MenuItem("Delete selected");
        popup.getItems().setAll((Object[])new MenuItem[]{miAdd, miRemove});
        miRemove.disableProperty().bind((ObservableValue)listClassifiers.getSelectionModel().selectedItemProperty().isNull());
        listClassifiers.setContextMenu(popup);
        miRemove.setOnAction(e -> {
            ArrayList selectedItems = new ArrayList(listClassifiers.getSelectionModel().getSelectedItems());
            if (selectedItems.isEmpty() || this.project == null) {
                return;
            }
            try {
                String message;
                String string = message = selectedItems.size() == 1 ? "'" + (String)selectedItems.get(0) + "'" : selectedItems.size() + " classifiers";
                if (!Dialogs.showConfirmDialog((String)"Object Classifiers", (String)("Are you sure you want to delete " + message + "?"))) {
                    return;
                }
                for (String selected : selectedItems) {
                    if (!this.project.getObjectClassifiers().getNames().contains(selected)) {
                        Dialogs.showErrorMessage((String)"Object Classifiers", (String)("Unable to delete " + selected + " - not found in the current project"));
                        return;
                    }
                    this.project.getObjectClassifiers().remove(selected);
                    listClassifiers.getItems().remove((Object)selected);
                }
            }
            catch (Exception ex) {
                Dialogs.showErrorMessage((String)"Error deleting classifier", (Throwable)ex);
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        });
        listClassifiers.setOnDragOver(e -> {
            e.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            e.consume();
        });
        listClassifiers.setOnDragDropped(e -> {
            Dragboard dragboard = e.getDragboard();
            if (dragboard.hasFiles()) {
                logger.trace("File(s) dragged onto classifier listView");
                try {
                    List<File> files = dragboard.getFiles().stream().filter(f -> f.isFile() && !f.isHidden()).toList();
                    this.addClassifierFiles(files);
                }
                catch (Exception ex) {
                    String plural = dragboard.getFiles().size() == 1 ? "" : "s";
                    Dialogs.showErrorMessage((String)("Error adding classifier" + plural), (String)ex.getLocalizedMessage());
                }
            }
            this.refreshNames((ObservableList<String>)listClassifiers.getItems());
            e.consume();
        });
        Label label = new Label("Choose classifier");
        label.setLabelFor((Node)listClassifiers);
        Button btnApplyClassifier = new Button("Apply classifier");
        btnApplyClassifier.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            if (listClassifiers.getSelectionModel().getSelectedItems().size() > 1) {
                return "Apply classifiers sequentially";
            }
            return "Apply classifier";
        }, (Observable[])new Observable[]{listClassifiers.getSelectionModel().getSelectedItems()}));
        btnApplyClassifier.disableProperty().bind((ObservableValue)listClassifiers.getSelectionModel().selectedItemProperty().isNull());
        btnApplyClassifier.setOnAction(e -> {
            ImageData imageData = this.qupath.getImageData();
            if (imageData == null) {
                Dialogs.showErrorMessage((String)"Object Classifiers", (String)"No image open!");
                return;
            }
            this.runClassifier((ImageData<BufferedImage>)imageData, this.project, this.externalObjectClassifiers, (List<String>)listClassifiers.getSelectionModel().getSelectedItems(), true);
        });
        GridPane pane = new GridPane();
        pane.setPadding(new Insets(10.0));
        pane.setHgap(5.0);
        pane.setVgap(10.0);
        int row = 0;
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{label, listClassifiers, btnApplyClassifier});
        GridPaneUtils.setVGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{listClassifiers});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{label, listClassifiers, btnApplyClassifier});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{label, listClassifiers, btnApplyClassifier});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Choose object classification model to apply to the current image", (Node[])new Node[]{label});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Drag and drop a file here to add a new classifier", (Node[])new Node[]{listClassifiers});
        GridPaneUtils.addGridRow((GridPane)pane, (int)row++, (int)0, (String)"Apply object classification to all open images", (Node[])new Node[]{btnApplyClassifier});
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{listClassifiers, btnApplyClassifier});
        Stage stage = new Stage();
        FXUtils.addCloseWindowShortcuts((Stage)stage);
        stage.setTitle("Object Classifiers");
        stage.setScene(new Scene((Parent)pane));
        stage.initOwner((Window)this.qupath.getStage());
        stage.setWidth(300.0);
        stage.setHeight(400.0);
        stage.focusedProperty().addListener((v, o, n) -> {
            if (n.booleanValue()) {
                this.refreshNames((ObservableList<String>)listClassifiers.getItems());
            }
        });
        stage.show();
    }

    private void addClassifierFiles(List<File> files) throws IOException {
        int nSuccess;
        String plural2;
        String plural = files.size() > 1 ? "s" : "";
        ButtonType response = Dialogs.showYesNoCancelDialog((String)("Copy classifier file" + plural), (String)("Copy classifier" + plural + " to the current project?"));
        if (response == ButtonType.CANCEL) {
            return;
        }
        ArrayList<File> fails = new ArrayList<File>();
        for (File file : files) {
            try {
                if (!((String)GeneralTools.getExtension((File)file).get()).equals(".json")) {
                    Dialogs.showErrorNotification((String)String.format("Could not add '%s'", file.getName()), (String)String.format("Classifier files should be JSON files (.json), not %s", GeneralTools.getExtension((File)file).get()));
                    continue;
                }
                BufferedReader json = Files.newBufferedReader(file.toPath());
                ObjectClassifier classifier = (ObjectClassifier)GsonTools.getInstance().fromJson((Reader)json, ObjectClassifier.class);
                int index = 1;
                Object name = GeneralTools.getNameWithoutExtension((File)file);
                while (this.project.getObjectClassifiers().contains((String)name) || this.externalObjectClassifiers.containsKey(name)) {
                    name = GeneralTools.getNameWithoutExtension((File)file) + " (" + index++ + ")";
                }
                if (response == ButtonType.YES) {
                    this.project.getObjectClassifiers().put((String)name, (Object)classifier);
                    continue;
                }
                this.externalObjectClassifiers.put((String)name, (ObjectClassifier<BufferedImage>)classifier);
            }
            catch (IOException ex) {
                Dialogs.showErrorNotification((String)String.format("Could not add %s", file.getName()), (String)ex.getLocalizedMessage());
                fails.add(file);
            }
        }
        if (!fails.isEmpty()) {
            String failedClassifiers = fails.stream().map(e -> "- " + e.getName()).collect(Collectors.joining(System.lineSeparator()));
            String pluralize = fails.size() == 1 ? "" : "s";
            Dialogs.showErrorMessage((String)("Error adding classifier" + pluralize), (String)String.format("Could not add the following classifier%s:%s%s", pluralize, System.lineSeparator(), failedClassifiers));
        }
        String string = plural2 = (nSuccess = files.size() - fails.size()) > 1 ? "s" : "";
        if (nSuccess > 0) {
            Dialogs.showInfoNotification((String)("Classifier" + plural2 + " added successfully"), (String)String.format("%d classifier" + plural2 + " added", nSuccess));
        }
    }

    private void refreshNames(ObservableList<String> availableClassifiers) {
        if (this.project == null) {
            availableClassifiers.clear();
            return;
        }
        try {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(this.project.getObjectClassifiers().getNames());
            names.addAll(this.externalObjectClassifiers.keySet());
            availableClassifiers.setAll(names);
        }
        catch (IOException e) {
            Dialogs.showErrorMessage((String)"Object Classifiers", (String)e.getLocalizedMessage());
            return;
        }
    }

    private void runClassifier(ImageData<BufferedImage> imageData, Project<BufferedImage> project, Map<String, ObjectClassifier<BufferedImage>> externalClassifiers, List<String> selectedClassifiersNames, boolean logWorkflow) {
        ObjectClassifier<BufferedImage> classifier;
        try {
            classifier = this.getClassifier(project, externalClassifiers, selectedClassifiersNames);
        }
        catch (IOException ex) {
            Dialogs.showErrorMessage((String)"Object classifier", (Throwable)ex);
            logger.error(ex.getMessage(), (Throwable)ex);
            return;
        }
        if (classifier == null) {
            logger.info("Classifier is null for {}", selectedClassifiersNames);
            return;
        }
        logger.info("Running classifier: {}", selectedClassifiersNames);
        Collection pathObjects = classifier.getCompatibleObjects(imageData);
        if (pathObjects.isEmpty()) {
            Dialogs.showWarningNotification((String)"Object Classifiers", (String)("No compatible objects found for " + String.valueOf(selectedClassifiersNames)));
            return;
        }
        Map missingCounts = classifier.getMissingFeatures(imageData, pathObjects);
        if (!missingCounts.isEmpty()) {
            StringBuilder sb = new StringBuilder("There are missing features!");
            int n = pathObjects.size();
            for (Map.Entry entry : missingCounts.entrySet()) {
                double percent = (double)((Integer)entry.getValue()).intValue() * 100.0 / (double)n;
                sb.append("\t").append((String)entry.getKey()).append(": ").append(entry.getValue()).append(" objects (").append(GeneralTools.formatNumber((double)percent, (int)2)).append("%)").append("\n");
            }
            if (missingCounts.size() == 1) {
                Dialogs.showWarningNotification((String)"Missing features", (String)("Missing feature: " + (String)missingCounts.keySet().iterator().next() + "\n\nSee the log for more details."));
            } else {
                Dialogs.showWarningNotification((String)"Missing features", (String)(missingCounts.size() + " missing features!\n\nSee the log for more details."));
            }
            logger.warn(sb.toString());
        } else {
            logger.debug("No missing features found");
        }
        if (classifier.classifyObjects(imageData, pathObjects, true) > 0) {
            imageData.getHierarchy().fireObjectClassificationsChangedEvent(classifier, pathObjects);
            if (logWorkflow) {
                imageData.getHistoryWorkflow().addStep(ObjectClassifierLoadCommand.createObjectClassifierStep(selectedClassifiersNames));
            }
        } else {
            Dialogs.showWarningNotification((String)"Object Classifiers", (String)("No objects could be classified for " + String.valueOf(selectedClassifiersNames)));
        }
    }

    static WorkflowStep createObjectClassifierStep(String ... classifierNames) {
        return ObjectClassifierLoadCommand.createObjectClassifierStep(Arrays.asList(classifierNames));
    }

    static WorkflowStep createObjectClassifierStep(List<String> classifierNames) {
        String names = classifierNames.stream().map(n -> "\"" + n + "\"").collect(Collectors.joining(", "));
        return new DefaultScriptableWorkflowStep("Run object classifier", "runObjectClassifier(" + names + ")");
    }

    private ObjectClassifier<BufferedImage> getClassifier(Project<BufferedImage> project, Map<String, ObjectClassifier<BufferedImage>> externalClassifiers, List<String> names) throws IOException {
        if (names.isEmpty()) {
            return null;
        }
        ArrayList<ObjectClassifier> classifiers = new ArrayList<ObjectClassifier>();
        LinkedHashMap<String, UriResource> uriClassifiers = new LinkedHashMap<String, UriResource>();
        for (String s : names) {
            ObjectClassifier classifier = this.cachedClassifiers.getOrDefault(s, null);
            if (classifier == null) {
                if (project != null && project.getObjectClassifiers().contains(s)) {
                    classifier = (ObjectClassifier)project.getObjectClassifiers().get(s);
                    logger.debug("Classifier {} read from project", (Object)s);
                } else if (externalClassifiers.containsKey(s)) {
                    classifier = externalClassifiers.get(s);
                    logger.debug("Classifier {} read from external map", (Object)s);
                }
                if (classifier == null) {
                    logger.error("Classifier '{}' not found!", (Object)s);
                    return null;
                }
            } else {
                logger.debug("Classifier {} read from cache", (Object)s);
            }
            classifiers.add(classifier);
            if (!(classifier instanceof UriResource)) continue;
            UriResource resource = (UriResource)classifier;
            if (fixQuietly) {
                UriUpdater.fixUris((UriResource)resource, project);
            }
            uriClassifiers.put(s, (UriResource)classifier);
        }
        if (!uriClassifiers.isEmpty()) {
            URI previousBase = project == null ? null : project.getPreviousURI();
            URI currentBase = project == null ? null : project.getURI();
            int nChanged = UpdateUrisCommand.promptToUpdateUris(uriClassifiers.values(), (URI)previousBase, (URI)currentBase, (boolean)true);
            if (nChanged < 0) {
                return null;
            }
            if (nChanged > 0) {
                logger.info("Storing updated classifiers {} in temporary cache", uriClassifiers.keySet());
                for (Map.Entry entry : uriClassifiers.entrySet()) {
                    this.cachedClassifiers.put((String)entry.getKey(), (ObjectClassifier<BufferedImage>)((ObjectClassifier)entry.getValue()));
                }
            }
        }
        if (names.size() == 1) {
            return (ObjectClassifier)classifiers.get(0);
        }
        return ObjectClassifiers.createCompositeClassifier(classifiers);
    }
}

