/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.application.Platform;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.PieChart;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;
import org.bytedeco.javacpp.PointerScope;
import org.bytedeco.javacpp.indexer.UByteIndexer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.opencv_core.Mat;
import org.bytedeco.opencv.opencv_core.Scalar;
import org.bytedeco.opencv.opencv_ml.ANN_MLP;
import org.bytedeco.opencv.opencv_ml.KNearest;
import org.bytedeco.opencv.opencv_ml.RTrees;
import org.bytedeco.opencv.opencv_ml.TrainData;
import org.controlsfx.control.ListSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.controls.PredicateTextField;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.classifiers.Normalization;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.common.GeneralTools;
import qupath.lib.common.ThreadTools;
import qupath.lib.geom.Point2;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.charts.ChartTools;
import qupath.lib.gui.dialogs.ProjectDialogs;
import qupath.lib.gui.tools.ColorToolsFX;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjectFilter;
import qupath.lib.objects.PathObjectTools;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyEvent;
import qupath.lib.objects.hierarchy.events.PathObjectHierarchyListener;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.ResourceManager;
import qupath.lib.roi.interfaces.ROI;
import qupath.opencv.ml.OpenCVClassifiers;
import qupath.opencv.ml.objects.OpenCVMLClassifier;
import qupath.opencv.ml.objects.features.FeatureExtractor;
import qupath.opencv.ml.objects.features.FeatureExtractors;
import qupath.opencv.ml.objects.features.Normalizer;
import qupath.opencv.ml.objects.features.Preprocessing;
import qupath.opencv.tools.OpenCVTools;
import qupath.process.gui.commands.ObjectClassifierLoadCommand;
import qupath.process.gui.commands.ml.ProjectClassifierBindings;

public class ObjectClassifierCommand
implements Runnable {
    private static final String name = "Train object classifier";
    private QuPathGUI qupath;
    private Stage dialog;

    public ObjectClassifierCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        if (this.dialog == null) {
            this.dialog = new Stage();
            if (this.qupath != null) {
                this.dialog.initOwner((Window)this.qupath.getStage());
            }
            this.dialog.setTitle(name);
            BorderPane pane = new BorderPane();
            ObjectClassifierPane panel = new ObjectClassifierPane(this.qupath);
            pane.setCenter((Node)panel.getPane());
            ScrollPane scrollPane = new ScrollPane((Node)pane);
            scrollPane.setFitToWidth(true);
            scrollPane.setFitToHeight(true);
            this.dialog.setScene(new Scene((Parent)scrollPane));
            this.dialog.setMinWidth(320.0);
            this.dialog.setMinHeight(320.0);
            panel.registerListeners(this.qupath);
            this.dialog.setOnCloseRequest(e -> {
                this.dialog = null;
                panel.cleanup(this.qupath);
            });
        } else {
            this.dialog.requestFocus();
        }
        this.dialog.sizeToScene();
        this.dialog.show();
    }

    static class ObjectClassifierPane
    implements ChangeListener<ImageData<BufferedImage>>,
    PathObjectHierarchyListener {
        private static final Logger logger = LoggerFactory.getLogger(ObjectClassifierPane.class);
        private QuPathGUI qupath;
        private GridPane pane;
        private ReadOnlyObjectProperty<PathObjectFilter> objectFilter;
        private ReadOnlyObjectProperty<OpenCVClassifiers.OpenCVStatModel> selectedModel;
        private ReadOnlyObjectProperty<OutputClasses> outputClasses;
        private ReadOnlyObjectProperty<TrainingFeatures> trainingFeatures;
        private ReadOnlyObjectProperty<TrainingAnnotations> trainingAnnotations;
        private ObjectProperty<Normalization> normalization = new SimpleObjectProperty((Object)Normalization.NONE);
        private DoubleProperty pcaRetainedVariance = new SimpleDoubleProperty(-1.0);
        private Set<PathClass> selectedClasses = new HashSet<PathClass>();
        private Set<String> selectedMeasurements = new LinkedHashSet<String>();
        private ReadOnlyBooleanProperty doMulticlass = new SimpleBooleanProperty(true);
        private StringProperty cursorLocation = new SimpleStringProperty();
        private BooleanProperty livePrediction = new SimpleBooleanProperty(false);
        private List<ProjectImageEntry<BufferedImage>> trainingEntries = new ArrayList<ProjectImageEntry<BufferedImage>>();
        private Map<ProjectImageEntry<BufferedImage>, ImageData<BufferedImage>> trainingMap = new WeakHashMap<ProjectImageEntry<BufferedImage>, ImageData<BufferedImage>>();
        private PieChart pieChart;
        private ExecutorService pool = Executors.newSingleThreadExecutor(ThreadTools.createThreadFactory((String)"object-classifier", (boolean)true));
        private FutureTask<ObjectClassifier<BufferedImage>> classifierTask;

        ObjectClassifierPane(QuPathGUI qupath) {
            this.qupath = qupath;
            this.selectedClasses.addAll((Collection<PathClass>)qupath.getAvailablePathClasses());
            this.initialize();
        }

        private void invalidateClassifier() {
            if (!Platform.isFxApplicationThread()) {
                logger.warn("invalidateClassifier() should only be called from the Application thread! I'll try to recover...");
                Platform.runLater(() -> this.invalidateClassifier());
                return;
            }
            if (this.classifierTask != null && !this.classifierTask.isDone()) {
                this.classifierTask.cancel(true);
            }
            this.classifierTask = null;
            if (this.livePrediction.get()) {
                this.classifierTask = this.submitClassifierUpdateTask(true);
            }
        }

        private FutureTask<ObjectClassifier<BufferedImage>> submitClassifierUpdateTask(boolean doClassification) {
            FutureTask<ObjectClassifier<BufferedImage>> task = this.createClassifierUpdateTask(true);
            if (task != null) {
                if (this.pool == null || this.pool.isShutdown()) {
                    logger.error("No thread pool available to train classifier!");
                    return null;
                }
                this.pool.submit(task);
            }
            return task;
        }

        public Pane getPane() {
            return this.pane;
        }

        private static List<PathObject> getTrainingAnnotations(PathObjectHierarchy hierarchy, TrainingAnnotations training) {
            Predicate<PathObject> trainingFilter = p -> p.isAnnotation() && p.getPathClass() != null && p.hasROI();
            switch (training.ordinal()) {
                case 3: {
                    trainingFilter = trainingFilter.and((Predicate<PathObject>)PathObjectFilter.ROI_AREA);
                    break;
                }
                case 2: {
                    trainingFilter = trainingFilter.and((Predicate<PathObject>)PathObjectFilter.ROI_POINT);
                    break;
                }
                case 1: {
                    trainingFilter = trainingFilter.and((Predicate<PathObject>)PathObjectFilter.UNLOCKED);
                    break;
                }
            }
            Collection annotations = hierarchy.getAnnotationObjects();
            return annotations.stream().filter(trainingFilter).toList();
        }

        private Collection<ImageData<BufferedImage>> getTrainingImageData() {
            ImageData imageData = this.qupath.getImageData();
            if (imageData == null) {
                logger.warn("Cannot train classifier - a valid image needs to be open in the current viewer");
                return Collections.emptyList();
            }
            ArrayList<ImageData<BufferedImage>> list = new ArrayList<ImageData<BufferedImage>>();
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                ImageData tempData = viewer.getImageData();
                if (tempData == null) continue;
                list.add((ImageData<BufferedImage>)tempData);
            }
            if (!this.trainingEntries.isEmpty()) {
                Collection currentEntries = ProjectDialogs.getCurrentImages((QuPathGUI)this.qupath);
                for (ProjectImageEntry<BufferedImage> entry : this.trainingEntries) {
                    try {
                        ImageData<BufferedImage> tempData;
                        if (currentEntries.contains(entry)) {
                            logger.debug("Will not load data for {} - will use the training annotations from the open viewer", entry);
                            tempData = this.trainingMap.remove(entry);
                            if (tempData == null) continue;
                            tempData.getServer().close();
                            continue;
                        }
                        tempData = this.trainingMap.get(entry);
                        if (tempData == null) {
                            tempData = entry.readImageData();
                            this.trainingMap.put(entry, tempData);
                        }
                        list.add(tempData);
                    }
                    catch (Exception e) {
                        logger.error(e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            return list;
        }

        private boolean promptToLoadTrainingImages() {
            Project project = this.qupath.getProject();
            if (project == null) {
                GuiTools.showNoProjectError((String)"Object classifier");
                return false;
            }
            ListSelectionView listView = ProjectDialogs.createImageChoicePane((QuPathGUI)this.qupath, (List)project.getImageList(), this.trainingEntries, (String)"Specified image is open!");
            BorderPane pane = new BorderPane((Node)listView);
            pane.setTop((Node)new Label("Select images to use for training the object classifier.\nNote that more images will require more memory and more processing time!"));
            if (Dialogs.builder().title("Object classifier training images").content((Node)pane).resizable().buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).showAndWait().orElse(ButtonType.CANCEL) == ButtonType.CANCEL) {
                return false;
            }
            this.trainingEntries.clear();
            this.trainingEntries.addAll((Collection<ProjectImageEntry<BufferedImage>>)listView.getTargetItems());
            return true;
        }

        private FutureTask<ObjectClassifier<BufferedImage>> createClassifierUpdateTask(boolean doClassification) {
            OpenCVClassifiers.OpenCVStatModel statModel;
            PathObjectFilter filter = (PathObjectFilter)this.objectFilter.get();
            OpenCVClassifiers.OpenCVStatModel openCVStatModel = statModel = this.selectedModel == null ? null : (OpenCVClassifiers.OpenCVStatModel)this.selectedModel.get();
            if (statModel == null) {
                logger.warn("No classifier - cannot update classifier");
                this.resetPieChart();
                return null;
            }
            Collection<ImageData<BufferedImage>> imageDataCollection = this.getTrainingImageData();
            if (imageDataCollection.isEmpty()) {
                logger.warn("No image - cannot update classifier");
                this.resetPieChart();
                return null;
            }
            TrainingAnnotations annotations = (TrainingAnnotations)((Object)this.trainingAnnotations.get());
            OutputClasses output = (OutputClasses)((Object)this.outputClasses.get());
            HashSet<PathClass> selectedClasses = new HashSet<PathClass>(this.selectedClasses);
            Normalization norm = (Normalization)this.normalization.get();
            double pcaRetained = this.pcaRetainedVariance.get();
            boolean multiclass = this.doMulticlass.get() && statModel.supportsMulticlass();
            List<String> measurements = this.getRequestedMeasurements();
            if (measurements.isEmpty()) {
                Dialogs.showWarningNotification((String)"Object classifiers", (String)"No measurements available - cannot update classifier");
                return null;
            }
            FeatureExtractor extractor = FeatureExtractors.createMeasurementListFeatureExtractor(measurements);
            return new FutureTask<ObjectClassifier<BufferedImage>>(() -> {
                ArrayList training = new ArrayList();
                for (ImageData imageData : imageDataCollection) {
                    TrainingData temp = ObjectClassifierPane.createTrainingData(filter, imageData, annotations, output == OutputClasses.ALL ? null : selectedClasses);
                    training.add(temp);
                }
                if (training.isEmpty() || Thread.interrupted()) {
                    return null;
                }
                long nTrainingObjects = training.stream().mapToLong(t -> t.map.size()).sum();
                if (nTrainingObjects <= 1L) {
                    Dialogs.showErrorNotification((String)"Object classifier", (String)"You need to annotate objects with at least two classifications to train a classifier!");
                    return null;
                }
                ObjectClassifier<BufferedImage> classifier = ObjectClassifierPane.createClassifier(training, filter, statModel, (FeatureExtractor<BufferedImage>)extractor, norm, pcaRetained, multiclass);
                if (Thread.interrupted()) {
                    return null;
                }
                if (classifier == null) {
                    Dialogs.showErrorNotification((String)"Object classifier", (String)"Unable to train object classifier with the current settings!");
                    return null;
                }
                if (doClassification) {
                    for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                        Collection pathObjects;
                        ImageData imageData = viewer.getImageData();
                        if (imageData == null || classifier.classifyObjects(imageData, pathObjects = classifier.getCompatibleObjects(imageData), true) <= 0) continue;
                        imageData.getHierarchy().fireObjectClassificationsChangedEvent((Object)this, pathObjects);
                    }
                }
                this.updatePieChart(training);
                return classifier;
            });
        }

        private Collection<PathObject> getTrainingAnnotations(Collection<ImageData<BufferedImage>> trainingImageData) {
            if (trainingImageData.isEmpty()) {
                return Collections.emptyList();
            }
            TrainingAnnotations annotationType = (TrainingAnnotations)((Object)this.trainingAnnotations.get());
            if (trainingImageData.size() == 1) {
                return ObjectClassifierPane.getTrainingAnnotations(trainingImageData.iterator().next().getHierarchy(), annotationType);
            }
            ArrayList<PathObject> trainingAnnotations = new ArrayList<PathObject>();
            for (ImageData<BufferedImage> imageData : trainingImageData) {
                trainingAnnotations.addAll(ObjectClassifierPane.getTrainingAnnotations(imageData.getHierarchy(), annotationType));
            }
            return trainingAnnotations;
        }

        private Collection<String> getAllMeasurements(Collection<ImageData<BufferedImage>> trainingImageData, boolean includeIntersection) {
            if (trainingImageData.isEmpty()) {
                return Collections.emptyList();
            }
            PathObjectFilter filter = (PathObjectFilter)this.objectFilter.get();
            if (trainingImageData.size() == 1) {
                return this.getAllMeasurements(trainingImageData.iterator().next(), filter);
            }
            LinkedHashSet<String> allMeasurements = new LinkedHashSet<String>();
            LinkedHashSet<String> firstMeasurements = new LinkedHashSet<String>();
            boolean firstChanges = false;
            for (ImageData<BufferedImage> imageData : trainingImageData) {
                Collection<String> newMeasurements = this.getAllMeasurements(imageData, filter);
                if (newMeasurements.isEmpty()) continue;
                if (includeIntersection) {
                    if (firstMeasurements.isEmpty()) {
                        firstMeasurements.addAll(newMeasurements);
                        allMeasurements.addAll(firstMeasurements);
                        continue;
                    }
                    if (!allMeasurements.retainAll(newMeasurements) || !firstChanges) continue;
                    logger.warn("Different measurements found in different training images! Available measurements will be restricted to the intersection of these.");
                    continue;
                }
                allMeasurements.addAll(newMeasurements);
            }
            return allMeasurements;
        }

        private Collection<String> getAllMeasurements(ImageData<?> imageData, PathObjectFilter filter) {
            List detections = imageData.getHierarchy().getFlattenedObjectList(null).stream().filter(filter).toList();
            return PathObjectTools.getAvailableFeatures(detections);
        }

        private List<String> getRequestedMeasurements() {
            Collection<ImageData<BufferedImage>> trainingImageData = this.getTrainingImageData();
            if (trainingImageData.isEmpty()) {
                return Collections.emptyList();
            }
            if (this.trainingFeatures.get() == TrainingFeatures.SELECTED) {
                return new ArrayList<String>(this.selectedMeasurements);
            }
            Collection<String> allMeasurements = this.getAllMeasurements(trainingImageData, true);
            if (this.trainingFeatures.get() == TrainingFeatures.FILTERED) {
                Collection<PathObject> trainingAnnotations = this.getTrainingAnnotations(trainingImageData);
                ArrayList<String> measurements = new ArrayList<String>();
                Set filterText = trainingAnnotations.stream().distinct().map(a -> a.getPathClass().toString().toLowerCase().trim()).collect(Collectors.toSet());
                block0: for (String m : allMeasurements) {
                    for (String f : filterText) {
                        if (!m.toLowerCase().contains(f)) continue;
                        measurements.add(m);
                        continue block0;
                    }
                }
                return measurements;
            }
            return new ArrayList<String>(allMeasurements);
        }

        private static <T> TrainingData<T> createTrainingData(PathObjectFilter filter, ImageData<T> imageData, TrainingAnnotations training, Collection<PathClass> selectedClasses) {
            TreeMap<PathClass, Set<PathObject>> map = new TreeMap<PathClass, Set<PathObject>>();
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            List<PathObject> trainingAnnotations = ObjectClassifierPane.getTrainingAnnotations(hierarchy, training);
            if (Thread.interrupted()) {
                return null;
            }
            Predicate filterNegated = filter.negate();
            for (PathObject annotation : trainingAnnotations) {
                PathClass pathClass = annotation.getPathClass();
                if (selectedClasses != null && !selectedClasses.contains(pathClass)) continue;
                Set set = map.computeIfAbsent(pathClass, p -> new TreeSet<PathObject>(Comparator.comparing(PathObject::getID)));
                ROI roi = annotation.getROI();
                if (roi.isPoint()) {
                    for (Point2 p2 : annotation.getROI().getAllPoints()) {
                        Collection pathObjectsTemp = PathObjectTools.getObjectsForLocation((PathObjectHierarchy)hierarchy, (double)p2.getX(), (double)p2.getY(), (int)roi.getZ(), (int)roi.getT(), (double)-1.0);
                        pathObjectsTemp.removeIf(filterNegated);
                        set.addAll(pathObjectsTemp);
                    }
                    continue;
                }
                Collection pathObjectsTemp = hierarchy.getAllDetectionsForROI(annotation.getROI());
                pathObjectsTemp.removeIf(filterNegated);
                set.addAll(pathObjectsTemp);
            }
            map.entrySet().removeIf(e -> ((Set)e.getValue()).isEmpty());
            return new TrainingData<T>(imageData, map);
        }

        private static ObjectClassifier<BufferedImage> createClassifier(Collection<TrainingData<BufferedImage>> training, PathObjectFilter filter, OpenCVClassifiers.OpenCVStatModel statModel, FeatureExtractor<BufferedImage> extractor, Normalization normalization, double pcaRetainedVariance, boolean doMulticlass) {
            List<PathClass> pathClasses = ObjectClassifierPane.getPathClasses(training);
            if (pathClasses.isEmpty()) {
                logger.warn("No compatible training data found!");
                return null;
            }
            if (training.size() > 1) {
                logger.info("Creating training data from {} images", (Object)training.size());
            }
            extractor = ObjectClassifierPane.updateFeatureExtractorAndTrainClassifier(statModel, training, extractor, normalization, pcaRetainedVariance, doMulticlass);
            return OpenCVMLClassifier.create((OpenCVClassifiers.OpenCVStatModel)statModel, (PathObjectFilter)filter, extractor, pathClasses);
        }

        void resetPieChart() {
            this.updatePieChart(Collections.emptyMap());
        }

        <T> void updatePieChart(Collection<TrainingData<T>> training) {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.updatePieChart(training));
                return;
            }
            LinkedHashMap<PathClass, Integer> counts = new LinkedHashMap<PathClass, Integer>();
            for (TrainingData<T> t : training) {
                for (Map.Entry<PathClass, Set<PathObject>> entry : t.map.entrySet()) {
                    PathClass key = entry.getKey();
                    Integer total = counts.getOrDefault(key, 0) + entry.getValue().size();
                    counts.put(entry.getKey(), total);
                }
            }
            ChartTools.setPieChartData((PieChart)this.pieChart, counts, PathClass::toString, p -> ColorToolsFX.getCachedColor((Integer)p.getColor()), (boolean)true, (!counts.isEmpty() ? 1 : 0) != 0);
            if (counts.isEmpty()) {
                this.pieChart.setTitle(null);
            } else {
                this.pieChart.setTitle("Training data");
            }
        }

        void updatePieChart(Map<PathClass, Set<PathObject>> map) {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.updatePieChart(map));
                return;
            }
            LinkedHashMap<PathClass, Integer> counts = new LinkedHashMap<PathClass, Integer>();
            for (Map.Entry<PathClass, Set<PathObject>> entry : map.entrySet()) {
                counts.put(entry.getKey(), entry.getValue().size());
            }
            ChartTools.setPieChartData((PieChart)this.pieChart, counts, PathClass::toString, p -> ColorToolsFX.getCachedColor((Integer)p.getColor()), (boolean)true, (!map.isEmpty() ? 1 : 0) != 0);
        }

        static <T> List<PathClass> getPathClasses(Collection<TrainingData<T>> training) {
            HashSet<PathClass> classSet = new HashSet<PathClass>();
            for (TrainingData<T> t : training) {
                classSet.addAll(t.getPathClasses());
            }
            ArrayList<PathClass> pathClasses = new ArrayList<PathClass>(classSet);
            Collections.sort(pathClasses);
            return pathClasses;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static <T> FeatureExtractor<T> updateFeatureExtractorAndTrainClassifier(OpenCVClassifiers.OpenCVStatModel classifier, Collection<TrainingData<T>> trainingCollection, FeatureExtractor<T> extractor, Normalization normalization, double pcaRetainedVariance, boolean doMulticlass) {
            boolean doNormalization;
            List<PathClass> pathClasses = ObjectClassifierPane.getPathClasses(trainingCollection);
            ArrayList<Mat> matFeaturesList = new ArrayList<Mat>();
            ArrayList<Mat> matTargetsList = new ArrayList<Mat>();
            double missingValue = 0.0;
            boolean bl = doNormalization = !classifier.supportsMissingValues() || normalization != Normalization.NONE || !(pcaRetainedVariance < 0.0);
            if (doNormalization) {
                missingValue = classifier.supportsMissingValues() && pcaRetainedVariance < 0.0 ? Double.NaN : 0.0;
            }
            Mat matAllFeatures = new Mat();
            Mat matAllTargets = new Mat();
            try (PointerScope scope = new PointerScope();){
                Iterator<TrainingData<T>> iterator;
                for (TrainingData<T> training : trainingCollection) {
                    Mat matTargets;
                    Mat matFeatures;
                    ImageData imageData = training.imageData;
                    Map<PathClass, Set<PathObject>> map = training.map;
                    int nFeatures = extractor.nFeatures();
                    int nSamples = map.values().stream().mapToInt(l -> l.size()).sum();
                    int nClasses = pathClasses.size();
                    if (nSamples == 0) continue;
                    if (doMulticlass) {
                        LinkedHashSet sampleSet = new LinkedHashSet();
                        for (Map.Entry<PathClass, Set<PathObject>> entry : map.entrySet()) {
                            sampleSet.addAll(entry.getValue());
                        }
                        nSamples = sampleSet.size();
                        matFeatures = new Mat(nSamples, nFeatures, opencv_core.CV_32FC1);
                        FloatBuffer buffer = (FloatBuffer)matFeatures.createBuffer();
                        matTargets = new Mat(nSamples, nClasses, opencv_core.CV_8UC1, Scalar.ZERO);
                        UByteIndexer idxTargets = (UByteIndexer)matTargets.createIndexer();
                        extractor.extractFeatures(imageData, sampleSet, buffer);
                        int row = 0;
                        for (PathObject sample : sampleSet) {
                            for (int col = 0; col < nClasses; ++col) {
                                PathClass pathClass = pathClasses.get(col);
                                if (!map.get(pathClass).contains(sample)) continue;
                                idxTargets.put((long)row, (long)col, 1);
                            }
                            ++row;
                        }
                        idxTargets.release();
                    } else {
                        matFeatures = new Mat(nSamples, nFeatures, opencv_core.CV_32FC1);
                        FloatBuffer buffer = (FloatBuffer)matFeatures.createBuffer();
                        matTargets = new Mat(nSamples, 1, opencv_core.CV_32SC1, Scalar.ZERO);
                        IntBuffer bufTargets = (IntBuffer)matTargets.createBuffer();
                        for (Map.Entry<PathClass, Set<PathObject>> entry : map.entrySet()) {
                            PathClass pathClass = entry.getKey();
                            Set<PathObject> pathObjects = entry.getValue();
                            extractor.extractFeatures(imageData, pathObjects, buffer);
                            int pathClassIndex = pathClasses.indexOf(pathClass);
                            for (int i = 0; i < pathObjects.size(); ++i) {
                                bufTargets.put(pathClassIndex);
                            }
                        }
                    }
                    matFeaturesList.add(matFeatures);
                    matTargetsList.add(matTargets);
                }
                if (matFeaturesList.isEmpty()) {
                    logger.warn("No features found!");
                    iterator = null;
                    return iterator;
                }
                OpenCVTools.vConcat(matFeaturesList, (Mat)matAllFeatures);
                matAllFeatures.put(matAllFeatures.clone());
                OpenCVTools.vConcat(matTargetsList, (Mat)matAllTargets);
                matAllTargets.put(matAllTargets.clone());
                if (doNormalization) {
                    Normalizer normalizer = Preprocessing.createNormalizer((Normalization)normalization, (Mat)matAllFeatures, (double)missingValue);
                    Preprocessing.normalize((Mat)matAllFeatures, (Normalizer)normalizer);
                    extractor = FeatureExtractors.createNormalizingFeatureExtractor(extractor, (Normalizer)normalizer);
                }
                if (pcaRetainedVariance > 0.0) {
                    Preprocessing.PCAProjector pca = Preprocessing.createPCAProjector((Mat)matAllFeatures, (double)pcaRetainedVariance, (boolean)true);
                    pca.project(matAllFeatures, matAllFeatures);
                    extractor = FeatureExtractors.createPCAProjectFeatureExtractor((FeatureExtractor)extractor, (Preprocessing.PCAProjector)pca);
                }
                if (Thread.currentThread().isInterrupted()) {
                    logger.warn("Classifier training interrupted!");
                    matAllFeatures.close();
                    matAllTargets.close();
                    iterator = null;
                    return iterator;
                }
            }
            try {
                ObjectClassifierPane.trainClassifier(classifier, matAllFeatures, matAllTargets, doMulticlass);
                if (classifier instanceof OpenCVClassifiers.RTreesClassifier) {
                    ObjectClassifierPane.tryLoggingVariableImportance((OpenCVClassifiers.RTreesClassifier)classifier, extractor);
                }
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage(), (Throwable)e);
            }
            finally {
                matAllFeatures.close();
                matAllTargets.close();
            }
            return extractor;
        }

        static boolean trainClassifier(OpenCVClassifiers.OpenCVStatModel classifier, Mat matFeatures, Mat matTargets, boolean doMulticlass) {
            long startTime = System.currentTimeMillis();
            TrainData trainData = classifier.createTrainData(matFeatures, matTargets, null, doMulticlass);
            classifier.train(trainData);
            long endTime = System.currentTimeMillis();
            logger.info("{} classifier trained with {} samples and {} features ({} ms)", new Object[]{classifier.getName(), matFeatures.rows(), matFeatures.cols(), endTime - startTime});
            return true;
        }

        static boolean tryLoggingVariableImportance(OpenCVClassifiers.RTreesClassifier trees, FeatureExtractor<?> extractor) {
            double[] importance = trees.getFeatureImportance();
            if (importance == null) {
                return false;
            }
            int[] sorted = IntStream.range(0, importance.length).boxed().sorted((a, b) -> -Double.compare(importance[a], importance[b])).mapToInt(i -> i).toArray();
            List names = extractor.getFeatureNames();
            StringBuilder sb = new StringBuilder("Variable importance:");
            for (int ind : sorted) {
                sb.append("\n");
                sb.append(String.format("%.4f \t %s", importance[ind], names.get(ind)));
            }
            logger.info(sb.toString());
            return true;
        }

        private boolean showAdvancedOptions() {
            Normalization norm = (Normalization)Dialogs.showChoiceDialog((String)"Advanced options", (String)"Feature normalization", (Object[])Normalization.values(), (Object)((Normalization)this.normalization.get()));
            if (norm == null || norm == this.normalization.get()) {
                return false;
            }
            this.normalization.set((Object)norm);
            return true;
        }

        private boolean tryToSave(String name) {
            ObjectClassifier<BufferedImage> classifier;
            String classifierName;
            String string = classifierName = name == null ? "" : GeneralTools.stripInvalidFilenameChars((String)name);
            if (classifierName.isBlank()) {
                Dialogs.showErrorMessage((String)"Object classifier", (String)"Please enter a valid classifier name!");
                return false;
            }
            if (!classifierName.equals(name)) {
                logger.warn("Invalid classifier name '{}' replaced with '{}'", (Object)name, (Object)classifierName);
            }
            if (this.classifierTask == null) {
                this.classifierTask = this.submitClassifierUpdateTask(false);
                if (this.classifierTask == null) {
                    return false;
                }
            }
            try {
                classifier = this.classifierTask.get();
            }
            catch (InterruptedException e1) {
                Dialogs.showErrorNotification((String)name, (String)"Classifier training was interrupted!");
                return false;
            }
            catch (ExecutionException e1) {
                Dialogs.showErrorNotification((String)name, (Throwable)e1);
                logger.error(e1.getMessage(), (Throwable)e1);
                return false;
            }
            if (classifier != null) {
                try {
                    Project project = this.qupath.getProject();
                    if (project != null) {
                        ResourceManager.Manager allClassifiers = project.getObjectClassifiers();
                        if (allClassifiers.contains(name) && !Dialogs.showConfirmDialog((String)"Object classifiers", (String)("Overwrite existing classifier \"" + classifierName + "\""))) {
                            return false;
                        }
                        project.getObjectClassifiers().put(classifierName, classifier);
                        logger.info("Classifier saved to project as {}", (Object)classifierName);
                    } else {
                        File file = FileChoosers.promptToSaveFile((String)"Save object classifier", (File)new File(classifierName), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"Object classifier", (String[])new String[]{".obj.json"})});
                        if (file == null) {
                            return false;
                        }
                        classifierName = file.getAbsolutePath();
                        ObjectClassifiers.writeClassifier(classifier, (Path)file.toPath());
                    }
                    Dialogs.showInfoNotification((String)"Object classifiers", (String)("Saved classifier as \"" + classifierName + "\""));
                    for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                        ImageData imageData = viewer.getImageData();
                        if (imageData == null) continue;
                        classifier.classifyObjects(imageData, true);
                        imageData.getHistoryWorkflow().addStep(ObjectClassifierLoadCommand.createObjectClassifierStep(classifierName));
                    }
                    return true;
                }
                catch (Exception e) {
                    logger.error("Error attempting to save classifier " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            Dialogs.showWarningNotification((String)"Object classifiers", (String)"Unable to save classifier!");
            return false;
        }

        private boolean editClassifierParameters() {
            OpenCVClassifiers.OpenCVStatModel model = (OpenCVClassifiers.OpenCVStatModel)this.selectedModel.get();
            if (model == null) {
                Dialogs.showErrorMessage((String)"Edit parameters", (String)"No classifier selected!");
                return false;
            }
            GuiTools.showParameterDialog((String)"Edit parameters", (ParameterList)model.getParameterList());
            this.invalidateClassifier();
            return true;
        }

        private void initialize() {
            this.pane = new GridPane();
            int row = 0;
            Label labelObjects = new Label("Object filter");
            ComboBox comboObjects = new ComboBox();
            comboObjects.getItems().addAll((Object[])new PathObjectFilter[]{PathObjectFilter.DETECTIONS_ALL, PathObjectFilter.DETECTIONS, PathObjectFilter.CELLS, PathObjectFilter.TILES});
            labelObjects.setLabelFor((Node)comboObjects);
            this.objectFilter = comboObjects.getSelectionModel().selectedItemProperty();
            comboObjects.getSelectionModel().select((Object)PathObjectFilter.DETECTIONS_ALL);
            this.objectFilter.addListener((v, o, n) -> this.invalidateClassifier());
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose object type to classify (default is all detections)", (Node[])new Node[]{labelObjects, comboObjects, comboObjects});
            Label labelClassifier = new Label("Classifier");
            ComboBox comboClassifier = new ComboBox();
            comboClassifier.getItems().addAll((Object[])new OpenCVClassifiers.OpenCVStatModel[]{OpenCVClassifiers.createStatModel(RTrees.class), OpenCVClassifiers.createStatModel(ANN_MLP.class), OpenCVClassifiers.createStatModel(KNearest.class)});
            labelClassifier.setLabelFor((Node)comboClassifier);
            this.selectedModel = comboClassifier.getSelectionModel().selectedItemProperty();
            comboClassifier.getSelectionModel().selectFirst();
            this.selectedModel.addListener((v, o, n) -> this.invalidateClassifier());
            Button btnEditClassifier = new Button("Edit");
            btnEditClassifier.setMaxWidth(Double.MAX_VALUE);
            btnEditClassifier.setOnAction(e -> this.editClassifierParameters());
            btnEditClassifier.disableProperty().bind((ObservableValue)this.selectedModel.isNull());
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose classifier type (RTrees or ANN_MLP are generally good choices)", (Node[])new Node[]{labelClassifier, comboClassifier, btnEditClassifier});
            Label labelFeatures = new Label("Features");
            ComboBox comboFeatures = new ComboBox();
            labelFeatures.setLabelFor((Node)comboFeatures);
            comboFeatures.getItems().setAll((Object[])TrainingFeatures.values());
            comboFeatures.getSelectionModel().select((Object)TrainingFeatures.ALL);
            labelFeatures.setLabelFor((Node)comboFeatures);
            this.trainingFeatures = comboFeatures.getSelectionModel().selectedItemProperty();
            this.trainingFeatures.addListener(v -> this.invalidateClassifier());
            Button btnSelectFeatures = new Button("Select");
            btnSelectFeatures.setMaxWidth(Double.MAX_VALUE);
            btnSelectFeatures.disableProperty().bind((ObservableValue)this.trainingFeatures.isNotEqualTo((Object)TrainingFeatures.SELECTED));
            btnSelectFeatures.setOnAction(e -> {
                if (this.promptToSelectFeatures()) {
                    this.invalidateClassifier();
                }
            });
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, null, (Node[])new Node[]{labelFeatures, comboFeatures, btnSelectFeatures});
            Tooltip tooltipFeatures = new Tooltip();
            tooltipFeatures.setOnShowing(e -> {
                List<String> measurements;
                Object text = "Select measurements for the classifier\n";
                text = this.trainingFeatures.get() == TrainingFeatures.ALL ? (String)text + "Currently, all available measurements will be used" : ((measurements = this.getRequestedMeasurements()).isEmpty() ? (String)text + "No measurements are currently selected - please choose some!" : (String)text + "Current measurements: \n - " + String.join((CharSequence)"\n - ", measurements));
                tooltipFeatures.setText((String)text);
            });
            btnSelectFeatures.setTooltip(tooltipFeatures);
            comboFeatures.setTooltip(tooltipFeatures);
            Label labelClasses = new Label("Classes");
            ComboBox comboClasses = new ComboBox();
            labelClasses.setLabelFor((Node)comboClasses);
            comboClasses.getItems().setAll((Object[])OutputClasses.values());
            comboClasses.getSelectionModel().select((Object)OutputClasses.ALL);
            labelClasses.setLabelFor((Node)comboClasses);
            this.outputClasses = comboClasses.getSelectionModel().selectedItemProperty();
            this.outputClasses.addListener(v -> this.invalidateClassifier());
            Button btnSelectClasses = new Button("Select");
            btnSelectClasses.setMaxWidth(Double.MAX_VALUE);
            btnSelectClasses.disableProperty().bind((ObservableValue)this.outputClasses.isEqualTo((Object)OutputClasses.ALL));
            btnSelectClasses.setOnAction(e -> {
                if (this.promptToSelectClasses()) {
                    this.invalidateClassifier();
                }
            });
            Tooltip tooltipClasses = new Tooltip();
            tooltipClasses.setOnShowing(e -> {
                Object text = "Choose which classes to use when training the classifier\n";
                text = this.outputClasses.get() == OutputClasses.SELECTED ? (this.selectedClasses.isEmpty() ? (String)text + "No classes are currently selected - please choose some!" : (String)text + "Current classes (where available): \n - " + this.selectedClasses.stream().map(c -> c == null ? "Unclassified" : c.toString()).collect(Collectors.joining("\n - "))) : (String)text + "Currently, all available classes will be used";
                tooltipClasses.setText((String)text);
            });
            btnSelectClasses.setTooltip(tooltipClasses);
            comboClasses.setTooltip(tooltipClasses);
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, null, (Node[])new Node[]{labelClasses, comboClasses, btnSelectClasses});
            Label labelTraining = new Label("Training");
            ComboBox comboTraining = new ComboBox();
            comboTraining.getItems().setAll((Object[])TrainingAnnotations.values());
            comboTraining.getSelectionModel().select((Object)TrainingAnnotations.ALL_UNLOCKED);
            this.trainingAnnotations = comboTraining.getSelectionModel().selectedItemProperty();
            this.trainingAnnotations.addListener(v -> this.invalidateClassifier());
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Choose what kind of annotations to use for training", (Node[])new Node[]{labelTraining, comboTraining, comboTraining});
            Button btnLoadTraining = new Button("Load training");
            btnLoadTraining.setTooltip(new Tooltip("Train using annotations from more images in the current project"));
            btnLoadTraining.setOnAction(e -> {
                if (this.promptToLoadTrainingImages()) {
                    this.invalidateClassifier();
                    int n = this.trainingEntries.size();
                    if (n > 0) {
                        btnLoadTraining.setText("Load training (" + n + ")");
                    } else {
                        btnLoadTraining.setText("Load training");
                    }
                }
            });
            Button btnAdvancedOptions = new Button("Advanced options");
            btnAdvancedOptions.setTooltip(new Tooltip("Advanced options to customize preprocessing and classifier behavior"));
            btnAdvancedOptions.setOnAction(e -> {
                if (this.showAdvancedOptions()) {
                    this.invalidateClassifier();
                }
            });
            ToggleButton btnLive = new ToggleButton("Live update");
            btnLive.selectedProperty().bindBidirectional((Property)this.livePrediction);
            btnLive.setTooltip(new Tooltip("Toggle whether to calculate classification 'live' while viewing the image"));
            btnLive.setMaxWidth(Double.MAX_VALUE);
            this.livePrediction.addListener((v, o, n) -> {
                if (n.booleanValue()) {
                    this.invalidateClassifier();
                    return;
                }
            });
            GridPane panePredict = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnLoadTraining, btnAdvancedOptions});
            this.pane.add((Node)panePredict, 0, row++, this.pane.getColumnCount(), 1);
            this.pane.add((Node)btnLive, 0, row++, this.pane.getColumnCount(), 1);
            this.pieChart = new PieChart();
            this.pieChart.getStyleClass().add((Object)"training-chart");
            this.pieChart.setAnimated(false);
            this.pieChart.setLabelsVisible(false);
            this.pieChart.setLegendVisible(true);
            this.pieChart.setPrefSize(40.0, 40.0);
            this.pieChart.setMaxSize(100.0, 100.0);
            this.pieChart.setLegendSide(Side.RIGHT);
            this.pieChart.setMaxWidth(Double.MAX_VALUE);
            GridPane.setVgrow((Node)this.pieChart, (Priority)Priority.ALWAYS);
            this.pane.add((Node)this.pieChart, 0, row++, this.pane.getColumnCount(), 1);
            Label labelCursor = new Label();
            labelCursor.textProperty().bindBidirectional((Property)this.cursorLocation);
            labelCursor.setMaxWidth(Double.MAX_VALUE);
            labelCursor.setAlignment(Pos.CENTER);
            labelCursor.setTooltip(new Tooltip("Prediction for current cursor location"));
            this.pane.add((Node)labelCursor, 0, row++, this.pane.getColumnCount(), 1);
            Button btnSave = new Button("Save");
            Label labelSave = new Label("Classifier name");
            TextField tfSaveName = new TextField("");
            tfSaveName.setMaxWidth(Double.MAX_VALUE);
            tfSaveName.setPromptText("Enter object classifier name");
            ProjectClassifierBindings.bindObjectClassifierNameInput(tfSaveName, (ObjectExpression<Project<BufferedImage>>)this.qupath.projectProperty());
            btnSave.setMaxWidth(Double.MAX_VALUE);
            btnSave.disableProperty().bind((ObservableValue)tfSaveName.textProperty().isEmpty().or((ObservableBooleanValue)this.qupath.projectProperty().isNull()).or((ObservableBooleanValue)this.qupath.imageDataProperty().isNull()));
            btnSave.setOnAction(e -> {
                this.tryToSave(tfSaveName.getText());
                tfSaveName.requestFocus();
                btnSave.requestFocus();
            });
            GridPaneUtils.addGridRow((GridPane)this.pane, (int)row++, (int)0, (String)"Specify name of the classifier - this will be used to save to save the classifier in the current project, so it may be used for scripting later", (Node[])new Node[]{labelSave, tfSaveName, btnSave});
            GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{comboTraining, comboObjects, comboClassifier, comboFeatures, comboClasses, panePredict});
            GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{comboTraining, comboObjects, comboClassifier, comboFeatures, comboClasses, panePredict});
            GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{comboTraining, comboObjects, comboClassifier, comboClasses, panePredict});
            this.pane.setHgap(5.0);
            this.pane.setVgap(6.0);
            this.qupath.getStage().getScene().addEventFilter(MouseEvent.MOUSE_MOVED, e -> this.updateLocationText((MouseEvent)e));
            this.pane.setPadding(new Insets(5.0));
        }

        boolean promptToSelectFeatures() {
            Collection<String> measurements = this.getAllMeasurements(this.getTrainingImageData(), true);
            if (measurements.isEmpty()) {
                Dialogs.showErrorMessage((String)"Select features", (String)"No features available for specified objects!");
                return false;
            }
            SelectionPane<String> featuresPane = new SelectionPane<String>(measurements, true);
            featuresPane.selectItems(this.selectedMeasurements);
            if (Dialogs.builder().title("Select features").buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).content((Node)featuresPane.getPane()).showAndWait().orElse(ButtonType.CANCEL) != ButtonType.APPLY) {
                return false;
            }
            this.selectedMeasurements.clear();
            this.selectedMeasurements.addAll(featuresPane.getSelectedItems());
            return true;
        }

        boolean promptToSelectClasses() {
            Collection<PathObject> annotations = this.getTrainingAnnotations(this.getTrainingImageData());
            if (annotations.isEmpty()) {
                Dialogs.showErrorMessage((String)"Object classifier", (String)"No annotations found for training!");
                return false;
            }
            TreeSet pathClasses = annotations.stream().map(p -> p.getPathClass()).collect(Collectors.toCollection(TreeSet::new));
            SelectionPane<PathClass> classesPane = new SelectionPane<PathClass>(pathClasses, true);
            classesPane.selectItems(this.selectedClasses);
            if (Dialogs.builder().title("Select classes").buttons(new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL}).content((Node)classesPane.getPane()).showAndWait().orElse(ButtonType.CANCEL) != ButtonType.APPLY) {
                return false;
            }
            this.selectedClasses.clear();
            this.selectedClasses.addAll(classesPane.getSelectedItems());
            return true;
        }

        void updateLocationText(MouseEvent e) {
            String text = "";
            for (QuPathViewer viewer : this.qupath.getAllViewers()) {
                Point2D p;
                Pane view;
                PathObjectHierarchy hierarchy = viewer.getHierarchy();
                if (hierarchy == null || !(view = viewer.getView()).contains(p = view.screenToLocal(e.getScreenX(), e.getScreenY()))) continue;
                text = viewer.getObjectClassificationString(p.getX(), p.getY());
            }
            this.cursorLocation.set((Object)text);
        }

        private void registerListeners(QuPathGUI qupath) {
            qupath.imageDataProperty().addListener((ChangeListener)this);
            this.changed((ObservableValue<? extends ImageData<BufferedImage>>)qupath.imageDataProperty(), null, (ImageData<BufferedImage>)qupath.getImageData());
        }

        private void deregisterListeners(QuPathGUI qupath) {
            qupath.imageDataProperty().removeListener((ChangeListener)this);
            this.changed((ObservableValue<? extends ImageData<BufferedImage>>)qupath.imageDataProperty(), (ImageData<BufferedImage>)qupath.getImageData(), null);
        }

        private void cleanup(QuPathGUI qupath) {
            this.deregisterListeners(qupath);
            for (ImageData<BufferedImage> data : this.trainingMap.values()) {
                try {
                    data.getServer().close();
                }
                catch (Exception e) {
                    logger.warn("Error closing server: " + e.getLocalizedMessage(), (Throwable)e);
                }
            }
            this.trainingEntries.clear();
            this.trainingMap.clear();
        }

        public void changed(ObservableValue<? extends ImageData<BufferedImage>> source, ImageData<BufferedImage> imageDataOld, ImageData<BufferedImage> imageDataNew) {
            if (imageDataOld != null) {
                imageDataOld.getHierarchy().removeListener((PathObjectHierarchyListener)this);
            }
            if (imageDataNew != null) {
                imageDataNew.getHierarchy().addListener((PathObjectHierarchyListener)this);
            }
            this.invalidateClassifier();
        }

        public void hierarchyChanged(PathObjectHierarchyEvent event) {
            if (!Platform.isFxApplicationThread()) {
                Platform.runLater(() -> this.hierarchyChanged(event));
                return;
            }
            if (event.isChanging()) {
                return;
            }
            PathObjectFilter filter = (PathObjectFilter)this.objectFilter.get();
            if (event.isObjectClassificationEvent() && event.getChangedObjects().stream().allMatch(filter)) {
                return;
            }
            if (event.isAddedOrRemovedEvent() && event.getChangedObjects().stream().allMatch(p -> !filter.test(p) && !p.isAnnotation() || p.isAnnotation() && p.getPathClass() == null)) {
                return;
            }
            this.invalidateClassifier();
        }

        private static enum TrainingAnnotations {
            ALL,
            ALL_UNLOCKED,
            POINTS,
            AREAS;


            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "All annotations";
                    }
                    case 1: {
                        return "Unlocked annotations";
                    }
                    case 2: {
                        return "Points only";
                    }
                    case 3: {
                        return "Areas only";
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        private static enum OutputClasses {
            ALL,
            SELECTED;


            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "All classes";
                    }
                    case 1: {
                        return "Selected classes";
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        private static enum TrainingFeatures {
            ALL,
            SELECTED,
            FILTERED;


            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "All measurements";
                    }
                    case 1: {
                        return "Selected measurements";
                    }
                    case 2: {
                        return "Filtered by output classes";
                    }
                }
                throw new IllegalArgumentException();
            }
        }

        static class TrainingData<T> {
            private ImageData<T> imageData;
            private Map<PathClass, Set<PathObject>> map;

            private TrainingData(ImageData<T> imageData, Map<PathClass, Set<PathObject>> map) {
                this.imageData = imageData;
                this.map = map;
            }

            public Collection<PathClass> getPathClasses() {
                return this.map.keySet();
            }
        }
    }

    static class SelectionPane<T> {
        private BorderPane pane;
        private TableView<SelectableItem<T>> tableFeatures;
        private FilteredList<SelectableItem<T>> list;
        private Map<T, SelectableItem<T>> itemPool = new HashMap<T, SelectableItem<T>>();

        SelectionPane(Collection<T> items, boolean includeFilter) {
            this.list = FXCollections.observableArrayList(items.stream().map(i -> this.getSelectableItem(i)).toList()).filtered(p -> true);
            this.tableFeatures = new TableView(this.list);
            this.pane = this.makePane(includeFilter);
        }

        public Pane getPane() {
            return this.pane;
        }

        public List<T> getSelectedItems() {
            ArrayList selectedFeatures = new ArrayList();
            for (SelectableItem feature : this.tableFeatures.getItems()) {
                if (!feature.isSelected()) continue;
                selectedFeatures.add(feature.getItem());
            }
            return selectedFeatures;
        }

        private BorderPane makePane(boolean includeFilter) {
            GridPane panelButtons;
            TableColumn columnName = new TableColumn("Name");
            columnName.setCellValueFactory((Callback)new PropertyValueFactory("item"));
            columnName.setEditable(false);
            TableColumn columnSelected = new TableColumn("Selected");
            columnSelected.setCellValueFactory((Callback)new PropertyValueFactory("selected"));
            columnSelected.setCellFactory(column -> new CheckBoxTableCell());
            columnSelected.setEditable(true);
            columnSelected.setResizable(false);
            columnName.prefWidthProperty().bind((ObservableValue)this.tableFeatures.widthProperty().subtract((ObservableNumberValue)columnSelected.widthProperty()));
            this.tableFeatures.getColumns().add((Object)columnName);
            this.tableFeatures.getColumns().add((Object)columnSelected);
            this.tableFeatures.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            this.tableFeatures.setEditable(true);
            ContextMenu menu = new ContextMenu();
            MenuItem itemSelect = new MenuItem("Select");
            itemSelect.setOnAction(e -> {
                for (SelectableItem feature : this.tableFeatures.getSelectionModel().getSelectedItems()) {
                    feature.setSelected(true);
                }
            });
            menu.getItems().add((Object)itemSelect);
            MenuItem itemDeselect = new MenuItem("Deselect");
            itemDeselect.setOnAction(e -> {
                for (SelectableItem feature : this.tableFeatures.getSelectionModel().getSelectedItems()) {
                    feature.setSelected(false);
                }
            });
            menu.getItems().add((Object)itemDeselect);
            this.tableFeatures.setContextMenu(menu);
            Button btnSelectAll = new Button("Select all");
            btnSelectAll.setOnAction(e -> {
                for (SelectableItem feature : this.tableFeatures.getItems()) {
                    feature.setSelected(true);
                }
            });
            Button btnSelectNone = new Button("Select none");
            btnSelectNone.setOnAction(e -> {
                for (SelectableItem feature : this.tableFeatures.getItems()) {
                    feature.setSelected(false);
                }
            });
            GridPane panelSelectButtons = GridPaneUtils.createColumnGridControls((Node[])new Node[]{btnSelectAll, btnSelectNone});
            if (includeFilter) {
                PredicateTextField tfFilter = new PredicateTextField(s -> s.getItem().toString());
                Tooltip tooltip = new Tooltip("Type to filter table entries (case-insensitive)");
                Tooltip.install((Node)tfFilter, (Tooltip)tooltip);
                tfFilter.setPromptText("Type to filter table entries");
                Label labelFilter = new Label("Filter");
                labelFilter.setLabelFor((Node)tfFilter);
                labelFilter.setPrefWidth(-1.0);
                tfFilter.setMaxWidth(Double.MAX_VALUE);
                this.list.predicateProperty().bind((ObservableValue)tfFilter.predicateProperty());
                GridPane paneFilter = new GridPane();
                paneFilter.add((Node)labelFilter, 0, 0);
                paneFilter.add((Node)tfFilter, 1, 0);
                GridPane.setHgrow((Node)tfFilter, (Priority)Priority.ALWAYS);
                GridPane.setFillWidth((Node)tfFilter, (Boolean)Boolean.TRUE);
                paneFilter.setHgap(5.0);
                paneFilter.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
                panelButtons = GridPaneUtils.createRowGrid((Node[])new Node[]{panelSelectButtons, paneFilter});
            } else {
                panelButtons = panelSelectButtons;
            }
            BorderPane panelFeatures = new BorderPane();
            panelFeatures.setCenter(this.tableFeatures);
            panelFeatures.setBottom((Node)panelButtons);
            return panelFeatures;
        }

        void selectItems(Collection<T> toSelect) {
            for (T item : toSelect) {
                SelectableItem<T> temp = this.itemPool.get(item);
                if (temp == null) continue;
                temp.setSelected(true);
            }
        }

        private SelectableItem<T> getSelectableItem(T item) {
            SelectableItem<T> feature = this.itemPool.get(item);
            if (feature == null) {
                feature = new SelectableItem<T>(item);
                this.itemPool.put(item, feature);
            }
            return feature;
        }

        public static class SelectableItem<T> {
            private ObjectProperty<T> item = new SimpleObjectProperty();
            private BooleanProperty selected = new SimpleBooleanProperty(false);

            public SelectableItem(T item) {
                this.item.set(item);
            }

            public ReadOnlyObjectProperty<T> itemProperty() {
                return this.item;
            }

            public BooleanProperty selectedProperty() {
                return this.selected;
            }

            public boolean isSelected() {
                return this.selected.get();
            }

            public void setSelected(boolean selected) {
                this.selected.set(selected);
            }

            public T getItem() {
                return (T)this.item.get();
            }
        }
    }
}

