/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import ij.IJ;
import ij.ImagePlus;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.FXUtils;
import qupath.imagej.tools.IJTools;
import qupath.lib.common.ColorTools;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ServerTools;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.projects.Projects;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.regions.RegionRequest;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class ExportTrainingRegionsCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(ExportTrainingRegionsCommand.class);
    private final QuPathGUI qupath;
    private Stage stage;
    private TrainingRegionExporter exporter;

    public ExportTrainingRegionsCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        this.stage = new Stage();
        this.stage.initOwner((Window)this.qupath.getStage());
        this.stage.setTitle("Export training");
        this.exporter = new TrainingRegionExporter(this.qupath);
        this.stage.setScene(new Scene((Parent)this.exporter.getPane()));
        FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        this.stage.show();
    }

    static class TrainingRegionExporter {
        private QuPathGUI qupath;
        private GridPane pane;
        private File dirExport = null;
        private ExecutorService executorService;
        private StringProperty description;
        private StringProperty exportResolutionString;
        private StringProperty classificationLabels;
        private BooleanProperty exportBoundaries;
        private BooleanProperty useMicronsPerPixel;
        private BooleanProperty exportParallel;
        private BooleanProperty useTrainTestMetadataValue;
        private DoubleProperty progressProperty;
        private boolean requestCancel = false;

        TrainingRegionExporter(QuPathGUI qupath) {
            this.qupath = qupath;
            this.init();
        }

        void cancelTasks() {
            this.requestCancel = true;
        }

        private void init() {
            int row = 0;
            this.pane = new GridPane();
            this.pane.setPadding(new Insets(10.0));
            this.pane.setVgap(5.0);
            this.pane.setHgap(5.0);
            this.executorService = this.qupath.getThreadPoolManager().getSingleThreadExecutor((Object)this);
            TextField tfResolution = new TextField("1");
            this.exportResolutionString = tfResolution.textProperty();
            Label labelResolution = new Label("Export resolution");
            labelResolution.setLabelFor((Node)tfResolution);
            tfResolution.setTooltip(new Tooltip("Define export resolution, in " + GeneralTools.micrometerSymbol() + " per pixel or in terms of downsampling"));
            RadioButton rbMicrons = new RadioButton(GeneralTools.micrometerSymbol() + " per px");
            RadioButton rbDownsample = new RadioButton("Downsample");
            ToggleGroup group = new ToggleGroup();
            group.getToggles().setAll((Object[])new Toggle[]{rbMicrons, rbDownsample});
            group.selectToggle((Toggle)rbMicrons);
            this.useMicronsPerPixel = rbMicrons.selectedProperty();
            rbMicrons.setTooltip(new Tooltip("Interpret the resolution as " + GeneralTools.micrometerSymbol() + " per pixel"));
            rbDownsample.setTooltip(new Tooltip("Interpret the resolution as a downsample factor (should be >= 1)"));
            this.pane.add((Node)labelResolution, 0, row);
            this.pane.add((Node)tfResolution, 1, row);
            this.pane.add((Node)rbMicrons, 0, ++row);
            this.pane.add((Node)rbDownsample, 1, row);
            ++row;
            TextArea textLabels = new TextArea();
            textLabels.setPrefRowCount(8);
            this.classificationLabels = textLabels.textProperty();
            this.updateClassificationLabels((Collection<PathClass>)this.qupath.getAvailablePathClasses());
            textLabels.setTooltip(new Tooltip("Classification labels in the exported labelled image -\nthis can be edited to assign multiple classifications to the same label"));
            Button btnResetClassifications = new Button("Reset all");
            btnResetClassifications.setOnAction(e -> this.updateClassificationLabels((Collection<PathClass>)this.qupath.getAvailablePathClasses()));
            btnResetClassifications.setMaxWidth(Double.MAX_VALUE);
            Button btnUpdateClassifications = new Button("From project");
            btnUpdateClassifications.setOnAction(e -> this.updateClassificationLabelsFromProject());
            btnUpdateClassifications.setMaxWidth(Double.MAX_VALUE);
            btnResetClassifications.setTooltip(new Tooltip("Reset the classification labels to the defaults shown under the 'Annotations' tab"));
            btnUpdateClassifications.setTooltip(new Tooltip("Update classification labels based on the classifications actually found within all images of the project"));
            this.pane.add((Node)textLabels, 0, row, 2, 1);
            GridPane.setHgrow((Node)btnResetClassifications, (Priority)Priority.ALWAYS);
            GridPane.setHgrow((Node)btnUpdateClassifications, (Priority)Priority.ALWAYS);
            this.pane.add((Node)btnResetClassifications, 0, ++row);
            this.pane.add((Node)btnUpdateClassifications, 1, row);
            ++row;
            Label labelDescription = new Label("Description (optional)");
            TextArea textDescription = new TextArea();
            textDescription.setPrefRowCount(4);
            this.description = textDescription.textProperty();
            labelDescription.setLabelFor((Node)textDescription);
            textDescription.setTooltip(new Tooltip("Optionally add a free-text description along with the exported JSON file"));
            this.pane.add((Node)labelDescription, 0, row, 2, 1);
            this.pane.add((Node)textDescription, 0, ++row, 2, 1);
            CheckBox cbSplitByMetadata = new CheckBox("Split by train/validation/test metadata");
            this.useTrainTestMetadataValue = cbSplitByMetadata.selectedProperty();
            cbSplitByMetadata.setTooltip(new Tooltip("Put exported images into separate sub-directories according to the metadata value Train/Validation/Test type"));
            this.pane.add((Node)cbSplitByMetadata, 0, ++row, 2, 1);
            CheckBox cbParallelExport = new CheckBox("Parallel export");
            this.exportParallel = cbParallelExport.selectedProperty();
            cbParallelExport.setTooltip(new Tooltip("Export regions for multiple images in parallel (a bad idea if the data files are huge!)"));
            this.pane.add((Node)cbParallelExport, 0, ++row, 2, 1);
            Button btnExport = new Button("Export");
            btnExport.setMaxWidth(Double.MAX_VALUE);
            btnExport.setTooltip(new Tooltip("Select export directory & export training images"));
            this.pane.add((Node)btnExport, 0, ++row, 2, 1);
            ProgressBar progressBar = new ProgressBar(0.0);
            this.progressProperty = progressBar.progressProperty();
            progressBar.setTooltip(new Tooltip("Current export progress bar"));
            this.pane.add((Node)progressBar, 0, ++row, 2, 1);
            progressBar.setMaxWidth(Double.MAX_VALUE);
            ++row;
            BooleanBinding isRunning = this.progressProperty.isNotEqualTo(0).and((ObservableBooleanValue)this.progressProperty.isNotEqualTo(1));
            btnExport.setOnAction(e -> {
                if (isRunning.get()) {
                    this.requestCancel = true;
                } else {
                    this.doExport();
                }
            });
            btnExport.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                if (isRunning.get()) {
                    return "Cancel";
                }
                return "Export";
            }, (Observable[])new Observable[]{isRunning}));
            btnExport.disableProperty().bind((ObservableValue)this.qupath.projectProperty().isNull());
        }

        void updateClassificationLabelsFromProject() {
            Project project = this.qupath.getProject();
            if (project == null) {
                this.updateClassificationLabels(Collections.emptyList());
            }
            TreeSet<PathClass> set = new TreeSet<PathClass>();
            for (ProjectImageEntry entry : project.getImageList()) {
                if (!entry.hasImageData()) continue;
                try {
                    PathObjectHierarchy hierarchy = entry.readHierarchy();
                    int nullCount = 0;
                    for (PathObject annotation : hierarchy.getAnnotationObjects()) {
                        if (annotation.getPathClass() == null) {
                            ++nullCount;
                            continue;
                        }
                        set.add(annotation.getPathClass());
                    }
                    if (nullCount <= 0) continue;
                    logger.warn("{} contains {} annotations without classification - these will be skipped!", (Object)entry.getImageName(), (Object)nullCount);
                }
                catch (IOException e) {
                    logger.error("Error reading hierarchy", (Throwable)e);
                }
            }
            this.updateClassificationLabels(set);
        }

        void updateClassificationLabels(Collection<PathClass> pathClasses) {
            Object s = "";
            int i = 1;
            PathClass regionClass = PathClass.StandardPathClasses.REGION;
            for (PathClass pathClass : pathClasses) {
                String name;
                if (pathClass == regionClass) continue;
                String string = name = pathClass == null ? null : pathClass.getName();
                if (name == null) continue;
                s = (String)s + name + ": " + i + "\n";
                ++i;
            }
            this.classificationLabels.set(s);
        }

        void doExport() {
            Number number;
            Project project = this.qupath.getProject();
            if (project == null) {
                return;
            }
            File dir = this.promptForDirectory();
            if (dir == null) {
                return;
            }
            LinkedHashMap<String, Integer> mapLabels = new LinkedHashMap<String, Integer>();
            for (String line : ((String)this.classificationLabels.get()).split("\n")) {
                int n = line.lastIndexOf(":");
                String name = n < 0 ? "NOT ANNOTATED" : line.substring(0, n);
                String labelText = line.substring(n + 1).trim();
                try {
                    Integer label = Integer.parseInt(labelText);
                    if (label > 255) {
                        throw new IllegalArgumentException("Label value " + label + " - should be <= 255");
                    }
                    mapLabels.put(name, label);
                }
                catch (Exception e) {
                    Dialogs.showErrorMessage((String)"Export error", (String)("Invalid label '" + labelText + "' for " + name + " - all labels must be integers <= 255!"));
                    return;
                }
            }
            int[] cmap = new int[256];
            LinkedHashMap<String, Color> mapLabelColor = new LinkedHashMap<String, Color>();
            ArrayList<PathClassDisplay> display = new ArrayList<PathClassDisplay>();
            for (Map.Entry entry2 : mapLabels.entrySet()) {
                int val = (Integer)entry2.getValue();
                mapLabelColor.put((String)entry2.getKey(), new Color(val, val, val));
                PathClass pathClass = PathClass.fromString((String)((String)entry2.getKey()));
                cmap[val] = pathClass.getColor();
                display.add(new PathClassDisplay((String)entry2.getKey(), val, pathClass.getColor()));
            }
            IndexColorModel colorModel = new IndexColorModel(8, 256, cmap, 0, false, -1, 0);
            Object var8_12 = null;
            try {
                number = NumberFormat.getInstance().parse((String)this.exportResolutionString.get());
            }
            catch (Exception e) {
                Dialogs.showErrorMessage((String)"Export training", (String)("Cannot part resolution from " + (String)this.exportResolutionString.get() + " - must be a number!"));
                return;
            }
            boolean useMPP = this.useMicronsPerPixel.get();
            List<ProjectImageEntry> entries = project.getImageList().stream().filter(entry -> entry.hasImageData()).toList();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (useMPP) {
                map.put("requestedPixelSizeMicrons", number.doubleValue());
            } else {
                map.put("downsample", number.doubleValue());
            }
            if (!((String)this.description.get()).trim().isEmpty()) {
                map.put("description", this.description.get());
            }
            map.put("classifications", display);
            File fileJSON = new File(dir, "training.json");
            try (PrintWriter writer = new PrintWriter(fileJSON);){
                writer.print(gson.toJson(map));
            }
            catch (FileNotFoundException e) {
                logger.error("Unable to write JSON file " + String.valueOf(fileJSON), (Throwable)e);
            }
            double resolutionValue = number.doubleValue();
            int target = entries.size();
            AtomicInteger nCompleted = new AtomicInteger(0);
            this.requestCancel = false;
            boolean splitByMetadata = this.useTrainTestMetadataValue.get();
            this.executorService.submit(() -> {
                Stream stream = entries.stream();
                if (this.exportParallel.get()) {
                    stream = (Stream)stream.parallel();
                }
                stream.forEach(entry -> {
                    try {
                        if (!this.requestCancel) {
                            File dirOutput = dir;
                            if (splitByMetadata) {
                                String value = entry.getMetadataValue("Train/Validation/Test type");
                                if (value == null) {
                                    value = "None";
                                }
                                if (!(dirOutput = new File(dir, value)).exists()) {
                                    dirOutput.mkdir();
                                }
                            }
                            this.exportLabelledImages((Project<BufferedImage>)project, (ProjectImageEntry<BufferedImage>)entry, dirOutput, useMPP, resolutionValue, mapLabelColor, colorModel);
                        }
                    }
                    catch (Exception e) {
                        logger.error("Error exporting image labels", (Throwable)e);
                    }
                    finally {
                        Platform.runLater(() -> this.progressProperty.set((double)nCompleted.incrementAndGet() / (double)target));
                    }
                });
            });
        }

        void exportLabelledImages(Project<BufferedImage> project, ProjectImageEntry<BufferedImage> entry, File dirOutput, boolean useMPP, double resolution, Map<String, Color> mapLabelColor, IndexColorModel colorModel) {
            ImageData imageData;
            if (!entry.hasImageData()) {
                return;
            }
            try {
                imageData = entry.readImageData();
            }
            catch (IOException e) {
                logger.error("Unable to read ImageData for " + entry.getImageName(), (Throwable)e);
                return;
            }
            ImageServer server = imageData.getServer();
            PathObjectHierarchy hierarchy = imageData.getHierarchy();
            double downsample = useMPP ? resolution / server.getPixelCalibration().getAveragedPixelSizeMicrons() : resolution;
            PathClass regionClass = PathClass.StandardPathClasses.REGION;
            List<PathObject> regionAnnotations = hierarchy.getAnnotationObjects().stream().filter(p -> p.getPathClass() == regionClass).toList();
            List<PathObject> otherAnnotations = hierarchy.getAnnotationObjects().stream().filter(p -> p.getPathClass() != regionClass && p.getROI().isArea()).toList();
            otherAnnotations.sort((a, b) -> -Double.compare(a.getROI().getArea(), b.getROI().getArea()));
            if (regionAnnotations.isEmpty()) {
                regionAnnotations.add(PathObjects.createAnnotationObject((ROI)ROIs.createRectangleROI((double)0.0, (double)0.0, (double)server.getWidth(), (double)server.getHeight(), (ImagePlane)ImagePlane.getDefaultPlane())));
            }
            for (PathObject annotation : regionAnnotations) {
                BufferedImage img;
                RegionRequest request = RegionRequest.createInstance((String)server.getPath(), (double)downsample, (ROI)annotation.getROI());
                try {
                    img = (BufferedImage)server.readRegion(request);
                }
                catch (IOException e1) {
                    logger.error("Error exporting " + String.valueOf(request), (Throwable)e1);
                    continue;
                }
                int w = img.getWidth();
                int h = img.getHeight();
                BufferedImage imgTemp = new BufferedImage(w, h, 10);
                Graphics2D g2d = imgTemp.createGraphics();
                Color colorBackground = mapLabelColor.getOrDefault("NOT ANNOTATED", null);
                if (colorBackground != null) {
                    g2d.setColor(colorBackground);
                    g2d.fillRect(0, 0, w, h);
                }
                g2d.scale(1.0 / downsample, 1.0 / downsample);
                g2d.translate(-request.getX(), -request.getY());
                int c = 0;
                for (PathObject other : otherAnnotations) {
                    Color color;
                    ROI roi = other.getROI();
                    if (!request.intersects(ImageRegion.createInstance((ROI)roi))) continue;
                    Color color2 = color = other.getPathClass() == null ? null : (Color)mapLabelColor.getOrDefault(other.getPathClass().getName(), null);
                    if (color == null) {
                        logger.warn("{}: No color for classification {}", (Object)entry.getImageName(), (Object)other.getPathClass());
                        continue;
                    }
                    g2d.setColor(color);
                    Shape shape = RoiTools.getShape((ROI)roi);
                    g2d.fill(shape);
                    ++c;
                }
                g2d.dispose();
                String name = String.format("%s-(%.2f,%d,%d,%d,%d)", ServerTools.getDisplayableImageName((ImageServer)server), request.getDownsample(), request.getX(), request.getY(), request.getWidth(), request.getHeight());
                BufferedImage imgTempIndexed = new BufferedImage(w, h, 13, colorModel);
                imgTempIndexed.getRaster().setRect(imgTemp.getRaster());
                try {
                    ImagePlus imp = (ImagePlus)IJTools.convertToImagePlus((String)"Image", (ImageServer)server, (BufferedImage)img, (RegionRequest)request).getImage();
                    IJ.saveAsTiff((ImagePlus)imp, (String)new File(dirOutput, name + ".tif").getAbsolutePath());
                    ImageIO.write((RenderedImage)imgTempIndexed, "PNG", new File(dirOutput, name + "-mask.png"));
                }
                catch (Exception e) {
                    logger.error("Error exporting for " + entry.getImageName(), (Throwable)e);
                }
                if (c != 0) continue;
                logger.warn("No classified annotations inside {}", (Object)(name + ".png"));
            }
        }

        File promptForDirectory() {
            Project project = this.qupath.getProject();
            if (this.dirExport == null && project != null) {
                this.dirExport = Projects.getBaseDirectory((Project)project);
            }
            Window window = this.pane.getScene().getWindow();
            File dirSelected = ((DirectoryChooser)FileChoosers.buildDirectoryChooser().title("Export training regions").initialDirectory(this.dirExport).build()).showDialog(window);
            if (dirSelected == null) {
                return null;
            }
            this.dirExport = dirSelected;
            return this.dirExport;
        }

        public Pane getPane() {
            return this.pane;
        }

        static class PathClassDisplay {
            public final String name;
            public final int label;
            public final RGB display;

            PathClassDisplay(String name, int label, int rgb) {
                this.name = name;
                this.label = label;
                this.display = new RGB(rgb);
            }

            static class RGB {
                public final int red;
                public final int green;
                public final int blue;

                RGB(int val) {
                    this.red = ColorTools.red((int)val);
                    this.green = ColorTools.green((int)val);
                    this.blue = ColorTools.blue((int)val);
                }
            }
        }
    }
}

