/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.images.ImageData;
import qupath.process.gui.commands.density.DensityMapDialog;

public class DensityMapCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DensityMapCommand.class);
    private QuPathGUI qupath;
    private DensityMapDialog dialog;

    public DensityMapCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        if (this.dialog == null) {
            logger.trace("Creating density map dialog");
            this.dialog = new DensityMapDialog(this.qupath);
            if (this.qupath.getImageData() != null) {
                this.dialog.updateDefaults((ImageData<BufferedImage>)this.qupath.getImageData());
            }
        }
        Stage stage = this.dialog.getStage();
        stage.setOnCloseRequest(e -> this.closeDialog());
        stage.show();
    }

    void closeDialog() {
        if (this.dialog != null) {
            this.dialog.deregister();
            this.dialog = null;
        }
    }
}

