/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import org.controlsfx.dialog.ProgressDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.lib.gui.commands.ProjectCommands;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.servers.ImageServer;
import qupath.lib.images.servers.ImageServerMetadata;
import qupath.lib.images.servers.SparseImageServer;
import qupath.lib.images.servers.TransformedServerBuilder;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.objects.hierarchy.PathObjectHierarchy;
import qupath.lib.plugins.parameters.ParameterList;
import qupath.lib.projects.Project;
import qupath.lib.projects.ProjectImageEntry;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.RectangleROI;
import qupath.lib.roi.interfaces.ROI;

public class CreateTrainingImageCommand {
    private static Logger logger = LoggerFactory.getLogger(CreateTrainingImageCommand.class);
    private static String NAME = "Create training image";
    private static PathClass pathClass = PathClass.StandardPathClasses.REGION;
    private static int maxWidth = 50000;
    private static boolean doZ = false;
    private static boolean rectanglesOnly = false;

    public static ProjectImageEntry<BufferedImage> promptToCreateTrainingImage(final Project<BufferedImage> project, List<PathClass> availableClasses) {
        ParameterList params;
        if (project == null) {
            Dialogs.showErrorMessage((String)NAME, (String)"You need a project!");
            return null;
        }
        if (availableClasses.isEmpty()) {
            Dialogs.showErrorMessage((String)NAME, (String)"Please ensure classifications are available in QuPath!");
            return null;
        }
        ArrayList<PathClass> pathClasses = new ArrayList<PathClass>(availableClasses);
        if (!pathClasses.contains(pathClass)) {
            pathClass = (PathClass)pathClasses.get(0);
        }
        if (!GuiTools.showParameterDialog((String)NAME, (ParameterList)(params = new ParameterList().addEmptyParameter("Generates a single image from regions extracted from the project.").addEmptyParameter("Before running this command, add classified rectangle annotations to select the regions.").addChoiceParameter("pathClass", "Classification", (Object)pathClass, pathClasses, "Select classification for annotated regions").addIntParameter("maxWidth", "Preferred image width", maxWidth, "px", "Preferred maximum width of the training image, in pixels").addBooleanParameter("doZ", "Do z-stacks", doZ, "Take all slices of a z-stack, where possible").addBooleanParameter("rectanglesOnly", "Rectangles only", rectanglesOnly, "Only extract regions annotated with rectangles. Otherwise, the bounding box of all regions with the classification will be taken.").addEmptyParameter("Note this command requires images to have similar bit-depths/channels/pixel sizes for compatibility.")))) {
            return null;
        }
        pathClass = (PathClass)params.getChoiceParameterValue("pathClass");
        maxWidth = params.getIntParameterValue("maxWidth");
        doZ = params.getBooleanParameterValue("doZ");
        rectanglesOnly = params.getBooleanParameterValue("rectanglesOnly");
        Task<SparseImageServer> task = new Task<SparseImageServer>(){

            protected SparseImageServer call() throws Exception {
                return CreateTrainingImageCommand.createSparseServer((Project<BufferedImage>)project, pathClass, maxWidth, doZ, rectanglesOnly);
            }
        };
        ProgressDialog dialog = new ProgressDialog((Worker)task);
        dialog.setTitle(NAME);
        dialog.setHeaderText("Creating training image...");
        Executors.newSingleThreadExecutor().submit((Runnable)task);
        dialog.showAndWait();
        try {
            SparseImageServer server = (SparseImageServer)task.get();
            if (server == null || server.getManager().getRegions().isEmpty()) {
                Dialogs.showErrorMessage((String)"Sparse image server", (String)"No suitable annotations found in the current project!");
                return null;
            }
            ProjectImageEntry entry = ProjectCommands.addSingleImageToProject(project, (ImageServer)server, null);
            server.close();
            project.syncChanges();
            return entry;
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)"Sparse image server", (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    static Predicate<PathObject> createPredicate(PathClass pathClass, boolean rectanglesOnly) {
        PathClass pathClass2;
        PathClass pathClass3 = pathClass2 = pathClass == PathClass.NULL_CLASS ? null : pathClass;
        if (rectanglesOnly) {
            return p -> p.isAnnotation() && p.getPathClass() == pathClass2 && p.getROI() instanceof RectangleROI;
        }
        return p -> p.isAnnotation() && p.getPathClass() == pathClass2;
    }

    static SparseImageServer createSparseServer(Project<BufferedImage> project, PathClass pathClass, int maxX, boolean doZ, boolean rectanglesOnly) throws IOException {
        return CreateTrainingImageCommand.createSparseServer(project.getImageList(), CreateTrainingImageCommand.createPredicate(pathClass, rectanglesOnly), maxX, doZ);
    }

    static SparseImageServer createSparseServer(Collection<ProjectImageEntry<BufferedImage>> entries, Predicate<PathObject> predicate, int maxWidth, boolean doZ) throws IOException {
        SparseImageServer.Builder builder = new SparseImageServer.Builder();
        boolean doT = false;
        int pad = 0;
        int x = 0;
        int y = 0;
        int rowHeight = 0;
        ImageServerMetadata firstMetadata = null;
        int n = 0;
        block2: for (ProjectImageEntry<BufferedImage> entry : entries) {
            Collection annotations;
            PathObjectHierarchy hierarchy;
            if (!entry.hasImageData() || (hierarchy = entry.readHierarchy()) == null || (annotations = hierarchy.getAnnotationObjects()).isEmpty()) continue;
            try {
                ImageServer server = null;
                for (PathObject annotation : annotations) {
                    int[] tArray;
                    int[] nArray;
                    int[] nArray2;
                    boolean cropT;
                    if (!predicate.test(annotation)) continue;
                    ROI roi = annotation.getROI();
                    ImageRegion region = ImageRegion.createInstance((ROI)roi);
                    if (server == null) {
                        server = entry.getServerBuilder().build();
                        if (firstMetadata == null) {
                            firstMetadata = server.getMetadata();
                        } else {
                            if (firstMetadata.getPixelType() != server.getPixelType()) {
                                logger.warn("Incompatible pixel types {} and {} - will skip regions from {}", new Object[]{server.getPixelType(), firstMetadata.getPixelType(), entry.getImageName()});
                                continue block2;
                            }
                            if (firstMetadata.getSizeC() != server.nChannels()) {
                                logger.warn("Incompatible channel counts {} and {} - will skip regions from {}", new Object[]{server.nChannels(), firstMetadata.getSizeC(), entry.getImageName()});
                                continue block2;
                            }
                        }
                    }
                    TransformedServerBuilder croppedServerBuilder = new TransformedServerBuilder(server).crop(region);
                    boolean cropZ = !doZ && server.nZSlices() > 1;
                    boolean bl = cropT = !doT && server.nTimepoints() > 1;
                    if (cropZ && cropT) {
                        croppedServerBuilder.slice(region.getZ(), region.getZ() + 1, region.getT(), region.getT() + 1);
                    } else if (cropZ) {
                        croppedServerBuilder.slice(region.getZ(), region.getZ() + 1, 0, server.nTimepoints());
                    } else if (cropT) {
                        croppedServerBuilder.slice(0, server.nZSlices(), region.getT(), region.getT() + 1);
                    } else {
                        logger.warn("Crop nothing!");
                    }
                    ImageServer croppedServer = croppedServerBuilder.build();
                    if (doZ) {
                        nArray2 = IntStream.range(0, croppedServer.nZSlices()).toArray();
                    } else {
                        int[] nArray3 = new int[1];
                        nArray2 = nArray3;
                        nArray3[0] = 0;
                    }
                    int[] zArray = nArray2;
                    if (doT) {
                        nArray = IntStream.range(0, croppedServer.nTimepoints()).toArray();
                    } else {
                        int[] nArray4 = new int[1];
                        nArray = nArray4;
                        nArray4[0] = 0;
                    }
                    for (int t : tArray = nArray) {
                        for (int z : zArray) {
                            rowHeight = Math.max(region.getHeight(), rowHeight);
                            ImageRegion regionOutput = ImageRegion.createInstance((int)x, (int)y, (int)region.getWidth(), (int)region.getHeight(), (int)z, (int)t);
                            for (double downsample : croppedServer.getPreferredDownsamples()) {
                                builder.serverRegion(regionOutput, downsample, croppedServer);
                                ++n;
                            }
                        }
                    }
                    if ((x += region.getWidth() + pad) < maxWidth) continue;
                    y += rowHeight + pad;
                    rowHeight = 0;
                    x = 0;
                }
            }
            catch (Exception e) {
                logger.warn("Exception trying to read {}: {}", (Object)entry.getImageName(), (Object)e.getLocalizedMessage());
            }
        }
        if (n == 0) {
            return null;
        }
        return builder.build();
    }
}

