/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.utils.FXUtils;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.gui.viewer.QuPathViewer;
import qupath.lib.images.ImageData;
import qupath.lib.images.servers.PixelCalibration;
import qupath.lib.objects.PathObject;
import qupath.lib.objects.PathObjects;
import qupath.lib.objects.classes.PathClass;
import qupath.lib.regions.ImagePlane;
import qupath.lib.regions.ImageRegion;
import qupath.lib.roi.ROIs;
import qupath.lib.roi.RoiTools;
import qupath.lib.roi.interfaces.ROI;

public class CreateRegionAnnotationsCommand
implements Runnable {
    private final QuPathGUI qupath;
    private Stage stage;

    public CreateRegionAnnotationsCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        if (this.stage == null) {
            this.stage = new Stage();
            this.stage.initOwner((Window)this.qupath.getStage());
            this.stage.setTitle("Create regions");
            this.stage.setScene(new Scene((Parent)RegionMaker.create(this.qupath).getPane()));
            FXUtils.addCloseWindowShortcuts((Stage)this.stage);
        }
        this.stage.show();
    }

    static class RegionMaker {
        private static final Logger logger = LoggerFactory.getLogger(RegionMaker.class);
        private QuPathGUI qupath;
        private QuPathViewer viewerDefault;
        private GridPane pane = new GridPane();
        private TextField tfRegionWidth = new TextField("500");
        private TextField tfRegionHeight = new TextField("500");
        private ComboBox<RegionUnits> comboUnits = new ComboBox(FXCollections.observableArrayList((Object[])RegionUnits.values()));
        private ComboBox<PathClass> comboClassification = new ComboBox();
        private ComboBox<RegionLocation> comboLocation = new ComboBox(FXCollections.observableArrayList((Object[])RegionLocation.values()));

        private RegionMaker(QuPathGUI qupath) {
            this.qupath = qupath;
            this.init();
        }

        private void init() {
            int row = 0;
            this.addLabelled("Width", (Node)this.tfRegionWidth, 0, row++, "Define region width");
            this.addLabelled("Height", (Node)this.tfRegionHeight, 0, row++, "Define region height");
            this.addLabelled("Size units", (Node)this.comboUnits, 0, row++, "Choose the units used to define the region width & height");
            this.addLabelled("Classification", (Node)this.comboClassification, 0, row++, "Choose the default classification to be applied to the region");
            if (this.qupath.getImageData() == null || !this.qupath.getImageData().getServer().getPixelCalibration().hasPixelSizeMicrons()) {
                this.comboUnits.getSelectionModel().select((Object)RegionUnits.PIXELS);
            } else {
                this.comboUnits.getSelectionModel().select((Object)RegionUnits.MICRONS);
            }
            this.comboClassification.setItems(this.qupath.getAvailablePathClasses());
            if (this.comboClassification.getItems().contains((Object)PathClass.StandardPathClasses.REGION)) {
                this.comboClassification.getSelectionModel().select((Object)PathClass.StandardPathClasses.REGION);
            } else {
                this.comboClassification.getSelectionModel().select((Object)PathClass.NULL_CLASS);
            }
            this.comboLocation.getItems().setAll((Object[])RegionLocation.values());
            this.comboLocation.getSelectionModel().select((Object)RegionLocation.VIEW_CENTER);
            this.addLabelled("Location", (Node)this.comboLocation, 0, row++, "Choose the default location for the region");
            Button btnCreateAnnotation = new Button("Create region");
            btnCreateAnnotation.setOnAction(e -> this.createAndAddRegion());
            this.pane.add((Node)btnCreateAnnotation, 0, row++, 2, 1);
            this.pane.setVgap(5.0);
            this.pane.setHgap(5.0);
            this.pane.setPadding(new Insets(10.0));
            btnCreateAnnotation.setMaxWidth(Double.MAX_VALUE);
            this.comboClassification.setMaxWidth(Double.MAX_VALUE);
            this.comboLocation.setMaxWidth(Double.MAX_VALUE);
            this.comboUnits.setMaxWidth(Double.MAX_VALUE);
        }

        public Pane getPane() {
            return this.pane;
        }

        private void createAndAddRegion() {
            QuPathViewer viewer;
            QuPathViewer quPathViewer = viewer = this.viewerDefault == null ? this.qupath.getViewer() : this.viewerDefault;
            if (viewer == null) {
                Dialogs.showErrorMessage((String)"Create region", (String)"Cannot create region - no viewer specified!");
                return;
            }
            ImageData imageData = viewer.getImageData();
            if (imageData == null) {
                GuiTools.showNoImageError((String)"Create region");
                return;
            }
            double width = Double.parseDouble(this.tfRegionWidth.getText());
            double height = this.tfRegionHeight.getText().isEmpty() ? width : Double.parseDouble(this.tfRegionHeight.getText());
            RegionUnits requestedUnits = (RegionUnits)((Object)this.comboUnits.getSelectionModel().getSelectedItem());
            PathClass pathClass = (PathClass)this.comboClassification.getSelectionModel().getSelectedItem();
            if (pathClass == PathClass.NULL_CLASS) {
                pathClass = null;
            }
            RegionLocation location = (RegionLocation)((Object)this.comboLocation.getSelectionModel().getSelectedItem());
            if (requestedUnits == RegionUnits.MICRONS) {
                double pixelHeightMicrons;
                PixelCalibration cal = imageData.getServer().getPixelCalibration();
                double pixelWidthMicrons = cal.getPixelWidthMicrons();
                if (!Double.isFinite(pixelWidthMicrons + (pixelHeightMicrons = cal.getPixelHeightMicrons()))) {
                    Dialogs.showErrorMessage((String)"Create region", (String)"Pixel size not available! Please switch to creating the region in pixels instead.");
                    return;
                }
                width /= pixelWidthMicrons;
                height /= pixelHeightMicrons;
            }
            if (width > (double)viewer.getServerWidth() || height > (double)viewer.getServerHeight()) {
                Dialogs.showErrorMessage((String)"Create region", (String)String.format("Requested size %.1f x %.1f must be smaller than image size %d x %d!", width, height, viewer.getServerWidth(), viewer.getServerHeight()));
                return;
            }
            PathObject parentObject = null;
            ROI rectangle = null;
            switch (location.ordinal()) {
                case 1: {
                    double x = ((double)imageData.getServer().getWidth() - width) / 2.0;
                    double y = ((double)imageData.getServer().getHeight() - height) / 2.0;
                    rectangle = ROIs.createRectangleROI((double)x, (double)y, (double)width, (double)height, (ImagePlane)viewer.getImagePlane());
                    break;
                }
                case 2: {
                    ROI roi;
                    parentObject = imageData.getHierarchy().getSelectionModel().getSelectedObject();
                    ROI rOI = roi = parentObject == null ? null : parentObject.getROI();
                    if (roi != null) {
                        if (!parentObject.isAnnotation() && !parentObject.isTMACore()) {
                            logger.warn("Ignoring parent object because it's not an annotation or a TMA core");
                            parentObject = null;
                            roi = null;
                        }
                        if (!roi.isArea() || roi.isEmpty()) {
                            logger.warn("Ignoring parent object because its ROI does not define an area");
                            parentObject = null;
                            roi = null;
                        }
                    }
                    try {
                        if (roi != null) {
                            rectangle = RoiTools.createRandomRectangle((ROI)roi, (double)width, (double)height);
                        } else {
                            ImageRegion region = ImageRegion.createInstance((int)0, (int)0, (int)viewer.getServerWidth(), (int)viewer.getServerHeight(), (int)viewer.getZPosition(), (int)viewer.getTPosition());
                            rectangle = RoiTools.createRandomRectangle((ImageRegion)region, (double)width, (double)height);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        Dialogs.showErrorMessage((String)"Create region", (String)e.getLocalizedMessage());
                        return;
                    }
                    if (rectangle != null) break;
                    Dialogs.showErrorMessage((String)"Create region", (String)"Unable to squeeze a rectangle of the specified size into the current ROI, sorry");
                    return;
                }
                case 0: {
                    rectangle = ROIs.createRectangleROI((double)(viewer.getCenterPixelX() - width / 2.0), (double)(viewer.getCenterPixelY() - height / 2.0), (double)width, (double)height, (ImagePlane)viewer.getImagePlane());
                    break;
                }
            }
            if (rectangle == null) {
                Dialogs.showErrorMessage((String)"Create region", (String)"Unable to create a rectangle region, sorry");
                return;
            }
            if (rectangle.getBoundsX() < 0.0 || rectangle.getBoundsY() < 0.0 || rectangle.getBoundsX() + rectangle.getBoundsWidth() > (double)imageData.getServer().getWidth() || rectangle.getBoundsY() + rectangle.getBoundsHeight() > (double)imageData.getServer().getHeight()) {
                Dialogs.showErrorMessage((String)"Create region", (String)"Cannot create requested region - it would extend beyond the image bounds");
                return;
            }
            PathObject annotation = PathObjects.createAnnotationObject((ROI)rectangle, (PathClass)pathClass);
            if (parentObject != null) {
                imageData.getHierarchy().addObjectBelowParent(parentObject, annotation, true);
            } else {
                imageData.getHierarchy().addObject(annotation);
            }
        }

        private void addLabelled(String labelText, Node node, int col, int row, String help) {
            Label label = new Label(labelText);
            label.setLabelFor(node);
            if (help != null) {
                Tooltip tip = new Tooltip(help);
                Tooltip.install((Node)label, (Tooltip)tip);
                Tooltip.install((Node)node, (Tooltip)tip);
            }
            this.pane.add((Node)label, col, row);
            this.pane.add(node, col + 1, row);
        }

        public static RegionMaker create(QuPathGUI qupath) {
            return new RegionMaker(qupath);
        }

        public static enum RegionUnits {
            PIXELS,
            MICRONS;


            public String toString() {
                switch (this.ordinal()) {
                    case 0: {
                        return "Pixels";
                    }
                    case 1: {
                        return GeneralTools.micrometerSymbol();
                    }
                }
                return "Unknown";
            }
        }

        public static enum RegionLocation {
            VIEW_CENTER,
            IMAGE_CENTER,
            RANDOM;


            public String toString() {
                switch (this.ordinal()) {
                    case 1: {
                        return "Image center";
                    }
                    case 2: {
                        return "Random";
                    }
                    case 0: {
                        return "Viewer center";
                    }
                }
                return "Unknown";
            }
        }
    }
}

