/*
 * Decompiled with CFR 0.152.
 */
package qupath.process.gui.commands;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.ObjectExpression;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.control.ListSelectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import qupath.fx.dialogs.Dialogs;
import qupath.fx.dialogs.FileChoosers;
import qupath.fx.utils.GridPaneUtils;
import qupath.lib.classifiers.object.ObjectClassifier;
import qupath.lib.classifiers.object.ObjectClassifiers;
import qupath.lib.common.GeneralTools;
import qupath.lib.gui.QuPathGUI;
import qupath.lib.gui.tools.GuiTools;
import qupath.lib.images.ImageData;
import qupath.lib.plugins.workflow.DefaultScriptableWorkflowStep;
import qupath.lib.plugins.workflow.WorkflowStep;
import qupath.lib.projects.Project;
import qupath.lib.projects.ResourceManager;
import qupath.process.gui.commands.ml.ProjectClassifierBindings;

public class CreateCompositeClassifierCommand
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(CreateCompositeClassifierCommand.class);
    private static String title = "Create composite classifier";
    private QuPathGUI qupath;

    public CreateCompositeClassifierCommand(QuPathGUI qupath) {
        this.qupath = qupath;
    }

    @Override
    public void run() {
        Optional option;
        ListSelectionView view = GuiTools.createListSelectionView();
        try {
            this.updateAvailableClassifiers((ListSelectionView<ClassifierWrapper<BufferedImage>>)view);
        }
        catch (IOException e2) {
            Dialogs.showErrorNotification((String)title, (Throwable)e2);
            logger.error(e2.getMessage(), (Throwable)e2);
        }
        String instructions = "Move individual classifiers to the column on the right to be included in the composite classifier.\nNote that the order of classifiers in the list determines the order in which they will be applied.";
        Label labelInstructions = new Label(instructions);
        labelInstructions.setAlignment(Pos.CENTER);
        view.setTooltip(new Tooltip("Classifier selection view."));
        GridPane paneName = new GridPane();
        Label labelName = new Label("Classifier name");
        TextField tfName = new TextField();
        ProjectClassifierBindings.bindObjectClassifierNameInput(tfName, (ObjectExpression<Project<BufferedImage>>)this.qupath.projectProperty());
        tfName.setPromptText("Enter composite classifier name");
        labelName.setLabelFor((Node)tfName);
        GridPaneUtils.setMaxWidth((double)Double.MAX_VALUE, (Region[])new Region[]{tfName});
        GridPaneUtils.setFillWidth((Boolean)Boolean.TRUE, (Node[])new Node[]{tfName});
        GridPaneUtils.setHGrowPriority((Priority)Priority.ALWAYS, (Node[])new Node[]{tfName});
        Button btnSave = new Button("Save");
        btnSave.setTooltip(new Tooltip("Save the composite classifier without applying it"));
        btnSave.setOnAction(e -> {
            CreateCompositeClassifierCommand.tryToSave((Project<BufferedImage>)this.qupath.getProject(), (Collection<ClassifierWrapper<BufferedImage>>)view.getTargetItems(), tfName.getText());
            tfName.requestFocus();
            btnSave.requestFocus();
        });
        GridPaneUtils.addGridRow((GridPane)paneName, (int)0, (int)0, (String)"Enter a name for the composite classifier", (Node[])new Node[]{labelName, tfName, btnSave});
        paneName.setHgap(5.0);
        BorderPane pane = new BorderPane((Node)view);
        pane.setTop((Node)labelInstructions);
        pane.setBottom((Node)paneName);
        Dialog dialog = new Dialog();
        dialog.initOwner((Window)this.qupath.getStage());
        dialog.setTitle(title);
        dialog.getDialogPane().setContent((Node)pane);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        Node btnApply = dialog.getDialogPane().lookupButton(ButtonType.APPLY);
        if (btnApply instanceof Button) {
            ((Button)btnApply).setText("Save & apply");
        }
        if ((option = dialog.showAndWait()).orElse(ButtonType.CANCEL).equals(ButtonType.APPLY)) {
            try {
                String name;
                Map.Entry<String, ObjectClassifier<BufferedImage>> entry = CreateCompositeClassifierCommand.tryToSave((Project<BufferedImage>)this.qupath.getProject(), (Collection<ClassifierWrapper<BufferedImage>>)view.getTargetItems(), tfName.getText());
                ObjectClassifier<BufferedImage> classifier = entry == null ? null : entry.getValue();
                String string = name = entry == null ? null : entry.getKey();
                if (classifier == null) {
                    return;
                }
                ImageData imageData = this.qupath.getImageData();
                if (imageData != null) {
                    Collection pathObjects = classifier.getCompatibleObjects(imageData);
                    if (classifier.classifyObjects(imageData, pathObjects, true) > 0) {
                        imageData.getHierarchy().fireObjectClassificationsChangedEvent(classifier, pathObjects);
                    }
                    if (name != null && !name.isBlank()) {
                        logger.debug("Adding object classifier '{}' to the workflow", (Object)name);
                        imageData.getHistoryWorkflow().addStep(CreateCompositeClassifierCommand.createObjectClassifierStep(Collections.singletonList(name)));
                    } else {
                        logger.warn("Object classifier has no name, so cannot be written to the workflow - sorry...");
                    }
                }
            }
            catch (Exception e3) {
                Dialogs.showErrorMessage((String)title, (Throwable)e3);
                logger.error(e3.getMessage(), (Throwable)e3);
            }
        }
    }

    static WorkflowStep createObjectClassifierStep(List<String> classifierNames) {
        String names = classifierNames.stream().map(n -> "\"" + n + "\"").collect(Collectors.joining(", "));
        return new DefaultScriptableWorkflowStep("Run object classifier", "runObjectClassifier(" + names + ")");
    }

    private static ObjectClassifier<BufferedImage> tryToBuild(Collection<ClassifierWrapper<BufferedImage>> wrappers) throws IOException {
        LinkedHashSet<ObjectClassifier<BufferedImage>> classifiers = new LinkedHashSet<ObjectClassifier<BufferedImage>>();
        for (ClassifierWrapper<BufferedImage> wrapper : wrappers) {
            classifiers.add(wrapper.getClassifier());
        }
        if (classifiers.size() < 2) {
            Dialogs.showErrorMessage((String)title, (String)"At least two different classifiers must be selected to create a composite!");
            return null;
        }
        return ObjectClassifiers.createCompositeClassifier(classifiers);
    }

    private static Map.Entry<String, ObjectClassifier<BufferedImage>> tryToSave(Project<BufferedImage> project, Collection<ClassifierWrapper<BufferedImage>> wrappers, String name) {
        try {
            ObjectClassifier<BufferedImage> composite = CreateCompositeClassifierCommand.tryToBuild(wrappers);
            if (composite == null) {
                return null;
            }
            String string = name = name == null ? null : GeneralTools.stripInvalidFilenameChars((String)name);
            if (project != null && name != null && !name.isBlank()) {
                if (project.getObjectClassifiers().contains(name) && !Dialogs.showConfirmDialog((String)title, (String)("Overwrite existing classifier called '" + name + "'?"))) {
                    return null;
                }
                logger.info("Saving classifier to project as {}", (Object)name);
                project.getObjectClassifiers().put(name, composite);
                Dialogs.showInfoNotification((String)title, (String)("Classifier written to project as " + name));
            } else {
                File file = FileChoosers.promptToSaveFile((String)title, (File)(name == null ? null : new File(name)), (FileChooser.ExtensionFilter[])new FileChooser.ExtensionFilter[]{FileChoosers.createExtensionFilter((String)"JSON", (String[])new String[]{".json"})});
                if (file != null) {
                    logger.info("Writing classifier to {}", (Object)file.getAbsolutePath());
                    name = file.getAbsolutePath().replaceAll("\\\\", "/");
                    ObjectClassifiers.writeClassifier(composite, (Path)file.toPath());
                    Dialogs.showInfoNotification((String)title, (String)("Classifier written to " + file.getAbsolutePath()));
                } else {
                    return null;
                }
            }
            return new AbstractMap.SimpleImmutableEntry<String, ObjectClassifier<BufferedImage>>(name, composite);
        }
        catch (Exception e) {
            Dialogs.showErrorMessage((String)title, (Throwable)e);
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private void updateAvailableClassifiers(ListSelectionView<ClassifierWrapper<BufferedImage>> view) throws IOException {
        Project project = this.qupath.getProject();
        if (project == null) {
            return;
        }
        ResourceManager.Manager manager = project.getObjectClassifiers();
        ObservableList source = view.getSourceItems();
        ObservableList target = view.getTargetItems();
        for (String name : manager.getNames()) {
            ProjectClassifierWrapper wrapper = new ProjectClassifierWrapper(project, name);
            if (source.contains(wrapper) || target.contains(wrapper)) continue;
            source.add(wrapper);
        }
    }

    static interface ClassifierWrapper<T> {
        public ObjectClassifier<T> getClassifier() throws IOException;
    }

    static class ProjectClassifierWrapper<T>
    implements ClassifierWrapper<T> {
        private Project<T> project;
        private String name;

        public ProjectClassifierWrapper(Project<T> project, String name) {
            this.project = project;
            this.name = name;
        }

        @Override
        public ObjectClassifier<T> getClassifier() throws IOException {
            return (ObjectClassifier)this.project.getObjectClassifiers().get(this.name);
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProjectClassifierWrapper other = (ProjectClassifierWrapper)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.project == null ? other.project != null : !this.project.equals(other.project));
        }
    }
}

